/* ================================================= */
/* NewDoc.rexx  FW new document return its port name */
/* RESULT=portname                                   */
/* FinalWriter macro/function                        */
/* Must go in REXX: directory                        */
/* Stand alone or call as a function from a FW macro */
/*                                                   */
/* written by Merrill Callaway                       */
/* $VER: NewDoc 2.0 copyright 1994 by                */
/* Merrill Callaway                                  */
/* ================================================= */
CALL TIME(R)
OPTIONS RESULTS

/* launch new FW document, find new portname */

/* is there a copy of FW running? */
portlist=SHOW(p)
num=LASTPOS('FINALW.',portlist)

/* no copy running */
IF num=0 THEN DO
   /* NOTE: Put in you own path name for FinalWriter */
   ADDRESS COMMAND 'RUNBACK Video:FinalWriter/FinalWriter'
   ADDRESS COMMAND 'WAITFORPORT' FINALW.1
   EXIT 'FINALW.1'
   END

PARSE VAR portlist =num lastportname .

/* is host address in FinalWriter?  If not, put it there */
IF LEFT(ADDRESS(),7) ~=='FINALW.' THEN,
   ADDRESS VALUE lastportname

/* start a new document */

New

/* waitforport when you don't know portname */
DO FOREVER
   CALL DELAY(20)
   portlist=SHOW(p)
   num2=LASTPOS('FINALW.',portlist)
   /* is there a new port on line? */
   IF num2~=num THEN LEAVE
   IF TIME(E)>30 THEN EXIT 20
   END

PARSE VAR portlist =num2 newportname .
EXIT newportname

