Using "Moving Textures" 
in Aladdin-4D: Tutorial #11 R. Shamms Mortier
	If you are an Amiga artist or animator and are not presently utilizing a CD-Rom player as a part of your Amiga environment, do yourself a big favor,.. buy one. If you never had a good enough reason before, perhaps the "Moving Textures" CD will make the decision for you. Of all of the CD collections of textures that I've seen thus far, this one from Precision Computer Graphics is the absolute cat's pajamas hottest. Why? Because these are what the package says,.. "Moving Textures". There are twenty-two sets of single framed animations on the CD, grouped into two categories: Tru-Maps and FX-Maps. Tru-Maps are actual stop frame collections of natural environmental shots: Clouds, Fire, Flames, Ocean waves, Smoke, and Steam. The FX-Maps make up the rest, and constitute a collection of rendered organic motions: Boiling, Burst, Calm, Disturb, Jiggle, Liquid, Pour, Rough, Spots, Swift, Tide, Water A & B, and Waves A & B. The FX-Maps and the Tru-Maps contain either 300, 600, or 900 frames each (900 frames is enough for up to 30 seconds of animation at 30 frames a second). FX-Maps are sized at 192 x 120 pixels, while the Tru-Maps are sized at 320 x 200 or 368 x 240. The only exception is the "Clouds24" Tru-Map, which is 300 frames (209 Mb) of 736 x 480 data (close to perfect for OpalVision which takes a 736 x 476 image size and resizable for everything else).
	There are two ways to apply these textures in a 3D animation. They can be used as backgrounds or as smaller texture elements dedicated to a specific 3D object in a scene. When used as a background, the "Clouds24" works best because it has the highest resolution. All of the files are naturally open to being reconfigured in ImageFX, ADPro, or ImageMaster, and their palettes can be altered as well (you could change the background sky from blue to red and the clouds to indigo for a planetscape backdrop for instance). If you decrease the bitplanes, a larger grouping of these images can also fit comfortably on a hard disk. The CD sells for a healthy $250.00, but since it has no competition as yet, it will probably get most of its asking price. Directions come for applying the texture images in most of the top Amiga 3D programs. The directions for Aladdin-4D are the shortest, since Aladdin-4D has the most intuitive and simple way of applying textures and backgrounds of any of the Amiga 3D software packages. In A4D's texture environment
	Let's recap exactly how to apply a texture in A4D (Aladdin-4D). There are three basic identities that a texture needs to know about in A4D as far as the targeted object is concerned: shading, attributes, and textures. Shading may be either Gouraud or Phong, and adjacent polys may be toggled on or off. If on, a smooth surface will hide adjacent poly edges, and if off the adjacent polys edges will be seen. An objects "attributes" include such things as transparency, hardness, reflectivity, color, and sensitivity to a collection of altering circumstances (waves, shadows, etc.). If no texture is applied, the object will still show its attributes. All attributes are assigned in A4D's "Attributes List Requester", and all attributes may be set to change over time. A separate requester is used to tell A4D what additional texture (bit-mapped or procedural) to assign to the object. As desired, textures can be wrapped in a variety of ways, and they can be bump maps, genlocked, decaled, and more. Textures used as backgrounds are set in a special background requester, though the texture itself is listed in the all-round texture list. Moving A4D Backgrounds
	The Moving Textures frames are perfect for A4D, and simple to apply to a background. A4D doesn't really make a caring distinction whether you want a picture or a single-framed series of pictures as your background, and it even has a special anti-aliasing feature that makes the best use of smaller sized frames so that almost any image looks its best when applied. To apply a Moving Textures frame to an Aladdin-4D background, choose "background" from the "View" requester. When the TXList comes up, select "Add", and then click on "Control" and "Member Control" respectively. This brings up the detailed Texture Control screen. There is a button in the lower left called "Select". Click on it. A Procedural Resource List will pop up showing all of the procedural texture choices. We want to access a bitmap, so we select the "Show Bitmap" option and then click on "Load". This brings up a standard path requester, so we have to tell it where the Moving Texture we want is stored. Selecting the name of the CD-Rom drive gives us access to the CD-Rom, and all we have to do is to select the proper texture for our background.
	After selection, there are a few more things to do in the Texture Control window. We usually click on "Suggested" to apply the picture to the background in its proper orientation. Backgrounds are seldom bump mapped, so it's common to leave their mapping choice set to "Normal". If the background is to be animated (as it is with Moving Textures), we can choose to cycle the frames in one direction or make them periodically loop. If we want to, we can play with the number of frames that the background will take up and alternate a separate series of pictures at another part of the animation. We could even fade the background in or out if desired. All of these choices are possible in Aladdin-4D. The same choices that Aladdin allows for a textured object (time alterations, fading, color fades, layered textures, moving the position of the texture...) are available for backgrounds.
	If you plan on using Moving Textures as a background. Remember that every pixel in the background is going to change. This will slow down the replay of the animation when you preview it, and also call for enhanced storage space when the animation is stored. Large changes in a screen make for livelier animation, but at the cost of replay and storage space. Of course the replay is no problem if you are going to record it to video with a single frame option (the PAR, NoahJi's V-Lab Motion, or other alternatives). Moving Textures and 3D Objects (and where you might want them)
	Where might it be useful to use Moving Textures on, or as a part of, a 3D object? Since the textures we're speaking of refer to organic process (the movement of clouds and water, for instance) we should look to 3D objects that need organic movements. Mapping Moving Textures on a vase yields an object that seems to be reflecting that movement on its surface. Another choice might be to map the Moving Texture onto its counterpart in form: water on a water surface, flame on flames, etc. One of my favorite ways of accomplishing the later is to record an animation as single frames that depicts the chosen Moving Textures on a background. Then I map that same background to a planar surface in my animation, many times setting the "genlock" option which removes the background color. I do it this way because it's a faster alternative and it can lead to far more experimental results.
	Mapping a Moving Texture to a 3D object in A4D requires familiarity with a linear activation of specific steps. The chosen object is first assigned selected attributes (transparency level, reflectivity, etc.) and shading is applied (none, phong, or gouraud). Then comes time for the texture. Choosing "Textures" from the Polygon menu, a BMList (BitMap List) is added and accessed. From here it's much the same process as the Background option detailed earlier. The path to the chosen texture is opened, and the texture (picture or single frame list) is imported. The difference here is that you may well decide to apply the texture in any number of ways: Normal, Reflection, GenLocked, Bumped, Opacity, Hardness, or Illumination. Each of these choices leads to a specific "look" and experimentation will inform your needs. You also have to tell the program how the texture is to be applied (planar, cylindrical, spherical...) and from what direction (X,Y, or Z). From there, it's a simple matter of previewing the results and changing your alternatives until you get what you want. See the accompanying figures for some examples. Aladdin-4D MSLP: $400.00 ADSPEC Programming (216) 223-2255 "Moving Textures" CD-Rom MSLP: $250.00 Precision Computer Graphics 634 N. Glenoaks blvd., Suite 367 Burbank, CA 91502-1024 818-842-6542 Captions to Figures: Figure 1. A "Moving Textures" bump mapped "Disturb" textures wraps a sphere, while the "Clouds" texture illuminates the background. Figure 2. "Flames" and "Waves" textures are applied to two urns, while "Moving Textures" Fire is mapped to the background. Figure 3. The background is "Moving Textures" Smoke, the letters are the Water texture (giving them a look of rough hewn quartz), and the ground plane is mapped with "Ocean".
