FinalData Database Manager for the Amiga
by Merrill Callaway

SoftWood, Inc., maker of FinalWriter, and FinalCopy has just released FinalData to help you manage lists of things in tables such as names and addresses of customers or friends; collections of tape, video or anything else; reference material such as bibliographies; home inventory; bills, or appointment histories. 
	As we have come to expect from SoftWood, the program installs flawlessly, and the program interface is beautiful and friendly. It is dead easy to set up and start using a list of, say, names and addresses and birthdays of friends. In fact, a tutorial guides the new user through the entire process of setting up the list, entering and changing data, rearranging column boundaries, and even printing a database report or labels. 
	The manual is very thorough and simple enough for the newest beginner, but the reference section is well thought out for quick and easy look ups. The package comes with one disk and a manual of approximately 95 pages which contains nine sections and an index. The list price is $99.95. FinalData works on any Amiga with System 1.3 or later, and one megabyte or better of RAM. Tooltypes are supported as well as launching from a command line or an icon in Workbench.

What is a Database?
It would be good to mention up front that there are databases and there are relational databases. Now all databases consist of one or more tables that contain columns of a certain data type (such as text or numbers or dates), and rows, usually called records which represent one instance or individual. That is, a person may be listed in a database with his or her last name entered under a column called LastName. The last name is actually entered into a field or a cell of the table. A similar field headed by the column name, FirstName, may contain records of each individual's first name, an address field will contain street data, a state field will contain state abbreviations, a zipcode field will contain postal codes, and so on. 
	This is pretty straightforward, and this is the kind of tool that FinalData is, a tool to allow you to search and sort and rearrange all sorts of tables, but only one table at a time. 
	A relational database, on the other hand, is not so simple. It will consist of the same kinds of tables, but there will be a collection of perhaps many interrelated and linked tables that depend in various ways on the other tables. The data you enter into a table is called an entity and the way one entity relates to another (perhaps in another table) is called a relationship. 
	Good database design involves deciding which columns uniquely identify each row in a table. For example, in a school database, many students may have the same last name, so a column is created in the Student Table with a unique number assigned for each student. There may be more than one column that is necessary to identify each row uniquely, but the set of one or more columns that does this is called the Primary Key. The Student Table contains a primary key Studnum, the student number mentioned before. The Student Table may be related to a second table, Register which contains Studnum, Course and Section to track course registrations. The Studnum column is called a Foreign Key in the Register Table because it relates to a Primary Key in another table. These relationships when properly set up cause changes in one table to filter out and update all dependent tables. 

What FinalData Is Not
	Out of the box, FinalData is by no means a relational database manager. It is strictly for managing one table at a time, and it lacks most of the database administration capabilities (such as granting access, networking, security, rollback, and backup, to name several) that one would have in a real database manager, which, by the way will not only cost you more but will be much more challenging to learn and use. 
	That caveat being said, the intriguing thing about FinalData, is its rather extensive ARexx control interface. I have not had the time to try out ARexx with FinalData yet (because of publishing deadlines), but my first impression is that there may be enough ARexx commands to implement certain relationships between tables and increase its power to match some features found in a relational database manager (and ARexx is easier than most database manager languages such as SQL). 
	Meanwhile, as a single table manager, FinalData is incredibly easy to use. Small businesses and individuals who only need to maintain mailing lists, customer sales histories, and other such non-complicated data will appreciate FinalData's "up and running in five minutes" philosophy.

Creating and Working with a FinalData Database
	All you need to do to start building a new database is to select New from the Project Menu. A Define Database requester opens which allows you to name columns, select what type of data they will contain, determine the position or order in which they will occur across the top, and how data will be aligned in their cells. After you accept a column definition, you may keep entering columns until your table is complete. If settings do not change between columns (e.g. there are several columns of text in a row), all you have to do is name the columns and press Enter each time to retain all the previous settings. 
	Entering data is a question of clicking on the first row and entering the information into the cells. Pressing Enter advances to the next cell and there are full cut, copy and paste edit commands to make life easy. Column width changes are as simple as dragging the column dividers with the mouse. An entire column may be moved sideways by holding down the Alt key and positioning the mouse pointer in the column header. Selecting data is also very easy. You may drag select, click on a column head to select the entire column, or on a row number to select the entire row. 
	The upper left hand corner has a special button called the "Deselect Button". The other button of interest is the "New" row button to enter a new row of data. These two toggle each other on and off. If you reach the end of a row and press Enter, the program automatically takes you back to the beginning of the next row. You may click anywhere and start editing or entering data. 
	Once a database session is complete, you may save the file in FinalData format. You may also export a FinalData database in ASCII format in order to use it in FinalWriter Release 2, or FinalCopy's mail merge features. You may import files from PenPal and other SoftWood products. SoftWood promises FinalWriter Release 3 will take FinalData files directly. You may save only selected parts of a database if you so desire as well. Once a database contains data, every column may be redefined or moved, but the data type may not be changed as long as there is data there. 
	One of the data types is Calculate, for which you may specify a formula to perform arithmetic on column items as long as their data type is Amount. The column names are used as variables as in: Hours * Rate. Date and Time formats allow several choices for date or time display format as well as how they are to be entered.

ARexx and FinalData
	FinalData has full ARexx capabilities in case you need to process and import a large amount of data from another source, or manipulate FinalData in some way automatically. ARexx has the most powerful string handling features of any language around, so it is a natural to use it with FinalData. There are several ARexx macros included; for instance, an ARexx macro to automatically set up a Name and Address database. ARexx macros may be assigned to function keys and given names that appear in the ARexx menu. There is a 35 page section on ARexx commands in the manual. As I mentioned before, as ARexx macros become available for this product, its power and usefulness will only increase. I will save the details for another article.

Printing
	Printing is through Preferences only, lacking the excellent PostScript drivers available for FinalWriter and FinalCopy. The product literature states that FinalData uses printer fonts "for speed" but translated this means: no print driver. What a shame this is not an option. SoftWood's PostScript drivers worked so well in the past. 
	When I tried my PostScript printer with the System 2.1 PostScript Preferences driver, the only font that worked was the mono-spaced courier. Any attempt to use a proportional font such as Times, failed to line anything up properly. On HP Laserjet setting, the only font available was courier which printed acceptably. The tutorial shows you how to print labels. It fails to mention that the settings are for one label per page, so if you have a sheet feed printer such as a laser printer, you will want to change to 3 labels across and 3 down per page, or you will get six pages from printing the six labels in the tutorial. You would want only one label per page when you are using a sprocket fed dot matrix printer loaded with a roll of labels.

Sorting and Searching
	Sorting works very well. If you have some contiguous columns to sort, then the Column menu has Sort Low to High as well as a Sort High to Low items. Simply choose one of these after clicking on one column or shift-clicking on one or more columns and they will sort. For more complicated sorts, such as non-contiguous columns or one column high to low and another low to high, or to determine sort priorities, use the Row/Sort menu item to open the sort requester. You may then choose which columns to sort, in what order, and whether high to low or the reverse. The interface is very intuitive and easy to figure out. Searching has a conventional Find or Find/Replace for single words without wild card support. 

Room for Improvement
	I have already mentioned that it is a mistake to deem FinalData any sort of real database manager, but notwithstanding the probability that FinalData will never grow up to be a real database manager, it occupies a useful niche in the Amiga market. Its ease of use and short learning curve will probably meet with more approval than would a full list of powerful but hard to master and therefore unused true database features. 
	I would prefer to call FinalData a list or table processor, not a database manager. I doubt most individuals or even most small businesses really need a full featured database manager. People who do need an Amiga database manager program should use Oxxi's Superbase Professional. I predict that people who have both products will find themselves using FinalData a lot more than they expect, however, because it is so convenient and pleasant to use for less complex jobs. There are a few features that FinalData should not have been without, however.
	There are no hard-wired features to perform a complex logical find nor are there wild card searches. There really ought to be a way to construct a report to be displayed in a separate window of things like, say, every record between July 1, 1994 and October 10, 1994 where the last name begins with "R" and the zipcode is 87106 or 87108. 
	This is the way a database manager ought to work, even if limited to only one table at a time, and why I state that FinalData, is not at present close to being a database manager. With judicious sorting and/or ARexx programming, most of these queries could be accomplished, but it would have been better to have more built-in features for searches, queries and reports. Another glaring omission is an UNDO button. Most program preferences, but oddly, not screen colors may be user-set. Finally printing leaves a lot to be desired. SoftWood needs to give it a driver that will allow proportional fonts to print, aligned properly, while retaining the option of printing in speedy, monospaced courier. 

Conclusions
	I really like FinalData for what it is, even though I disagree that it is a database manager program as SoftWood claims. Because of my experience with real database managers and how hard they are to master, I find FinalData a real joy to use. It is just right for almost anything I need to do in the way of maintaining lists of people or things. I'm going to have fun writing ARexx routines to take care of the things that were not built in, and I expect that most of the needs I may have to relate two or more tables or to construct complex queries and reports will be met by ARexx quite handily. 
	FinalData will most likely never have the robust system, network, access, and data safeguards of a true database manager, but then on my single user system that would be overkill, anyway. At a fraction of their cost and with a minuscule learning curve in comparison to its big brothers, FinalData fills an important need and makes a useful addition to the family of SoftWood products.
