; scrolls a multicolor 4bit picture

; some equates
fetch4Bit		= $0403		; location of the fetch 4Bit from buffer routine

c64			= $4f00		; location of the 4 bit palette
; .res 256
; used by the four bit conversion routines
colorcount		= $5ec0		; contains # of most used colors in a graphics card
; .res 16
histotab		= $5ed0		; contains the bit patterns spread across a color range
; .res 32					; for a graphics card
bitpatt		= $5ef5		; contains the vital bit patterns corresponding to
; .res 4					; available colors
coltable		= $5ef9		; contains the color table for a graphics card
; .res 5
optcolor		= $5efe		; optimized color
; .res 1
optbkgd		= $5eff		; the optimized background value
; .res 1
fourBuff		= $5f00		; four bit buffer area
; .res 256

graphicsMode	= $003f		; graphics mode 80 or 40 columns
scpubk2		= $d074		; select VICBank Two optimization mode
scpunot		= $d077		; select no Optimization mode (default)
scpuenb		= $d07e		; enables the SCPU registers
scpudis		= $d07f		; disables the SCPU registers
scpuver		= $d0b0		; indicates which version of the scpu online
scpudet		= $d0bc		; detects whether a SCPU is online
firstpage		= $d27c		; first available SuperRAM bank, etc.
expram		= $e487		; RAM version identifier string
ram128		= $f6dd		; 128 RAM version identifier string
nmi16			= $ffea		; 16 bit NMI vector

colorram		= r10			; proxy for colorram
videoram		= r11			; proxy for videoram
pixeldat		= r12			; proxy for pixel data

;Maintain a consistent jump table
; jsr setorigin				; sets the variables for the origin (0,0) pointer.
; jsr scrollright				; scrolls the screen to the right by a card.
; jsr scrollleft				; scrolls the screen to the left by a card.
; jsr scrolldown				; scrolls the screen downwards by a card.
; jsr scrollup				; scrolls the screen upwards by a card.
