; Super DBGETFILES Dialog Box - Copyright 2000 By Todd S. Elliott

InitSuperDB:				; intializes the SuperDB requestor
	lda	#$00
	jsr	SetPattern			; clear the area
	lda	#$00				; pass coordinates of the DB in Rectangle format
	sta	r3H
	sta	r1H				; pass RAM expansion address of where to store
	sta	r1L				; the area underlying the rectangle
	lda	#$10
	sta	r3L
	lda	#$01
	sta	r4H
	lda	#$28
	sta	r4L
	LoadB	r2L, $20
	LoadB	r2H, $a0
	LoadW	r0, dbColorBuf		; pass color buffer address
	jsr	CustImpRect			; store the area underlying the Rectangle
	jsr	Rectangle
	lda	#$ff
	jsr	FrameRectangle
colordb:					; colorizes the SuperDB file requestor
	jsr	ConvToCards
	LoadB	r4H, $03			; black/cyan
	jsr	ColorRectangle		; color the entire SuperDB
	jsr	SetFNRect			; set the filename display rectangle
	jsr	ConvToCards
	LoadB	r4H, $07			; black/yellow
	jsr	ColorRectangle		; color the filename entries
	LoadB	r1H, $10			; ycoord
	lda	#$02
	ora	xdblB				; bitmap double it
	sta	r2L				; width
	LoadB	r2H, $01			; height
	LoadB	r4H, $05			; black/green
	jsr	ColorRectangle		; colorizes the left diskpage icon
	lda	#$22
	sta	r1L				; xcoord
	jsr	ColorRectangle		; colorizes the right diskpage icon
	lda	#$06
	sta	r1L				; xcoordinate
	lda	#$03
	sta	r2H				; height
	ora	xdblB				; bitmap doubling
	sta	r2L				; width
	jsr	ColorRectangle		; colors the open file icon
	LoadB	r1H, $11			; ycoord
	lda	#$16
	sta	r1L				; xcoord
	LoadB	r2H, $02			; height
	jsr	ColorRectangle		; colorizes the DISK icon

;	lda	#$0a
;	sta	r1L	; xpos
;	jsr	ColorRectangle		; colors the FlagFiles icon
;	lda	#$0e
;	sta	r1L	; xpos
;	jsr	ColorRectangle		; colors the Toggle icon
	LoadB	r1H, $12			; ycoord
	lda	#$0a
	sta	r1L				; xcoordinate
	lda	#$01
	sta	r2H				; height
	lda	#$07				; go through the different drives
	sta	r15L
@2:	ldx	r15L
	inx
	cpx	#$0c				; are we done through the icons?
	beq	@4
	lda	driveType-8,x		; check to see if a drive is present
	beq	@3
	jsr	ColorRectangle		; colorize the drive icons
@3:	lda	r1L				; adjust the xcoordinate
	clc
	bit	screenMode			; check video mode
	bpl	@5				; branch on 40 columns
	adc	#$06
.byte	$2c					; BIT opcode
@5:	adc	#$03
	sta	r1L
	inc	r15L				; go through the next drive icon
	bne	@2				; cycle through the drives
@4:	PopW	returnAddress		; preserve the calling routine
rSuperDB:					; entry point to restart the SuperDB requestor
	jsr	setup4DB			; set up the drive icons
	lda	#$00
	sta	r6H				; load r6H w/ $00 for initializing the filename
	sta	r7L				; counter
	lda	#$30				; and initialize the expansion RAM offset to $3000
	sta	r7H
	jsr	SetupFilenames		; scans the directory for certain types of filenames
						; builds up a list and stashes a list of valid
						; filenames onto the expansion RAM device.
	jsr	SetFNTable			; sets the filename entry list and
						; clears the filename display.
	LoadW	otherPressVec, BoolIcons; enable the filename selector
	LoadW	r0, SDBITable		; sets up the icon structure for the SuperDB
	jmp	DoIcons			; requestor

SetupFilenames:				; sets up the Super file requestor DB
	lda	r7L				; save RAM expansion offset and use self-
	sta	fileRAM
	lda	r7H
	sta	fileRAM+1
	jsr	Get1stDirEntry		; get first directory block
	txa
	beq	@1				; check disk error
	jmp	DError
@1:	ldy	#$00				; go through individual file entries in a dirblock
	lda	(r5),y
	and	#%00111111			; get rid of bits 7 & 6
	beq	@3				; branch if it's DELeted
	cmp	#$03				; is it USR filetype or higher?
	bcs	@3				; branch if so
	iny					; get t/s
	lda	(r5),y
	sta	r1L
	iny
	lda	(r5),y
	sta	r1H
	LoadW	r4, fileHeader
	jsr	GetBlock			; get the first block of the datafile
	txa
	beq	@4				; check disk error
	jmp	DError
@4:	ldy	#$04
	ldx	#$02
@5:	lda	(r4),y
	cmp	godsig,x			; trace the god0 signature
	bne	@3				; if not equal, drop the file from the SuperDB
	dey
	dex
	bpl	@5
	jsr	stashFN			; stash the filename

@3:	jsr	GetNxtDirEntry		; gets the next directory entry
	txa					; check disk error
	beq	@2				; and repeat the search process
	jmp	DError
@2:	tya					; are we done with the directory?
	beq	@1
	rts					; end the routine here for a successful
						; search of the directory

stashFN:					; stashes the matching filename into RAM device
						; ideally, r6H is initialized with Zero for index
						; and r7 (word) is initialized with $3000 for
						; destination address
	inc	r6H				; contains the number of detected filenames
	bne	@4				; handles a list up to 255 filenames
	dec	r6H				; reset the counter
	rts					; and return w/o doing anything.
@4:	lda	r5H				; point to filename as the source address
	sta	r0H
	ldy	r5L
	iny
	iny
	iny					; point the LSB to the filename within the
	sty	r0L				; file entry
	MoveW	r7, r1			; destination address in the RAM device
	LoadW	r2, $0010			; move only 16 bytes
	LoadB	r3L, $00			; the first 32Kb of the RAM device is used
	ldy	#$90
	jsr	DoRAMOp			; stashes the filename into RAM device
	txa					; check error
	beq	@2
	pla
	pla					; if there's an error, clean up the stack
	jmp	DError			; otherwise branch on error
@2:	ldx	#r7L
	jmp	AdjZPOffset			; update destination address

SetFNTable:					; sets up the filename entry list
	ldy	#$00
	tya					; clear out the filename entry list first
@1:	sta	FNTable,y
	dey
	bne	@1
	lda	r6H				; check to see if filenames were selected
	beq	@3				; branch if no filenames were selected
	iny
	tya					; a non-Zero entry means the filename exists
	dey
@2:	sta	FNTable,y
	iny
	cpy	r6H				; contains number of filename entries
	bne	@2
@3:	lda	#$00				; indexes the entry into the filename list
	sta	r14L
	sta	HomeFN			; store a copy there to note the 'home' entry
	lda	fileRAM
	sta	r15L				; for the expansion RAM offset
	sta	HFNRam			; and make the pointer the 'home' entry
	lda	fileRAM+1
	sta	r15H
	sta	HFNRam+1
; and fall through to the next routine

enterHere:					; an alternative entry point
	jsr	SetFNRect			; set up the filename display rectangle
	jsr	Rectangle			; clears the filename display area
						; actually displays the filenames onscreen.
	lda	#$00				; x2pos for its invert rectangle counterpart
	pha
	bit	screenMode			; check video mode
	bpl	@4
	lda	#$af				; 80 column positioning
.byte	$2c					; bit opcode
@4:	lda	#$97				; x2pos for its invert rectangle counterpart
	pha
	lda	#$00				; x1pos of column for filename entry list
	ora	xdblB				; bitmap double it
	pha
	lda	#$18				; x1pos of column one for filename entry list
	pha
	jsr	sColValues			; sets up the column values for the filename entries
	beq	@1				; branch if no more filename entries are needed
	lda	#$01
	pha					; x2pos for inverting entry (hibyte)
	bit	screenMode			; check video mode
	bpl	@6
	lda	#$37
.byte	$2c					; bit opcode
@6:	lda	#$1f				; x2pos for its related invert rectangle call
	pha
	lda	#$00
	pha					; x1pos of filename entry (hibyte)
	bit	screenMode			; check video mode
	bpl	@5
	lda	#$b8
.byte	$2c					; bit opcode
@5:	lda	#$a0				; xpos of column two for filename entry list
	pha
	jsr	sColValues			; set up column values for filename display
	beq	@1				; are we done?
	bit	screenMode			; check videomode
	bmi	@7
@1:	rts

@7:	lda	#$01
	pha					; x2pos for invert filename entry (hibyte)
	lda	#$bf				; x2pos for its related invert rectangle call
	pha
	lda	#$01
	pha					; x1pos for its filename entry (hibyte)
	lda	#$40				; xpos of column three for filename entry list
	pha
	jsr	sColValues			; set up column vales for the filenames
	beq	@1				; are we done?
	lda	#$02
	pha					; x2pos for the inverted filename (hibyte)
	lda	#$47				; x2pos for its related invert rectangle call
	pha
	lda	#$01
	pha					; x1pos for the filename entry
	lda	#$c8				; xpos of column four for filename entry list
	pha
	jsr	sColValues			; set up filename column values and exits
	rts

dispFN:
	ldy	r14L
	lda	FNTable,y			; check the status of the filename entry
	bne	@1				; branch if it is the end of the filename list
	rts					; Zero flag set to indicate end of list
@1:	ldy	#$10				; delimit the filename buffer
	lda	#$00
	sta	fileName,y
	LoadW	r0, fileName		; Commodore addy
	MoveW	r15, r1			; Expansion RAM addy
	LoadW	r2, $0010			; move only 16 bytes
	LoadB	r3L, $00			; use bank Zero
	ldy	#$91				; fetch expansion ram contents
	jsr	DoRAMOp

fnx:	lda	#$00				; xpos of filename text
	sta	r11L
	lda	#$00
	sta	r11H
fny:	lda	#$00				; ypos of baseline offset of filename text
	sta	r1H
	jsr	PutString			; and draws the filename text onscreen
irx1:	lda	#$00				; for the invert rectangle routines
	sta	r3L				; x1pos
	lda	#$00
	sta	r3H
irx2:	lda	#$00				; x2pos
	sta	r4L
	lda	#$00
	sta	r4H
iry1:	lda	#$00				; y1pos (scanline)
	sta	r2L
iry2:	lda	#$00				; y2pos (scanline)
	sta	r2H
	ldy	r14L				; check the filename table list again
	lda	FNTable,y
	bpl	@1				; branch if the filename isn't selected
	jsr	InvertRectangle		; and inverts the filename entry if it is
						; already selected.

@1:	inc	r14L				; increment index into filename list
	ldx	#r15L
	jsr	AdjZPOffset			; adjust expansion RAM offset
	clc					; and take care of the carry
	ldy	iry2+1			; adjust ypos for the invert rectangle box
	iny
	sty	iry1+1
	tya
	adc	#$0a				; each filename text occupies 11 scanlines
	sta	iry2+1
	clc
	lda	fny+1				; adjust ypos
	adc	#$0b				; each filename text occupies 11 scanlines
	sta	fny+1
	bmi	@2
	jmp	dispFN			; check to see if we're done with a single
@2:	rts					; column of filename texts
						; Zero flag is cleared to indicate list
						; has not ended yet.

;SDBClose:	; event handler to handle the close icon of the SuperDB requestor
;	jsr	CustRcvrRect	; and restore the area underlying the SuperDB
;	LoadW	otherPressVec, $0000; deactivate the filename selector
;	LoadW	r0, DITable	; deactivate the icons
;	jsr	DoIcons
;	jmp	ReDoMenu	; and reenable the menus and exits.

OFilesRoutine:				; event handler to handle the open files icon of the
						; SuperDB file requestor
	jsr	sFNTable			; sets the filename entry table pointers
	jsr	CustRcvrRect		; restore the area underlying the rectangle	
	LoadW	otherPressVec, $0000	; deactivate the filename selector
	LoadW	r0, DITable			; deactivate the icons
	jsr	DoIcons
	PushW	returnAddress		; restore the calling routine
	rts

PageLeft:					; event handler to handle the page filenames left icon
	lda	HomeFN			; get the 'home' filename entry
	bne	@1				; make sure we're not on the first 'disk page'
	rts					; if so, abort
@1:	sec
	bit	screenMode			; check video mode
	bpl	@2
	sbc	#$20				; each 80 column disk page has 32 entries
.byte	$2c					; bit opcode
@2:	sbc	#$10				; each 'disk page' contains 16 filename entries
	sta	HomeFN			; make it the new 'home' filename entry
	sta	r14L
	ldy	HFNRam+1			; adjust the expansion ram pointer to the
	dey					; home filename entry - adjust hi bytes only
	bit	screenMode			; check video mode
	bpl	@3
	dey					; go one more for 80 columns
@3:	sty	HFNRam+1
	sty	r15H
	lda	HFNRam
	sta	r15L
	jmp	enterHere			; and jump through the display filename
						; entries routine and exits

PageRite:					; event handler to page the filename entries to the right
	lda	HomeFN			; get the 'home' filename entry
	bit	screenMode			; check video mode
	bpl	@3
	cmp	#$e0				; for 80 columns - is it the last filename entry?
	bne	@1
	rts
@3:	cmp	#$f0				; are we on the last filename entry columns?
	bne	@1
@2:	rts					; if so, abort
@1:	clc
	bit	screenMode			; check video mode
	bpl	@4
	adc	#$20				; each 80 column diskpage has 32 entries
.byte	$2c					; bit opcode
@4:	adc	#$10				; each 'disk page' contains 16 filename entries
	sta	r14L
	tay
	lda	FNTable,y			; need to check ahead to see if more filename
	beq	@2				; entries exist - branch if none exists
	sty	HomeFN			; make it the new home filename entry
	ldy	HFNRam+1			; adjust the expansion ram pointer to the
	iny					; home filename entry - adjust hi bytes only
	bit	screenMode			; check video mode
	bpl	@5
	iny					; adjust it one more for 80 columns
@5:	sty	HFNRam+1
	sty	r15H
	lda	HFNRam
	sta	r15L
	jmp	enterHere			; and jump through the display filename
						; entries routine and exits

SetFNRect:					; sets the rectangle for the filename display
	bit	screenMode			; check video mode
	bpl	@2
	LoadW	r4, $0247			; x2coordinate - 80 columns
	bne	@3				; relative JMP
@2:	LoadW	r4, $011f			; x2coordinate
@3:	lda	#$18
	sta	r3L				; x1coordinate
	lda	#$00
	ora	xdblB				; bitmap double it
	sta	r3H
	LoadB	r2L, $28			; y1coordinate
	LoadB	r2H, $7f			; y2coordinate
	rts

sColValues:					; set values for the filename entry columns
	pla					; save the return address
	tax
	pla
	tay
	pla
	sta	fnx+1
	sta	irx1+1			; xpos for its related invert rectangle call
	pla
	sta	fnx+5
	sta	irx1+5			; x1pos (hibyte)
	pla
	sta	irx2+1			; x2pos for its related invert rectangle call
	pla
	sta	irx2+5			; x2pos (hibyte)
	lda	#$30				; ypos (scanline) of baseline offset of
	sta	fny+1				; filename entries
	lda	#$28				; ypos for its invert rectangle counterpart
	sta	iry1+1
	lda	#$32				; y2pos for its invert rectangle counterpart
	sta	iry2+1
	tya
	pha					; restore return address
	txa
	pha
	jmp	dispFN			; displays the filename entries column

BoolIcons:					; use boolean algorithms for the user to select the proper
						; filename entry in the Super DB file requestor
	lda	mouseData			; ignore mouse releases
	bpl	@10
	rts
@10:	lda	HomeFN
	sta	r14H				; reset the 'home' filename entry index
	jsr	SetFNRect			; set up the filename display rectangle
	jsr	IsMseInRegion		; check where the mouse was
	bne	@1				; branch if it was in the file requestor area
	rts
@1:	bit	screenMode			; check video mode
	bpl	@9
	sec					; halve the screen in 80 columns
	lda	r4L
	sbc	#$10
	sta	r4L
	lda	r4H
	sbc	#$01
	sta	r4H
	jsr	IsMseInRegion
	bne	@9				; branch if it's in the region
	clc
	lda	r14H				; get the home filename entry
	adc	#$10				; and adjust it by 16 filenames
	sta	r14H
	clc
	lda	r3L				; adjust x1pos and x2pos coordinates
	adc	#$10
	sta	r3L
	lda	r3H
	adc	#$01
	sta	r3H
	lda	r4L
	adc	#$10
	sta	r4L
	lda	r4H
	adc	#$01
	sta	r4H

@9:	sec					; shorten the rectangle by half
	lda	r4L
	sbc	#$88
	sta	r4L
	lda	r4H
	sbc	#$00
	sta	r4H
	jsr	IsMseInRegion		; the horiZontal direction.
	bne	@2				; check to see which column the mouse was
	clc					; resting upon when clicked
	lda	r14H				; get the 'home' filename entry value
	adc	#$08				; by eight to arrive on second column
	sta	r14H
	clc
	lda	r3L				; adjust x1pos and x2pos coordinates
	adc	#$88
	sta	r3L
	lda	r3H
	adc	#$00
	sta	r3H
	lda	r4L
	adc	#$88
	sta	r4L
	lda	r4H
	adc	#$00
	sta	r4H

@2:	LoadB	r2H, $53			; halve the area by half in the vertical direction
	jsr	IsMseInRegion		; and check where the mouse
	bne	@3				; check to see which rows the mouse was
	clc					; resting upon when clicked.
	lda	r14H				; get the 'home'filename entry value
	adc	#$04				; by four to arrive four rows later
	sta	r14H
	LoadB	r2L, $54			; update y1pos
	LoadB	r2H, $7f			; restore y2pos
@3:	sec
	lda	r2H				; adjust y2pos
	sbc	#$16				; by two rows
	sta	r2H
	jsr	IsMseInRegion		; further refine the search on which row
	bne	@4				; the mouse was resting upon when clicked
	clc
	lda	r14H				; adjust the 'home' filename entry
	adc	#$02
	sta	r14H
	ldy	r2H				; adjust y1pos
	iny
	sty	r2L
	clc
	lda	r2L				; adjust y2pos
	adc	#$15				; by two rows
	sta	r2H
@4:	sec					; adjust y2pos by one row
	lda	r2H
	sbc	#$0b				; a row has 11 scanlines
	sta	r2H
	jsr	IsMseInRegion		; finally refine the search on which row
	bne	@5				; the mouse was resting upon when clicked
	ldy	r14H				; update the 'home' filename
	iny
	sty	r14H
	ldy	r2H				; update y1pos
	iny
	sty	r2L
	clc
	lda	r2L				; update y2pos
	adc	#$0a				; by ten scanlines
	sta	r2H
@5:	ldy	r14H				; at this point, the HomeFN+1 pointer is ready
	lda	FNTable,y			; for updating in the FNTable
	bne	@6				; branch if there's a valid filename entry
	rts

@6:	eor	#$ff				; invert the filename entry to indicate if it
	sta	FNTable,y			; was selected or deselected.
	jmp	InvertRectangle		; at this point the specified rectangle is
						; all set up for the inverting process

CustImpRect:				; Custom Imprint Rectangle Routine
						; pass coordinates in Rectangle format
						; however, byte aligned values are used, i.e.,
						; falling on a card boundary.
						; works in either 40 or 80 columns by checking screenMode
						; plus memory offset in RAM expansion at r1
						; plus memory address for color data at r0
	lda	r1L				; get REU memory offset
	sta	rbase+1			; use self-modifying code
	lda	r1H
	sta	rbase+5
	lda	r0L				; save color data offset
	sta	cbase+1			; use self-modifying code
	sta	r7L				; for the VDC stash routines
	lda	r0H
	sta	cbase+5
	sta	r7H
	ldx	#$05				; save pseudoregisters first
@3:	lda	r2,x
	sta	r12,x
	dex
	bpl	@3
	sec
	lda	r2H				; get y2 coordinate (scanline)
	sbc	r2L				; get true height of rectangle
	bit	screenMode			; check which video mode it's running under
	bmi	@5				; do not adjust true height in 80 columns
	lsr
	lsr
	lsr					; divide it by eight
@5:	sta	r15L				; r15L contains true height of rectangle
	sta	tHgt+1			; for the recover routine
	ldx	r2L				; get y1 coordinate (scanline)
	jsr	GetScanLine			; get screen address of pixel coordinate
	bit	screenMode			; check 80 columns and adjust values
	bpl	@6
	jsr	TempHideMouse		; disable soft sprites
	lsr	r3H				; adjust x1 and x2 coordinates for 80 columns
	ror	r3L
	lsr	r3H
	ror	r3L
	lsr	r3H
	ror	r3L				; divide r3 by eight
	lsr	r4H
	ror	r4L
	lsr	r4H
	ror	r4L
	lsr	r4H
	ror	r4L				; divide r4 by eight

@6:	clc
	lda	r5L
	adc	r3L				; xcoordinate (word value)
	sta	r0L
	sta	tXcoord+1			; for the recover routine
	lda	r5H
	adc	r3H
	sta	r0H				; r0 now contains start screen address for the
	sta	tXcoord+5			; specific x1..y1 pixel coordinate
	sec
	lda	r4L				; get true width of rectangle
	sbc	r3L
	sta	r2L
	sta	tWdth+1			; for the recover routines
	lda	r4H
	sbc	r3H
	sta	r2H				; r2 contains true width of rectangle
	sta	tWdth+5			; for the recover routines
	LoadB	r3L, $00			; use bank Zero of the RAM expansion device
	bit	screenMode			; check which video mode it's running under
	bpl	@2
@10:	lda	r2L				; get width for VDC screen
	sta	r8L
	lda	r0H				; set VDC start address
	ldx	#$12
	jsr	WrVDCReg
	lda	r0L
	ldx	#$13
	jsr	WrVDCReg
	ldy	#$00
@7:	ldx	#$1f				; read the contents at that VDC ram address
	jsr	RdVDCReg
	sta	(r7),y			; and store it temporarily
	iny
	dec	r8L				; are we done with the current scanline?
	bne	@7
	MoveW	r0, r9			; save original r0 values
	MoveW	r7, r0			; make r7 the source address as it contains
						; the stashed VDC data
@2:	ldy	#$90				; stash the screen contents onto the RAM device
	jsr	DoRAMOp
	bit	screenMode			; check videomode
	bpl	@8				; branch if 40 columns
	MoveW	r9, r0			; restore original r0 values
@8:	clc
	lda	r1L				; add width in figuring out the RAM offset
	adc	r2L
	sta	r1L
	lda	r1H
	adc	r2H				; r1 is updated for the RAM expansion offset
	sta	r1H
	dec	r15L				; are we done with the rectangle?
	beq	CImpClr
	lda	r0L				; adjust the video ram address
	bit	screenMode			; check video mode
	bpl	@9
	adc	#$50				; add 80 for the 80 column screen
	sta	r0L
	bcc	@10
	inc	r0H				; adjust hibyte	
	bra	@10
@9:	lda	r0L
	adc	#$40				; add 320 to the CBM address
	sta	r0L
	lda	r0H
	adc	#$01
	sta	r0H				; and go back to transferring screen contents
	bra	@2				; onto the RAM expansion device

CImpClr:
	lda	r12L				; restore pseudoregisters and adjust them
	sta	r2L				; y1coordinate
	dec	r12H				; adjust it slightly for the color routines
	lda	r12H
	sta	r2H				; y2coordinate
	lda	r13L
	sta	r3L				; x1coordinate
	lda	r13H
	sta	r3H
	ldx	#r14				; x2coordinate
	jsr	Ddec				; adjust it slightly for the color routines
	lda	r14L
	sta	r4L
	lda	r14H
	sta	r4H
	lda	r1L				; save RAM expansion address offset
	sta	r11L
	lda	r1H
	sta	r11H
	jsr	ConvToCards			; convert rectangle format to color format
	lda	r1L				; import values for the recover routine
	sta	clrdim+1
	lda	r1H
	sta	clrdim+5
	lda	r2L
	sta	clrdim+9
	lda	r2H
	sta	clrdim+13
	lda	cbase+1			; get color buffer address
	sta	r0L
	lda	cbase+5
	sta	r0H
	jsr	SaveColor			; and saves the color info onto the buffer
	lda	r2H				; get height of color rectangle
	sta	r10L				; save it there
	lda	#$00
	sta	r2H
	sta	r3L				; use bank Zero for RAM transfer
	ldx	#r2				; multiply width by height
	ldy	#r10L
	jsr	BMult				; r2 will have COUNT byte for the RAM transfer
	lda	r2L
	sta	cCnt+1			; for the recover routines
	lda	r2H
	sta	cCnt+5
	lda	r11L				; restore RAM expansion address offset
	sta	r1L
	lda	r11H
	sta	r1H
	ldy	#$90				; STASH
	jsr	DoRAMOp			; and stash color contents onto the RAM
						; expansion device
	ldx	#$05				; restore pseudoregisters for successive
@4:	lda	r12,x				; rectangle calls
	sta	r2,x
	dex
	bpl	@4
	rts

CustRcvrRect:				; Custom Recover Rectangle routine using RAM expansion
						; heavily uses self-modifying code installed by CustImpRect
rbase:	lda	#$00
	sta	r1L
	lda	#$00
	sta	r1H				; r1 points to RAM expansion offset
tHgt:	lda	#$00
	sta	r15L				; r15L contains true height of rectangle
tXcoord:	lda	#$00
	sta	r0L
	lda	#$00				; r0 now contains start screen address for
	sta	r0H				; the specific x1..y1 pixel coordinate
tWdth:	lda	#$00
	sta	r2L
	lda	#$00
	sta	r2H				; r2 contains true width of rectangle
	LoadB	r3L, $00			; use bank zero of the RAM expansion device
	bit	screenMode			; check video mode
	bpl	@2
	MoveW	r0, r9			; save commodore address
	lda	cbase+1			; adjust commodore address for REU xfer
	sta	r0L
	lda	cbase+5
	sta	r0H
@2:	ldy	#$91				; fetch the screen contents from the RAM device
	jsr	DoRAMOp
	bit	screenMode			; check video mode
	bpl	@1
	ldy	#$00
	lda	r2L				; get width
	sta	r8L
	lda	r9H				; set up screen address in VDC ram
	ldx	#$12
	jsr	WrVDCReg
	lda	r9L
	ldx	#$13
	jsr	WrVDCReg
@3:	lda	(r0),y			; get video data into the VDC
	ldx	#$1f
	jsr	WrVDCReg
	iny
	dec	r8L				; are we done with the current scanline?
	bne	@3

@1:	clc
	lda	r1L				; add width in figuring out the RAM offset
	adc	r2L
	sta	r1L
	lda	r1H
	adc	r2H				; r1 is updated for the RAM expansion offset
	sta	r1H
	dec	r15L				; are we done with the rectangle?
	beq	cbase
	bit	screenMode			; check video mode
	bpl	@4
	lda	r9L				; get original r0 pointing to video address
	adc	#$50				; add 80 columns to arrive at the next scanline
	sta	r9L
	bcc	@2
	inc	r9H
	bra	@2
@4:	lda	r0L
	adc	#$40				; add 320 to the CBM address
	sta	r0L
	lda	r0H
	adc	#$01
	sta	r0H				; and go back to transferring screen contents
	bra	@2				; from the RAM expansion device
cbase:	lda	#$00			; get color buffer address
	sta	r0L
	lda	#$00
	sta	r0H
cCnt:	lda	#$00
	sta	r2L
	lda	#$00
	sta	r2H				; r2 will have COUNT byte for the RAM transfer
	ldy	#$91
	jsr	DoRAMOp			; and fetch color contents from the RAM
						; expansion device
clrdim:	lda	#$00			; use self-modifying code
	sta	r1L				; x1coord of color rectangle
	lda	#$00
	sta	r1H				; y1coord of color rectangle
	lda	#$00
	sta	r2L				; card width
	lda	#$00
	sta	r2H				; card height
	jmp	RstrColor			; restore colors and exit

;ToggleFiles:
;	ldy	#$00
;@2:	lda	FNTable,y			; toggle filename selections
;	beq	@1				; check to see if we're done
;	eor	#$ff
;	sta	FNTable,y
;	iny
;	bne	@2				; go back and toggle filename selections
;@1:	lda	HomeFN			; get the home filename entry
;	sta	r14L
;	MoveW	HFNRam, r15			; set up pointers for the display routines
;	jmp	enterHere			; and displays the filename selections again

setup4DB:					; sets up the dialog box table for four drives.
	jsr	readDiskName		; reads in the disk name and stores it
	ldx	#$08
@2:	lda	iconLTable-8,x
	sta	r0L
	lda	iconHTable-8,x
	sta	r0H
	lda	driveType-8,x		; check to see if a drive is present
	beq	@3
	cpx	curDrive			; is it the current disk device?
	bne	@4
	lda	onLTable-8,x		; select an ON icon for that drive entry
	sta	r1L
	lda	onHTable-8,x
	sta	r1H
	clv
	bvc	@5				; BRA macro
@4:	lda	offLTable-8,x		; select an OFF icon for that drive entry
	sta	r1L
	lda	offHTable-8,x
	sta	r1H
	clv
	bvc	@5				; BRA macro
@3:	lda	#$00
	sta	r1L
	sta	r1H				; r1 points to nothing
@5:	ldy	#$00
	lda	r1L
	sta	(r0L),y
	iny
	lda	r1H
	sta	(r0L),y			; sets up the icontable
	inx
	cpx	#$0c				; are we done with 8-11 yet?
	bne	@2
	rts

; table of pointers to relevant data
iconLTable:
.byte <aDriveTable,<bDriveTable,<cDriveTable,<dDriveTable
iconHTable:
.byte >aDriveTable,>bDriveTable,>cDriveTable,>dDriveTable
onLTable:
.byte <onAIcon,<onBIcon,<onCIcon,<onDIcon
onHTable:
.byte >onAIcon,>onBIcon,>onCIcon,>onDIcon
offLTable:
.byte <offAIcon,<offBIcon,<offCIcon,<offDIcon
offHTable:
.byte >offAIcon,>offBIcon,>offCIcon,>offDIcon

; these are the routines that get called when the user clicks on these icons
iconADrive:
	lda #$08
.byte $2c
iconBDrive:
	lda #$09
.byte $2c
iconCDrive:
	lda #$0a
.byte $2c
iconDDrive:
	lda #$0b
	sta	progDrive+1			; inits the disk information for the datafile
	jsr	SetDevice			; turns on the disk device
	jsr	GetHeadTS			; get the disk info
	MoveB	r2L, progPartition+1
	jsr	GetDirHead
	MoveB	r1L, progTrack+1
	MoveB	r1H, progSector+1
	jsr	OpenDataDirectory		; opens the directory for the datafiles
	jmp	rSuperDB			; restarts the SuperDB

diskIcon:					; event handler for the DISK icon
	lda	#(5 | 64)
	jsr	GetNewKernal
	jsr	ChPartition			; issues the change partition dialog box
	jsr	RstrKernal
	bra	iconDDrive+8		; and finish off the disk icon handler

; icon bitmap data follows
; 33 bytes for each icon bitmap
offAIcon:
.byte $98					; 24 unique bytes follow
.byte %11111111,%01111110,%11111100
.byte %10000000,%10000001,%00000110
.byte %10000000,%10000001,%00000110
.byte %10000001,%11111111,%10000110
.byte %10000001,%00000000,%10000110
.byte %10000001,%00000000,%10000110
.byte %11111101,%01111110,%10111110
.byte %00111111,%11111111,%11111110

offBIcon:
.byte $98					; 24 unique bytes follow
.byte %11111101,%11111111,%01111110
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%11111111,%00000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %11111101,%11111111,%01111111
.byte %00111111,%11111111,%11111111

offCIcon:
.byte $98					; 24 unique bytes follow
.byte %11111110,%11111111,%01111100
.byte %10000001,%00000000,%10000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%10000110
.byte %11111110,%11111111,%01111110
.byte %00111111,%11111111,%11111110

offDIcon:
.byte $98					; 24 unique bytes follow
.byte %11111101,%11111111,%01111110
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %11111101,%11111111,%01111111
.byte %00111111,%11111111,%11111111

onAIcon:
.byte $98					; 24 unique bytes follow
.byte %11111111,%10000001,%11111100
.byte %11111111,%01111110,%11111110
.byte %11111111,%01111110,%11111110
.byte %11111110,%00000000,%01111110
.byte %11111110,%11111111,%01111110
.byte %11111110,%11111111,%01111110
.byte %11111110,%11111111,%01111110
.byte %00111111,%11111111,%11111110

onBIcon:
.byte $98					; 24 unique bytes follow
.byte %11111110,%00000000,%11111110
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%00000000,%11111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%00000000,%11111111
.byte %00111111,%11111111,%11111111

onCIcon:
.byte $98					; 24 unique bytes follow
.byte %11111111,%00000000,%11111100
.byte %11111110,%11111111,%01111110
.byte %11111110,%11111111,%11111110
.byte %11111110,%11111111,%11111110
.byte %11111110,%11111111,%11111110
.byte %11111110,%11111111,%01111110
.byte %11111111,%00000000,%11111110
.byte %00111111,%11111111,%11111110

onDIcon:
.byte $98					; 24 unique bytes follow
.byte %11111110,%00000000,%11111110
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%11111111,%01111111
.byte %11111110,%00000000,%11111111
.byte %00111111,%11111111,%11111111

readDiskName:				; reads in disk name and stores it
	lda	#$50				; x1 - 144 in 80 columns
	sta	r3L
	lda	#$e0				; x2 - 288 in 80 columns
	sta	r4L
	lda	#$00
	sta	r3H
	lda	#$00				; x2 - 288 in 80 columns
	sta	r4H
	lda	#$80				; y1 scanline
	sta	r2L
	lda	#$8f				; y2 scanline
	sta	r2H
	jsr	Rectangle			; clear out the disk name area
	ldx	#r1
	jsr	GetPtrCurDkNm		; get disk name
	LoadW	r0, diskName
	ldy	#$10
	lda	#$00				; delimit it
	sta	(r0),y
	dey
@1:	lda	(r1),y
	sta	(r0),y			; transfer contents to diskName
	dey
	bpl	@1
	lda	#$50				; 144 in 80 columns
	sta	r11L
	lda	#$00
	sta	r11H
	LoadB	r1H, $8c			; baseline
	jmp	PutString
