; file containing tables, variables, data, buffers and ramsects
.data

SDBITable:					; SuperDB file requestor icon table
.byte	$09					; # of icons - use self modifying code here
.word	$0000					; don't alter the mouse for now
.byte	$00
.word	bm_Close				; bitmap data for the close icon
.byte	$02					; xpos (card) - $05 for 80 columns
.byte	$20					; ypos (scanlines)
.byte	$01					; width (card)
.byte	$08					; height (scanlines)
.word	OFilesRoutine			; event handler to close the SuperDB file requestor
;.word	SDBClose			; event handler to close the SuperDB file requestor
.word	bm_LeftArrow			; bitmap data for the left disk page icon
.byte	$03					; xpos (card) - use bitmap doubling
.byte	$80					; ypos (scanlines)
.byte	$02					; width (card) - use bitmap doubling
.byte	$08					; height (scanlines)
.word	PageLeft				; event handler to page the filenames leftwards
.word	bm_RiteArrow			; bitmap data for the right disk page icon
.byte	$22					; xpos (card) - $45 for 80 columns
.byte	$80					; ypos (scanlines)
.byte	$02					; width (card) - use bitmap doubling
.byte	$08					; height (scanlines)
.word	PageRite				; event handler to page the filenames rightwards
.word	bm_OpenIcon				; bitmap data for the open files icon
.byte	$06					; xpos (card) - $0b for 80 columns
.byte	$80					; ypos (scanlines)
.byte	$03					; width (card) - use bitmap doubling
.byte	$18					; height (scanlines)
.word	OFilesRoutine			; event handler for the open files icon
;.word	bm_Toggle			; bitmap data for the toggle files icon
;.byte	$0e				; xpos (card) $19 for 80 columns
;.byte	$80				; ypos (scanlines)
;.byte	$03				; width (card) - use bitmap doubling
;.byte	$18				; height (scanlines)
;.word	ToggleFiles			; event handler for the toggle files icon
aDriveTable:
.word offAIcon
.byte $0a,$90				; default pos - $12,$90 in 80 column mode
.byte $03,$08				; height/width - use bitmap doubling here
.word iconADrive
bDriveTable:
.word offBIcon
.byte $0d,$90				; default pos
.byte $03,$08				; height/width
.word iconBDrive
cDriveTable:
.word offCIcon
.byte $10,$90				; default pos
.byte $03,$08				; height/width
.word iconCDrive

dDriveTable:
.word offDIcon
.byte $13,$90				; default pos
.byte $03,$08				; height/width
.word iconDDrive
.word bm_Disk
.byte $16,$88				; default pos
.byte $03,$10				; width/height
.word diskIcon				; event handler

DITable:					; dummy icon table
.byte	$01,$00,$00,$00,$00,$00,$00,$00,$01,$01,$00,$00

bm_Close:					; compacted bitmap data for the close icon
.byte	$81,$ff,$06,$81,$81,$ff
bm_LeftArrow:				; compacted bitmap data for the left disk page icon
.byte	$90,$ff,$ff,$83,$01,$8f,$01,$bf,$fd,$bf,$fd,$8f,$01,$83,$01,$ff,$ff
bm_RiteArrow:				; compacted bitmap data for the right disk page icon
.byte	$90,$ff,$ff,$80,$c1,$80,$f1,$bf,$fd,$bf,$fd,$80,$f1,$80,$c1,$ff,$ff
bm_OpenIcon:				; compacted bitmap data for the open icon
.byte	$c8,$ff,$ff,$ff,$80,$00,$01,$9f,$00,$61,$a0,$ff,$11,$a0,$01,$15
.byte	$a0,$01,$0d,$a0,$01,$1d,$a0,$00,$01,$a0,$ff,$fd,$a0,$ff,$fd
.byte	$a1,$ff,$f9,$a1,$ff,$f9,$a3,$ff,$f1,$a3,$ff,$f1,$a7,$ff,$e1
.byte	$a7,$ff,$e1,$af,$ff,$c1,$af,$ff,$c1,$9f,$ff,$81,$9f,$ff,$81
.byte	$bf,$ff,$01,$bf,$ff,$01,$80,$00,$01,$ff,$ff,$ff
;bm_Toggle:					; compacted bitmap data for the toggle files icon
;.byte	$03,$ff,$98,$80,$00,$01,$bf,$2b,$81,$a1,$28,$41,$a1,$28,$21,$a7,$da,$f1
;.byte	$a7,$da,$f9,$a7,$da,$fd,$a7,$c0,$fd,$e0,$03,$83,$a7,$ff,$fd
;.byte	$95,$a7,$f3,$fd,$a7,$ed,$fd,$a7,$ed,$fd,$a7,$f3,$fd,$a7,$ff,$fd
;.byte	$a7,$ff,$fd,$bf,$ff,$fd,$e0,$03,$83,$87,$ff,$fd,$83,$80,$00,$01,$03,$ff
bm_Disk:					; compacted bitmap data for the disk icon
.byte	$b0,$ff,$ff,$ff,$80,$00,$01,$bc,$00,$01,$a2,$00,$41,$a2,$00,$41,$a2,$80,$41
.byte	$a2,$00,$41,$a2,$9e,$45,$a2,$a0,$49,$a2,$a0,$51,$a2,$9e,$61,$a2,$81,$51
.byte	$a2,$81,$49,$bc,$9e,$45,$80,$00,$01,$ff,$ff,$ff

cols64:					; the c64 palette itself
.byte	$00,$66,$99,$bb,$22,$44,$88,$cc,$ee,$aa,$55,$ff,$33,$77,$dd,$11

godsig:					; god(x) signature
.byte	$47,$4f,$44

genDBTable:					; generic DB table
.byte	DEF_DB_POS
.byte	DB_USR_ROUT
.word	setMargin
.byte	OK
.byte	$11,$48				; X and Y offsets
.byte	DBVARSTR
.byte	$10,$10				; X and Y offsets
.byte	r5					; pointer to NULL terminated string
.byte	NULL

.bss
;.ramsect	;$39bb	; the ramsect section has been changed because the initialiZation code
		; had to come afterwards to conserve codespace
		; so these variables will overwrite the initialiZation code!
xdblB:
.res 1
xadd1W:
.res 2
;screenMode:					; which computer is it running and which screen mode?
;.res 1
dataIndex:					; index to the datafile table, from 1 to 16 datafiles
.res 1
progDrive:					; the drive from which the application was loaded from.
.res	$11
progPartition:				; the partition from which the application was loaded from
.res	$11
progTrack:					; the t/s of directory from which the application was
.res	$11					; loaded from
progSector:					; the first entry of these four tables is for the program -
.res	$11					; the remaining 16 entries are for the respective datafiles
scpuflag:					; SuperCPU flag
.res 1
sp:						; start page of expansion RAM in SuperRAM, etc.
.res 4
mmucpy:					; 128 MMU config
.res 1
sb:						; start bank of expansion RAM (other than SuperRAM)
.res 1
inpBuffer:					; for the ReadByte input buffer
.res 256
cBuf:						; copy of pointer to inpBuffer
.res 2
cIndex:					; copy of index into inpBuffer
.res 2
cTS:						; copy of track/sector for inpBuffer
.res 2
;speed:					; processor speed
;.res	1
HomeFN:					; the 'home' filename entry
.res 1
HFNRam:					; the expansion ram pointer pointing to the home filename
.res 2
fileRAM:					; the expansion ram offset for the start of the filename
.res 2					; entry buffer.
FNTable:					; a table of filename entries for the SuperDB File Req.
.res 256					; $00 = no filename
						; $01 = filename
						; $fe = selected filename
curlen:					; current filename length
.res	$01
saveRecVec:					; for the recover vector
.res	2

;make this buffer larger if you plan to
;use larger dialogue boxes. This can store
;the color area for a standard size DB from
;the 80 column screen, 48 cards wide by 12
;cards high.
dbColorBuf:
.res 1280					; enough for the SuperDB routine
curVMod:					; current Viewer module
.res 1
nmiSave:					; save original NMI vector
.res 2
hex:
.res 2					; hexadecimal string
ViewVIndex:					; Viewers Supporting Module's VLIR index block
.res 256
diskName:
.res 17
fileName:
.res 17
endOfProg:
.res	$01					; for the symbol table

ViewerModules =	$5000			; Load Address of the Viewer modules.
