; core routines for 4Bit Viewer for GEOS

; nmi16	=	$ffea	; 16 bit NMI vector

OpenDataDirectory:			; opens the disk directory housing the respective
	ldy	dataIndex			; datafile & gets the index into the datafile table
.byte	$2c					; BIT opcode
OpenProgDirectory:
	ldy	#$00				; otherwise open the program directory
	lda	progDrive,y			; gets the actual drive number
	sty	r15H				; save it temporarily
	jsr	SetDevice			; and opens the drive
	lda	#(5 | 64)			; issue a group 5 command
	jsr	GetNewKernal		; from the Wheels kernal
	ldy	r15H				; retrieve .Y
	ldx	progPartition,y		; get partition # of the disk device
	jsr	GoPartition
	jsr	RstrKernal			; bank out the Wheels kernal
	ldy	r15H				; retrieve .Y
	lda	progTrack,y			; get t/s of directory
	sta	r1L
	lda	progSector,y
	sta	r1H
	jmp	OpenDirectory		; and opens the directory & rts's

AdjPixCoords:
	lda	r3H
	ora	xdblB
	sta	r3H
	ldx	#r3
	jsr	NormalizeX
	lda	r4H
	ora	xadd1W
	sta	r4H
	ldx	#r4
	jmp	NormalizeX

puthex:	pha
	lsr
	lsr
	lsr
	lsr					; 0..9 -> $30..$39, A..F -> $41..$46
	cmp	#10
	bcc	@1
	adc	#$70-10
@1:	eor	#$30
	sta	hex
	pla
	and	#15
	cmp	#10
	bcc	@2
	adc	#$70-10
@2:	eor	#$30
	sta	hex+1
	rts

; set up a generic DB to display messages, etc.
IssueMSG:
	stx	r5L
	sty	r5H				; for the DBVARSTR function
	LoadW	r0, genDBTable		; generic DB table
	jmp	DoRcvrBox			; issues a message in a DB w/ an OK icon and exits

setMargin:
	lda	screenMode			; check computer
	bmi	@1
	LoadW	leftMargin, $0050
	rts
@1:	LoadW	leftMargin, ($0050 | DOUBLE_W)
	rts

TurnNative:
	sta	saveA+1			; save .A register
	PopW	returnAddress		; save the return address
	php
	sei					; disable GEOS interrupts
	lda	screenMode			; check computer
	bne	@6				; i/o and ram always visible in Wheels 128
	PushB	CPU_DATA
	LoadB	CPU_DATA, IO_IN		; enable i/o in geos 64 config
@6:	MoveW	nmi16, nmiSave		; save NMI vector
;	LoadW	nmi16, #phonyVector	; and disable NMI's
	clc
.byte	$fb					; xce - Native mode
.byte	$8b					; phb
	lda	sp+1				; get bank byte
	pha
.byte	$ab					; plb - Set DBR
	PushW	returnAddress		; restore the return address
saveA:	lda	#$00			; restore .A register
	rts

TurnEmulation:
	PopW	returnAddress		; save the return address
.byte	$ab					; plb - set original DBR
	sec
.byte	$fb					; xce - Emulation mode
	MoveW	nmiSave, nmi16		; restore NMI's
	lda	screenMode			; check computer
	bne	@5				; Wheels 128 always has ram and i/o visible
	pla					; get 64 configuration
	sta	CPU_DATA
@5:	plp					; get Status register and reenable interrupts
	PushW	returnAddress		; restore the return address
	rts

DError:
	jsr	puthex			; for debugging
	lda	hex
	sta	tDiskError+2
	lda	hex+1
	sta	tDiskError+3
	ldx	#<tDiskError
	ldy	#>tDiskError		; pointer to text
	jsr	IssueMSG			; makes a dialog box
	LoadW	otherPressVec, $0000	; deactivate the filename selector
	LoadW	r0, DITable			; deactivate the icons
	jsr	DoIcons
	lda	#$02				; checkerboard
	jsr	SetPattern
	LoadW	r3, $0000			; x1coord
	LoadB	r2L, $00			; y1coord
	LoadW	r4, 319			; x2coord
	LoadB	r2H, 199			; y2coord
	jsr	AdjPixCoords
	jsr	Rectangle
	jsr	ConvToCards
	LoadB	r4H, $61			; purple/white
	jsr	ColorRectangle
	jsr	ReDoMenu			; redraws the menu's
	ldx	#$ff
	txs					; reset the stack
	jmp	MainLoop			; and exit via the GEOS mainloop?
;	rts

DoRcvrBox:
	jsr	SaveDB
	PushW	keyVector
	LoadB	keyVector+0, 0
	sta	keyVector+1
	jsr	DoDlgBox
	PopW	keyVector
	lda	r0L
	rts

SaveDB:
	MoveW	RecoverVector,saveRecVec
	LoadW	RecoverVector, RstrDB
	ldx	#31
@10:	lda	r0,x
	pha
	dex
	bpl	@10
	jsr	LdDBCoords
	LoadW	r0, dbColorBuf
	LoadW	r1, $0000			; for the expansion RAM offset
	jsr	CustImpRect			; save the area underlying the rectangle
	jsr	ConvToCards
	MoveB	appDBColor,r4H
	jsr	ColorRectangle
	ldx	#0
@50:	pla
	sta	r0,x
	inx
	cpx	#32
	bcc	@50
	rts

LdDBCoords:
	ldy	#0
	lda	(r0),y			;DEF_DB_POS?
	bmi	@50				;branch if so.
	iny
	ldx	#0
@10:	lda	(r0),y
	sta	r2,x
	iny
	inx
	cpx	#6
	bcc	@10
	rts
@50:	LoadB	r2L, DEF_DB_TOP		; add one here for the custom imprint/recover
	LoadB	r2H, DEF_DB_BOT+1		; routines.
	LoadW	r3,  $0040			; DEF_DB_LEFT
	LoadW	r4,  $0100			; DEF_DB_RIGHT+1	; ditto here
	bit	screenMode			; check video mode
	bpl	@1
	asl	r3L				; the custom imprint/recover routines do not handle
	asl	r4H				; bitmap doubling yet.
@1:	rts

RstrDB:
	ldx	#31
@10:	lda	r0,x
	pha
	dex
	bpl	@10
	jsr	CustRcvrRect		; use custom imprint/recover routines
	ldx	#0
@50:	pla
	sta	r0,x
	inx
	cpx	#32
	bcc	@50
	MoveW	saveRecVec,RecoverVector
	rts

getFNRAM:					; get filename from expansion RAM in sequence
	jsr	OpenDataDirectory		; opens the disk directory for the datafile
	jsr	RGetFilename
	beq	@2				; if Zero then we're done getting the filenames
	bpl	@1				; if negative flag cleared, no disk error occurred
@2:	rts					; negative flag set to indicate error
@1:	ldy	#$01
	lda	dirEntryBuf,y		; get t/s of the file
	sta	cTS
	iny
	lda	dirEntryBuf,y
	sta	cTS+1
	LoadW	cBuf, inpBuffer
	lda	#$00
	sta	cIndex
	sta	cIndex+1			; for the ReadByte routine
	tya					; force nonZero result
	rts

RGetFilename:				; gets a single filename from expansion RAM
	ldy	HomeFN			; #$00
	lda	FNTable,y			; find the first filename
	bmi	@2				; branch when a selected filename is found
	jsr	AdjRAMOffset		; adjusts the expansion RAM offset
	bne	RGetFilename
	rts					; zero flag set to indicate no more files
@2:	eor	#$ff				; deselect the filename
	sta	FNTable,y
	LoadW	r0, fileName		; Commodore addy
	MoveW	HFNRam, r1			; Expansion RAM addy
	LoadW	r2, $0010			; move only 16 bytes
	LoadB	r3L, $00			; use bank Zero
	ldy	#$91				; fetch expansion ram contents
	jsr	DoRAMOp
	ldy	#$00				; strip filename of padded spaces
@7:	lda	fileName,y
	beq	@6				; check for the NULL terminator, just in case
	cmp	#$a0				; check for padded space
	beq	@6
	iny
	cpy	#$10				; are we done w/ the filename?
	bne	@7
@6:	lda	#$00				; delimit the filename and strip it of the
	sta	fileName,y			; padded spaces at the same time
	tya					; save length of filename
	sta	curlen
	LoadW	r6, fileName		; preps filename for the FindFile function
	jsr	FindFile
	txa					; check error
	beq	@1
	jmp	DError			; issue disk error message
@1:	inx					; force nonZero result
	rts					; negative flag set to indicate error

AdjZPOffset:				; adjusts the Zero page pointers by sixteen
						; pass .X the Zero page pointer
	clc
	lda	$00,x
	adc	#$10
	sta	$00,x
	bcc	@1
	inc	$01,x
@1:	rts

AdjRAMOffset:				; adjusts the ram offset by sixteen
	clc
	lda	HFNRam
	adc	#$10				; by a full filename length
	sta	HFNRam
	bcc	@4
	inc	HFNRam+1			; take care of hibyte
@4:	inc	HomeFN			; adjusts index pointer to filename table
	rts

sFNTable:					; sets pointers to the filename table
	lda	#$00
	sta	HomeFN			; set index into the filename entry table
	MoveW	fileRAM, HFNRam		; sets expansion ram pointers
	rts

;call this with x holding a register number.
;This will return with the accumulator holding
;the value from the register.
RdVDCReg:
	stx	$d600
@10:	bit	$d600
	bpl	@10
	lda	$d601
	rts

;call this with x holding a register number
;and the accumulator holding a value to place
;in the register.
WrVDCReg:
	stx	$d600
@10:	bit	$d600
	bpl	@10
	sta	$d601
	rts

makec64:					; creates a table for converting the brightness palette of
						; Godot to the standard CBM color palette
	ldy	#$00
@1:	tya
	lsr
	lsr
	lsr
	lsr
	tax
	lda	cols64,x
	and	#$f0
	sta	a0L
	tya
	and	#$0f
	tax
	lda	cols64,x
	and	#$0f
	ora	a0L
	sta	c64,y
	iny
	bne	@1
	rts

LdViewerMod:				; Loads in a Viewer module. Pass .X the Module #
						; Add offset of 1 to .X prior to calling this routine
						; to compensate for the T/S link.
						; OpenProgDirectory should be done prior to this call.
	txa
	asl					; multiply it by two to arrive at the correct t/s link
						; in the index block.
	cmp	curVMod			; is it already in memory?
	beq	@1				; abort the load if that is the case.
	sta	curVMod			; set the current Viewer Module #
	tax
	lda	ViewVIndex,x		; get t/s link
	sta	r1L
	lda	ViewVIndex+1,x
	sta	r1H
	LoadW	r7, ViewerModules		; currently $5000
	LoadW	r2, $0e00			; Buffer size
	jsr	ReadFile			; Loads it into memory.
	txa
	beq	@1				; check disk error.
	jmp	DError
@1:	rts

setoffset:					; sets the offsets needed for expansion RAM address
						; pass r0 a word pointer for the start column
						; (in cards - 0 to 39)
						; pass r1L a byte pointer for the start line
						; pass .Y the picture #
	lda	picwidth,y			; get picture width for a particular picture
	sta	a2L
	lda	#$00
	sta	a2H				; middle byte of a 24 bit value
	sta	a3L				; high byte of a 24 bit value
	sta	a4L
	sta	a4H
	asl	a2L
	rol	a2H
	asl	a2L
	rol	a2H
	asl	a2L
	rol	a2H				; and multiply it by 8

	ldx	r1L				; get start line
	beq	@1				; are we done?
@2:	clc					; do a 24-bit multiplication by simple addition
	lda	a4L
	adc	a2L
	sta	a4L				; low byte of a 24 bit value
	lda	a4H
	adc	a2H
	sta	a4H				; middle byte of a 24 bit value
	lda	a3L
	adc	#$00
	sta	a3L				; high byte of a 24 bit value
	dex					; are we done with the multiplication?
	bne	@2
						; at this point, a3L, a4 has the 24-bit value

@1:	asl	r0L
	rol	r0H
	asl	r0L
	rol	r0H
	asl	r0L
	rol	r0H				; multiply the start column value by 8

	clc
	lda	r0L
	adc	a4L
	sta	a4L				; low byte of a 24 bit value
	lda	r0H
	adc	a4H
	sta	a4H				; middle byte of a 24 bit value
	lda	picbank,y			; get starting bank
	adc	a3L
	sta	r9H				; bank byte
						; Now, the value at r0 & r9H contains the values needed							; to arrive at the correct address in expansion RAM.

picRAMSize:					; routine that calculates # of 64Kb banks required by								; a picture occupying expansion RAM.
						; pass .X = width (in cards) resolution and
						; .Y = height (in cards) resolution of the entire picture.
						; returns a value in r2L the # of 64Kb banks needed.
	stx	r0L
	sty	r2L
	ldy	#r0L				; pass parameters to the GEOS Kernal BBMult routine.
	ldx	#r2L
	jsr	BBMult
	lda	#$00
	sta	r0L
	lda	#$08				; constant value (2048)
	sta	r0H
	ldx	#r2L
	ldy	#r0L				; pass parameters to the GEOS Kernal Ddiv routine.
	jsr	Ddiv
	inc	r2L				; arrive at the true # of 64Kb banks needed to store
	rts					; this picture into expansion RAM memory.

FreePicture:				; pass curPicture the picture # to free up in expansion
						; ram memory.
	ldy	curPicture			; free up RAM that is occupied by the pictures.
	lda	picbank,y			; get starting bank
	sta	r6L
	lda	picsize,y			; get # of banks the picture occupies.
	sta	r6H
	lda	#(0|64)
	jsr	GetNewKernal
@1:	jsr	FreeRAMBlock		; free up the banks in expansion RAM memory
	inc	r6L				; free up the next 64Kb bank.
	dec	r6H
	bne	@1				; are we done freeing up all banks?
	jmp	RstrKernal
