;.include "../include/geos/geossym.inc"
;.include "../include/geos/geossym2.inc"
;.include "../include/geos/diskdrv.inc"
;.include "../include/geos/jumptab.inc"
;.include "../include/geos/const.inc"
;.include "../include/geos/geosmac.ca65.inc"
;.include "../include/geos/wheelsym.inc"


; converts the 4bit format into multicolor format

; some equates
fetch4Bit		= $0403		; location of the fetch 4Bit from buffer routine

;graphicsMode	= $003f		; graphics mode 80 or 40 columns
;scpubk2		= $d074		; select VICBank Two optimization mode
;scpunot		= $d077		; select no Optimization mode (default)
;scpuenb		= $d07e		; enables the SCPU registers
;scpudis		= $d07f		; disables the SCPU registers
;scpuver		= $d0b0		; indicates which version of the scpu online
;scpudet		= $d0bc		; detects whether a SCPU is online
;firstpage		= $d27c		; first available SuperRAM bank, etc.
;expram		= $e487		; RAM version identifier string
;ram128		= $f6dd		; 128 RAM version identifier string
;nmi16		= $ffea		; 16 bit NMI vector

colorram		= r10			; proxy for colorram
videoram		= r11			; proxy for videoram
pixeldat		= r12			; proxy for pixel data

	jmp	EnterDeskTop		; in case the user accidentially clicked on the Viewers
						; module first.
;Maintain a consistent jump table
; Full renderization and optimization for entire screen
	jmp	convert4bit

; this handles the irq routine/keyboard polling.
	jmp	irqservice

; Implement the scrolling routines
	jmp	SUp				; scrolls the image upwards
	jmp	SDown				; scrolls the image downwards
	jmp	SLeft				; scrolls the image leftwards
	jmp	SRight			; scrolls the image rightwards

; converts 4bit format to multicolor format
convert4bit:
; set up tables first
	LoadW	r1, $a000			; clear the screen first
	LoadW	r0, $1f40
	jsr	ClearRam
	jsr	setDimensions
	ldx	#$1f
	lda	#$00				; clear out the histogram
@5:	sta	histotab,x
	dex
	bpl	@5

@8:	MoveB	a2L, a2H			; reset the physical screen width variable
	LoadB	r14L, $00			; initialize r14
	jsr	fetch4Bit
@6:	ldx	#$0f				; clear out the color distribution table
	lda	#$00
@7:	sta	colorcount,x
	dex
	bpl	@7
	ldy	#$1f				; do 8 cardrows at a time (4 bytes of 4bit data)
@1:	lda	(r14),y			; get 4bit data
	and	#%00001111			; get rid of upper nybble
	tax					; index the byte found there
	inc	colorcount,x		; and count the colors found so far
	dey
	bpl	@1				; go through a single cardrow

	iny					; optimize a single color for colorram
	sty	optcolor
	ldx	#$0f				; go through the color spectrum
@4:	lda	colorcount,x
	beq	@3				; if empty then skip that color
	iny					; count colors in a graphics card
	cmp	optcolor			; compare the count against the most counted color
	beq	@3				; if equal then skip that color
	bcc	@3				; if less then skip that color
	sta	optcolor			; if more then make it the new 'most counted' color
	stx	coltable			; preserve the color value temporarily
@3:	dex					; for the color ram entry
	bpl	@4				; go through colors $00-$0f
	cpy	#$04				; does the graphics card have more than 3 colors?
	bcc	@2
	ldx	coltable			; count the most predominant color in the graphics
	inc	histotab,x			; card to arrive at the proper colorram offset
	bne	@2				; take care of high byte
	inc	histotab+16,x
@2:	clc
	lda	r14L				; check for more 4bit data
	adc	#$20				; in the next graphics card
	sta	r14L
	bcc	@9				; did we finish the 256-byte 4-bit buffer?
	jsr	fetch4Bit
@9:	dec	a2H				; decrement the physical screen width variable
	bne	@6				; are we done with the current screen row?

	clc
	lda	a3L				; add in the REU location and the REU offset for the
	adc	a0L				; next screen row.
	sta	a3L
	sta	r13L				; for the REU. (lobyte)
	lda	a3H
	adc	a0H
	sta	a3H
	sta	r13H				; (hibyte)
	lda	r9H
	adc	#$00
	sta	r9H
	sta	pbank				; (bankbyte)

	dec	r9L				; are we done with all screen rows?
	bne	@8

; The histogram for all visible graphical cards have been computed. Need to pick the best
; color to arrive at the background value.
calcColor:
	lda	#$00
	sta	optcolor
	sta	optcolor+1
	ldx	#$0f	; go through the color spectrum
@4:	lda	histotab+16,x		; check hibyte
	cmp	optcolor+1
	bcc	@3				; if less then skip that color
	bne	@2				; if hibytes are equal then investigate low byte
	lda	histotab,x
	cmp	optcolor			; compare the count against the most counted color
	beq	@3				; if equal then skip that color
	bcc	@3				; if less then skip that color
@2:	lda	histotab,x
	sta	optcolor			; if more then make it the new 'most counted' color
	lda	histotab+16,x
	sta	optcolor+1
	stx	coltable			; preserve the color value temporarily
@3:	dex					; for the color ram entry
	bpl	@4				; go through colors $00-$0f
	lda	coltable			; get color value
	sta	optbkgd			; preserve it for the background color value


; renders 4bit format to multicolor format
; set up tables first
	jsr	setDimensions

convertclip:				; converts a clipped area onscreen.
	MoveB	a2L, a2H			; reset the physical screen width variable
	LoadB	r14L, $00			; initialize r14
	jsr	fetch4Bit
blkloop:
	lda	xScroll			; check clipped region
	beq	@11
	dec	xScroll
	bne	@16
	lda	#40
	sta	xScroll			; reset it
	bne	@11				; relative JMP
@16:	clc
	lda	pixeldat
	adc	#$08				; take care of pixel data
	sta	pixeldat
	bcc	@12
	clc
	inc	pixeldat+1
@12:	lda	r14L
	adc	#$20
	sta	r14L				; take care of 4-bit buffer offset
	bcc	@10				; did we finish the 256-byte 4-bit buffer?
	jsr	fetch4Bit
@10:	jmp	skipclip

@11:	lda	yScroll			; check clipped region
	beq	@13
	clc
	lda	pixeldat
	adc	#$40				; take care of pixel data
	sta	pixeldat
	lda	pixeldat+1
	adc	#$01
	sta	pixeldat+1
	lda	colorram
	adc	#40
	sta	colorram
	bcc	@14
	inc	colorram+1
	clc
@14:	lda	videoram
	adc	#40
	sta	videoram
	bcc	@15
	clc
	inc	videoram+1
@15:	lda	a3L				; add in the REU location and the REU offset for the
	adc	a0L				; next screen row.
	sta	a3L
	sta	r13L				; for the REU. (lobyte)
	lda	a3H
	adc	a0H
	sta	a3H
	sta	r13H				; (hibyte)
	lda	r9H
	adc	#$00
	sta	r9H
	sta	pbank				; (bankbyte)
	jsr	fetch4Bit
	dec	r9L				; decrement the card row counter
	dec	yScroll
	bne	@11

@13:	ldx	#$0f				; clear out the color distribution table
	lda	#$00
@7:	sta	colorcount,x
	dex
	bpl	@7
	ldy	#$03
@9:	lda	bits,y
	sta	bitpatt,y			; create a bit pattern table
	lda	#32				; clear the color table as well
	sta	coltable+1,y
	dey
	bpl	@9
	lda	optbkgd			; get the optimized color value for the background
	sta	coltable
	ldy	#$1f				; do 8 cardrows at a time (4 bytes of 4bit data)
@1:	lda	(r14),y			; get 4bit data
	and	#%00001111			; get rid of upper nybble
;	nop
;	nop					; self-modifying code used here - use LSR to get rid of
						; lower nybble
	tax					; index the byte found there
	inc	colorcount,x		; and count the colors found so far
	dey
	bpl	@1				; go through a single cardrow
	iny					; optimize a single color for colorram

; if the routine below had a .X =1 and went up to 15 instead of the other way
; around, the colors selected could be different.
; According to Godot's brightness palette, this routine is designed to select
; brighter colors for the color ram.
	tya
	sta	optcolor
	ldx	optbkgd			; delete the background color entry
	sta	colorcount,x
	ldx	#$0f				; go through the histogram
@4:	lda	colorcount,x
	beq	@3				; if empty then skip that color
	cmp	optcolor			; compare the count against the most counted color
	beq	@3				; if equal then skip that color
	bcc	@3				; if less then skip that color
	sta	optcolor			; if more then make it the new 'most counted' color
	stx	coltable+3			; and store the corresponding color entry here
@3:	dex					; for the color ram entry
	bpl	@4				; go through colors $01-$0f
	lda	coltable+3			; has it been filled with a color?
	cmp	#$20
	beq	reorder			; if not, then jump to the reordering routines

	tax
	tya
	sta	colorcount,x		; zero out its entry
	sta	optcolor			; zero out the index
	ldx	#$0f				; find most used color in a single card
@2:	lda	colorcount,x
	beq	@5				; if empty, move onto the next color entry
	cmp	optcolor			; check for the highest number of a single color
	beq	@5				; if equal numbers then skip that color entry
	bcc	@5				; if less numbers then skip that color entry
	sta	optcolor			; make it the new number showing highest color count
	stx	coltable+1
@5:	dex					; for videoram (upper nybble).
	bpl	@2
	lda	coltable+1			; has it been filled with a color?
	cmp	#$20
	beq	reorder			; if not, then jump to reordering routines.
	tax
	tya
	sta	colorcount,x		; clear out the color entry that was previously found
	sta	optcolor			; and start the search for a second color
	ldx	#$0f				; find second most used color in a single card
@8:	lda	colorcount,x
	beq	@6				; if empty, move onto the next color entry
	cmp	optcolor			; check for the highest number of a single color
	beq	@6				; if equal numbers then skip that color entry
	bcc	@6				; if less numbers then skip that color entry
	sta	optcolor			; make it the new number showing highest color count
	stx	coltable+2			; and the color entry into the color table
@6:	dex					; for videoram (lower nybble).
	bpl	@8

reorder:
; at this point, the color table is now filled out.
; we need to insert color values into videoram
	lda	coltable+2			; get selected videoram values
	and	#$0f				; get rid of upper nybble
	sta	a1H				; save it temporarily
	lda	coltable+1
	asl					; move it to the upper nybble
	asl
	asl
	asl
	ora	a1H				; and add in the lower nybble
	tax					; index it
	lda	c64,x				; and retrieve the color 64 equivalent
	sta	(videoram),y
	lda	coltable+3			; get selected color ram value
	and	#$0f				; get rid of upper nybble
	tax					; index it
	lda	c64,x				; and retrieve the color 64 equivalent
	sta	(colorram),y

; we need to sort the filled out color table with lower values first in
; an ascending order.
	ldx	#$00
@1:	stx	a1H
	ldy	#$03
@2:	lda	coltable,x
	cmp	coltable,y			; see which color entry is higher
	bcc	@3
	beq	@3				; if equal or less then do nothing
	pha
	lda	coltable,y
	sta	coltable,x			; otherwise, switch colors
	pla
	sta	coltable,y
	lda	bitpatt,x			; rearrange the corresponding bit patterns
	pha
	lda	bitpatt,y
	sta	bitpatt,x			; switch bitpatterns
	pla
	sta	bitpatt,y
@3:	dey
	cpy	a1H				; go through all possible combinations to sort the
	bne	@2				; color table
	inx
	cpx	#$03				; are we done sorting the color table?
	bne	@1

; Next we need to spread out the colors onto a histogram. This way, colors that have to be
; discarded due to the VIC's color limitations will be assigned to their neighboring colors
; on Godot's brightness scale.
	ldy	#$ff
	sty	a1H
@4:	iny
	lda	coltable,y			; need to compute average of neighboring colors
	clc
	adc	coltable+1,y
	lsr					; average the added colors
	cmp	#16				; have we exceeded the maximum range?
	bcc	@5				; if so, then set .A to 15
	lda	#15
@5:	sta	r15L
	lda	bitpatt,y			; store in the bit pattern
	ldx	a1H
@6:	inx
	sta	histotab,x			; create a histogram table of bit patterns
	cpx	r15L				; are we done creating a particular bit pattern on
	bcc	@6				; the histogram?
	cpx	#15				; are we done with the entire histogram?
	bcs	render			; branch out when done
	stx	a1H
	cpy	#$03				; are we done with the sorted color table?
	bne	@4

render:
; the bit patterns corresponding to their color values have been spread out
; over the histogram at histotab and can now be used to render the actual bitmap.
	lda	#$08				; grab an entire card
	sta	r15L
@3:	lda	#$00
	sta	a1H
	ldy	#$03				; grab a cardrow
@1:	lda	(r14),y			; get Godot's four bit values
	and	#%00001111			; get rid of upper nybble
;	nop
;	nop					; self modifying code - use LSR's here to get upper nybble
	tax					; index the color found there
	lda	histotab,x			; get the proper bit pattern
	and	mask,y			; set up the mask for inserting the proper bitpair
	ora	a1H				; we are creating four bitpairs onto the same byte
	sta	a1H
	dey
	bpl	@1
	lda	a1H				; has the byte containing graphics bitmap data
	iny
	sta	(pixeldat),y		; and store it into the bitmap
	clc
	lda	r14L				; get the next 4bit datastream
	adc	#$04
	sta	r14L
	bcc	@9				; did we finish the 256-byte 4-bit buffer?
	jsr	fetch4Bit
@9:	inc	pixeldat			; increment it by one
	bne	@2
	inc	pixeldat+1			; take care of high byte
@2:	dec	r15L				; are we done with all 8 scanlines of a single card?
	bne	@3

skipclip:
	inc	colorram
	bne	@4
	inc	colorram+1			; take care of color ram
@4:	inc	videoram
	bne	@5
	inc	videoram+1			; take care of video ram
@5:	dec	a2H				; are we done with a screen row?
	beq	@6
	jmp	blkloop			; go back and finish the graphics block
@6:	clc
	lda	a3L				; add in the REU location and the REU offset for the
	adc	a0L				; next screen row.
	sta	a3L
	sta	r13L				; for the REU. (lobyte)
	lda	a3H
	adc	a0H
	sta	a3H
	sta	r13H				; (hibyte)
	lda	r9H
	adc	#$00
	sta	r9H
	sta	pbank				; (bankbyte)
	ldy	a2L				; get the picture (physical screen) width again.
@13:	cpy	#40				; are we done with the physical screen width?
	beq	@8
	inc	colorram
	bne	@10
	inc	colorram+1			; take care of color ram
@10:	inc	videoram
	bne	@11
	inc	videoram+1			; take care of video ram
@11:	clc
	lda	pixeldat
	adc	#$08				; take care of pixel data
	sta	pixeldat
	bcc	@12
	inc	pixeldat+1
@12:	iny					; go through the entire physical screen, calculating
	bne	@13				; the necessary offsets. (relative JMP)
@8:	dec	r9L				; are we done with all screen rows?
	beq	@7
	jmp	convertclip			; otherwise, go back and repeat
@7:	rts

setDimensions:				; sets variables for the onscreen and picture dimensions
	lda	#$00				; set no scrolling
	sta	xScroll
	sta	yScroll
	LoadW	r14, fourBuff
	ldy	curPicture			; get index into picture
	lda	reuLoOrigin,y		; get reu address
	sta	r13L
	sta	a3L
	lda	reuHiOrigin,y
	sta	r13H
	sta	a3H
	lda	reuBOrigin,y		; get bank byte
	sta	pbank
	sta	r9H
	lda	picwidth,y			; get width of picture
	cmp	#41				; does it exceed the physical screen width?
	bcc	@1				; maybe use #80 for the VDC screen here.
	lda	#40				; store in #39 for the maximum physical screen width here.
@1:	sta	a2L				; store in the width which would be less than
						; physical screen width.
	lda	picheight,y			; get height of picture
	cmp	#26				; does it exceed the physical screen height?
	bcc	@2
	lda	#25				; store in #24 for the maximum physical screen height here.
@2:	sta	r9L				; store in height which would be less than
						; physical screen height.
	lda	#$00
	sta	videoram
	sta	colorram
	sta	pixeldat
	lda	#$8c				; location of video matrix within GEOS
	sta	videoram+1
	lda	#$7c				; color ram offset within GEOS
	sta	colorram+1			; location of color ram containing Godot palette
	lda	#$a0
	sta	pixeldat+1			; location of pixel data at $a000

getWidth:
	lda	picwidth,y			; get width of picture
	sta	r0L
	lda	#$20				; a constant value
	sta	a0L
	ldy	#r0L
	ldx	#a0L
	jmp	BBMult			; multiply 32 * picwidth to get the offset for locating
						; the next screen row in 4-bit data in expansion RAM.
						; a0 will have the offset constant.

SUp:						; Used to scroll the image upwards
	ldx	curPicture
	lda	picYoffset,x
	bne	@1				; check top boundary
	rts					; we have reached top of image
@1:	dec	picYoffset,x		; decrement the y-offset of window
	LoadW	r0, $a000			; source address
	LoadW	r1, $a140			; move bitmap data downwards
	LoadW	r2, $1e00
	jsr	MoveData
	lda	#$8c
	sta	r0H				; $8c00 source address
	sta	r1H
	lda	#$28
	sta	r1L				; $8c28 dest. address
	LoadW	r2, $03c0			; move video matrix data downwards
	jsr	MoveData
	LoadB	r0H, $db			; $db00 source address
	sta	r1H				; $db28 dest. address
	ldy	#$bf
@2:	lda	(r0),y
	sta	(r1),y			; move color ram data downwards
	dey
	cpy	#$ff
	bne	@2				; are we done?
	ldx	#$02
@4:	dec	r0H
	dec	r1H
@3:	lda	(r0),y
	sta	(r1),y
	dey
	cpy	#$ff
	bne	@3
	dex
	bpl	@4

	ldy	curPicture
	jsr	getWidth			; get the image width.
	ldy	curPicture
	sec
	lda	reuLoOrigin,y		; get reu address
	sbc	a0L				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	sbc	a0H
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	sbc	#$00
	sta	reuBOrigin,y

	jsr	setDimensions		; reset image parameters
	lda	#$01
	sta	r9L				; do only the top row.
	jsr	convertclip			; and renderize the top card row
	LoadW	r0, $7c00			; source address
	LoadW	r1, $d800			; transfer renderized color ram data
	jmp	SLeft-10

SDown:					; Used to scroll the image downwards
	ldx	curPicture
	clc
	lda	picYoffset,x
	adc	#26				; add in 26 screen rows
	cmp	picheight,x
	bcc	@1				; check bottom boundary
	beq	@1				; check bottom boundary
	rts					; we have reached bottom of image
@1:	inc	picYoffset,x		; increment the y-offset of window
	LoadW	r0, $a140			; source address
	LoadW	r1, $a000			; move bitmap data upwards
	LoadW	r2, $1e00
	jsr	MoveData
	lda	#$28
	sta	r0L
	lda	#$8c
	sta	r0H				; $8c28 source address
	sta	r1H
	LoadW	r2, $03c0			; move video matrix data upwards
	jsr	MoveData
	LoadB	r0H, $d8			; $d828 source address
	sta	r1H				; $d800 dest. address
	ldx	r2H
	ldy	#$00
@2:	lda	(r0),y
	sta	(r1),y			; move color ram data upwards
	iny
	bne	@2
	inc	r0H
	inc	r1H
	dex
	bpl	@2

	ldy	curPicture
	jsr	getWidth			; get the image width.
	ldy	curPicture
	clc
	lda	reuLoOrigin,y		; get reu address
	adc	a0L				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	adc	a0H
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	adc	#$00
	sta	reuBOrigin,y

	lda	#$00
	sta	xScroll			; do not alter X-direction scrolling
	lda	#24				; only scroll the last card row
	sta	yScroll
	jsr	setDimensions+8		; reset image parameters
	jsr	convertclip			; and renderize the bottom card row
	LoadW	r0, $7fc0			; source address
	LoadW	r1, $dbc0			; transfer renderized color ram data
	ldy	#$27
@3:	lda	(r0),y
	sta	(r1),y
	dey
	bpl	@3
	rts

SLeft:
	ldx	curPicture
	lda	picXoffset,x
	bne	@1				; check left boundary
	rts					; we have reached left of image
@1:	dec	picXoffset,x		; increment the y-offset of window
	LoadW	r0, $a000			; source address
	LoadW	r1, $a008			; move bitmap data leftwards
	LoadW	r2, $1f38
	jsr	MoveData
	lda	#$01
	sta	r1L
	lda	#$8c				; source address $8c00
	sta	r0H				; destination address $8c01
	sta	r1H				; move video data leftwards
	LoadW	r2, $03e7
	jsr	MoveData
	lda	#$db				; source address $db00
	sta	r0H				; destination address $db01
	sta	r1H
	ldx	r2H
	ldy	#$ff
@4:	lda	(r0),y
	sta	(r1),y			; move color ram data leftwards
	dey
	cpy	#$ff
	bne	@4
	dec	r0H
	dec	r1H
	dex
	bpl	@4

	ldy	curPicture
	jsr	getWidth			; get the image width.
	ldy	curPicture
	sec
	lda	reuLoOrigin,y		; get reu address
	sbc	#$20				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	sbc	#$00
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	sbc	#$00
	sta	reuBOrigin,y
	jsr	setDimensions		; reset image parameters
	lda	#$01
	sta	a2L				; only do the first column.
	jsr	convertclip			; and renderize the first column
	LoadW	r0, $7c00			; transfer renderized color ram data
	LoadW	r1, $d800
	ldx	#24
	ldy	#$00
@3:	lda	(r0),y
	sta	(r1),y
	clc
	lda	r0L
	adc	#$28
	sta	r0L
	sta	r1L
	bcc	@2
	inc	r0H
	inc	r1H
@2:	dex
	bpl	@3				; do all 25 rows
	rts

SRight:					; move the image rightwards
	ldx	curPicture
	clc
	lda	picXoffset,x
	adc	#41				; add in 41 screen columns
	cmp	picwidth,x
	bcc	@1				; check right boundary
	beq	@1				; check right boundary
	rts					; we have reached right of image
@1:	inc	picXoffset,x		; increment the y-offset of window
	LoadW	r0, $a008			; source address
	LoadW	r1, $a000			; move bitmap data rightwards
	LoadW	r2, $1f38
	jsr	MoveData
	lda	#$01
	sta	r0L
	lda	#$8c				; source address $8c01
	sta	r0H				; destination address $8c00
	sta	r1H				; move video data rightwards
	LoadW	r2, $03e7
	jsr	MoveData
	lda	#$d8				; source address $d801
	sta	r0H				; destination address $d800
	sta	r1H
	ldx	r2H
	ldy	#$00
@4:	lda	(r0),y
	sta	(r1),y			; move color ram data rightwards
	iny
	bne	@4
	inc	r0H
	inc	r1H
	dex
	bpl	@4

	ldy	curPicture
	jsr	getWidth			; get the image width.
	ldy	curPicture
	clc
	lda	reuLoOrigin,y		; get reu address
	adc	#$20				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	adc	#$00
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	adc	#$00
	sta	reuBOrigin,y

	lda	#$28
	sta	xScroll			; scroll on the x-direction
	lda	#$00				; only scroll the last column
	sta	yScroll			; do not scroll the y-direction
	jsr	setDimensions+8		; reset image parameters
	jsr	convertclip			; and renderize the last column
	LoadW	r0, $7c27			; transfer renderized color ram data
	LoadW	r1, $d827
	ldx	#24
	ldy	#$00
@3:	lda	(r0),y
	sta	(r1),y
	clc
	lda	r0L
	adc	#$28
	sta	r0L
	sta	r1L
	bcc	@2
	inc	r0H
	inc	r1H
@2:	dex
	bpl	@3				; do all 25 rows
	rts

irqservice:					; services the graphics IRQ & keyboard polling
	jsr	InitForIO			; turn on i/o
	jsr	fullopt			; optimizes color ram and background ($d021) color
	bit	screenMode			; check video mode
	bpl	@5				; branch if it's in 40 columns
	lda	$d030				; save processor speed
	sta	speed
	lda	#$00
	sta	$d030				; downshift the machine to 1MHz
	lda	$d011				; open the 40 column screen
	ora	#$10
	sta	$d011
@5:	lda	$d016
	ora	#%00010000			; turn on multicolor mode
	sta	$d016

@6:	LoadB	$dc00, %11101111		; read the cursor up keypress
	lda	$dc01
	cmp	#%11111101			; is it cursor up?
	bne	@7
	jsr	SUp
	bra	@6

@7:	cmp	#%11101111			; read the cursor down keypress
	bne	@8				; is it cursor down?
	jsr	SDown
	bra	@6

@8:	cmp	#%11111011			; read the cursor left keypress
	bne	@9				; is it cursor left?
	jsr	SLeft
	bra	@6

@9:	cmp	#%11011111			; read the cursor right keypress
	bne	@2				; is it cursor right?
	jsr	SRight
	bra	@6

@2:	LoadB	$dc00, $7f			; read the space bar
	lda	$dc01
	cmp	#%11011111			; is it the C= keypress?
	bne	@10
	jsr	convert4bit			; go through a full conversion
	jsr	fullopt			; optimize the entire screen
	bra	@6

@10:	cmp	#%11111101			; is it the back arrow keypress?
	bne	@11
	jsr	HomeImage			; homes the image
	bra	@6

@11:	cmp	#%11101111			; is it the space bar?
	bne	@6

	lda	$d016
	and	#%11101111			; turn off multicolor mode
	sta	$d016
	bit	screenMode			; check video mode
	bpl	@3				; branch if it's in 40 columns
	lda	$d011
	and	#%11101111			; blank the 40 column screen
	sta	$d011
	lda	speed
	sta	$d030				; restore processor speed
@3:	jmp	DoneWithIO			; restore RAM under i/o

fullopt:					; optimizes the entire screen
	ldx	#$03
	ldy	#$00
	tya
	sta	r14L
	sta	r15L
	lda	#$7c				; location of freshly-created color ram
	sta	r14H
	lda	#$d8				; physical location of color ram
	sta	r15H
@1:	lda	(r14),y			; move color ram
	sta	(r15),y
	dey
	bne	@1
	inc	r14H
	inc	r15H				; take care of hibytes
	dex
	bpl	@1				; go through entire color ram
	lda	fourBuff-1			; get the optimized background value
	tax					; index it
	lda	c64,x				; convert the 4bit palette to the correct color
	sta	$d021				; into the background
	rts

HomeImage:					; Homes the image onscreen
	ldy	curPicture
	jsr	getWidth			; get the width for future calculations
	ldx	curPicture
	txa
	tay
	lda	picXoffset,y
	beq	@1				; are we at the left side of the screen?
@2:	sec
	lda	reuLoOrigin,y		; get reu address
	sbc	#$20				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	sbc	#$00
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	sbc	#$00
	sta	reuBOrigin,y
	dec	picXoffset,x
	bne	@2

@1:	lda	picYoffset,y
	beq	@3				; are we at the top of the screen?
@4:	sec
	lda	reuLoOrigin,y		; get reu address
	sbc	a0L				; add new origin for the REU
	sta	reuLoOrigin,y
	lda	reuHiOrigin,y
	sbc	a0H
	sta	reuHiOrigin,y
	lda	reuBOrigin,y		; get bank byte
	sbc	#$00
	sta	reuBOrigin,y
	dec	picYoffset,x
	bne	@4

@3:	jsr	convert4bit			; converts the screen and renderizes it.
	jmp	fullopt

; used by 4 bit conversion routines
bits:						; bit patterns
.byte	$00,$55,$aa,$ff			; %00, %01, %10, %11

mask:						; used for the masking of the bits in creating a bitmap
.byte	$c0,$30,$0c,$03			; %11000000, %00110000, %00001100, %00000011
