; main 4Bit Viewer module by Arndt Dettke & Todd Elliott

	jmp	detHardware		; Do this FIRST
	jmp	fetch4Bit

Go:					; starts up the menu structure and exits back to GEOS Mainloop
	LoadW	r0, mMenu
	lda	#$00
	jsr	DoMenu
	rts				; for now

Exit:
	jsr	OpenProgDirectory
	jsr	FreePicture		; frees up expansion RAM memory of any pictures.
	jmp	EnterDeskTop

Hires:
Slideshow:
	jsr	ReDoMenu
	rts				; for now

Load:					; opens the SuperDB requestor in order to load a datafile
	ldy	#$00			; set up paramters for the picture tables.
	sty	curPicture		; put them here for now. May move elsewhere.
	tya
	sta	reuLoOrigin,y
	sta	reuHiOrigin,y	; zero out the entries.

	lda	picwidth,y		; is there a picture in expansion RAM memory?
	beq	@12
	jsr	FreePicture		; if so, delete it from memory and free up memory.
@12:	jsr	OpenDataDirectory	; opens the directory housing the datafile	
	jsr	InitSuperDB		; calls the SuperDB requestor
	jsr	getFNRAM		; get a filename from expansion RAM 
	bne	@1
	jmp	ReDoMenu		; if no filename was selected, abort
@1:	lda	#$00
	sta	picXoffset
	sta	picYoffset		; reset the x,y offsets of a window into an image
;	lda	#$00
	sta	r15H			; initalize index for the 4bit loader
	sta	r13L			; initialize expansion RAM
	sta	r13H
	LoadW	r14, fourBuff	; set up buffer for the 4bit data
	MoveW	cBuf, r4		; grab a copy of pointer to the input buffer
	MoveW	cIndex, r5		; grab a copy of index into input buffer
	MoveW	cTS, r1		; grab a copy of track sector for this buffer
	LoadB	r12L, $04		; skip the god0 signature
@2:	jsr	ReadByte		; this routine trashes registers
	dec	r12L
	bne	@2
	cmp	#48			; is it '0' for the god0 signature?
	bne	@9
	lda	#40			; stores the default dimensions for a regular GoDot 4-bit file.
	sta	picwidth		; Stores it. (Needs to be indexed.)
	lda	#25
	sta	picheight		; Stores it. (Needs to be indexed.)
	lda	#$01			; allocate one bank for regular GoDot 4-bit files.
	sta	r2L			; for the Wheels Kernal RamBlkAlloc routine.
	bne	@10			; relative JMP
					; take care of the GoDot 4-bit Clipped files.
@9:	jsr	ReadByte		; get rid of the line/column pointers as they are not used here
	jsr	ReadByte		; in dotView, and is only for GoDot.
	jsr	ReadByte		; get picture width
	sta	picwidth		; Stores it. (Needs to be indexed.)
	pha
	jsr	ReadByte		; get picture height
	sta	picheight		; Stores it. (Needs to be indexed.)
	tay
	pla
	tax
	jsr	picRAMSize		; get the 64Kb bank value for the picture.

@10:	lda	#$00
	sta	r3L			; pass parameters to the Wheels Kernal RamBlkAlloc routine.
	lda	#(0|64)
	jsr	GetNewKernal
	jsr	RamBlkAlloc
	jsr	RstrKernal
	txa				; check error
	beq	@11
	ldx	#<insfram		; inform the user that there is insufficient RAM.
	ldy	#>insfram
	stx	r5L
	sty	r5H			; for the DBVARSTR function
	LoadW	r0, genDBTable	; generic DB table
	jsr	DoRcvrBox		; issues a message in a DB w/ an OK icon
	jmp	ReDoMenu

@11:	lda	r3L			; get the starting bank of the allocated memory range.
	ldy	curPicture		; get picture #
	sta	picbank,y		; Stores it.
	sta	reuBOrigin,y
	sta	pbank			; for the fetch/stash 4bit routines.
	lda	r2L			; get # of bank bytes each picture occupies
	sta	picsize,y
					; Finally, read in the rest of the GoDot 4-bit data.
@5:	jsr	ReadByte		; fetch/decode Godot four bit data
	cpx	#BUFFER_OVERFLOW	; have we reached end of file?
	bne	@3
@8:	jsr	stash4Bit		; flush the 4-bit buffer
	jmp	ReDoMenu		; abort the load
@3:	cmp	#$ad			; is it the packer byte?
	beq	@4
	ldy	r15H			; get index into 4bit buffer
	sta	(r14),y		; and store data into 4bit buffer
	inc	r15H
	bne	@5
	jsr	stash4Bit		; stash it into expansion ram
	bra	@5

@4:	jsr	ReadByte		; get the counter byte
	cpx	#BUFFER_OVERFLOW	; have we reached end of file?
	beq	@8
	sta	r15L			; and index it
	jsr	ReadByte		; get the counted byte
@7:	ldy	r15H			; get index into 4bit buffer
	sta	(r14),y		; and store data into 4bit buffer
	inc	r15H
	bne	@6			; if equal then flush 4bit buffer
	jsr	stash4Bit		; stash the buffer into expansion ram
@6:	dec	r15L			; decrement the counter
	bne	@7
	beq	@5			; relative JMP

stash4Bit:				; stashes the temporary 4bit buffer into expansion ram
	pha				; preserve .A
	MoveW	r1, cTS		; save t/s for the input buffer
	MoveW	r14, r0		; source address in CBM
	MoveW	r13, r1		; ram expansion address
	LoadW	r2, $0100		; move 256 bytes
	MoveB	pbank, r3L		; use startbank of the reu
	ldy	#$90			; do a STASH
	jsr	DoRAMOp		; to expansion RAM
	inc	r13H			; update hibyte
	bne	@1
	inc	pbank			; increment the bank byte
@1:	MoveW	cTS, r1		; restore t/s for the input buffer
	pla				; restore .A
	rts

fetch4Bit:				; fetches the temporary 4bit buffer from expansion ram
	MoveW	r14, r0		; CBM address
	MoveW	r13, r1		; ram expansion address
	LoadW	r2, $0100		; move 256 bytes
	MoveB	pbank, r3L		; use startbank of the reu
	ldy	#$91			; do a FETCH
	jsr	DoRAMOp		; from expansion RAM
	inc	r13H			; update hibyte
	bne	@1
	inc	pbank			; increment the bank byte
@1:	rts

Multi:				; displays the 4bit file in multicolor mode
	ldy	curPicture
	lda	picwidth,y		; is there a picture in expansion RAM memory?
	beq	@4
	jsr	OpenProgDirectory	; opens the program directory
	ldx	#$01			; use Viewer Module #1
	jsr	LdViewerMod		; and loads in the particular Viewer Module.
	jsr	ViewerModules+3	; index it by picture.
	jsr	ViewerModules+6	; initializes the graphics & polls keyboard
	bit	screenMode		; check video mode
	bmi	@4			; skip pattern in 80 column mode
	lda	#$02			; checkerboard
	jsr	SetPattern
	LoadW	r3, $0000		; x1coord
	LoadB	r2L, $00		; y1coord
	LoadW	r4, 319		; x2coord
	LoadB	r2H, 199		; y2coord
	jsr	Rectangle
	jsr	ConvToCards
	LoadB	r4H, $61		; purple/white
	jsr	ColorRectangle
@4:	jmp	ReDoMenu		; and RTS'es
