; Detect Wheels and the SuperCPU
graphicsMode	= $003f		; graphics mode 80 or 40 columns
scpubk2		= $d074		; select VICBank Two optimization mode
scpunot		= $d077		; select no Optimization mode (default)
scpuenb		= $d07e		; enables the SCPU registers
scpudis		= $d07f		; disables the SCPU registers
scpuver		= $d0b0		; indicates which version of the scpu online
scpudet		= $d0bc		; detects whether a SCPU is online
firstpage		= $d27c		; first available SuperRAM bank, etc.
expram		= $e487		; RAM version identifier string
ram128		= $f6dd		; 128 RAM version identifier string
nmi16			= $ffea		; 16 bit NMI vector

detHardware:
	lda	c128Flag
	and	#%10000000
	sta	xdblB
	asl
	php
	ror
	lsr
	plp
	ror
	sta	xadd1W
	lda	version			; check GEOS version at $c00f
	cmp	#$41				; is it Wheels?
	bcs	@8
	lda	driverVersion		; check disk device drivers
	cmp	#$52				; is it Wheels?
	bcs	@8
; If branch is taken here, then the app cannot continue and generates a dialog box and then 
; enters the deskTop
	ldx	#<tReqWheels
	ldy	#>tReqWheels
	stx	r5L
	sty	r5H				; for the DBVARSTR function
	LoadW	r0, genDBTable		; generic DB table
	jsr	DoDlgBox			; issues a message in a DB w/ an OK icon
	jmp	EnterDeskTop		; and exits the application
@8:	bit	c128Flag			; checks for the c128 system flag
	bpl	@11				; branch if it's a 64 running
	bit	graphicsMode
	bpl	@12
	lda	#$80				; 80 columns
.byte	$2c					; BIT opcode
@12:	lda	#$40				; 40 column 128 mode
.byte	$2c					; BIT instruction
@11:	lda	#$00				; 40 columns
	sta	screenMode
	lda	#$00
	sta	sb				; set variables

; first initialize some stuff
	lda	#$01
	sta	dataIndex			; indexes the first datafile entry
	MoveB	curDrive, progDrive	; save current drive
	sta	progDrive+1			; inits the disk information for the datafile
	jsr	GetHeadTS			; get the disk info which loaded geoGodot
	MoveB	r2L, progPartition
	sta	progPartition+1
	jsr	GetDirHead
	MoveB	r1L, progTrack
	sta	progTrack+1
	MoveB	r1H, progSector
	sta	progSector+1

; Check for all modules and store its t/s entries
	LoadW	r6, fnViewers		; find the Viewers supporting module
	jsr	FindFile
	txa					; check disk error
	beq	@1
@2:	ldx	#<tReqModules
	ldy	#>tReqModules
	stx	r5L
	sty	r5H				; for the DBVARSTR function
	LoadW	r0, genDBTable		; generic DB table
	jsr	DoDlgBox			; issues a message in a DB w/ an OK icon
	jmp	EnterDeskTop		; and exits the application	

@1:	lda	dirEntryBuf+1		; get t/s of its index block
	sta	r1L
	lda	dirEntryBuf+2
	sta	r1H
	LoadW	r4, ViewVIndex		; Buffer containing its VLIR index block
	jsr	GetBlock
	txa					; check disk error
	bne	@2

detRAM:
	lda	#(0 | 64)			; RAM routines
	jsr	GetNewKernal
	jsr	GetRAMInfo			; check free RAM banks
	jsr	RstrKernal
	lda	r2L				; check RAM availability
	cmp	#$01				; must have 64Kb allocated
	bcc	@9				; no ram available
						; try detecting the SuperCPU
	lda	r3L				; get available RAM bank
	sta	sb				; into start bank for the RAM
	lda	ramExpType			; check to see if this RAM is also SuperRAM
	cmp	#$04
	bne	@9				; branch if it's not
	lda	#$00				; for now, zero out SuperCPU flag
	sta	scpuflag
	jmp	cnt1
; first of all, detect the SCPU
@9:	lda	screenMode			; check computer
	bne	@82
	PushB	CPU_DATA
	LoadB	CPU_DATA, IO_IN
@82:	lda	scpudet			; get the scpu detect register
	bmi	@1				; if bit 7 is high, then there is no scpu
	lda	scpuver			; detect which scpu version is being used
	and	#$c0				; protect bits 7 and 6
	bmi	@2
	lda	#$80				; indicate that it is scpu version two
.byte		$2c				; BIT instruction
@2:	lda	#$01				; indicate that it is scpu version one
.byte		$2c				; BIT instruction
@1:	lda	#$00				; indicate that there is no scpu online
	sta	scpuflag
	tay

	lda	screenMode			; check computer
	bne	@83
	PopB	CPU_DATA
@83:	tya
	bne	@3
	jmp	cnt1				; abort if no SuperCPU
@3:	jsr	InitForIO
	jsr	OnCBMKernal
	ldy	#$00
	lda	screenMode			; check computer
	beq	@7
	lda	ram128,y			; check 128 ram string
	bra	@4
@7:	lda	expram,y			; detect expansion ram
@4:	cmp	expver,y
	bcc	clrSRAM			; @7	; clear up expansion ram pointers
	bne	detSRAM			; @8
	iny
	iny					; skip over the period
	lda	screenMode			; check computer
	beq	@5
	lda	ram128,y			; check 128 ram string
	bra	@6
@5:	lda	expram,y			; read in the next version number
@6:	cmp	expver,y
	bcc	clrSRAM			; @7	; clear up expansion ram pointers

detSRAM:	jsr	OnGeosKernal
	jsr	DoneWithIO
	lda	screenMode			; check computer
	bne	@80
	PushB	CPU_DATA
	LoadB	CPU_DATA, IO_IN
@80:	ldx	#$03	; expansion ram available
@9:	lda	firstpage,x			; get expansion ram variables
	sta	sp,x				; and store it in a memory location
	dex
	bpl	@9
	lda	screenMode
	bne	@81
	PopB	CPU_DATA
@81:	lda	sp
	beq	@17				; make sure SuperRAM is aligned on a bank
	inc	sp+1				; boundary- If not, increment the bank counter
@17:	lda	sp+1				; check RAM availability
	cmp	sp+3
	bcs	clrSRAM+6			; branch if not enough RAM memory
	ldy	sp+1				; make sure we have a 64Kb RAM bank
	iny
;	iny
	cpy	sp+3
	bcc	cnt1				; if equal then we're on the last available RAM
	ldy	sp+2				; bank. Check to see if 64Kb of RAM is avail.
	beq	cnt1				; if equal then we have entire 64Kb of RAM
	bne	clrSRAM+6

clrSRAM:	jsr	OnGeosKernal
	jsr	DoneWithIO
	lda	#$00
	ldx	#$03
@10:	sta	sp,x				; clear out expansion RAM registers
	dex
	bpl	@10
	sta	scpuflag			; Zero out the flag if no RAM is available
cnt1:	lda	scpuflag
	bne	@4				; do not run if either SuperRAM or expansion
	lda	sb				; RAM not detected with at least 64Kb
	bne	@4
	ldx	#<tReqRAM
	ldy	#>tReqRAM
	stx	r5L
	sty	r5H				; for the DBVARSTR function
	LoadW	r0, genDBTable		; generic DB table
	jsr	DoDlgBox			; issues a message in a DB w/ an OK icon
	jmp	EnterDeskTop		; and exits the application

@4:	LoadB	dispBufferOn, ST_WR_FORE; turn on only foreground writes
	lda	screenMode			; check computer
	bpl	@1
	lda	#$02	
	jsr	SetColorMode
@1:	lda	#$02				; checkerboard
	jsr	SetPattern
	LoadW	r3, $0000			; x1coord
	LoadB	r2L, $00			; y1coord
	LoadW	r4, 319			; x2coord
	LoadB	r2H, 199			; y2coord
	jsr	AdjPixCoords
	jsr	Rectangle
	jsr	ConvToCards
	LoadB	r4H, $61			; purple/white
	jsr	ColorRectangle
	bit	screenMode			; check videomode
	bmi	@2				; branch if 80 columns detected
	jmp	InitGod			; jump to godot initializations in 40 columns

@2:	lda	#$05				; need to modify the icon structure
						; for 80 column use for the SuperDB table
	sta	SDBITable+6			; use self-modifying code
	lda	SDBITable+14
	ora	xdblB				; and use bitmap doubling
	sta	SDBITable+14
	lda	SDBITable+16
	ora	xdblB
	sta	SDBITable+16
	lda	#$45
	sta	SDBITable+22
	sta	colordb+46
	lda	SDBITable+24
	ora	xdblB
	sta	SDBITable+24
	lda	#$0b
	sta	SDBITable+30
	sta	colordb+53
	lda	SDBITable+32
	ora	xdblB
	sta	SDBITable+32		; take care of the Open Files icon
	sta	aDriveTable+4		; bitmap double the drive icons
	sta	bDriveTable+4
	sta	cDriveTable+4
	sta	dDriveTable+4
	sta	dDriveTable+12		; bitmap double the DISK icon
	lda	#$12
	sta	aDriveTable+2
	sta	colordb+88			; for the colorization of the OPEN icon
	lda	#$18
	sta	bDriveTable+2
	lda	#$1e
	sta	cDriveTable+2
	lda	#$24
	sta	dDriveTable+2		; position the drive icons
	lda	#$2a
	sta	dDriveTable+10		; position the DISK icon
	sta	colordb+73			; ditto for its color counterpart
;	lda	#$19
;	sta	SDBITable+46
;	sta	colordb+81
;	lda	SDBITable+48
;	ora	xdblB
;	sta	SDBITable+48

	lda	#$28
	sta	InitSuperDB+14
	lda	#$02
	sta	InitSuperDB+18
	lda	#$50
	sta	InitSuperDB+22
	lda	#$90
	sta	readDiskName+1		; position the disk name
	sta	readDiskName+57
	lda	#$20
	sta	readDiskName+5		; position the screen area clear
	lda	#$01
	sta	readDiskName+13

InitGod:
	ldx	#<splash
	ldy	#>splash
	stx	r5L
	sty	r5H				; for the DBVARSTR function
	LoadW	r0, genDBTable		; generic DB table
	jsr	DoRcvrBox			; issues a message in a DB w/ an OK icon
	LoadB	curVMod, $00		; sets the initial value of current Viewer Module
	jsr	makec64			; create 64 palette table as Godot palette is
						; very different and a conversion is needed.
	jmp	Go				; set up the menu structure, icons, etc.

OnGeosKernal:				; turns on the GEOS kernal in 128 mode
	lda	screenMode			; check computer mode
	beq	@1				; do nothing on 64 mode
	lda	mmucpy			; get GEOS 128 mmu config
	sta	$ff00				; enable GEOS kernal
@1:	rts

OnCBMKernal:				; turns off the GEOS kernal and
						; turns on CBM kernal in 128 mode
	lda	screenMode			; check computer mode
	beq	@2				; do nothing on 64 mode
	lda	$ff00
	sta	mmucpy			; preserve 128 mmu config
	lda	#%01001110			; restore original 128 mmu config
	sta	$ff00
@2:	rts

; text used in the initialization sequence
splash:
.byte "dotView B0.3 by Todd Elliott", 13
.byte "With help by Arndt Dettke and", 13
.byte "Maurice Randall. All Copyrights", 13
.byte "and Trademarks remain with", 13
.byte "their respective owners.", 0

tReqWheels:
.byte $18		; boldface style
.byte "Requires Wheels To Run."
.byte $00		; terminator

tReqRAM:
.byte $18		; boldface style
.byte "Requires at least 64Kb", CR
.byte "of expansion RAM to Run."
.byte NULL

tReqModules:
.byte	$18					; boldface style
.byte	"Requires supporting modules", CR
.byte	"to run.", NULL

expver:
.byte 49, 46, 52				; "1.4"

fnViewers:
.byte "Viewers", 0			; The filename for the Viewers supporting module

fnScrollers:
.byte	"Scrollers",0			; the filename for the Scrollers supporting module

lastC:
; last piece of code
;.res 1
