; Verifies geoPublish disk as an original. Requires GEOS 64 or 128 v2.0 to run.
; Copyright 2004 by Todd S. Elliott

.out "Source Code (c) 2003 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.org	$0400

	lda	version		; Get GEOS version
	cmp	#$40			; is it v4.0 (aka Wheels OS?)
	bcc	@2			; proceed if it is GEOS OS
	lda	#<tReqGEOS
	ldy	#>tReqGEOS		; issue error DB & exit
	jmp	errorDB

@2:	lda	#$00
	jsr	SetPattern
	jsr	i_Rectangle		; draws a framed & blank box onscreen
.byte	 $54				; top scanline
.byte $73				; bottom scanline
.word $0020				; left side
.word $011f				; right side
	lda	#$ff
	jsr	FrameRectangle
	LoadW	r0, tGreetings	; print out the copyright box
	LoadB	r1H, $60
	LoadW	r11, $0028
	jsr	PutString

	lda	curDrive		; get current drive #
	sta	progDrive
@7:	ldy	#$08			; cycle through the drives to find 1541/1571's
@3:	lda	driveType-8,y
	beq	@9			; is it empty?
	cmp	#$03			; 1571 or lower?
	bcc	@1			; if so, proceed.
@9:	iny
@5:	cpy	#$0c			; are we done cycling through the drives?
	bcc	@3
	lda	#<dbDisk		; issue disk not found error db
	ldy	#>dbDisk
	sta	r0L
	sty	r0H
	jsr	DoDlgBox
	lda	r0L
	cmp	#$01			; was it the OK icon?
	beq	@7			; if so, the user inserted the disk and try again!
	jmp	quit			; otherwise, the user CANCEL'led and needs to quit.
;	lda	#<tReq154171
;	ldy	#>tReq154171	; issue error DB & exit
;	jmp	errorDB

@1:	tya
	sta	targetDrive
	jsr	SetDevice		; issue a SetDevice call
	jsr	OpenDisk		; and opens the disk
	txa
	beq	@4
@6:	ldy	curDrive		; get the offending drive
	iny
	bne	@5			; relative JMP

@4:	LoadW	r6, nbuffer		; point r6 to nbuffer
	lda	#$06			; file type APPLICATION
	sta	r7L
	lda	#$01			; return only one filename
	sta	r7H
	lda	#>permName
	sta	r10H
	lda	#<permName
	sta	r10L			; pointer to geoPublish's permanent name string
	jsr	FindFTypes
	lda	nbuffer		; check to see if geoPublish was found
	beq	@6			; branch if it wasn't found

	lda	#>(checkHdr-3)	; stash the return address onto stack
	pha
	lda	#<(checkHdr-3)
	pha
	LoadW r0, nbuffer		; point r0 to geoPublish filename
	jsr	OpenRecordFile	; and opens geoPublish
	lda	#$08			; load VLIR #$08
	jsr	PointRecord
	LoadW	r2, $7fff		; max 32K bytes
	LoadW	r7, $2500		; set loading address
	jsr	ReadRecord		; calls ReadRecord function.
	jsr	CloseRecordFile	; and closes the geoPublish VLIR file
;	lda	#$94
;	eor	#$f1			; decode VLIR #$08
;	sta	crc+1
	LoadW	r15, $2500		; start decoding @ $2500
	LoadW	r14, $e80c		; # of bytes to decode
	ldy	#$00
	lda	(r15),y
crc:	eor	#$65			; modified earlier
	sta	(r15),y
	inc	r15L
	bne	@7
	inc	r15H			; go through $2500 buffer
@7:	inc	r14L
	bne	@8
	inc	r14H			; and decrease # of bytes to decode
@8:	bne	crc-2			; are we done?

; at this point, VLIR #$08 of geoPublish has been fully loaded/decoded in memory.
checkSerNum:
	LoadW	r15, $2500		; load r15 w/ $2500 again
	ldy	#$00
@2:	lda	(r15),y
	cmp	#$20			; check for the first JSR call - this goes to the SN check
	beq	@1
	iny
	bra	@2			; relative JMP
@1:	iny
	lda	(r15),y		; get address of the JSR call
	sta	r14L
	iny
	lda	(r15),y
	sta	r14H
	ldy	#$04			; get location of SN within geoPublish
	lda	(r14),y
	sta	r13L
	iny
	lda	(r14),y
	sta	r13H			; r13 now points to geoPublish's SN
	ldy	#$00
	lda	(r13),y		; get geoPublish's SN
	sta	seed			; and set up the initial seed value
	iny
	lda	(r13),y
	sta	seed+1
	jsr	GetSerialNumber
	CmpW	r0, seed
	beq	@3			; branch if the GEOS Kernal ID equals geoPublish's ID
@5:	lda	#<tMisSN
	ldy	#>tMisSN		; issue error DB & exit
	jmp	errorDB

@3:	asl	seed			; detect the modified SN hidden within geoPublish's dirheader
	rol	seed+1
	lda	seed
	adc	#$00
	sta	seed
	lda	curDirHead+191
	cmp	seed+1
	bne	@4
	lda	curDirHead+190
	cmp	seed
@4:	bne	@5

checkCP:				; checks the header for copy protection
	ldy	#$0a			; get offset for the copy protection header call
	sty	r0L			; save it temporarily.
	lda	(r14),y
	sec				; add +1
	adc	r0L
	tay				; and make it the new offset
	iny
	lda	(r14),y		; get the JSR copy protection call
	sta	r12L
	iny
	lda	(r14),y
	sta	r12H			; r12 now has the JSR copy protection address
	ldy	#$00
@2:	lda	(r12),y		; search for the first LDA #immediate opcode
	cmp	#$a9
	beq	@1
	iny
	bra	@2			; relative JMP

@1:	iny
	lda	(r12),y		; get the T/S links
	sta	r1L
	iny
	iny
	iny
	iny
	lda	(r12),y
	sta	r1H
	lda	#$80
pha					; for the return address
	sta	r4H
	lda	#$00
	sta	r4L			; buffer @ $8000
	jsr	GetBlock		; gets block at $0x, $0x
	txa
	bne	hdrErrDB
	ldy	#$02
@3:	clc
	adc	diskBlkBuf,y	; rudimentary CRC check addition
	iny
	cpy	#$FF
	bne	@3
	cmp	$80FF			; compares the CRC value against the checksum
	beq	hdrErrDB+7
hdrErrDB:
	lda	#<tHdrError
	ldy	#>tHdrError
	jmp	errorDB

	clc
	iny
	iny
	tya
pha					; for the return address
	dey
@5:	lda	diskBlkBuf,y	; add in the values in that header for the CRC value
	adc	seed
	sta	seed
	lda	seed+1
	adc	#$00
	sta	seed+1		; recompute the 16-bit CRC value
	iny
	bne	@5			; and go through the disk buffer
	rts				; and exit to diskBlkBuf+2

errorDB:
	sta	r5L
	sty	r5H
	lda	#<dbtError
	ldy	#>dbtError
	sta	r0L
	sty	r0H
	jsr	DoDlgBox
quit:					; quits the validation process
	lda	progDrive
	jsr	SetDevice		; issue a SetDevice call
	jsr	OpenDisk		; and opens the disk
	jmp	EnterDeskTop	; and exits the application

dectohex:
	ldx	#$01
	ldy	#$00
	sty	nbuffer		; preserve .Y
@1:	lda	seed,x		; gets the stored integer value and pushes it into the stack
	pha
	lsr
	lsr
	lsr
	lsr				; get the upper nybble for processing.
	tay				; Since .A now contains an offset for the hex pointer, this
	lda	hex1,y		; is transferred to the .Y register for retrieval.
	ldy	nbuffer
	sta	hCRC,y		; stores the upper nybble hexadecimal value.
	pla
	and	#$0f			; retrieves the lower nybble for processing.
	tay
	lda	hex1,y		; gets the corresponding hexadecimal value.
	inc	nbuffer
	ldy	nbuffer		; retrieves the .Y register.
	sta	hCRC,y		; now store the lower nybble hexadecimal value.
	inc	nbuffer
	dex				; get the low byte value of the word field, RES variable.
	bpl	@1
	rts

dbtError:					; error dialog box table
.byte $81					; standard DB
.byte $0c					; DBVARSTR
.byte $10,$10				; x/y positions
.byte $0c					; r5 (error message)
.byte $01					; OK icon
.byte $11,$48				; x/y positions
.byte $00					; delimiter

dbDisk:
.byte $81					; default db table
.byte $0b					; DBTXTSTR
.byte $10,$10				; x/y positions
.word tReq154171				; text pointer
.byte $01					; OK icon
.byte $11,$48				; x/y positions
.byte $02					; CANCEL icon
.byte $01,$48				; x/y positions
.byte $00					; delimiter

permName:
.asciiz "geoPublish  V1.0"

tReq154171:					; error requiring 1541/71 drives

;.byte "Requires a 1541/1571"
;.byte $16,$50,$00,$40
;.asciiz "Drive to Proceed!"

.byte "geoPublish Disk Not Found!"
.byte $16,$50,$00,$40
.asciiz "Insert Disk or CANCEL"

tReqGEOS:					; error requiring GEOS OS to run

.byte "Requires GEOS 64/128"
.byte $16,$50,$00,$40
.asciiz "OS To Proceed!"

tMisSN:					; error producing mismatched S/N's

.byte "Mismatched GEOS Kernal"
.byte $16,$50,$00,$40
.asciiz "ID's. Cannot Proceed!"

hex1:						; used in dec/hex conversions
.byte "0123456789abcdef"

checkHdr:					; check geoPublish's header upon return.
	txa
	beq	@6				; branch if the geoPublish disk header is found
	jmp	hdrErrDB			; issue errorDB

@6:
;	sec					; for now
	adc	seed				; add the .A to contents at seed
	sta	seed
	lda	seed+1
	adc	#$00
	sta	seed+1
	jsr	dectohex			; and convert the seed value to hex CRC value
	lda	#<tSuccessCRC
	ldy	#>tSuccessCRC
	jmp	errorDB			; for now

tHdrError:					; error for a disk header check failure

.byte "geoPublish header not"
.byte $16,$50,$00,$40
.asciiz "Found! Cannot Proceed!"

tGreetings:					; for the text info box greeting the user

.byte $18,$1a				; BOLD & OUTLINE
.byte "geoPublish Verification Program"
.byte $1b					; PLAINTEXT
.byte $16,$28,$00,$6e
.asciiz "Copyright 2004 by Todd S. Elliott - Please Wait"

tSuccessCRC:				; prints the successful CRC message

.byte $18					; BOLD
.byte "Verification Successful"
.byte $1b					; PLAINTEXT
.byte " - $"
hCRC:
.byte $00,$00,$00,$00
.byte $16,$50,$00,$40
.asciiz "Please Report it to Author"

.bss
progDrive:					; contains device # for the verification program
.res 1
targetDrive:				; contains device # for the geoPublish target drive
.res 1
nbuffer:					; filename buffer
.res $11
seed:						; CRC value
.res 2
