; This routine will display a dialog box, handling the user's Photo Scrap, JPEG & EPS files
; This is VLIR #$11 of geoPublish
.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"

.org $4880					; up to $527f - 2560 maxsize bytes for this module

; equates
OPattern		=	$e8		; graphics object pattern
OAttribute		=	$e9		; graphics object attribute
pFindFile		=	$142b		; issues the FindFile call
toggleZP		=	$1761		; preserves zero page locations
L1790			=	$1790		; calls a Dialog Box w/ custom recover/imprint routines
SetDataDevice	=	$181c		; issues a SetDevice call on the data drive
RZoomBox		=	$1913		; imprints the zoom toolbox and sets it up
EZoomBox		=	$1946		; erases the zoom toolbox
eJDimensions	=	$1a4f		; gets ending dimensions of the JPEG image
pInsertObj		=	$1a58		; inserts a graphics object onto a geoPublish page
L2178			=	$2178		; routine to 'open' a geoPublish file
L31A4			=	$31a4		; clears current VLIR # at $74
L346F			=	$346f		; sets r2 pointing to the current graphics object
L39DF			=	$39df		; sets r3 pointing to the current GO's image header
delObj		=	$3b75		; deletes a graphics object
L4144			=	$4144		; routine to get starting dimensions of an image
L4214			=	$4214		; .A given to this routine will load in that VLIR module
L4347			=	$4347		; calls the Attributes DB when a object is picked.
fileReqBuffer	=	$4f00		; 256-byte buffer for the restrictive file requestor
l6ac1			=	$6ac1		; variable holding value for a graphics object
gwvlir		=	$6d32		; geoWrite's VLIR records are located here
jMode			=	gwvlir	; indicate which operating mode (JPEG/EPS/PS)
imagedat		=	jMode+1	; 8 bits are reserved in this variable and unused.
xWidth		=	imagedat+1	; contains width of image in pixels (word)
yHeight		=	xWidth+2	; contains height of image in pixels (word)
OrientObj		=	yHeight+2	; JPEG/EPS's orientation value
fnBuffer		=	$6e23		; filename buffer
ObjPatt		=	$712a		; graphics object pattern value
ObjAttr		=	$712c		; graphics object attribute value
l712f			=	$712f		; word value for height of image in scanlines
curObj		=	$750b		; current graphics object #
OrientLoc		=	$a908		; actual screen location for the orientation icon

; jump table
	jmp	promptJPEG			; prompts the user with the JPEG DB
	jmp	processJPEG			; processes the user-selected JPEG file
	jmp	attributeJPEG		; allows the user to select attributes

promptJPEG:					; prompts the user with a dialog box
	ldx	#$02
@1:	lda	mouseXPos,x			; preserve mouse x/y positions first
	sta	$d2,x				; store them here temporarily
	dex
	bpl	@1

JPEGdbReq:
	lda	jMode				; check to see which mode is being used
	bne	@1				; if $00, then Photo Scrap mode is used
	lda	#$00				; null-terminate the dialog box a bit early.
	ldx	#<tPS				; load name of Photo Scrap
	ldy	#>tPS
	bne	@4				; relative JMP
@1:	bmi	@2				; if $01, then EPS mode is used
	ldx	#<tEPS			; load name of EPS
	ldy	#>tEPS
	bne	@3				; relative JMP
@2:	ldx	#<tJPEG			; load name of JPEG ($FF in jMode means JPEG mode is used.)
	ldy	#>tJPEG
@3:	lda	#$10				; DBGETFILES
@4:	sta	dbfr				; determines if the DBGETFILES will show up or not
	stx	r8L
	sty	r8H				; load r8 w/ the text pointer

	lda	#145				; JPEG filetypes
	sta	r7L				; for DBGETFILES routine
	lda	#$00
	sta	fnBuffer			; zero it out
;	sta	OrientObj			; default 'Up' image orientation
	sta	r10L
	sta	r10H				; zero out permanent name string
	LoadW	r5, InitJPEGFilenames	; load r5 pointing to feeder routine
	jsr	readDiskName		; gets name of disk

	lda	#<dbJPEG
	ldx	#>dbJPEG
	jsr	toggleZP
	jsr	L1790				; issue the DB
	jsr	toggleZP			; preserve zero page locations due to disk access
	lda	r0L				; get result of DB action
	bmi	JPEGdbReq			; did the user press any attribute buttons?

	pha					; preserve r0L parameter
	jsr	L31A4				; clear the current VLIR pointer at $74
	lda	#$11				; VLIR #$11 - JPEG module
	jsr	L4214				; reload in this VLIR module due to the restrictive
	pla					; file requestor overwriting code in this module

	ldx	#$02
@12:	ldy	$d2,x				; restore mouse x/y positions before exiting
	sty	mouseXPos,x
	dex
	bpl	@12
	ldy	jMode				; get current operating mode
	rts					; for now

dbJPEG:					; the PS/JPEG/EPS dialog box table
.byte $81					; default DB position and pattern
.byte $05					; OPEN icon
.byte $11					; card xpos
.byte $19					; ypos
.byte $0b					; DBTXTSTR
.byte $82					; xpos
.byte $0a					; ypos
.word tOnDisk				; - pointer to text (on disk:)
.byte $0b					; DBTXTSTR
.byte $82					; xpos
.byte $14					; ypos
.word tDiskName				; - pointer to diskname
.byte $0c					; DBVARSTR
.byte $88					; xpos
.byte $47					; ypos (experiment w/ this value)
.byte r8					; use pseudoregister r8
.byte $12					; DBUSRICON
.byte $16					; card xpos
.byte $3f					; ypos
.word itButton				; pointer to table
;.byte $12					; DBUSRICON
;.byte $16					; card xpos (or $11?)
;.byte $2b					; ypos
;.word itConstBox				; pointer to table
;.byte $0b					; DBTXTSTR
;.byte $88					; xpos
;.byte $32					; ypos (experiment w/ this value)
;.word tConstrain				; pointer to text
;.byte $12					; DBUSRICON
;.byte $16					; card xpos (or $11?)
;.byte $35					; ypos
;.word itCentBox				; pointer to table
;.byte $0b					; DBTXTSTR
;.byte $88					; xpos
;.byte $3c					; ypos (experiment w/ this value)
;.word tCenter				; pointer to text
.byte $02					; CANCEL icon
.byte $11					; card xpos
.byte $4c					; ypos
dbfr:						; pointer for the file requestor portion of the DB
.byte $10					; DBGETFILES
.byte $04
.byte $04					; default x,y pos
.byte $00					; NULL terminator

itButton:					; icon table for the jpeg/eps/ps button
.word iButton				; pointer to icon data
.word $0000
.byte $01					; width in cards
.byte $0c					; height in scanlines
.word sButton				; pointer to service routine

itOrient:					; icon table for orientation icons
.word iOrientUp				; pointer to icon data
.word $0000
.byte $01					; card width
.byte $08					; scanline height
.word sOrient				; pointer to service routine

;itCentBox:					; icon table for constrained box
;.word iBox					; pointer to icon data
;.word $0000
;.byte $01					; card width
;.byte $08					; scanline height
;.word sCenter				; pointer to service routine

iButton:					; actual icon data for button
.byte $8c,$ff,$81,$99,$a5,$c3,$c3
.byte $c3,$c3,$a5,$99,$81,$ff

iOrientUp:					; actual icon data for Up orientation
.byte $88,$18,$3c,$3c,$18,$3c,$7e,$7e,$ff
iOrientDown:				; actual icon data for Down orientation
.byte $88,$ff,$7e,$7e,$3c,$18,$3c,$3c,$18
iOrientRite:				; actual icon data for Right orientation
.byte $88,$80,$e0,$f6,$ff,$ff,$f6,$e0,$80
iOrientLeft:				; actual icon data for Left orientation
.byte $88,$01,$07,$6f,$ff,$ff,$6f,$07,$01

tPS:
.asciiz "P.S."

tJPEG:
.asciiz "JPEG"

tEPS:
.asciiz "EPS"

tOnDisk:
.byte $18

.byte "On disk:"
.byte $1B,$00

tOrient:					; Image Orientation Text
.asciiz "Orientation"

tName:					; Name of image
.byte $18					; BOLD
.asciiz "Name"

;tCenter:
;.asciiz "Center"

;iBox:
;.byte $81,$ff,$06,$81,$81,$ff
;iChek:
;.byte $08,$ff

;sCenter:					; for now
;	lda	fConstCent
;	eor	#$40				; manipulate bit 6
;	sta	fConstCent
;	jmp	contDB

srJPEG:					; service routine for the JPEG db
	lda	#$00
	sta	iconSelFlag			; turn off the icon inverting routines
	sta	appMain
	sta	appMain+1			; zero out appMain
	lda	OrientObj
	beq	@6				; check for Up Orientation - go clockwise
	cmp	#$10				; is it Right Orientation?
	beq	sButton-29
	cmp	#$20				; is it Down Orientation?
	beq	sButton-37
	bne	sButton-45			; is it Left Orientation?
@6:	rts

sJPEG:
	LoadW	appMain, srJPEG		; load the appMain vector for after DB activities
	rts

;Delay:					; delays the db routines in between mouse clicks
;	inc	ascSign
;	beq	sOrient
;	rts

sOrient:					; service routine for the orientation icon
;	lda	mouseData			; check buttonpress data
;	bpl	@1
;	lda	#$00				; button hasn't been released - free up appMain
;	sta	appMain+1
;	sta	appMain
;	rts
;@1:	lda	#>Delay
;	sta	appMain+1
;	lda	#<Delay			; load appMain w/ mouse delay routine
;	sta	appMain
	lda	OrientObj
	beq	@2				; check for Up Orientation - go clockwise
	cmp	#$10				; is it Right Orientation?
	beq	@3
	cmp	#$20				; is it Down Orientation?
	beq	@4
	ldx	#<iOrientUp
	ldy	#>iOrientUp
	lda	#$00				; set for Up Orientation
	beq	@5
@4:	ldx	#<iOrientLeft
	ldy	#>iOrientLeft
	lda	#$30				; set for Left Orientation
	bne	@5
@3:	ldx	#<iOrientDown
	ldy	#>iOrientDown
	lda	#$20				; set for Down Orientation
	bne	@5
@2:	ldx	#<iOrientRite
	ldy	#>iOrientRite
	lda	#$10				; set for Right Orientation
@5:	sta	OrientObj
	stx	r9L
	sty	r9H				; r9 points to icon data
	ldy	#$08				; extract icon data towards screen
@6:	lda	(r9),y
	sta	OrientLoc-1,y		; actual screen value (experiment)
	dey
	bne	@6
@1:	bit	mouseData
	bpl	@1				; branch if button is still pressed.
	rts					; exit if the button has been released.

sButton:					; service routine for the button
	ldy	jMode
	bpl	@5				; check JPEG mode
@6:	iny
@7:	sty	jMode				; increment it and change it to Photo Scrap mode
	jmp	contDB
@5:	beq	@6				; check photo scrap mode, and if it is, change it to EPS
	ldy	#$ff				; mode. Otherwise, reset the flag to JPEG mode
	bne	@7				; relative JMP

contDB:
sAttribute:					; service routine for the ATTR icon
	lda	#$ff
	sta	sysDBData
	jmp	RstrFrmDialog

InitJPEGFilenames:			; Initalizes the JPEG filename feeder routine
	lda	#$00				; initalize the filename counter
	sta	$ff
	jsr	Get1stDirEntry		; gets the next available filename
	txa					; check disk error
	beq	FeedAgain			; branch if there's no disk error

FeedJPEGFilenames:			; feeds the JPEG filenames into DBGETFILES
	MoveW	r15, r5			; restore r5
	lda	$ff				; are we done?
	bne	StartFeed			; branch if we still have space left for more filenames
	LoadW	r5, fnBuffer		; loads r5 with the filename buffer
	sec					; tells the DBGETFILES item requestor under Wheels OS
	rts					; that we are done feeding filenames

StartFeed:
	jsr	GetNxtDirEntry		; gets the next directory entry
	txa					; check disk error
	beq	@2				; and continue the search
	ldy	#$ff				; force error
@2:	tya					; are we done with the directory?
	bne	StartFeed-10		; if so, exit the feeder routine

FeedAgain:
	ldy	#$00				; go through individual file entries in a dirblock
	lda	(r5),y
	and	#%00111111			; get rid of bits 7 & 6
	beq	StartFeed			; branch if it's DELeted
	cmp	#$04				; is it REL filetype or higher?
	bcs	StartFeed			; branch if so
	iny					; get t/s
	lda	(r5),y
	sta	r1L
	iny
	lda	(r5),y
	sta	r1H
	LoadW	r4, fileReqBuffer
	jsr	GetBlock			; get the first block of the datafile
	txa
	beq	@4				; check disk error
	LoadW	r4, FeedAgain		; use the actual code of FeedAgain to trigger
						; an erroneous comparison
@4:	lda	jMode				; check which JPEG/EPS mode is used.
	bmi	@5				; branch if it's a JPEG file requestor
	jsr	restrictEPS			; otherwise, it's an EPS file requestor
	bne	StartFeed			; If non-zero, then it's not a EPS file.
	beq	@1				; relative JMP
@5:	jsr	restrictJPEG		; check for JPEG files.
	bne	StartFeed			; if non-zero, then it's not a JPEG file.
@1:	inc	$ff				; increment the filename counter
	ldy	#$03				; feed the JPEG filename to DBGETFILES
@8:	lda	(r5),y
	dey
	dey
	dey					; correct .Y
	cmp	#$a0				; are we done with the filename?
	beq	@7
	sta	(r6),y
	iny
	iny
	iny
	iny					; restore .Y
	cpy	#$13				; are we done with the filename anyway?
	bne	@8
@7:	lda	#$00				; NULL-terminate it
	sta	(r6),y
	MoveW	r5, r15			; preserve r5 for the next feed
	LoadW	r5, FeedJPEGFilenames
	clc					; we're not done.
	rts

jpegsig:
.byte $ff,$d8
;.byte $ff,$e0				; JPEG marker ($ff,$d8) & JFIF header ($ff,$e0)
epsSig1String:
.asciiz "%!PS"
epsSig2String:
.asciiz "EPSF"

readDiskName:				; reads in disk name and stores it
	jsr	SetDataDevice		; switch to data device
	ldx	#r3				; use r3
	jsr	GetPtrCurDkNm		; retrieve the disk name
	ldy	#$00
	ldx	#$00
@5:	lda	(r3),y
	cmp	#$a0				; check for padded spaces
	beq	@6
	sta	tDiskName,x			; store in disk name.
	iny
	inx
	cpx	#$10				; are we done anyway?
	bne	@5
@6:	lda	#$00
	sta	tDiskName,x			; and delimit it
	rts

processJPEG:				; processes a JPEG file.
						; .Y will have the jMode variable
	jsr	ReadJDimensions		; get dimensions of the JPEG file.
	bcs	processJPEG-1		; branch on an error
	jsr	L2178				; 'opens' the geoPub datafile
	jsr	L4144				; sets up starting x,y positions of the graphics object
;	jsr	chkOrient			; check image orientation first
	jsr	EZoomBox			; erases the zoom toolbox
	MoveW	xWidth, r0			; r0 points to width of JPEG file.
	lda	yHeight
	sta	l712f				; $712f-$7130 holds height of JPEG file in scanlines
	lda	yHeight+1
	sta	l712f+1
	jsr	eJDimensions		; calculate the ending values of the JPEG file
	lda	#$04				; value for Rectangle
	sta	l6ac1				; variable holding current graphics object value
	lda	ObjAttr			; object attribute value
	sta	OAttribute			; $e9
	lda	ObjPatt			; object pattern value
	sta	OPattern			; $e8 - borrowed from the Rectangle Object routines
	LoadW	r0, $0015			; tell the insert object routine that 20 bytes
						; need to be allocated in high memory
	jsr	pInsertObj			; paste the rectangle onto the geoPub page
	lda	#$08				; value for Photo Scrap
	sta	l6ac1				; variable holding current graphics object value

	jsr	L39DF				; set r3 to point to image header
	lda	r3H
	beq	@1				; if empty, then abort JPEG insertion routine
	ldy	#$01
	lda	#$00				; for now, set the 2nd GEOS pattern as $00
	sta	(r3),y
	iny
	lda	jMode				; set the JPEG/EPS byte (3/5)
	bpl	@3
	lda	#$03				; JPEG value
.byte $2c
@3:	lda	#$05				; EPS value
;	ora	OrientObj			; and add in the orientation value (bits 5 & 4)
						; default orientation is UP (%00)
	sta	(r3),y			; and store it into the info header
	iny
	lda	#$55				; proxy for imagedat, containing default contrast
						; & brightness values ($55)
	sta	(r3),y			; into offset 2 of the info header
	ldx	#$00
@2:	iny
	lda	fnBuffer,x			; get the JPEG/EPS filename
	sta	(r3),y
	beq	@1				; check for the NULL terminator
	inx
	cpx	#$10				; are we done?
	bne	@2

;	lda	#$ff				; set flags to force geoPublish into saving the
;	sta	l75ad				; the newly imported graphics object data into
;	sta	l75ad+1			; the relevant geoPublish datafile's VLIR record

@1:	jmp	RZoomBox			; imprint the zoom toolbox and rts for now
;	rts					; for now

ReadJDimensions:
	jsr	i_FillRam			; zero out frameString
.word $0007					; fill 7 bytes
.word frameString				; address
.byte $00					; fill (clear) byte
	LoadW	r6, fnBuffer		; r6 contains pointer to filename as returned
	jsr	pFindFile			; by DBGETFILES. Get its parameters.
	txa					; check error
	bne	@9
	jsr	toggleZP			; preserve zp space as disk routines are heavily used
	MoveW	dirEntryBuf+1, r1		; copy T/S links to r1
	LoadB	r5L, $00
	sta	r5H
	LoadW	r4, diskBlkBuf		; use diskBlkBuf as a buffer
	lda	jMode				; check JPEG or EPS operating mode
	bmi	@2				; branch if it's a JPEG
	jmp	GetEPSCoords		; otherwise, get EPS file coordinates
@2:	jsr	ReadByte
;	cmp	#$ff
;	bne	@90
	jsr	ReadByte			; issue two ReadByte's to get rid of JPEG marker
;	cmp	#$d8
;	bne	@90

	LoadW	r2, $ffc0			; look for this special JPEG header
	jsr	GetFrame
	jsr	toggleZP			; restore ZP space for geoPublish as we're done
	bcs	@9				; abusing the disk drive
	ldy	#$06
	ldx	#$00
@1:	lda	frameString,y		; get the height/width of image
	sta	xWidth,x
	dey
	inx
	cpx	#$04				; are we done getting image dimensions?
	bne	@1
	clc
	rts
@9:	sec
sAttach:					; for now
	rts

GetFrame:
	jsr	ReadByte
	sta	r0H				; get the JPEG header into r0
	jsr	ReadByte
	sta	r0L
	txa					; check error
	bne	@5
	lda	r0H
	cmp	r2H
	bne	@7
	lda	r0L
	cmp	r2L				; is it the special JPEG header ($ffc0?)
	beq	@3
@7:	jsr	ReadByte
	sta	r0H				; if not equal, then get the length word into r0
	jsr	ReadByte
	sta	r0L
	txa					; check error
	bne	@5
	sec
	lda	r0L
	sbc	#$02
	sta	r0L
	lda	r0H
	sbc	#$00
	sta	r0H
;	SubVW	$02, r0			; subtract 2 from value in r0 to compensate for the
@2:	jsr	ReadByte			; length word. Read further bytes and discard them.
	txa					; check error
	bne	@5
	ldx	#r0
	jsr	Ddec				; go through the entire JPEG header until we're done
	bne	@2
	beq	GetFrame			; done processing the current JPEG header, so get
@3:	ldy	#0				; another JPEG header and start again.
	sty	r3L
@4:	jsr	ReadByte
	cpx	#0				; check disk error
	bne	@6
	ldy	r3L
	sta	frameString,y		; store length & contents into frameString
	iny
	sty	r3L
	cpy	#$07				; are we done yet with the $ffc0 header?
	bcc	@4
@6:	clc					; no error exit
	rts
@5:	sec					; error exit
	rts

;the file's directory entry must already be loaded by a calling routine.
GetEPSCoords:
	jsr	FindBBoxLine		; find the BoundingBox line.
	jsr	toggleZP			; we're done abusing the disk device, restore zp space
	bcc	@4				; if carry is set, the BBox line is available.
	lda	#<(epsLineBuf+14)
	sta	r0L
	lda	#>(epsLineBuf+14)
	sta	r0H				; point to start of EPS coordinates
	jsr	GetNxtAscWord		; gets the first ASCII #
	bcc	@4
	MoveW r1, lowerXBBox		; copies the integer equivalent to this word value
	jsr	GetNxtAscWord		; repeat for the next ASCII #
	bcc	@4
	MoveW	r1, lowerYBBox		; etc.
	jsr	GetNxtAscWord		; repeat for the next ASCII #
	bcs	@5
@4:	sec
	rts
@5:	MoveW	r1, upperXBBox		; ditto
	jsr	GetNxtAscWord		; get the final ASCII # in sequence
	bcc	@4
	MoveW	r1, upperYBBox		; and store it here.

; now convert PostScript's 72 units per inch (upi) to the equivalent dimension at 300dpi.
	sec
	lda	upperXBBox+0
	sbc	lowerXBBox+0
	sta	xWidth			; r1L
	lda	upperXBBox+1
	sbc	lowerXBBox+1
	sta	xWidth+1			; r1H now holds width value
;	jsr	IncR1				; r1 now holds width value
;	MoveW	r1, eps72Width		; width at 72upi.
;	jsr	X25Div6
;	MoveW	r1, xWidth			; width at 300dpi.
	sec
	lda	upperYBBox+0
	sbc	lowerYBBox+0
	sta	yHeight			; r1L
	lda	upperYBBox+1
	sbc	lowerYBBox+1
	sta	yHeight+1			; r1H now holds height value
;	jsr	IncR1				; r1 now holds height value
;	MoveW r1, eps72Height		; height at 72upi.
;	jsr	X25Div6
;	MoveW	r1, yHeight			;height at 300dpi.
	clc
	rts

;multiply by 4.1667
;X25Div6:
;	LoadB	r2L, 25
;	ldx	#r1
;	ldy	#r2L
;	jsr	BMult
;	LoadW	r2, $06
;	ldx	#r1
;	ldy	#r2
;	jmp	Ddiv

;IncR1:
;	inc	r1L
;	bne	@1
;	inc	r1H
;@1:	rts

;eps72Width:
;.block 2
;eps72Height:
;.block 2

GetNxtAscWord:
	LoadB	ascSign, $00		; returns r1 w/ integer value of ASCII #
	ldy	#$00
@1:	lda	(r0),y
	beq	@2				; check for delimiter
	cmp	#' '
	bne	@3
	iny
	cpy	#3
	bcc	@1
@2:	clc
	rts

@3:	ldx	#$00
	cmp	#'+'
	beq	@5
	cmp	#'-'
	bne	@4
	dec	ascSign
@5:	iny
@4:	lda	(r0),y			; get ASCII # equivalent
	beq	@6				; check for delimiters for the number
	cmp	#' '
	beq	@6
	cmp	#'.'
	beq	@6				; ignore decimal points.
	sta	ascStringBuffer,x
	iny
	inx
	cpx	#$04				; up to 4 digits of accuracy?
	bcc	@4
@9:	clc
	rts

@6:	lda	#$00
	sta	ascStringBuffer,x		; delimit the ASCII #
@65:	lda	(r0),y
	beq	@68
	cmp	#' '
	beq	@68
	iny
	bne	@65
@68:	tya
	clc
	adc	r0L
	sta	r0L
	bcc	@7
	inc	r0H				; compensate r0 pointing to the next ASCII #
@7:	lda	ascStringBuffer		; is it empty?
	bne	@8
	LoadB	r1L, $00
	sta	r1H
	sec
	rts
@8:	jsr	AscStr2Bin			; convert the ASCII # to integer
	bcs	@9
	bit	ascSign
	bpl	@85
	ldx	#r1
	jsr	Dnegate
@85:	sec
	rts

FindBBoxLine:				; goes through the EPS file in finding a
	jsr	FindNxtLineStart		; bounding box comment line
	bne	@9				; carry set = comment line available.
@2:	jsr	ReadByte
	cpx	#$00				; check error
	bne	@9
	cmp	#CR
	beq	@2
	cmp	#LF
	beq	@2
	ldy	#$00
	sty	r0L
@3:	ldy	r0L
	sta	epsLineBuf,y
	inc	r0L
	cpy	#38
	beq	@5
	jsr	ReadByte
	cpx	#$00				; check error
	bne	@9
	cmp	#CR
	beq	@6
	cmp	#LF
	bne	@3
	beq	@6

@5:	jsr	FindNxtLineStart
	bne	@9
@6:	ldy	r0L
	lda	#$00
	sta	epsLineBuf,y		; delimit the EPS line buffer
	jsr	TestIfBoundingBox
	bne	@7
	sec
	rts
@7:	jsr	TestIfEndComments		; are we done with the EPS file?
	bne	@2
@9:	clc
	rts

TestIfBoundingBox:
	ldy	#$00
@1:	lda	bboxString,y
	beq	@8				; check for delimiter
	cmp	epsLineBuf,y
	bne	@8
	iny
	bne	@1
@8:	rts

TestIfEndComments:
	ldy	#$00
@1:	lda	endCommentsString,y
	beq	@8				; check for delimiter
	cmp	epsLineBuf,y
	bne	@8
	iny
	bne	@1
@8:	rts

FindNxtLineStart:
	jsr	ReadByte
	cpx	#$00				; check error
	bne	@9
	cmp	#CR
	beq	@9
	cmp	#LF
	bne	FindNxtLineStart
@9:	rts

AscStr2Bin:
	lda	#0				; this routine converts ascii #'s into a two byte integer
	ldx	#$01				; number of bytes in result
@1:	sta	r1,x				; r1 holds the result
	dex
	bpl	@1
	sta	r15H
	lda	#$0a				; the multiplier
	sta	r2L
@2:	ldx	r15H				; index to ascStringBuffer
	lda	ascStringBuffer,x		; gets an ASCII number
	beq	@6				; are we done?
	sec					; strip off the ascii by subtracting 48 to get the number
	sbc	#48
	bcc	@3
	ldx	#r1				; multiplicand & word result
	ldy	#r2				; byte multiplier
	pha					; save this number temporarily
	jsr	BMult				; use GEOS multiply routine to multiply result by 10
	pla
	clc
	adc	r1L
	sta	r1L
	bcc	@5
	inc	r1H				; does the high bytes
@5:	inc	r15H
	bne	@2
@6:	clc
	rts
@3:	sec					; error
	rts					; value in res variable. exit for now.

;chkOrient:					; checks image orientation and compensates the
;	lda	OrientObj			; width & height values accordingly.
;	beq	@1				; is it 'Up'?
;	cmp	#$20				; is it 'Down'?
;	beq	@1
;	lda	xWidth			; at this point, the image is rotated 90 degrees
;	ldx	yHeight			; need to switch width/height values
;	sta	yHeight
;	stx	xWidth
;	lda	xWidth+1
;	ldx	yHeight+1
;	sta	yHeight+1
;	stx	xWidth+1
;@1:	rts

restrictJPEG:				; restrict the file requestor to JPEG files.
	ldy	#$03
	ldx	#$01
@5:	lda	(r4),y
	cmp	jpegsig,x			; trace the JPEG signature
	bne	@1				; if not equal, then it is not a JPEG file
	dey
	dex
	bpl	@5				; go through the signature
	inx					; set Z flag
@1:	rts

restrictEPS:				; restrict the file requestor to EPS files.
	ldy	#2
@2:	lda	(r4),y
	cmp	epsSig1String-2,y
	beq	@3
	iny
	cpy	#$04
	bcc	@2				; branch back just in case the file starts with a
@1:	tya					; carr return or space or something.
	rts					; clear equals flag for an error.

@3:	iny					; now test for "%!PS"
	lda	epsSig1String-2,y
	beq	@9				; branch if end of string.
	cmp	(r4),y
	beq	@3				; branch if test still OK.
	rts					; now weed past the PS version stuff until we
						; get to a space character.

@9:	lda	(r4),y
	cmp	#' '				; look for first space.
	beq	@6
	cmp	#CR				; if end of line found,
	beq	@1				; then branch, not EPS.
	cmp	#LF				; branch if any CR or LF.
	beq	@1				; branch if not EPS.
	iny					; there must be a space soon.
	cpy	#30				; have we checked far enough?
	bcc	@9				; branch if not.
	tya					; give up, not an EPS.
	rts

@6:	ldx	#$ff				; now check for the "EPSF" string.
@7:	inx
	iny
	lda	epsSig2String,x
	beq	@8
	cmp	(r4),y
	beq	@7
@8:	rts

attributeJPEG:				; allows the user to select attributes
	lda	#$00
	sta	OrientObj
	sta	tDiskName
	jsr	L346F				; set r2 to point to selected object at $750b
	jsr	L39DF				; set r3 to point to image header
	ldy	#$00
	lda	(r2),y			; get type of graphics object for now.
	cmp	#$04				; is it a Rectangle?
	beq	@1
	cmp	#$02				; is it a Circle?
	bne	attributeJPEG-1		; if not equal to these 2 objects, simply exit
@1:	lda	r3H				; check high byte of image header
	beq	@3				; if empty, do not fill image name
	ldy	#$04				; point to start of image name
	jsr	readDiskName+10		; reuse disk name routines for this purpose
	ldy	#$02				; get object orientation
	lda	(r3),y
	and	#$30				; preserve orientation information
	sta	OrientObj

@3:	lda	#<dbAttrJPEG
	ldx	#>dbAttrJPEG
	jsr	L1790				; issue the DB
	lda	r0L				; get DB info
	bpl	@7				; any GEOS icons clicked upon?
						; Handle the 'ATTR' icon.
	jsr	RZoomBox			; imprint the area under the toolbox
	pla
	pla					; get rid of the previous JSR call
	jmp	L4347				; and start over again with the Attributes DB

@7:	cmp	#$02				; did the user CANCEL?
	beq	attributeJPEG-1
	cmp	#$01				; did the user OK?
	beq	@4
	cmp	#$05				; did the user OPEN?
	bne	attributeJPEG-1

	jsr	promptJPEG			; open the image file requestor box
	beq	attributeJPEG		; did the user load in a Photo Scrap?
	cmp	#$02				; did the user CANCEL?
	beq	attributeJPEG		; if so, repeat the attributes DB again

	jsr	L346F				; set r2 to point to selected object at $750b
	jsr	L39DF				; set r3 to point to image header
	lda	r3H				; check to see if the image header exists
	bne	@5				; if it exists, simply change the image name

	ldy	#$0d
	ldx	#$07				; starting x,y & ending x,y coordinates
@6:	lda	(r2),y
	sta	$EA,x				; get object's coordinates into zp operating space
	dey
	dex
	bpl	@6
	ldy	#$00				; get type of object
	lda	(r2),y
	sta	l6ac1
	lda	curObj			; gets current object at $750b
	jsr	delObj			; and removes the old graphics object
	LoadW	r0, $0015			; tell the insert object routine that 20 bytes
						; need to be allocated in high memory
	jsr	pInsertObj			; paste the rectangle onto the geoPub page
	lda	#$00
	sta	l6ac1				; restore it to the SELECT icon
	jsr	L39DF				; set r3 to point to image header
	lda	r3H				; if it is empty, abort
	beq	@2
	ldy	#$06				; get newly created graphics object's number
	lda	($d5),y
	tay
	dey
	sty	curObj			; and make it the current object

@5:	ldy	#$02				; set the JPEG/EPS byte (3/5)
	lda	jMode
	bpl	@9
	lda	#$03				; JPEG value
.byte $2c
@9:	lda	#$05				; EPS value
	ora	OrientObj			; and add in the orientation value (bits 5 & 4)
	sta	(r3),y			; and store it into the info header
	iny
	lda	#$55				; proxy for imagedat, containing default contrast
						; & brightness values ($55)
	sta	(r3),y			; into offset 3 of the info header
	ldx	#$00				; insert image name
@8:	iny
	lda	fnBuffer,x			; get the JPEG/EPS filename
	sta	(r3),y
	beq	@10				; check for the NULL terminator
	inx
	cpx	#$10				; are we done?
	bne	@8

@10:	jmp	attributeJPEG		; and repeat the DB again.

						; Handles the OK selection
@4:	jsr	L346F				; set r2 to point to selected object again
	jsr	L39DF				; set r3 to point to image header
	lda	r3H				; make sure the image header exists
	beq	@2
	ldy	#$02
	lda	(r3),y			; get imagetype variable
	and	#$0f				; get rid of old orientation info
	ora	OrientObj			; and add in the orientation byte
	sta	(r3),y
						; Handles the CANCEL selection
@2:	rts					; for now

dbAttrJPEG:					; dialog box for the image attributes
.byte $81					; default DB parameters
.byte $05					; OPEN icon
.byte $01					; card xpos
.byte $07					; ypos
.byte $12					; DBUSRICON
.byte $08					; card xpos
.byte $07					; ypos
.word itAttach				; pointer to icon table
.byte $0b					; DBTXTSTR
.byte $72					; xpos
.byte $14					; ypos
.word tDiskName				; - pointer to diskname
.byte $01					; OK icon
.byte $01					; card xpos
.byte $4c					; ypos
.byte $12					; DBUSRICON
.byte $09					; card xpos
.byte $4c					; ypos
.word itAttr				; pointer to icon table
.byte $02					; CANCEL icon
.byte $11					; card xpos
.byte $4c					; ypos
.byte $13					; DB_USR_ROUT
.word sJPEG					; pointer to service routine
.byte $12					; DBUSRICON
.byte $01					; card xpos
.byte $18					; ypos
.word itOrient				; pointer to icon table
.byte $0b					; DBTXTSTR
.byte $12					; xpos
.byte $1f					; ypos
.word tOrient				; text pointer
.byte $0b					; DBTXTSTR
.byte $72					; xpos
.byte $09					; ypos
.word tName					; text pointer
.byte $00					; NULL

itAttr:					; icon table for Attributes button
.word iAttr					; pointer to icon data
.byte $00,$00				; xpos/ypos already in db table
.byte $06					; card width
.byte $10					; scanline height
.word sAttribute				; service routine for Attributes button

itAttach:					; icon table for Attach button
.word iAttach				; pointer to icon data
.byte $00,$00				; xpos/ypos already in db table
.byte $06					; card width
.byte $10					; scanline height
.word sAttach				; service routine for Attributes button

iAttr:					; icon data for the Attributes button (70 bytes)
.byte $06,$ff				; repeat byte
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $e3,$02,$86,$80,$0c,$18,$60,$00,$03; BIGCOUNT byte
.byte $8c,$80,$1e,$3c,$f3,$f0,$03,$80,$1e,$18,$63,$80,$03; unique byte
.byte $e3,$02,$86,$80,$33,$18,$63,$00,$03; BIGCOUNT byte
.byte $92,$80,$7f,$98,$63,$00,$03,$80,$61; unique byte
.byte $98,$63,$00,$03,$80,$61,$8e,$3b,$00,$03
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $0c,$ff				; repeat byte

iAttach:					; icon data for the Attach button (72 bytes)
.byte $06,$ff				; repeat byte
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $e3,$02,$86,$81,$83,$18,$00,$06,$03; BIGCOUNT byte
.byte $aa,$83,$c7,$bc,$f1,$e6,$e3	; unique byte
.byte $83,$c3,$19,$9b,$37,$33
.byte $86,$63,$18,$fb,$06,$33
.byte $86,$63,$19,$9b,$06,$33
.byte $8f,$f3,$19,$9b,$06,$33
.byte $8c,$33,$19,$9b,$36,$33
.byte $8c,$31,$8c,$f9,$e6,$33
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $0c,$ff				; repeat byte

bboxString:
.asciiz "%%BoundingBox:"
endCommentsString:
.asciiz "%%EndComments"

.bss						; switch to variable space
tDiskName:					; contains name of disk (null-terminated)
.res $11

ascSign:					; used in ASCII converting routines
.res $01
ascStringBuffer:				; used in ASCII # conversions
.res $05

lowerXBBox:					; holds the coordinates of the EPS image
.res 2
lowerYBBox:
.res 2
upperXBBox:
.res 2
upperYBBox:
.res 2
;epsWidth:					; width of EPS image
;.block 2
;epsHeight:					; height of EPS image
;.block 2

epsLineBuf:					; used by the EPS frame sizing routines (40 bytes)
frameString:				; used by the JPEG frame sizing routines (40 bytes)
;JPEGBuffer:				; used for the JPEG detection routines (256 bytes)
;.res $ff					; JPEGBuffer eats into $5000, jamming the Wheels Kernal
.res $28
