; da65 V2.9.3 - (C) Copyright 2000-2003 Ullrich von Bassewitz
; Input file: gpd01v08.bin
; geoPublish decoded VLIR Module #$08
; Disassembly Copyright (c) 2003 by Todd Elliott

.out "Source Code (c) 2003 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"

; external equates
l051f		=	$051f
l05dc		=	$05dc
l06e2		=	$06e2
l0ad6		=	$0ad6
l14b9		=	$14b9
toggleZP	=	$1761
gpvlir	=	$6a94			; geoPublish's VLIR records are located here
pglFlag	=	gpvlir		; flag to indicate if a Page Graphics library file exists.
toggleLib	=	$1a00			; toggles file pointers for MP & PG library files

; equates
L12B8           = $12B8
L1305           = $1305
L138A           = $138A
L142B           = $142B
L1434           = $1434
L1437           = $1437
L17AF           = $17AF
L1817           = $1817
L186F           = $186F
L18C5           = $18C5
L1975           = $1975
L1A80           = $1A80
L1B72           = $1B72
L1B84           = $1B84
L2274           = $2274
L23F6           = $23F6
L2EBB		=	$2ebb
L4220           = $4220
LC2E3           = $C2E3
LFBF9           = $FBF9

.org $2500

	jmp	@1
	jmp	L257F
@1:	lda	r0L
	sta	L3401+1			; save pointer for LoadOptFlag
	lda	r3H
	sta	L3401+3
	lda	r3L
	sta	L3401+2			; save pointer to data filename
	jsr	serialgpb			; gets GEOS Kernal ID and serializes geoPublish if needed
	jsr	setDA				; loads in desk accessory filenames into buffer.
	lda	#$00
	sta	$6A82
	sta	$75AD
	sta	$6D48				; no idea yet.
	lda	L3401+1			; checks LoadOptFlag
	and	#$40				; did the user want to print a datafile?
	beq	@2				; branch if the user is not printing
	jsr	decodeGP			; decodes $1864-18a1 in geoPublish VLIR #00 code
	jsr	L2622				; sets the custom RecoverVector routines
	jsr	L25E1				; sets vectors, variables, processes & library files.
	clv
	bvc	@3
@2:	jsr	L257F				; decodes geoPublish VLIR #00 $1864-18a1
						; sets vectors, variables, processes, etc.
@3:  jsr	L2C6F				; checks GEOS 64 v1.3 version and patches GEOS Kernal, etc.
	jsr	L2E19				; ditto for GEOS 128 v1.3 version.
	jsr	setFonts			; sets fonts for geoPublish
	lda	L3401+1			; checks LoadOptFlag again
	and	#$40				; are we printing?
	bne	@4				; branch if we are printing
	jmp	@5
@4:	jsr	L2568				; get the data filename onto nameBuffer
	jmp	L1A80				; and goes directly into geoPublish VLIR #$00
@5:	lda	L3401+1			; get LoadOptFlag
	and	#$80				; was the datafile double-clicked upon?
	beq	@6				; branch if it wasn't
	jsr	L2568				; get name of datafile to nameBuffer
	jsr	L12B8				; not sure yet.
	jmp	L1B84				; goes directly into geoPublish VLIR #$00
@6:  jmp	L1B72				; ditto - end of VLIR #$08

L2568:
	lda	L3401+3
	sta	r0H
	lda	L3401+2			; get the data filename
	sta	r0L
	ldy	#$00
@1:	lda	(r0L),y
	sta	$6E23,y			; transfers it to nameBuffer
	iny
	cmp	#$00
	bne	@1
	rts

L257F:
	jsr	decodeGP
	jsr	L2891				; modifies menu table pertaining to DA's.
	jsr	L2622				; sets up custom recover routines
	lda	$01
	pha
	lda	#$35
	sta	$01
	lda	#$01
	sta	$D015
	lda	$D027
	sta	$D02A
	sta	$D02B
	lda	#$00
	sta	$D02D				; modifies the VIC-II chip directly, I assume are sprites
	pla
	sta	$01
	jsr	i_FillRam
.byte $80,$01,$80,$8A,$00
	jsr	i_MoveData
.word l2678
.byte $80,$8A,$19,$00
	jsr	i_MoveData
.word l269c
.byte $C0,$8A,$0D,$00
	jsr	i_MoveData
.word l26a9
.byte $00,$8B,$0D,$00
	jsr	i_MoveData
.word l2691
.byte $80,$8B,$0B,$00
	jsr	L1975				; issues a GraphicsString
	lda	#>l05dc			; I'm guessing, but it clears the screen.
	sta	r0H
	lda	#<l05dc
	sta	r0L
	lda	#$00
	jsr	DoMenu			; sets up the main menu table.

L25E1:
	lda	#>l051f
	sta	r0H
	lda	#<l051f
	sta	r0L				; $051f table of processes
	lda	#$0D				; # of processes
	jsr	InitProcesses
	lda	#>l06e2
	sta	keyVector+1
	lda	#<l06e2
	sta	keyVector			; load keyVector w/ $06e2 for keyboard handling
	lda	#$00
	sta	$75AD
	sta	$75AF
	jsr	L2631				; sets geoPublish main loop, variables and library files
	lda	#$00
	sta	$6AC1
	sta	$6D87
	sta	iconSelFlag
	sta	$AD
	sta	$AE
	sta	$6DAC
	sta	$6DAD
	sta	$6DA8
	sta	$6F05
	sta	$6F10
	rts

L2622:
	lda	#$80
	sta	dispBufferOn
	lda	#>l0ad6
	sta	RecoverVector+1
	lda	#<l0ad6
	sta	RecoverVector
	rts

L2631:
	ldy	#$09
	lda	#$00
@1:	sta	pglFlag,y			; zero out the MP&PG file pointer buffer
	dey
	bpl	@1

	jsr	L138A				; zeroes out a memory region at 7510-...
	lda	#>l14b9
	sta	appMain+1
	lda	#<l14b9			; geoPublish's main loop
	sta	appMain
	jsr	L1817				; calls SetProgDevice
	lda	#>l2c59
	sta	r10H
	lda	#<l2c59			; finds layout library files
	sta	r10L
	lda	#$02
	jsr	L2658
	lda	#>l2c64
	sta	r10H
	lda	#<l2c64			; finds master library files
	sta	r10L
	lda	#$01

	jsr	L2658
	jsr	toggleLib			; toggle to PG library file mode
	lda	#>graphxName
	sta	r10H
	lda	#<graphxName		; finds Page Graphics library file
	sta	r10L
	lda	#$01
	jsr	L2658
	jmp	toggleLib			; toggle back to MP mode and exits routine

L2658:
	pha
	jsr	L18C5				; loads r6 w/ $6e23
	lda	#$03				; DATA file type
	sta	r7L
	lda	#$01
	sta	r7H				; only find one file
	jsr	L1437				; calls FindFTypes
	pla
	ldx	r7H
	bne	@1
	ldx	#$6E				; the library file was found.
	stx	r0H
	ldx	#$23
	stx	r0L
	jsr	L1305				; basically calls FindFile on the library file
@1:	rts					; and saves file pointers associated with the library file

l2678:
.byte $08,$00,$00,$08,$00,$00,$08,$00,$00,$08,$00,$00,$FF,$80,$00,$08
.byte $00,$00,$08,$00,$00,$08,$00,$00,$08
l2691:
.byte $FF,$80,$00,$80,$80,$00,$80,$80,$00,$FF,$80
l269c:
.byte $20,$00,$00,$50,$00,$00,$88,$00,$00,$88,$00,$00,$F8
l26a9:
.byte $1C,$00,$00,$24,$00,$00,$44,$00,$00,$24,$00,$00,$1C

graphxName:
.asciiz "Graphx lib"

;serialgpb:
;	jsr	GetSerialNumber
;	lda	L2792
;	ora	L2793
;	beq	@4				; Has geoPublish been serialized?
;	rts

;;.byte $ad
;.byte   $93					; looks like abandoned code.
;.byte   $27					; should read as lda L2793, but lda opcode is missing
;	cmp	r0H
;	bne	@1
;	lda	L2792
;	cmp	r0L
;@1:	beq	@2				; aborted jump
;	lda	#<l2b1e
;	ldy	#>l2b1e
;	clv
;	bvc	@3

;@4:	jsr	L2825				; gets geoPublish disk block $0b, $0b
;	txa					; checks validity and then executes code there.
;	beq	@5
;	lda	#<l2b82
;	ldy	#>l2b82
;@3:  jsr	L280D				; issues DB warning user of invalid geoPublish disk
.byte $0d,$28

@6:	jsr	toggleZP
	jmp	EnterDeskTop		; and quits geoPublish

@2: .byte	$ad				; maybe this is the missing lda opcode

@5:	jsr	L2729				; gets GEOS Kernal ID and serializes geoPublish.
	txa
	bne	@6
	asl	L2792
	rol	L2793
	lda	L2792
	adc	#$00
	sta	L2792
	jsr	toggleZP
	jsr	GetDirHead
	jsr	toggleZP
	lda	L2793
	sta	curDirHead+191
	lda	L2792
	sta	curDirHead+190
	jsr	toggleZP
	jsr	PutDirHead			; serializes the directory header of geoPublish disk
	jsr	toggleZP
	lda	#<l2c42
	ldy	#>l2c42			; text for geoPublish installed DB
	jsr	L280D				; issues the DB
	jsr	toggleZP
	jmp	EnterDeskTop

L2729:
	lda	#$96
	ldx	#$C1
	jsr	CallRoutine			; calls GetSerialNumber again.
	lda	r0H
	sta	L2793
	lda	r0L
	sta	L2792				; inserts GEOS Kernal ID into geoPublish
	lda	#$80
	sta	r4H
	lda	#$00
	sta	r4L				; buffer @ $8000
	lda	#$0C
	sta	r1L
	lda	#$08				; $0c, $08 is the track/sector
	sta	r1H
	jsr	toggleZP
	jsr	GetBlock			; gets the disk block at $0c, $08
	jsr	toggleZP
	txa
	bne	@1
	lda	L2792
	eor	#$65
	sta	diskBlkBuf+152
	lda	L2793
	eor	#$65
	sta	diskBlkBuf+153		; stores the decoded equivalent of GEOS Kernal ID
	lda	#$80
	sta	r4H
	lda	#$00
	sta	r4L
	jsr	toggleZP
	jsr	PutBlock			; writes back the modified disk block
	jsr	toggleZP
	lda	#<l2c42
	ldy	#>l2c42			; text for geoPublish installed DB
	cpx	#$00
	beq	@2
	cpx	#$26				; checks for a specific disk error.
	beq	@3
@1:	lda	#<l2c25
	ldy	#>l2c25			; text message for geoPublish install error.
	clv
	bvc	@4
@3:	lda	#<l2bec
	ldy	#>l2bec			; cannot install on write protected disk error.
@4:	jsr	L17AF				; issues DB
@2:	rts

L2792: .byte	$7F			; GEOS Kernal ID #
L2793: .byte	$84

serialgpb:
decodeGP:
	rts					; abort serializing/decoding routine
.byte $25
;	lda	#$25
	sta	r0H
	lda	#$00
	sta	r0L				; r0 points to $2500 - this module
	lda	#$0F
	sta	r1H
	lda	#$02
	sta	r1L				; length of $0f02
	lda	#$00
	sta	r2L				; initial seed value
	ldy	#$00
@1:	lda	(r0L),y
	clc
	adc	r2L
	sta	r2L
	inc	r0L
	bne	@2
	inc	r0H
@2:	ldx	#r1
	jsr	Ddec
	bne	@1
	lda	r2L				; get the checksum value
	sec
	sbc	L2792
	sec
	sbc	L2793
	sec
	sbc	$2743
	sec
	sbc	$2747
	sec
	sbc	$2833
	sec
	sbc	$2837				; this prevents tampering with code at these addresses
	clc
	adc	#$65
	clc
	adc	#$65
	clc
	adc	#$65
	clc
	adc	#$65
	sta	r2L				; save the final checksum value
	lda	#$18
	sta	r0H
	lda	#$64
	sta	r0L				; r0 points to $1864 in VLIR #$00 geoPublish code
	lda	#$FF
	sta	r1H
	lda	#$C3
	sta	r1L				; decode only $3d bytes
	ldy	#$00
@3:	lda	(r0L),y
	eor	r2L
	sta	(r0L),y
	inc	r0L
	bne	@4
	inc	r0H
@4:	inc	r1L
	bne	@5
	inc	r1H
@5:	bne	@3
	rts

L280D:
	sta	r5L
	sty	r5H
	lda	#>l281c
	sta	r0H
	lda	#<l281c
	sta	r0L
	jmp	DoDlgBox

l281c:					; DB table.
.byte $81,$0c,$10,$10,$0c,$01,$11,$48,$00

L2825:
	jsr	toggleZP
	jsr	NewDisk			; refreshes the BAM of the disk drive containing
	jsr	toggleZP			; geoPublish disk
	txa
	beq	@1
	rts
@1:	lda	#$0B				; physical T/S pointers
	sta	r1L
	lda	#$0B
	sta	r1H
	lda	#$80
	sta	r4H
	lda	#$00
	sta	r4L				; buffer @ $8000
	jsr	toggleZP
	jsr	GetBlock			; gets block at $0b, $0b
	jsr	toggleZP
	txa
	bne	@2
	lda	#$00				; not necessary
	ldy	#$02
@3:	clc
	adc	diskBlkBuf,y		; rudimentary CRC check addition
	iny
	cpy	#$FF
	bne	@3
	cmp	$80FF				; compares the CRC value against the checksum
	beq	@4
	ldx	#$FF				; issue error
@2:	rts
@4:	jsr	diskBlkBuf+2		; there is code at $0b, $0b
	rts

setDA:
	lda	#$6C
	sta	r6H
	lda	#$AA
	sta	r6L				; buffer @ $6caa
	lda	#$05
	sta	r7L				; DESK_ACC - Desk Accessories
	lda	#$08
	sta	r7H				; Up to 8 DA's can be included
	lda	#$00
	sta	r10H
	lda	#$00
	sta	r10L				; no permanent name string to search for
	jsr	toggleZP
	jsr	FindFTypes			; get up to 8 DA's at buffer at $6caa
	jsr	toggleZP
	lda	#$08
	sec
	sbc	r7H
	sta	$0215				; contains # of desk accessories resident.
	rts

L2891:
	lda	$0215				; get # of DA's present
	clc
	adc	#$01
	pha
	ora	#$80
	sta	$0602				; I assume, modifies the menu table
	pla
	sta	r0L
	lda	#$0E
	sta	r1L
	ldy	#r0
	ldx	#r1
	jsr	BBMult
	clc
	adc	#$11
	sta	$05FD				; modifies the menu table
	rts

setFonts:					; sets up geoPublish's font routines.
	jsr	i_FillRam
.byte $50,$01,$5A,$6B,$00
	jsr	L1817				; SetProgDevice
	jsr	i_MoveData
.word l291a					; source
.byte $C2,$6A,$06,$00
	lda	#$6A
	sta	r6H
	lda	#$D5
	sta	r6L				; buffer @ $6ad5
	lda	#$08
	sta	r7L				; FONT filetype
	lda	#$07				; Only get up to seven fonts
	sta	r7H
	lda	#$00
	sta	r10H
	lda	#$00
	sta	r10L				; no permanent name string used
	jsr	toggleZP
	jsr	FindFTypes
	jsr	toggleZP
	jsr	L2AD6				; expands the font list
	lda	#$08
	sec
	sbc	r7H
	sta	$A7				; variable carries # of fonts
	sta	$0214				; ditto here
	cmp	#$01				; do we have one font (BSW) here?
	beq	@1
	lda	#$01
@2:	pha
	jsr	L23F6				; multiplies # of font entries?
	pla
	pha
	jsr	L2A39				; seems to extract font information
	pla
	clc
	adc	#$01
	cmp	$A7
	bne	@2
	jsr	L2920				; no idea yet.
@1:	lda	#$00
	sta	$AC
	sta	$AA
	sta	$AB
	jsr	L2274				; calls UseSystemFont
	rts

l291a:
.byte $20,$20,$42,$53,$57,$00

L2920:
	lda	$A7
	sec
	sbc	#$02
	sta	r7H
@1:	jsr	L2931
	dec	r7H
	lda	r7H
	bpl	@1
	rts

L2931:
	asl	a
	asl	a
	asl	a
	asl	a
	pha
	tay
	ldx	#$10
	lda	#$00
@1:	ora	$6B5A,y
	iny
	dex
	bne	@1
	tax
	bne	@2
	pla
	jsr	L294F
	dec	$0214
	rts
@2:	pla
	rts

L294F:
	sta	r7L
	lda	#$6B
	sta	r1H
	lda	#$5A
	sta	r1L
	ldx	#$04
	lda	r7L
	jsr	L186F
	lda	r1L
	clc
	adc	#$10
	sta	r0L
	lda	r1H
	adc	#$00
	sta	r0H
	lda	#$6B
	sta	r2H
	lda	#$5A
	sta	r2L
	ldx	#$06
	lda	#$70
	jsr	L186F
	lda	r2L
	sec
	sbc	r0L
	sta	r2L
	lda	r2H
	sbc	r0H
	sta	r2H
	ldx	#$00
@1:	lda	r0L,x
	pha
	inx
	cpx	#$06
	bne	@1
	jsr	MoveData
	ldx	#$05
@2:	pla
	sta	r0L,x
	dex
	bpl	@2
	clc
	lda	#$70
	adc	r0L
	sta	r0L
	bcc	@3
	inc	r0H
@3:	clc
	lda	#$70
	adc	r1L
	sta	r1L
	bcc	@4
	inc	r1H
@4:	ldx	#$00
@5:	lda	r0L,x
	pha
	inx
	cpx	#$06
	bne	@5
	jsr	MoveData
	ldx	#$05
@6:	pla
	sta	r0L,x
	dex
	bpl	@6
	clc
	lda	#$70
	adc	r0L
	sta	r0L
	bcc	@7
	inc	r0H
@7:	clc
	lda	#$70
	adc	r1L
	sta	r1L
	bcc	@8
	inc	r1H
@8:	jsr	MoveData
	lda	r7H
	pha
	sta	r3L
	lda	#$00
	sta	r3H
	lda	#$13
	sta	r0L
	ldy	#$02
	ldx	#$08
	jsr	BMult
	pla
	sta	r7H
	lda	#$6A
	sta	r1H
	lda	#$D5
	sta	r1L
	lda	r3L
	clc
	adc	r1L
	sta	r1L
	bcc	@9
	inc	r1H
@9:	lda	r1L
	clc
	adc	#$13
	sta	r0L
	lda	r1H
	adc	#$00
	sta	r0H
	lda	#$6A
	sta	r2H
	lda	#$D5
	sta	r2L
	ldx	#$06
	lda	#$85
	jsr	L186F
	lda	r2L
	sec
	sbc	r0L
	sta	r2L
	lda	r2H
	sbc	r0H
	sta	r2H
	jsr	MoveData
	rts

L2A39:					; extracts font data
	pha
	lda	r0H
	sta	r6H
	lda	r0L
	sta	r6L
	jsr	L142B
	lda	#$84
	sta	r9H
	lda	#$00
	sta	r9L
	jsr	toggleZP
	jsr	GetFHdrInfo
	jsr	toggleZP
	lda	dirEntryBuf+2
	sta	r1H
	lda	dirEntryBuf+1
	sta	r1L
	lda	#$80
	sta	r4H
	lda	#$00
	sta	r4L
	jsr	L1434
	pla
	asl	a
	asl	a
	asl	a
	asl	a
	tay
	ldx	#$00
@1:	jsr	L2A82
	jsr	L2AAC
	iny
	iny
	inx
	inx
	cpx	#$10
	bne	@1
	rts

L2A82:
	lda	fileHeader+130,x
	sta	$6B4A,y
	and	#$3F
	sta	r6L
	lda	fileHeader+131,x
	sta	$6B4B,y
	ora	$6B4A,y
	beq	@1
	txa
	pha
	lda	r6L
	asl	a
	tax
	lda	diskBlkBuf+2,x
	sta	$6BBA,y
	lda	diskBlkBuf+3,x
	sta	$6BBB,y
	pla
	tax
@1:	rts

L2AAC:
	lda	fileHeader+97,x
	sta	$6C2A,y
	sta	r2L
	lda	fileHeader+98,x
	sta	$6C2B,y
	sta	r2H
	lda	r2H
	cmp	#$10
	bne	@1
	lda	r2L
	cmp	#$00
@1:	bcc	@2
	beq	@2
	lda	#$00
	sta	$6BBA,y
	sta	$6B4A,y
	sta	$6B4B,y
@2:	rts

L2AD6:					; expands the font list to make room for the asterisk
	lda	#$6B
	sta	r1H
	lda	#$3B
	sta	r1L
	lda	#$6B
	sta	r2H
	lda	#$47
	sta	r2L
	lda	#$07
	sta	r3L
@1:	ldy	#$10
@2:	lda	(r1L),y
	iny
	iny
	sta	(r2L),y
	dey
	dey
	dey
	bpl	@2
	iny
	lda	#$20
	sta	(r2L),y
	iny
	sta	(r2L),y
	sec
	lda	r1L
	sbc	#$11
	sta	r1L
	lda	r1H
	sbc	#$00
	sta	r1H
	sec
	lda	r2L
	sbc	#$13
	sta	r2L
	lda	r2H
	sbc	#$00
	sta	r2H
	dec	r3L
	bne	@1
	rts

l2b1e:
.byte $18

.byte "Please reboot your system"
.byte $16,$50,$00,$40

.byte "using the same GEOS disk"
.byte $16,$50,$00,$50

.byte "that was first used to run"
.byte $16,$50,$00,$60

.byte "geoPublish."
.byte $00

l2b82:
.byte $18

.byte "Cannot install geoPublish on"
.byte $16,$50,$00,$40

.byte "this disk.  Please refer to"
.byte $16,$50,$00,$50

.byte "installation directions in"
.byte $16,$50,$00,$60

.byte "the manual."
.byte $00

l2bec:
.byte $18

.byte "Cannot install geoPublish on a"
.byte $16,$50,$00,$40

.byte "write protected disk."
.byte $00

l2c25:
.byte $18

.byte "Error installing geoPublish"
.byte $00

l2c42:
.byte $18

.byte "geoPublish installed."
.byte $00

l2c59:
.asciiz "Layout lib"

l2c64:
.asciiz "Master lib"

L2C6F:					; patches GEOS 64 code
	lda	$C00F
	cmp	#$13				; is it geos v1.3?
	bcc	@2
	bne	@1
	lda	$C013				; C128 Flag - is it running in GEOS 128?
	bpl	@2
@1:	rts					; will return here in GEOS v2.0 and Wheels OS systems
@2:	sec
	lda	$C203				; make an exception for geos 64 v1.3?
	sbc	#$41				; patch SmallPutChar?
	sta	r8L
	lda	$C204
	sbc	#$00
	sta	r8H
	ldy	#$00
	lda	(r8L),y
	sta	r9L
	iny
	lda	(r8L),y
	sta	r9H
	ldy	#$00
	lda	(r9L),y
	cmp	#$EA				; is there a NOP at the suspect code?
	beq	@3
	sec
	lda	r9L
	sbc	#$34
	sta	r9L
	lda	r9H
	sbc	#$03
	sta	r9H
	lda	r9L
	clc
	adc	#$AE
	sta	r10L
	lda	r9H
	adc	#$03
	sta	r10H
	jsr	L2CEC				; modifies code in this VLIR module & elsewhere
	ldy	#$00
	lda	r10L
	sta	(r8L),y
	iny
	lda	r10H
	sta	(r8L),y
	ldy	#$45
	lda	r10L
	sta	(r8L),y
	iny
	lda	r10H
	sta	(r8L),y			; patches GEOS Kernal somewhat
	clc
	lda	#$00
	adc	r8L
	sta	r8L
	lda	#$01
	adc	r8H
	sta	r8H
	ldy	#$00
	lda	r10L
	sta	(r8L),y
	iny
	lda	r10H
	sta	(r8L),y			; patches GEOS Kernal somewhat
@3:  rts

L2CEC:					; no idea what it does - modifies code in this module
	sec
	lda	r9L
	sbc	#$BB
	sta	r1L
	lda	r9H
	sbc	#$2E
	sta	r1H
	ldx	#$38
@1:	lda	L2DA7,x
	sta	r0L
	lda	L2DE0,x
	sta	r0H
	ldy	#$00
	lda	(r0L),y
	clc
	adc	r1L
	sta	(r0L),y
	iny
	lda	(r0L),y
	adc	r1H
	sta	(r0L),y
	dex
	bpl	@1
	lda	L2FC6
	clc
	adc	r1L
	sta	L2FC6
	lda	L2FCA
	adc	r1H
	sta	L2FCA
	lda	L2FC6+1
	clc
	adc	r1L
	sta	L2FC6+1
	lda	L2FCB
	adc	r1H
	sta	L2FCB
	lda	L2FC8
	clc
	adc	r1L
	sta	L2FC8
	lda	L2FCC
	adc	r1H
	sta	L2FCC
	lda	L2FC8+1
	clc
	adc	r1L
	sta	L2FC8+1
	lda	L2FCD
	adc	r1H
	sta	L2FCD
	lda	l3098+1
	clc
	adc	r1L
	sta	l3098+1
	lda	l309d+1
	adc	r1H
	sta	l309d+1
	lda	L30A5-1
	clc
	adc	r1L
	sta	L30A5-1
	lda	L30A1+1
	adc	r1H
	sta	L30A1+1
	lda	#$2E
	sta	r0H
	lda	#$BB
	sta	r0L
	lda	r9H
	sta	r1H
	lda	r9L
	sta	r1L
	lda	#$05
	sta	r2H
	lda	#$47
	sta	r2L
	lda	$88C4
	pha
	lda	#$00
	sta	$88C4
	jsr	MoveData
	pla
	sta	$88C4
	rts

L2DA7:
.byte   $FB,$00,$1E,$2D,$72,$79,$81,$88
.byte   $9B,$D4,$D7,$0B,$2D,$30,$3B,$58
.byte   $6D,$95,$EE,$F3,$F7,$03,$08,$0F
.byte   $23,$32,$5A,$74,$94,$AF,$B2,$B8
.byte   $BB,$BE,$CE,$D1,$D4,$F0,$F5,$08
.byte   $13,$1B,$33,$4A,$70,$7C,$82,$89
.byte   $8F,$A1,$D2,$F8,$02,$28,$38,$40
.byte   $12

L2DE0:
.byte   $2E,$2F,$2F,$2F,$2F,$2F,$2F,$2F
.byte   $2F,$2F,$2F,$30,$30,$30,$30,$30
.byte   $30,$30,$30,$30,$30,$31,$31,$31
.byte   $31,$31,$31,$31,$31,$31,$31,$31
.byte   $31,$31,$31,$31,$31,$31,$31,$32
.byte   $32,$32,$32,$32,$32,$32,$32,$32
.byte   $32,$32,$32,$32,$33,$33,$33,$33
.byte   $30

L2E19:					; patch GEOS 128 routine
	lda	$C00F				; check GEOS version
	cmp	#$13				; is it GEOS v1.3?
	bne	@1
	lda	$C013				; check C128Flag
	bpl	@1
	lda	$C014				; no idea yet what's there.
	beq	@2
@1:	rts					; will return here on GEOS v2.0 and Wheels OS systems.
@2:  php					; only for GEOS 128 v1.3
	sei
	lda	$FF00
	pha
	ora	#$01
	sta	$FF00
	lda	#$8A
	sta	$D1CB
	lda	#$D1
	sta	$D1CC
	pla
	sta	$FF00
	lda	#$2E
	sta	r0H
	lda	#$AF
	sta	r0L
	lda	#$E3
	sta	r1H
	lda	#$3D
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$04
	sta	r2L
	lda	#$01
	sta	r3L
L2E60:	lda	#$00
	sta	r3H
	jsr	LC2E3
	lda	#$2E
	sta	r0H
	lda	#$B3
	sta	r0L
	lda	#$FB
	sta	r1H
	lda	#$F9
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$07
	sta	r2L
	lda	#$01
	sta	r3L
	lda	#$00
	sta	r3H
	jsr	LC2E3
	lda	#$2E
	sta	r0H
	lda	#$BA
	sta	r0L
	lda	#$E3
	sta	r1H
	lda	#$52
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$01
	sta	r2L
	lda	#$01
	sta	r3L
	lda	#$00
	sta	r3H
	jsr	LC2E3
	plp
	rts

        jsr     LFBF9
        nop
        lsr     r7L
        ror     a
        lsr     r7L
        ror     a
        rts
        bpl     L2E60
        ora     $C8
        sty     $87FE
        sta     r5L
        ldx     #$00
        clc
        adc     #$20
        jsr     GetRealSize
        tya
        pha
        lda     r5L
        asl     a
        tay
        lda     ($2A),y
        sta     r2L
        and     #$07
        sta     $87FD
        lda     r2L
        and     #$F8
        sta     r3L
        iny
        lda     ($2A),y
        sta     r2H
        pla
        clc
        adc     r2L
        sta     r6H
        clc
        sbc     r3L
        lsr     a
        lsr     a
        lsr     a
        sta     r3H
        tax
        cpx     #$03
        bcc     L2EFA
        ldx     #$03
L2EFA:  lda     L2FC6,x
        sta     r13L
        lda     L2FCA,x
        sta     r13H
        lda     r2L
        lsr     r2H
        ror     a
        lsr     r2H
        ror     a
        lsr     r2H
        ror     a
        clc
        adc     $2C
        sta     r2L
        lda     r2H
        adc     $2D
        sta     r2H
        ldy     $87FD
        lda     L33F7,y
        eor     #$FF
        sta     $87FC
        ldy     r6H
        dey
        tya
        and     #$07
        tay
        lda     L33F0,y
        eor     #$FF
        sta     r7H
        lda     currentMode
        tax
        and     #$08
        beq     L2F3C
        lda     #$80
L2F3C:  sta     r8H
        lda     r5L
        clc
        adc     #$20
        jsr     GetRealSize
        sta     r5H
        lda     r1H
        sec
        sbc     r5H
        sta     r1H
        stx     r10H
        tya
        pha
        lda     r11H
        bmi     L2F63
        lda     rightMargin+1
        cmp     r11H
        bne     L2F61
        lda     rightMargin
        cmp     r11L
L2F61:  bcc     L2FAA
L2F63:  lda     currentMode
        and     #$10
        bne     L2F6A
        tax
L2F6A:  txa
        lsr     a
        sta     r3L
        clc
        adc     r11L
        sta     L3400
        lda     r11H
        adc     #$00
        sta     L3401
        pla
        sta     $8807
        clc
        adc     L3400
        sta     r11L
        lda     #$00
        adc     L3401
        sta     r11H
        bmi     L2FB9
        lda     leftMargin+1
        cmp     r11H
        bne     L2F98
        lda     leftMargin
        cmp     r11L
L2F98:  bcs     L2FB9
        jsr     L2FCE
        ldx     #$00
        lda     currentMode
        and     #$20
        beq     L2FA6
        dex
L2FA6:  stx     r10L
        clc
        rts
L2FAA:  pla
        sta     $8807
        clc
        adc     r11L
        sta     r11L
        bcc     L2FC4
        inc     r11H
        sec
        rts
L2FB9:  lda     r11L
        sec
        sbc     r3L
        sta     r11L
        bcs     L2FC4
        dec     r11H
L2FC4:  sec
        rts
L2FC6:
.byte $84,$92
L2FC8:
.byte $a9,$c3
L2FCA:  .byte   $33
L2FCB:  .byte   $33
L2FCC:  .byte   $33
L2FCD:  .byte   $33
L2FCE:  ldx     r1H
        jsr     GetScanLine
        lda     L3400
        ldx     L3401
        bmi     L2FE3
        cpx     leftMargin+1
        bne     L2FE1
        cmp     leftMargin
L2FE1:  bcs     L2FE7
L2FE3:  ldx     leftMargin+1
        lda     leftMargin
L2FE7:  pha
        and     #$F8
        sta     r4L
        cpx     #$00
        bne     L2FF4
        cmp     #$C0
        bcc     L3008
L2FF4:  sec
        sbc     #$80
        pha
        lda     r5L
        clc
        adc     #$80
        sta     r5L
        sta     r6L
        bcc     L3007
        inc     r5H
        inc     r6H
L3007:  pla
L3008:  sta     r1L
        lda     L3401
        sta     r3L
        lsr     r3L
        lda     L3400
        ror     a
        lsr     r3L
        ror     a
        lsr     r3L
        ror     a
        sta     r7L
        lda     leftMargin+1
        lsr     a
        lda     leftMargin
        ror     a
        lsr     a
        lsr     a
        sec
        sbc     r7L
        bpl     L302C
        lda     #$00
L302C:  sta     L33FF
        lda     L3400
        and     #$07
        sta     r7L
        pla
        and     #$07
        tay
        lda     L33F7,y
        sta     r3L
        eor     #$FF
        sta     r9L
        ldy     r11L
        dey
        ldx     rightMargin+1
        lda     rightMargin
        cpx     r11H
        bne     L3050
        cmp     r11L
L3050:  bcs     L3053
        tay
L3053:  tya
        and     #$07
        tax
        lda     L33F0,x
        sta     r4H
        eor     #$FF
        sta     r9H
        tya
        sec
        sbc     r4L
        bpl     L3068
        lda     #$00
L3068:  lsr     a
        lsr     a
        lsr     a
        clc
        adc     L33FF
        sta     r8L
        cmp     r3H
        bcs     L3077
        lda     r3H
L3077:  cmp     #$03
        bcs     L30A1
        cmp     #$02
        bne     L3081
        lda     #$01
L3081:  asl     a
        asl     a
        asl     a
        asl     a
        sta     r12L
        lda     r7L
        sec
        sbc     $87FD
        clc
        adc     #$08
        clc
        adc     r12L
        tax
        lda     L30AB,x
        clc
l3098:
        adc     #$CA
        tay
        lda     #$00
l309d:
        adc     #$32
        bne     L30A5
L30A1:  lda     #$33
        ldy     #$2A
L30A5:  sta     r12H
        sty     r12L
L30A9:  clc
        rts
L30AB:  .byte   $B4,$30,$31,$32,$33,$34,$35,$36
        .byte   $07,$06,$05,$04,$03,$02,$01,$00
        .byte   $B4,$3A,$3F,$44,$49,$4E,$53,$58
        .byte   $2D,$28,$23,$1E,$19,$14,$0F,$0A
L30CB:  lda     currentMode
        bpl     L30E2
        ldy     r1H
        cpy     $87FE
        beq     L30DC
        dey
        cpy     $87FE
        bne     L30E2
L30DC:  lda     r10L
        eor     #$FF
        sta     r10L
L30E2:  lda     currentMode
        and     #$10
        beq     L30A9
        lda     r10H
        lsr     a
        bcs     L3105
        ldx     L3400
        bne     L30F5
        dec     L3401
L30F5:  dex
        stx     L3400
        ldx     r11L
        bne     L30FF
        dec     r11H
L30FF:  dex
        stx     r11L
        jsr     L2FCE
L3105:  lda     rightMargin+1
        cmp     L3401
        bne     L3111
        lda     rightMargin
        cmp     L3400
L3111:  bcc     L311E
        lda     leftMargin+1
        cmp     r11H
        bne     L311D
        lda     leftMargin
        cmp     r11L
L311D:  rts
L311E:  sec
        rts
L3120:  ldy     r1L
        ldx     L33FF
        lda     $45,x
        cpx     r8L
        beq     L3167
        bcs     L3182
        eor     r10L
        and     r9L
        sta     l3139
        lda     r3L
        and     (r6L),y
.byte $09					; ORA instruction
l3139:
.byte $00
        sta     (r6L),y
        sta     (r5L),y
L313E:  tya
        clc
        adc     #$08
        tay
        inx
        cpx     r8L
        beq     L3153
        lda     $45,x
        eor     r10L
        sta     (r6L),y
        sta     (r5L),y
        clv
        bvc     L313E
L3153:  lda     $45,x
        eor     r10L
        and     r9H
        sta     l3161
        lda     r4H
        and     (r6L),y
.byte $09					; ORA instruction
l3161:
.byte $00
        sta     (r6L),y
        sta     (r5L),y
        rts
L3167:  eor     r10L
        and     r9H
        eor     #$FF
        ora     r3L
        ora     r4H
        eor     #$FF
        sta     l317d
        lda     r3L
        ora     r4H
        and     (r6L),y
.byte $09					; ORA instruction
l317d:
.byte $00
        sta     (r6L),y
        sta     (r5L),y
L3182:  rts
L3183:  ldx     r8L
        lda     #$00
L3187:  sta     $87FF,x
        dex
        bpl     L3187
        lda     r8H
        and     #$7F
        bne     L31A3
L3193:  jsr     L3207
L3196:  ldx     r8L
L3198:  lda     $87FF,x
        sta     $45,x
        dex
        bpl     L3198
        inc     r8H
        rts
L31A3:  cmp     #$01
        beq     L31B7
        ldy     r10H
        dey
        beq     L3193
        dey
        php
        jsr     L3207
        jsr     L31D9
        plp
        beq     L31CD
L31B7:  jsr     L31D9
        jsr     L337F
        jsr     L3207
        lda     r2L
        sec
        sbc     $27
        sta     r2L
        lda     r2H
        sbc     $28
        sta     r2H
L31CD:  jsr     L337F
        jsr     L3207
        jsr     L31E7
        clv
        bvc     L3196
L31D9:  lda     $27
        clc
        adc     r2L
        sta     r2L
        lda     $28
        adc     r2H
        sta     r2H
        rts
L31E7:  ldy     #$FF
L31E9:  iny
        ldx     #$07
L31EC:  lda     $45,y
        and     L33E8,x
        beq     L31FF
        lda     L33E8,x
        eor     #$FF
        and     $87FF,y
        sta     $87FF,y
L31FF:  dex
        bpl     L31EC
        cpy     r8L
        bne     L31E9
        rts
L3207:  jsr     L3258
        ldy     #$FF
L320C:  iny
        ldx     #$07
L320F:  lda     $45,y
        and     L33E8,x
        beq     L3250
        lda     $87FF,y
        ora     L33E8,x
        sta     $87FF,y
        inx
        cpx     #$08
        bne     L322F
        lda     $87FE,y
        ora     #$01
        sta     $87FE,y
        bne     L3238
L322F:  lda     $87FF,y
        ora     L33E8,x
        sta     $87FF,y
L3238:  dex
        dex
        bpl     L3246
        lda     $8800,y
        ora     #$80
        sta     $8800,y
        bne     L324F
L3246:  lda     $87FF,y
        ora     L33E8,x
        sta     $87FF,y
L324F:  inx
L3250:  dex
        bpl     L320F
        cpy     r8L
        bne     L320C
        rts
L3258:  lsr     $45
        ror     $46
        ror     $47
        ror     $48
        ror     $49
        ror     $4A
        ror     $4B
        ror     $4C
        rts
        nop
        tay
        lda     r1H
        pha
        tya
        jsr     L2EBB
        bcs     L32C6
L3274:  clc
        lda     currentMode
        and     #$90
        beq     L327E
        jsr     L30CB
L327E:  php
        bcs     L3284
        jsr     L337F
L3284:  bit     r8H
        bpl     L328E
        jsr     L3183
        clv
        bvc     L3291
L328E:  jsr     L31D9
L3291:  plp
        bcs     L32A3
        lda     r1H
        cmp     windowTop
        bcc     L32A3
        cmp     windowBottom
        bcc     L32A0
        bne     L32A3
L32A0:  jsr     L3120
L32A3:  inc     r5L
        inc     r6L
        lda     r5L
        and     #$07
        bne     L32C0
        inc     r5H
        inc     r6H
        lda     r5L
        clc
        adc     #$38
        sta     r5L
        sta     r6L
        bcc     L32C0
        inc     r5H
        inc     r6H
L32C0:  inc     r1H
        dec     r10H
        bne     L3274
L32C6:  pla
        sta     r1H
        rts
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        jmp     L335E
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        lsr     a
        ror     $46
        ror     $47
        jmp     L335E
        asl     a
        asl     a
        asl     a
        asl     a
        asl     a
        asl     a
        asl     a
        jmp     L335E
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        asl     $47
        rol     $46
        rol     a
        jmp     L335E
        sta     $45
        lda     r7L
        sec
        sbc     $87FD
        beq     L333D
        bcc     L3342
        tay
L3337:  jsr     L3258
        dey
        bne     L3337
L333D:  lda     $45
        jmp     L335E
L3342:  lda     $87FD
        sec
        sbc     r7L
        tay
L3349:  asl     $4C
        rol     $4B
        rol     $4A
        rol     $49
        rol     $48
        rol     $47
        rol     $46
        rol     $45
        dey
        bne     L3349
        lda     $45
L335E:  sta     $45
        bit     currentMode
        bvc     L337E
        lda     #$00
        pha
        ldy     #$FF
L3369:  iny
        ldx     $45,y
        pla
        ora     $D110,x
        sta     $45,y
        txa
        lsr     a
        lda     #$00
        ror     a
        pha
        cpy     r8L
        bne     L3369
        pla
L337E:  rts
L337F:  ldy     #$00
        jmp     (r13L)
        sty     $46
        sty     $47
        lda     (r2L),y
        and     $87FC
        and     r7H
        jmp     (r12L)
        sty     $47
        sty     $48
        lda     (r2L),y
        and     $87FC
        sta     $45
        iny
        lda     (r2L),y
        and     r7H
        sta     $46
L33A4:  lda     $45
        jmp     (r12L)
        sty     $48
        sty     $49
        lda     (r2L),y
        and     $87FC
        sta     $45
        iny
        lda     (r2L),y
        sta     $46
        iny
        lda     (r2L),y
        and     r7H
        sta     $47
        clv
        bvc     L33A4
        lda     (r2L),y
        and     $87FC
        sta     $45
L33CA:  iny
        cpy     r3H
        beq     L33D7
        lda     (r2L),y
        sta     $45,y
        clv
        bvc     L33CA
L33D7:  lda     (r2L),y
        and     r7H
        sta     $45,y
        lda     #$00
        sta     $46,y
        sta     $47,y
        beq     L33A4
L33E8:  .byte   $01,$02,$04,$08,$10,$20,$40,$80
L33F0:  .byte   $7F,$3F,$1F,$0F,$07,$03,$01
L33F7:  .byte   $00,$80,$C0,$E0,$F0,$F8,$FC,$FE
L33FF:  .byte   $00
L3400:  .byte   $00
L3401:  .byte   $00
