; da65 V2.10.0 - (C) Copyright 2000-2003 Ullrich von Bassewitz
; Input file: gpb01v10.bin
; VLIR $10 Source Code for geoPublish
.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"

.org $4880
.setcpu "6502"

L12F0           = $12F0
L1790           = $1790
OAttrImage	=	$1a61			; opens the image attributes DB
L1C2F           = $1C2F
L3183           = $3183
L346F           = $346F
L39DF           = $39DF
L3A05           = $3A05
L3E2A           = $3E2A
L4554           = $4554
L46CD           = $46CD
l6ac0		=	$6ac0
l6ac1		=	$6ac1			; currently active icon # from the toolbox
l6d59		=	$6d59
l6d5b		=	$6d5b
l6d5d		=	$6d5d
l6d5f		=	$6d5f
l6d87		=	$6d87
l6dcc		=	$6dcc
l6dce		=	$6dce
l6dcf		=	$6dcf
l6dd0		=	$6dd0
l6f05		=	$6f05
l7129		=	$7129			; holds the GEOS pattern
l712b		=	$712b			; holds the attribute byte
l712d		=	$712d
l7131		=	$7131
l7132		=	$7132

; jump table
	jmp	L4883

L4883:					; pass .A the object number
	pha					; r2 points to address of graphics object
	lda	l6d87				; location r3H has a $00 for a rectangle object
	beq	@1				; otherwise a non-zero value for a JPEG proxy
	jsr	L48FA
	jsr	L346F
@1:	pla
	tax
	cpx	#$08				; is it a Photo Scrap?
	bne	@2
	jmp	L4E8B				; handle Photo Scraps differently.
@2:	lda	l6ac0
	pha
	lda	#$FF
	sta	l6ac0
	lda	l712b
	sta	$E9				; Attribute byte
	lda	l7129
	sta	$E8				; GEOS Pattern
	lda	l6d87
	beq	@3
	jsr	L39DF
@3:	lda	#$01
	sta	L4E4E				; required frame/line width
;	lda	#>tLineWidth
;	sta	L49C7+1
;	lda	#<tLineWidth		; not needed in new version of geoPublish?
;	sta	L49C7
	cpx	#$04				; is it a Rectangle?
	beq	@4
	cpx	#$02				; is it a Circle?
	bne	@6
@4:	dec	L4E4E				; = $00 meaning no minimum required frame/line width
;	lda	#$00
;	sta	L4E4E
	lda	l712b+1
	sta	$E9				; Attribute byte
	lda	l7129+1
	sta	$E8				; GEOS Pattern
	lda	l6d87				; Don't know, but has an $ff when an object
	beq	@6				; @5- is selected.
						; checks for JPEG proxies
	jsr	L39DF				; loads r2 & r3 registers pointing to image data
;	cpx	#$04				; is it a rectangle?
;	beq	@8				; @5- branch if it isn't.
;	cpx	#$02				; is it a circle?
;	bne	@6				; branch if it isn't.
;@8:
	lda	r3H				; check to see if there is a JPEG proxy
	beq	@6				; @5- branch if it is just a regular rectangle/circle
	ldy	#<tImageMode
	lda	#>tImageMode		; otherwise, load it for Image Mode.
	sta	drawHdr+1
	sty	drawHdr			; modify the DB accordingly

;@5:	lda	#>tFrameWidth
;	sta	L49C7+1
;	lda	#<tFrameWidth
;	sta	L49C7				; not needed in new version of geoPublish
@6:	lda	l6ac1				; is the SELECT icon currently active?
	beq	@9				; branch if it is active
	lda	#$00				; otherwise, turn off the EDIT icon
	sta	editHdr
@9:	jsr	L4554
	lda	#<dbAttribute
	ldx	#>dbAttribute
	jsr	L1790
	pla
	sta	l6ac0
	lda	r0L				; did the user click on the EDIT icon?
	bpl	@7
	jmp	OAttrImage			; open up the Image Attributes DB
@7:	rts

L48FA:					; Seems to clear the graphics object's area onscreen
	jsr	L346F
	jsr	L3E2A
	jsr	L12F0
	lda	l6d59+1
	sta	r0H
	lda	l6d59
	sta	r0L
	lda	l6d5b+1
	sta	r1H
	lda	l6d5b
	sta	r1L
	jsr	L1C2F
	lda	r0H
	sta	r3H
	lda	r0L
	sta	r3L
	lda	r1L
	sta	r2L
	lda	l6d5d+1
	sta	r0H
	lda	l6d5d
	sta	r0L
	lda	l6d5f+1
	sta	r1H
	lda	l6d5f
	sta	r1L
	jsr	L1C2F
	lda	r0H
	sta	r4H
	lda	r0L
	sta	r4L
	lda	r1L
	sta	r2H
	jmp	Rectangle			; and clears it up.

sAttribute:					; service routine for the attribute dialog box
	lda	#>srAttribute
;	sta	appMain+1
	ldy	#<srAttribute
	jmp	lAppMain
;	sta	appMain
;	rts

srAttribute:				; appMain calls this routine after the attribute
	jsr	zAppMain
;	ldy	#$00				; dialog box is drawn onscreen.
;	sty	appMain
;	sty	appMain+1
	sta	iconSelFlag
	jsr	L496C
	jsr	L4B6D
	jmp	L4C2D
;	rts

L496C:
	ldx	l6dcc
	ldy	#$00
	jsr	L497D
	ldx	l6dce
	ldy	#$02
;	jsr	L497D
;	rts

L497D:
	lda	L49B5,y
	sta	r3L
	clc
	adc	#$05
	sta	r4L
	lda	#$00
	sta	r3H
	sta	r4H
	iny
	lda	L49B5,y
	sta	r2L
	clc
	adc	#$05
	sta	r2H
	txa
	pha
	eor	#$01
	jsr	L49AE
	lda	r3L
	clc
	adc	#$08
	sta	r3L
	lda	r4L
	clc
	adc	#$08
	sta	r4L
	pla

L49AE:
	jsr	SetPattern
	jmp	Rectangle
;	rts

L49B5:
.byte $B9,$35,$B9,$4D

dbAttribute:				; object attribute dialog box table
.byte $81					; DEFAULT DB
.byte $0B					; DBTXTSTR
.byte $1F,$0C				; xpos/ypos
.word tDBTitle				; text pointer
.byte $0B					; DBTXTSTR
.byte $0E,$1A				; xpos/ypos
.word tBrushShape				; text pointer
.byte $0B					; DBTXTSTR
.byte $0E,$32				; xpos/ypos
drawHdr:					; placeholder
.word tDrawMode				; text pointer
.byte $0B					; DBTXTSTR
.byte $0E,$26				; xpos/ypos
;L49C7:
.word tFrameWidth				; text pointer (line width)
.byte $0B					; DBTXTSTR
.byte $0E,$40				; xpos/ypos
.word tPattern				; text pointer
.byte $12					; DBUSRICON
.byte $0F,$14				; xpos/ypos
.word itBrushShape			; pointer to icon table
.byte $12					; DBUSRICON
.byte $0F,$2C				; xpos/ypos
.word itDrawMode				; pointer to icon table
.byte $12					; DBUSRICON
.byte $0D,$20				; xpos/ypos
.word itFrameUp				; pointer to icon table
.byte $12					; DBUSRICON
.byte $0B,$20				; xpos/ypos
.word itFrameDown				; pointer to icon table
.byte $12					; DBUSRICON
.byte $07,$38				; xpos/ypos
.word itUpArrow				; pointer to icon table
.byte $12					; DBUSRICON
.byte $0D,$38				; xpos/ypos
.word itDownArrow				; pointer to icon table
.byte $13					; DB_USR_ROUT
.word sAttribute				; pointer to service routine
.byte $01					; OK icon
.byte $01,$4C				; xpos/ypos
editHdr:					; placeholder
.byte $12					; DBUSRICON
.byte $08,$4c				; xpos/ypos
.word itEdit				; pointer to icon table
.byte $00					; NULL delimiter

tDBTitle:
.byte $18,$0E

.byte "Graphics Object Attributes"
.byte $1B,$00

tFrameWidth:
.byte $18					; BOLD attribute
.asciiz "Frame Width:"

;tLineWidth:
;.byte $18
;.asciiz "Line Width:"

tBrushShape:
.byte $18

.byte "Brush Shape:"
.byte $1B

.byte $14,$9A,$00				; GOTOX

.byte "Round"

.byte $14,$CC,$00				; GOTOX
.asciiz "Square"

tDrawMode:
.byte $18

.byte "Draw Mode:"
.byte $1B

.byte $14,$96,$00				; GOTOX

.byte "Opaque"

.byte $14,$CA,$00				; GOTOX
.asciiz "Transparent"

;tPattern:					; this is duplicated elsewhere
;.byte $18					; BOLD

;.byte "Pattern:"
;.byte $1B,$00				; plaintext, NULL

itBrushShape:				; icon table for brush shape box
.word iToggleBox				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$08				; width/height
.word sBrush				; pointer to service routine

itDrawMode:					; icon table for the opaque/transparent box
.word iToggleBox				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$08				; width/height
.word sDraw					; pointer to service routine

itUpArrow:					; icon table for up arrow for Pattern
.word iUpArrow				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$0C				; width/height
.word sUpArrow				; pointer to service routine

itDownArrow:				; icon table for down arrow for Pattern
.word iDownArrow				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$0C				; width/height
.word sDownArrow				; pointer to service routine

itFrameUp:					; icon table for up arrow for Frame width
.word iFrameUp				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$08				; width/height
.word sFrameUp				; pointer to service routine

itFrameDown:				; icon table for down arrow for Frame width
.word iFrameDown				; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $02,$08				; width/height
.word sFrameDown				; pointer to service routine

itEdit:					; icon table for [EDIT] icon
.word iEdit					; pointer to icon data
.byte $00,$00				; x/y offsets (not used)
.byte $06,$10				; width/height
.word sEdit					; pointer to service routine

iToggleBox:					; icon data for the toggle box
.byte $02,$FF,$0C,$81,$02,$FF
iFrameUp:					; icon data for the up arrow in Frame Width
.byte $90,$FF,$FF,$80,$01,$81,$01,$87,$C1
.byte $9F,$F1,$BF,$F9,$80,$01,$FF,$FF
iFrameDown:					; icon data for the down arrow in Frame Width
.byte $90,$FF,$FF,$80,$01,$BF,$F9,$9F,$F1
.byte $87,$C1,$81,$01,$80,$01,$FF,$FF

sBrush:					; service routine for the Brush Shape parameter
	lda	l6dcc
	eor	#$01
	sta	l6dcc
	jsr	L496C
	jmp	L4BB1

sDraw:					; service routine for the Draw Mode parameter
	lda	l6dce
	eor	#$01
	sta	l6dce
	jsr	L4BC4
	jmp	L496C

UpDelay:					; delays the db routines in between mouse clicks
	inc	L4E57
	beq	sUpArrow
	rts

DownDelay:
	inc	L4E57
	beq	sDownArrow
	rts

sUpArrow:					; service routine for the Up Arrow for Pattern
	lda	mouseData			; check mouseData
	bpl	@1
	jmp	zAppMain
;	lda	#$00				; button hasn't been released - free up appMain
;	sta	appMain+1
;	sta	appMain
;	rts
@1:	lda	#>UpDelay
;	sta	appMain+1
	ldy	#<UpDelay			; load appMain w/ new value
	jsr	lAppMain
;	sta	appMain
	lda	#$01
	bne	sArrow			; relative JMP

sDownArrow:					; service routine for the Up Arrow for Pattern
	lda	mouseData
	bpl	@1
	jmp	zAppMain
;	lda	#$00
;	sta	appMain+1
;	sta	appMain
;	rts
@1:	lda	#>DownDelay
;	sta	appMain+1
	ldy	#<DownDelay
	jsr	lAppMain
;	sta	appMain
	lda	#$FF

sArrow:
	clc
	adc	l6dcf
	ldy	#$20
	ldx	#$FF
	stx	r0L
	sty	r0H
	cmp	r0L
	bne	@1
	tya
	sec
	sbc	#$01
@1:	cmp	r0H
	bne	@2
	lda	r0L
	clc
	adc	#$01
@2:	sta	l6dcf
	jsr	SetPattern
	jsr	L4BC4				; modifies the object structure for the new pattern
	lda	L4E4E
	bne	@3
	jsr	L4C80				; no idea yet
	jsr	L4C07				; no idea yet
	clv
	bvc	L4B6D
@3:	jsr	L4C2D

L4B6D:
	lda	l6dcf
	jsr	SetPattern
	ldy	#$0C
	jsr	L51C8
	ldy	#$0C
	jsr	L51FA
	lda	#$FF
	jmp	FrameRectangle
;	rts

sFrameUp:					; service routine for the up arrow in Frame Width
	inc	l6dd0
	lda	l6dd0
	and	#$07
	sta	l6dd0
	bne	L4BB1
	lda	L4E4E
	beq	L4BB1
	inc	l6dd0
	bne	L4BB1

sFrameDown:					; service routine for the down arrow in Frame Width
	dec	l6dd0
	lda	l6dd0
	and	#$07
	sta	l6dd0
	bne	L4BB1
	lda	L4E4E
	beq	L4BB1
	lda	#$07
	sta	l6dd0

L4BB1:
	jsr	L4BC4
	lda	l6dd0
	cmp	#$01
	bcc	@1
	beq	@1
	jsr	L46CD
@1:	jmp	L4C2D
;	rts

L4BC4:
	lda	l6dd0
	asl	a
	asl	a
	asl	a
	asl	a
	ldx	l6dcc
	beq	@1
	ora	#$80
@1:	ldx	l6dce
	beq	@2
	ora	#$08
@2:	sta	$E9
	tay
	lda	l6dcf
	sta	$E8
	ldx	L4E4E
	beq	@3
	sty	l712b
	sta	l7129
	clv
	bvc	@4
@3:	sty	l712b+1
	sta	l7129+1
@4:	ldx	l6d87
	beq	@5
	pha
	tya
	pha
	jsr	L346F
	pla
	tay
	pla
	jsr	L3A05
@5:	rts

L4C07:
	lda	l6dd0
	beq	@1
	clc
	adc	r2L
	sta	r2L
	lda	r2H
	sec
	sbc	l6dd0
	sta	r2H
	lda	r3L
	clc
	adc	l6dd0
	sta	r3L
	lda	r4L
	sec
	sbc	l6dd0
	sta	r4L
@1:	jmp	Rectangle
;	rts

L4C2D:
	lda	l6f05
	pha
	lda	#$01
	sta	l6f05
	jsr	L4C62
	jsr	L4554
	jsr	L4C80
	lda	L4E4E
	beq	@1
	jsr	L4DCC
	clv
	bvc	@2
@1:	jsr	L4C07
	lda	l6dd0
	beq	@2
	jsr	L4C80
	lda	#$01
	jsr	SetPattern
	jsr	L4CA3
@2:	pla
	sta	l6f05
	rts

L4C62:
	jsr	L12F0
	lda	#$58
	sta	r2L
	lda	#$7E
	sta	r2H
	lda	#$00
	sta	r3H
	lda	#$B6
	sta	r3L
	lda	#$00
	sta	r4H
	lda	#$FE
	sta	r4L
	jmp	Rectangle

L4C80:
	lda	#$60
	sta	r2L
	sta	r11L
	lda	#$76
	sta	r2H
	sta	r14L
	lda	#$00
	sta	r11H
	sta	r14H
	lda	#$00
	sta	r3H
	lda	#$BE
	sta	r3L
	lda	#$00
	sta	r4H
	lda	#$F6
	sta	r4L
	rts

L4CA3:
	lda	l6dd0
	cmp	#$01
	bne	@1
	lda	#$FF
	jmp	FrameRectangle
@1:	lda	r2L
	sta	L4D50
	lda	r2H
	sta	L4D52
	lda	#$00
	sta	L4D51
	sta	L4D53
	lda	r4H
	sta	L4D4F
	lda	r4L
	sta	L4D4E
	lda	r3L
	sta	L4D4C
	sta	r4L
	lda	r3H
	sta	L4D4D
	sta	r4H
	jsr	L4D90
	lda	L4D4E
	sta	r3L
	sta	r4L
	lda	L4D4F
	sta	r3H
	sta	r4H
	lda	L4D51
	sta	r11H
	lda	L4D50
	sta	r11L
	lda	L4D53
	sta	r14H
	lda	L4D52
	sta	r14L
	jsr	L4D90
	lda	L4D50
	sta	r11L
	sta	r14L
	lda	L4D51
	sta	r11H
	sta	r14H
	lda	L4D4D
	sta	r3H
	lda	L4D4C
	sta	r3L
	lda	L4D4F
	sta	r4H
	lda	L4D4E
	sta	r4L
	jsr	L4D54
	lda	L4D52
	sta	r11L
	sta	r14L
	lda	L4D53
	sta	r11H
	sta	r14H
	lda	L4D4D
	sta	r3H
	lda	L4D4C
	sta	r3L
	lda	L4D4F
	sta	r4H
	lda	L4D4E
	sta	r4L
;	jsr	L4D54
;	rts

L4D54:
	lda	r11H
	pha
	lda	r11L
	pha
	lda	r3H
	pha
	lda	r3L
	pha
	lda	r4H
	pha
	lda	r4L
	pha
	jsr	L3183
	pla
	sta	r4L
	pla
	sta	r4H
	pla
	sta	r3L
	pla
	sta	r3H
	pla
	sta	r11L
	pla
	sta	r11H
	inc	r3L
	bne	@1
	inc	r3H
@1:	lda	r3H
	cmp	r4H
	bne	@2
	lda	r3L
	cmp	r4L
@2:	bcc	L4D54
	beq	L4D54
	rts

L4D90:
	lda	r11H
	pha
	lda	r11L
	pha
	lda	r14H
	pha
	lda	r14L
	pha
	lda	r3H
	pha
	lda	r3L
	pha
	jsr	L3183
	pla
	sta	r3L
	pla
	sta	r3H
	pla
	sta	r14L
	pla
	sta	r14H
	pla
	sta	r11L
	pla
	sta	r11H
	inc	r11L
	bne	@1
	inc	r11H
@1:	lda	r11H
	cmp	r14H
	bne	@2
	lda	r11L
	cmp	r14L
@2:	bcc	L4D90
	beq	L4D90
	rts

L4DCC:
	lda	#$00
	sta	L4E4D
	lda	r11H
	pha
	lda	r11L
	pha
	lda	r14H
	sta	r11H
	lda	r14L
	sta	r11L
	pla
	sta	r14L
	pla
	sta	r14H
@1:	lda	r11H
	pha
	lda	r11L
	pha
	lda	r14H
	pha
	lda	r14L
	pha
	lda	r3H
	pha
	lda	r3L
	pha
	lda	r4H
	pha
	lda	r4L
	pha
	jsr	L3183
	pla
	sta	r4L
	pla
	sta	r4H
	pla
	sta	r3L
	pla
	sta	r3H
	pla
	sta	r14L
	pla
	sta	r14H
	pla
	sta	r11L
	pla
	sta	r11H
	inc	r3L
	bne	@2
	inc	r3H
@2:	inc	L4E4D
	lda	L4E4D
	and	#$01
	bne	@5
	lda	r11L
	bne	@3
	dec	r11H
@3:	dec	r11L
	lda	r14H
	cmp	r11H
	bne	@4
	lda	r14L
	cmp	r11L
@4:	beq	@5
	bcs	@6
@5:	lda	r3H
	cmp	r4H
	bne	@7
	lda	r3L
	cmp	r4L
@7:	bcc	@1
	beq	@1
@6:	rts

L4E59:
	ldy	#$0E
	lda	(r2L),y
	sta	r1L
	iny
	lda	(r2L),y
	sta	r1H
	ldy	#$05
@1:	lda	(r1L),y
	sta	l712d,y
	dey
	bpl	@1
	rts

L4E6F:
	ldy	#$00
	lda	#$08
	sta	(r2L),y
	ldy	#$0E
	lda	(r2L),y
	sta	r1L
	iny
	lda	(r2L),y
	sta	r1H
	ldy	#$05
@1:	lda	l712d,y
	sta	(r1L),y
	dey
	bpl	@1
	rts

L4E8B:					; Handles Photo Scraps
	lda	l6d87
	beq	@1
	jsr	L346F
	jsr	L4E59
@1:	ldy	#$05
@2:	lda	l712d,y
	sta	L4E4F,y
	dey
	bpl	@2
	ldy	#$02
	jsr	L4EC4
	cmp	#$02
	beq	@3
	lda	l6d87
	beq	@5
	jsr	L346F
	jsr	L4E6F
	clv
	bvc	@5
@3:	ldy	#$05
@4:	lda	L4E4F,y
	sta	l712d,y
	dey
	bpl	@4
@5:	rts

L4EC4:
	sty	L4F05
	ldx	#>dbPSAttribute
	lda	#<dbPSAttribute
	jsr	L1790
	lda	r0L
	rts

dbPSAttribute:				; Photo Scrap Attributes dialog box
.byte $81					; default DB parameters
.byte $0B					; DBTXTSTR
.byte $28,$0C				; xpos/ypos values
.word tCenter				; text pointer
.byte $0B					; DBTXTSTR
.byte $28,$17				; xpos/ypos values
.word tScaled				; text pointer
.byte $0B					; DBTXTSTR
.byte $28,$22				; xpos/ypos values
.word tStretched				; text pointer
.byte $0B
.byte $6C,$34				; xpos/ypos values
.word tSmoothed
.byte $0B
.byte $6C,$40				; xpos/ypos values
.word tTransparent
.byte $0B
.byte $1B,$32				; xpos/ypos values
.word tPattern
.byte $12					; DBUSRICON
.byte $02,$05				; xpos/ypos values
.word itCenter				; pointer to icon table
.byte $12					; DBUSRICON
.byte $02,$10				; xpos/ypos values
.word itScaled				; pointer to icon table
.byte $12					; DBUSRICON
.byte $02,$1B				; xpos/ypos values
.word itStretch				; pointer to icon table
.byte $13					; DB_USR_ROUT
.word sPSAttr				; pointer to service routine
.byte $01					; OK icon
.byte $01,$48				; xpos/ypos values
L4F05:
.byte $02					; CANCEL icon
.byte $11,$48				; xpos/ypos values
.byte $00

sPSAttr:					; service routine for the Photo Scrap Attributes db
	lda	#>L4F58
;	sta	appMain+1
	ldy	#<L4F58
	jmp	lAppMain
;	sta	appMain
;	rts

srCenter:					; service routine for center PS icon
	ldy	#$00
.byte $2c
srScaled:					; service routine for scaling PS icon
	ldy	#$01
.byte $2c
srStretch:					; service routine for stretching PS icon
	ldy	#$02
L4F1C:
	lda	l7131
	and	#$FC
	sta	l7131
	tya
	and	#$03
	ora	l7131
	sta	l7131
	jsr	L12F0
	jsr	i_Rectangle
.byte $26					; y1pos
.byte $48					; y2pos
.word $0042					; x1pos
.word $004f					; x2pos
	lda	l7131
	and	#$03
	tay
	lda	L4F4F,y
	sta	L4F4B
	jsr	i_BitmapUp
.word l4f52					; pointer to bitmap data
.byte $09					; xpos
L4F4B:
.byte $00					; ypos
.byte $01					; width (cards)
.byte $05					; height
	rts

L4F4F:
.byte $27,$32,$3d
l4f52:					; bitmap data
.byte $85,$40,$70,$7c,$70,$40		; looks like an arrow tip pointing --->

L4F58:
	lda	#>L505E
	sta	otherPressVec+1
	lda	#<L505E
	sta	otherPressVec
	jsr	L500E
	jsr	L5043
	jsr	L5198
	jsr	L51A3
	jsr	zAppMain
;	lda	#$00
;	sta	appMain+1
;	sta	appMain
	ldy	l7131
	jmp	L4F1C

itCenter:					; icon table for centering PS
.word iCenter				; pointer to icon data
.byte $00,$00				; xpos/ypos values
.byte $02					; card width
.byte $0A					; scanline height
.word srCenter				; pointer to service routine
itScaled:					; icon table for scaling PS
.word iScaled				; pointer to icon data
.byte $00,$00				; xpos/ypos values
.byte $02					; card width
.byte $0A					; scanline height
.word srScaled				; pointer to service routine
itStretch:					; icon table for stretching PS
.word iStretch				; pointer to icon data
.byte $00,$00				; xpos/ypos values
.byte $02					; card width
.byte $0A					; scanline height
.word srStretch				; pointer to service routine

iCenter:					; icon data for centering PS
.byte $02,$FF,$DF,$03,$82,$80,$01
.byte $84,$8A,$A1,$85,$51,$DF,$03,$82,$80,$01
iScaled:					; icon data for scaling PS
.byte $02,$FF,$DF,$02,$82,$80,$01
.byte $E1,$02,$84,$D5,$55,$AA,$AB,$DF,$02,$82,$80,$01
iStretch:					; icon data for stretching PS
.byte $02,$FF,$E1,$04,$84,$AA,$AB,$D5
.byte $55,$02,$FF

tCenter:
.byte $18
.asciiz "Centered in region"

tStretched:

.byte "Stretched & "
tScaled:
.asciiz "Scaled to fit"
tSmoothed:
.asciiz "Smoothed"
tPattern:
.asciiz "Pattern"
tTransparent:
.asciiz "Transparent"

L500E:
	ldy	#$00
	sty	r10L
@1:	cpy	#$10
	bpl	@2
	lda	L5161,y
	sta	r1L
	lda	L5162,y
	sta	r1H
	lda	L5163,y
	sta	r2L
	lda	L5164,y
	sta	r2H
	lda	L5165,y
	sta	r0L
	lda	L5165+1,y
	sta	r0H
	jsr	BitmapUp
	lda	r10L
	clc
	adc	#$08
	sta	r10L
	tay
	clv
	bvc	@1
@2:	rts

L5043:
	ldy	#$00
	sty	r10L
@1:	cpy	#$0C
	bpl	@2
	jsr	L51FA
	lda	#$FF
	jsr	FrameRectangle
	lda	r10L
	clc
	adc	#$04
	sta	r10L
	tay
	bne	@1
@2:	rts

L505E:
	lda	mouseData
	bpl	@1
	jmp	zAppMain
;	lda	#$00
;	sta	appMain+1
;	sta	appMain
;	rts
@1:	lda	#>L5134
;	sta	appMain+1
	ldy	#<L5134
	jsr	lAppMain
;	sta	appMain
	lda	#$00
	sta	L4E55
	sta	L4E56
	sta	L4E57
	jsr	L508A
	bcs	L505E-1			; @2
	jmp	L50DD
;@2:	rts

L508A:
	ldy	$3B
	bne	@5
	sty	r0H
	lda	$3A
	sta	r0L
	lda	$3C
	sta	r1L
	lda	#$01
	sta	r2L
@1:	cpy	#$08
	clc
	bpl	@5
	lda	r0L
	cmp	L5151,y
	bcc	@2
	cmp	L5152,y
	bcs	@2
	lda	r1L
	cmp	L5153,y
	bcc	@2
	cmp	L5154,y
	bcc	@3
@2:	asl	r2L
	iny
	iny
	iny
	iny
	bne	@1
@3:	lda	l7131
	cpy	#$00
	bne	@4
	eor	#$10
.byte $2c
@4:	eor	#$20
	sta	l7131
	jsr	L51A3
	jsr	zAppMain
;	lda	#$00
;	sta	appMain+1
;	sta	appMain
	sec
@5:	rts

L50DD:
	ldy	$3B
	bne	L50DD-1			; @6
	sty	r0H
	lda	$3A
	sta	r0L
	lsr	r0L
	lsr	r0L
	lsr	r0L
	lda	$3C
	sta	r1L
@1:	cpy	#$10
	clc
	bpl	L50DD-1			; @6
	lda	L5161,y
	cmp	r0L
	beq	@2
	bcs	@4
@2:	clc
	adc	L5163,y
	cmp	r0L
	beq	@4
	bcc	@4
	lda	L5162,y
	cmp	r1L
	beq	@3
	bcs	@4
@3:	clc
	adc	L5164,y
	cmp	r1L
	beq	@5
	bcs	@5
@4:	tya
	clc
	adc	#$08
	tay
	clv
	bvc	@1
@5:	lda	L5167,y
	sta	L4E55
	lda	L5167+1,y
	sta	L4E56
	jmp	L513A
;@6:	rts

L5134:
	inc	L4E57
	beq	L513A
	rts

L513A:
	lda	#$00
	sta	L4E57
	lda	L4E55
	ora	L4E56
	beq	L513A-1			; @1
	lda	L4E55
	ldx	L4E56
	jmp	CallRoutine
;@1:	rts

; don't know what this data is
L5151:  .byte   $A0
L5152:  .byte   $A7
L5153:  .byte   $5A
L5154:  .byte   $61,$A0,$A7,$4E,$55,$5B,$80,$56
        .byte   $61,$83,$A8,$58,$63

L5161:  .byte   $0A			; coordinates
L5162:  .byte   $56			; coordinates
L5163:  .byte   $02			; card width
L5164:  .byte   $0C			; scanline height
L5165:
.word iUpArrow
L5167:
.word L5171
.byte $10,$56				; coordinates
.byte $02,$0c				; card width/scanline height
.word iDownArrow
.word L5176

L5171:
	lda	#$01
	jmp	L5178
L5176:
	lda	#$FF
L5178:
	clc
	adc	l7132
	ldy	#$20
	ldx	#$FF
	stx	r0L
	sty	r0H
	cmp	r0L
	bne	@1
	tya
	sec
	sbc	#$01
@1:	cmp	r0H
	bne	@2
	lda	r0L
	clc
	adc	#$01
@2:	sta	l7132

L5198:
	lda	l7132
	jsr	SetPattern
	ldy	#$08
	jmp	L51C8

L51A3:
	ldy	#$00
	jsr	L51C1
	ldy	#$04
	jsr	L51C1
	ldy	#$00
	lda	#$10
	jsr	L51B8
	ldy	#$04
	lda	#$20

L51B8:
	and	l7131
	beq	@1
	jsr	L51DF
@1:	rts

L51C1:
	tya
	pha
	jsr	L12F0
	pla
	tay

L51C8:
	jsr	L51FA
	inc	r2L
	dec	r2H
	inc	r3L
	bne	@1
	inc	r3H
@1:	ldx	#$0A
	jsr	Ddec
	lda	#$FF
	jmp	Rectangle

L51DF:
	tya
	pha
	jsr	L51FA
	jsr	L51F4
	pla
	tay
	jsr	L51FA
	lda	r3L
	ldy	r4L
	sty	r3L
	sta	r4L

L51F4:
	lda	#$00
	sec
	jmp	DrawLine

L51FA:
	lda	L5151,y
	sta	r3L
	lda	#$00
	sta	r3H
	sta	r4H
	lda	L5152,y
	sta	r4L
	lda	L5153,y
	sta	r11L
	sta	r2L
	lda	L5154,y
	sta	r11H
	sta	r2H
	rts

sEdit:					; service routine for the Edit icon
	lda	#$ff
	sta	sysDBData
	jmp	RstrFrmDialog

zAppMain:					; zeroes out the appMain vector
	lda	#$00
	tay
lAppMain:					; loads the appMain vector w/ address
	sta	appMain+1			; .A = high byte
	sty	appMain			; .Y = low byte
	rts

iUpArrow:					; icon data for up arrow for Pattern
.byte $98,$FF,$F0,$80,$10,$86,$10,$86
.byte $10,$8F,$10,$8F,$10,$9F,$90,$9F
.byte $90,$86,$10,$86,$10,$80,$10,$FF,$F0
iDownArrow:					; icon data for down arrow for Pattern
.byte $98,$FF,$F0,$80,$10,$86,$10,$86
.byte $10,$9F,$90,$9F,$90,$8F,$10,$8F
.byte $10,$86,$10,$86,$10,$80,$10,$FF,$F0

iEdit:					; hand-compacted icon data for EDIT button (67 bytes)
.byte $06,$ff				; repeat byte
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $9c,$80,$0f,$c1,$99,$80,$03,$80,$0c; unique byte
.byte $01,$81,$80,$03,$80,$0c,$0f,$bb
.byte $c0,$03,$80,$0c,$19,$99,$80,$03
.byte $80,$0f,$99,$99
.byte $e3,$03,$86,$80,$03,$80,$0c,$19,$99; BIGCOUNT byte
.byte $88,$80,$03,$80,$0f,$cf,$98,$e0,$03; unique byte
.byte $e2,$02,$81,$80,$04,$00,$81,$03; BIGCOUNT byte
.byte $0c,$ff				; repeat byte

tImageMode:	
.byte $18

.byte "Image:"
.byte $1B
.byte $14,$88,$00				; GOTOX

.byte " Constrain"
.byte $14,$CA,$00				; GOTOX
.asciiz "Scale"

.bss						; start bss data segment
L4D4C: .res $01
L4D4D: .res $01
L4D4E: .res $01
L4D4F: .res $01
L4D50: .res $01
L4D51: .res $01
L4D52: .res $01
L4D53: .res $01

L4E4D: .res $01
L4E4E: .res $01				; minimum required frame/line width
L4E4F: .res $06
L4E55: .res $01
L4E56: .res $01
L4E57: .res $02
