; da65 V2.10.0 - (C) Copyright 2000-2003 Ullrich von Bassewitz
; Input file: gpb01v0c.bin
; geoPublish's VLIR module #$0c

.out "Source Code (c) 2003 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"


.org $4880
.setcpu "6502"

; module equates
pPutBlock		=	$141c
pFindFile		=	$142b
pGetBlock		=	$1434
SetProgDevice	=	$1817
SetDataDevice	=	$181c

L1145           = $1145
L12C4           = $12C4
L12F0           = $12F0
L1404           = $1404
L1481           = $1481
L17AF           = $17AF
L186D           = $186D
RZoomBox	=	$1913			; imprints the zoom toolbox
EZoomBox	=	$1946			; erases the zoom toolbox
L1999           = $1999
L1C2F           = $1C2F
L2178           = $2178
L253F           = $253F
L346F           = $346F
L3472           = $3472
L38BF           = $38BF
L395E           = $395E
L3A34           = $3A34
L3A3A           = $3A3A
L3B4A           = $3B4A
L3D77           = $3D77
L3DDA           = $3DDA
L3E2A           = $3E2A
L3E38           = $3E38
L3E9B           = $3E9B
L40AE           = $40AE
L40CD           = $40CD
L4144           = $4144
L415C           = $415C
L4186           = $4186
L41EC           = $41EC

; module jump table
        jmp     L489E
        jmp     L48BF
        jmp     L4952
        jmp     L4A0A
        jmp     L4A62
        jmp     L4DEF
	jmp	PastePS
        jmp     L4FA0
        jmp     L495E
        jmp     L4C6A
L489E:  ldy     $750B
        sty     $7A7C
        ldy     $4860
        dey
L48A8:  ldx     $7A7C,y
        cpx     $6ED6
        beq     L48B5
        dey
        bpl     L48A8
        bmi     L48B8
L48B5:  sta     $7A7C,y
L48B8:  lda     $7A7C
        sta     $750B
        rts
L48BF:  ldy     r4H
        cpy     #$03
        beq     L48D4
        lda     $6ED7
        cmp     r4L
        bne     L48E3
        lda     (r2L),y
        sta     $6ED7
        clv
        bvc     L4905
L48D4:  lda     $6ED8
        cmp     r4L
        bne     L48E3
        lda     (r2L),y
        sta     $6ED8
        clv
        bvc     L4905
L48E3:  lda     $750D
        sta     r3H
        lda     $750C
        sta     r3L
L48ED:  lda     (r3L),y
        cmp     r4L
        beq     L4901
        clc
        lda     #$10
        adc     r3L
        sta     r3L
        bcc     L48FE
        inc     r3H
L48FE:  clv
        bvc     L48ED
L4901:  lda     (r2L),y
        sta     (r3L),y
L4905:  jmp     L3A34
L4908:  pha
        jsr     L3472
        ldy     #$00
        lda     (r2L),y
        cmp     #$08
        bne     L491F
        jsr     L4923
        jsr     L1999
        bne     L491F
        dec     $73C1
L491F:  pla
        jmp     L3B4A
L4923:  lda     #$00
        sta     $6DAE
        ldy     #$0E
        lda     (r2L),y
        sta     r0L
        iny
        lda     (r2L),y
        beq     L4951
        sta     r0H
        ldy     #$00
        lda     (r0L),y
        beq     L4951
        pha
        jsr     L2178
        pla
        cpx     #$00
        bne     L4951
        jsr     PointRecord
        txa
        bne     L4951
        stx     r2H
        stx     r2L
        jsr     L1404
L4951:  rts
L4952:
	jsr	EZoomBox			; erases the zoom toolbox
        jsr     L40AE
        jsr     L495E
        jmp     L41EC
L495E:  lda     $750B
        sta     $7A7C
        jsr     L4EDE
        lda     $6D88
        sta     $4860
        dec     $4860
L4970:  ldy     $4860
        lda     $7A7C,y
        pha
        jsr     L4908
        pla
        jsr     L489E
        dec     $4860
        bpl     L4970
        lda     #$00
        sta     $6D87
        rts
L4989:  lda     $EB
        sta     r0H
        lda     $EA
        sta     r0L
        lda     $ED
        sta     r1H
        lda     $EC
        sta     r1L
        jsr     L4ECA
        lda     #$02
        sta     r0H
        lda     #$7F
        sta     r0L
        lda     r0L
        sec
        sbc     L4EDA
        sta     r0L
        lda     r0H
        sbc     L4EDB
        sta     r0H
        lda     #$02
        sta     r1H
        lda     #$EF
        sta     r1L
        lda     r1L
        sec
        sbc     L4EDC
        sta     r1L
        lda     r1H
        sbc     L4EDD
        sta     r1H
        lda     $6F05
        beq     L49F7
        lda     r0H
        cmp     $C7
        bne     L49D9
        lda     r0L
        cmp     $C6
L49D9:  bcc     L49E3
        lda     $C7
        sta     r0H
        lda     $C6
        sta     r0L
L49E3:  lda     r1H
        cmp     $C9
        bne     L49ED
        lda     r1L
        cmp     $C8
L49ED:  bcc     L49F7
        lda     $C9
        sta     r1H
        lda     $C8
        sta     r1L
L49F7:  jsr     L1C2F
        lda     r0H
        sta     mouseRight+1
        lda     r0L
        sta     mouseRight
        lda     r1L
        sta     mouseBottom
        rts
L4A0A:  jsr     L415C
        lda     r3H
        cmp     $ED
        bne     L4A17
        lda     r3L
        cmp     $EC
L4A17:  bne     L4A25
        lda     r2H
        cmp     $EB
        bne     L4A23
        lda     r2L
        cmp     $EA
L4A23:  beq     L4A61
L4A25:  lda     r3H
        pha
        lda     r3L
        pha
        lda     r2H
        pha
        lda     r2L
        pha
        jsr     L38BF
        pla
        sta     $EA
        pla
        sta     $EB
        pla
        sta     $EC
        pla
        sta     $ED
        lda     $EA
        clc
        adc     L4EDA
        sta     $EE
        lda     $EB
        adc     L4EDB
        sta     $EF
        lda     $EC
        clc
        adc     L4EDC
        sta     $F0
        lda     $ED
        adc     L4EDD
        sta     $F1
        jsr     L38BF
L4A61:  rts
L4A62:  lda     $750B
        sta     $7A7C
        jsr     L4DA8
        ldy     $6D88
L4A6E:  dey
        sty     $4860
        lda     $7A7C,y
        sta     r4L
        sta     $F4
        jsr     L3472
        ldy     #$03
        sty     r4H
        jsr     L48BF
        lda     r2H
        pha
        lda     r2L
        pha
        ldy     $F5
        cpy     #$08
        bne     L4A95
        jsr     L4AC4
        clv
        bvc     L4A98
L4A95:  jsr     L4B1C
L4A98:  pla
        sta     r0L
        pla
        sta     r0H
        ldy     #$0D
        ldx     #$07
L4AA2:  lda     (r0L),y
        sta     r9L,x
        dey
        dex
        bpl     L4AA2
        jsr     L3A3A
        ldy     $4860
        bne     L4A6E
        rts

L4AB3:
	jmp	testObj			; test certain graphics objects
.byte $ea					; compensate for file integrity
;	ldy	#$00
;	lda	(r2L),y
	cmp	#$07				; Text Objects?
	beq	@1
	cmp	#$08				; Photo Scraps?
	beq	@1
	ldy	#$0F
	lda	(r2L),y
@1:	rts

L4AC4:  jsr     L4AB3			; this routine will adjust the graphics object
        beq     L4AD2			; coordinates when the user moves it onscreen.
        jsr     L4186
        ldx     $4855
        jsr     L4AE1
L4AD2:  lda     r2L
        clc
        adc     #$06
        sta     r4L
        lda     r2H
        adc     #$00
        sta     r4H
        ldx     #$01
L4AE1:  jsr     L4AF3
        lda     r4L
        clc
        adc     #$04
        sta     r4L
        bcc     L4AEF
        inc     r4H
L4AEF:  dex
        bpl     L4AE1
        rts
L4AF3:  ldy     #$00
L4AF5:  sec
        lda     (r4L),y
        sbc     $6D61,y
        sta     (r4L),y
        iny
        lda     (r4L),y
        sbc     $6D61,y
        sta     (r4L),y
        dey
        clc
        lda     (r4L),y
        adc     $6D69,y
        sta     (r4L),y
        iny
        lda     (r4L),y
        adc     $6D69,y
        sta     (r4L),y
        iny
        cpy     #$04
        bne     L4AF5
        rts
L4B1C:  jsr     L4AB3
        beq     L4B2A
        jsr     L4186
        ldx     $4855
        jsr     L4B55
L4B2A:  lda     $6D88
        cmp     #$01
        bcc     L4B45
        beq     L4B45
        lda     r2L
        clc
        adc     #$06
        sta     r4L
        lda     r2H
        adc     #$00
        sta     r4H
        ldx     #$01
        jmp     L4B55
L4B45:  jsr     L4B6D
        ldy     #$0D
        ldx     #$07
L4B4C:  lda     r12L,x
        sta     (r2L),y
        dey
        dex
        bpl     L4B4C
        rts
L4B55:  stx     L4B6C
L4B58:  jsr     L4BD5
        lda     r4L
        clc
        adc     #$04
        sta     r4L
        bcc     L4B66
        inc     r4H
L4B66:  dec     L4B6C
        bpl     L4B58
        rts
L4B6C:  brk
L4B6D:  ldy     #$0D
        ldx     #$07
L4B71:  lda     (r2L),y
        sta     r12L,x
        dey
        dex
        bpl     L4B71
        lda     #$00
        ldy     r12H
        cpy     r14H
        bne     L4B85
        ldy     r12L
        cpy     r14L
L4B85:  bcc     L4B8B
        beq     L4B8B
        ora     #$80
L4B8B:  ldy     r13H
        cpy     r15H
        bne     L4B95
        ldy     r13L
        cpy     r15L
L4B95:  bcc     L4B9B
        beq     L4B9B
        ora     #$40
L4B9B:  sta     L4BD4
        ldy     #$07
L4BA0:  lda     $6D69,y
        sta     r12L,y
        dey
        bpl     L4BA0
        bit     L4BD4
        bpl     L4BBE
        ldx     r12L
        ldy     r12H
        lda     r14L
        sta     r12L
        lda     r14H
        sta     r12H
        stx     r14L
        sty     r14H
L4BBE:  bit     L4BD4
        bvc     L4BD3
        ldx     r13L
        ldy     r13H
        lda     r15L
        sta     r13L
        lda     r15H
        sta     r13H
        stx     r15L
        sty     r15H
L4BD3:  rts
L4BD4:  brk
L4BD5:  ldy     #$03
L4BD7:  lda     (r4L),y
        sta     r10L,y
        dey
        bpl     L4BD7
        lda     r11L
        sec
        sbc     $6D63
        sta     r11L
        lda     r11H
        sbc     $6D64
        sta     r11H
        lda     L4DEA
        sta     r15H
        lda     L4DE9
        sta     r15L
        ldy     #$20
        ldx     #$18
        jsr     DMult
        lda     L4DEE
        sta     r15H
        lda     L4DED
        sta     r15L
        ldx     #$18
        ldy     #$20
        jsr     L4D78
        lda     $6D6B
        clc
        adc     r11L
        sta     r11L
        lda     $6D6C
        adc     r11H
        sta     r11H
        lda     r10L
        sec
        sbc     $6D61
        sta     r10L
        lda     r10H
        sbc     $6D62
        sta     r10H
        lda     L4DE8
        sta     r15H
        lda     L4DE7
        sta     r15L
        ldy     #$20
        ldx     #$16
        jsr     DMult
        lda     L4DEC
        sta     r15H
        lda     L4DEB
        sta     r15L
        ldx     #$16
        ldy     #$20
        jsr     L4D78
        lda     $6D69
        clc
        adc     r10L
        sta     r10L
        lda     $6D6A
        adc     r10H
        sta     r10H
        ldy     #$03
L4C61:  lda     r10L,y
        sta     (r4L),y
        dey
        bpl     L4C61
        rts
L4C6A:  lda     $750B
        sta     $7A7C
        lda     $6D88
        cmp     #$01
        beq     L4C79
        bcs     L4C85
L4C79:  jsr     L346F
        jsr     L3E2A
        jsr     L3D77
        clv
        bvc     L4CBE
L4C85:  lda     #$00
        sta     $3E26
        sta     $3E27
        sta     $3E28
        sta     $3E29
        lda     #$06
        sta     $3E23
        sta     $3E25
        ldy     $6D88
L4C9E:  dey
        sty     $4860
        lda     $7A7C,y
        jsr     L3472
        jsr     L3E38
        jsr     L3DDA
        ldy     $4860
        bne     L4C9E
        ldy     #$07
L4CB5:  lda     $3E22,y
        sta     $6D49,y
        dey
        bpl     L4CB5
L4CBE:  rts
L4CBF:  lda     $750B
        sta     $7A7C
        ldy     #$07
        lda     #$00
L4CC9:  sta     $6D61,y
        dey
        bpl     L4CC9
        lda     #$0A
        sta     $6D62
        sta     $6D64
        ldy     $6D88
L4CDA:  dey
        sty     $4860
        lda     $7A7C,y
        jsr     L3472
        ldy     #$0D
        ldx     #$07
L4CE8:  lda     (r2L),y
        sta     r12L,x
        dey
        dex
        bpl     L4CE8
        lda     r12L
        ldx     r12H
        cpx     r14H
        bne     L4CFA
        cmp     r14L
L4CFA:  bcc     L4D0A
        beq     L4D0A
        ldy     r14L
        sty     r12L
        ldy     r14H
        sty     r12H
        sta     r14L
        stx     r14H
L4D0A:  lda     r13L
        ldx     r13H
        cpx     r15H
        bne     L4D14
        cmp     r15L
L4D14:  bcc     L4D24
        beq     L4D24
        ldy     r15L
        sty     r13L
        ldy     r15H
        sty     r13H
        sta     r15L
        stx     r15H
L4D24:  ldy     #$07
        jsr     L4D52
        ldy     #$05
        jsr     L4D52
        ldy     #$03
        jsr     L4D3E
        ldy     #$01
        jsr     L4D3E
        ldy     $4860
        bne     L4CDA
        rts
L4D3E:  tya
        tax
        lda     r12L,y
        cmp     $6D61,y
        bne     L4D4F
        dey
        lda     r12L,y
        cmp     $6D61,y
L4D4F:  bcc     L4D68
        rts
L4D52:  tya
        tax
        lda     r12L,y
        cmp     $6D61,y
        bne     L4D63
        dey
        lda     r12L,y
        cmp     $6D61,y
L4D63:  beq     L4D67
        bcs     L4D68
L4D67:  rts
L4D68:  txa
        tay
        lda     r12L,y
        sta     $6D61,y
        dey
        lda     r12L,y
        sta     $6D61,y
        rts
L4D78:  lda     $00,y
        ora     $01,y
        beq     L4DA7
        lda     #$10
        sta     r9L
L4D84:  asl     $00,x
        rol     $01,x
        rol     r7L
        rol     r7H
        lda     r7L
        sec
        sbc     $00,y
        sta     r9H
        lda     r7H
        sbc     $01,y
        bcc     L4DA3
        inc     $00,x
        sta     r7H
        lda     r9H
        sta     r7L
L4DA3:  dec     r9L
        bne     L4D84
L4DA7:  rts
L4DA8:  ldy     #$00
L4DAA:  sec
        lda     $6D6D,y
        sbc     $6D69,y
        sta     L4DE7,y
        lda     $6D6E,y
        sbc     $6D6A,y
        sta     L4DE8,y
        sec
        lda     $6D65,y
        sbc     $6D61,y
        sta     L4DEB,y
        lda     $6D66,y
        sbc     $6D62,y
        sta     L4DEC,y
        bne     L4DE0
        lda     L4DEB,y
        bne     L4DE0
        lda     L4DEB,y
        clc
        adc     #$01
        sta     L4DEB,y
L4DE0:  iny
        iny
        cpy     #$04
        bne     L4DAA
        rts
L4DE7:  .byte   $00
L4DE8:  .byte   $00
L4DE9:  .byte   $00
L4DEA:  .byte   $00
L4DEB:  .byte   $00
L4DEC:  .byte   $00
L4DED:  .byte   $00
L4DEE:  .byte   $00
L4DEF:  ldx     #$06
        jsr     BlockProcess
        lda     #$41
        sta     otherPressVec+1
        lda     #$AF
        sta     otherPressVec
	jsr	EZoomBox		; erases the zoom toolbox
        jsr     L40CD
        jsr     L4EDE
        lda     $6F05
        beq     L4E0F
        jsr     L253F
L4E0F:  lda     #$00
        sta     $6AC0
        lda     #$FF
        sta     $6D48
        jsr     L4CBF
        ldy     #$07
L4E1E:  lda     $6D61,y
        sta     $EA,y
        dey
        bpl     L4E1E
        ldx     #$EA
        ldy     #$EE
        jsr     L1145
        ldx     #$EC
        ldy     #$F0
        jsr     L1145
        ldy     #$07
L4E37:  lda     $EA,y
        sta     $6D61,y
        dey
        bpl     L4E37
        jsr     L38BF
        ldx     $F5
        cpx     #$05
        bne     L4E9C
        lda     $EF
        sta     r0H
        lda     $EE
        sta     r0L
        lda     $F1
        sta     r1H
        lda     $F0
        sta     r1L
        jsr     L4ECA
        lda     #$F0
        and     $FF
        bne     L4EC5
        ldx     #$03
L4E64:  lda     $EA,x
        sta     r0L,x
        dex
        bpl     L4E64
        lda     $6D88
        cmp     #$01
        bne     L4E7D
        jsr     L346F
        ldy     #$00
        lda     (r2L),y
        cmp     #$01
        beq     L4E87
L4E7D:  ldx     #$02
        jsr     L186D
        ldx     #$04
        jsr     L186D
L4E87:  jsr     L1C2F
        lda     r0H
        sta     mouseLeft+1
        lda     r0L
        sta     mouseLeft
        lda     r1L
        sta     mouseTop
        clv
        bvc     L4EC5
L4E9C:  lda     $6D65
        sec
        sbc     $6D61
        sta     L4EDA
        lda     $6D66
        sbc     $6D62
        sta     L4EDB
        lda     $6D67
        sec
        sbc     $6D63
        sta     L4EDC
        lda     $6D68
        sbc     $6D64
        sta     L4EDD
        jsr     L4989
L4EC5:  ldx     $F5
        jmp     RestartProcess
L4ECA:  jsr     L1C2F
        lda     r0H
        sta     $3B
        lda     r0L
        sta     $3A
        lda     r1L
        sta     $3C
        rts
L4EDA:  .byte   $00
L4EDB:  .byte   $00
L4EDC:  .byte   $00
L4EDD:  .byte   $00
L4EDE:  lda     $6AC1
        beq     L4EF7
        ldx     #$07
L4EE5:  lda     $6D49,x
        sta     $6D51,x
        sta     $6D59,x
        dex
        bpl     L4EE5
        jsr     L3E9B
        clv
        bvc     L4EFD
L4EF7:  jsr     L346F
        jsr     L3E2A
L4EFD:  jsr     L12F0
        lda     $6D5A
        sta     r0H
        lda     $6D59
        sta     r0L
        lda     $6D5C
        sta     r1H
        lda     $6D5B
        sta     r1L
        jsr     L1C2F
        lda     r0H
        sta     r3H
        lda     r0L
        sta     r3L
        lda     r1L
        sta     r2L
        lda     $6D5E
        sta     r0H
        lda     $6D5D
        sta     r0L
        lda     $6D60
        sta     r1H
        lda     $6D5F
        sta     r1L
        jsr     L1C2F
        lda     r0H
        sta     r4H
        lda     r0L
        sta     r4L
        lda     r1L
        sta     r2H
        jsr     Rectangle
        rts

PastePS:					; routine to paste in a photo scrap
	jsr	L12C4				; calls CalcBlksFree - Must have 20 blocks free
	jsr	L2178				; 'opens' the geoPub datafile
	txa					; check error
	bne	@4
	lda	#$35				; starting VLIR # of geoPub datafile
@1:	pha
	jsr	PointRecord
	pla
	cpx	#$00
	bne	@4				; check error
	ldy	r1L				; was the VLIR record already allocated?
	beq	@2				; if so, then get next VLIR #
	clc
	adc	#$01
	cmp	#$7F				; up to VLIR #$7f
	bcc	@1				; and continue
	lda	#<tPSFull
	ldy	#>tPSFull
	jsr	L17AF				; issues DB
	bne	@4
@2:	sta	$712D				; variable now holding VLIR # for photo scrap
	jsr	PointRecord
	jsr	copyPS			; copies a photo scrap to the geoPub datafile
	txa					; check error
	bne	@4
;	jsr	eZoomBox			; erases the zoom toolbox
	jsr	L4144				; sets up starting x,y positions of the graphics object
	jsr	L4FD2				; sets up ending x,y positions of the graphics object
	jsr	L1999				; checks MP mode being in use
	bne	@3				; take branch if MP mode isn't in use
	inc	$73C1				; increments the bitmap counter in MP mode
@3:	lda	#$00
	sta	r0H
	lda	#$06
	sta	r0L				; loads r0 with $0006 for # of extra information
	jmp	L395E				; inserts the photo scrap into the geoPublish datafile
						; and exits. Another VLIR module will be loaded in.
;	jsr	rZoomBox			; imprints the zoom toolbox and exits (quasi-JSR)
;@4:	txa
;	beq	@5
.byte $ea,$ea,$ea				; compensate the code for this VLIR module.

@4:	lda	#$00				; clear out the variable holding VLIR # of photo scrap
	sta	$712D				; embedded within the datafile
;@5:
	rts

L4FA0:
	lda	#$00
	sta	$6DAE
	jsr	L4FBF
	lda	r0H
	sta	r2H
	lda	r0L
	sta	r2L
	jsr	L502D
	ldx	#$07
@1:	lda	$EA,x
	sta	r9L,x
	dex
	bpl	@1
	jmp	L3A3A

L4FBF:
	ldy	#$00
	lda	#$08
	sta	(r0L),y
	ldy	#$0D
	ldx	#$07
@1:	lda	$EA,x
	sta	(r0L),y
	dey
	dex
	bpl	@1
	rts

L4FD2:
	lda	$712E				; get width (cards) of photo scrap
	sta	r0L
	lda	#$00
	asl	r0L
	rol	a
	asl	r0L
	rol	a
	asl	r0L
	rol	a
	sta	r0H				; multiply it by eight & store result in r0
	lda	$EA				; get starting xpos of object
	clc
	adc	r0L
	sta	$EE
	lda	$EB
	adc	r0H
	sta	$EF				; $ee-$ef now holds the ending xpos of object
	lda	$EC				; get starting ypos of object
	clc
	adc	$712F				; add height (scanlines) of object
	sta	$F0
	lda	$ED
	adc	$7130
	sta	$F1				; $f0-$f1 now holds the ending ypos of object
	lda	$F1
	cmp	#$02
	bne	@1
	lda	$F0
	cmp	#$EF				; seems to be a boundary check - have we reached the
@1:	bcc	@2				; bottom of the geoPub document page?
	beq	@2
	lda	#$02
	sta	$F1
	lda	#$EF
	sta	$F0				; if the boundary is exceeded, trunctuate the object
@2:	lda	$EF
	cmp	#$02
	bne	@3
	lda	$EE
	cmp	#$7F				; same thing for the x direction - have we reached the
@3:	bcc	@4				; right edge of the geoPub document page?
	beq	@4
	lda	#$02
	sta	$EF				; if the right edge of the boundary is exceeded,
	lda	#$7F				; trunctuate the object accordingly.
	sta	$EE
@4:	rts

L502D:
	ldy	#$0E
	lda	(r2L),y
	sta	r1L
	iny
	lda	(r2L),y
	sta	r1H
	ldy	#$05
@1:	lda	$712D,y
	sta	(r1L),y
	dey
	bpl	@1
	rts

copyPS:					; copies a photo scrap to the geoPub datafile
	lda	#>permname
	sta	r6H
	lda	#<permname
	sta	r6L				; permname
	jsr	SetProgDevice
	jsr	pFindFile			; tries to locate a photo scrap on ProgDevice
	jsr	SetDataDevice
	txa					; check error
	beq	@1
	pha
	lda	#<tNoPS
	ldy	#>tNoPS
	jsr	L17AF				; issues DB
	jsr	RZoomBox			; imprints the zoom toolbox
	pla
	tax					; set error
	rts

@1:	jsr	L1481				; sets variables to mark that the datafile will be
	lda	dirEntryBuf+2		; modified and such changes need to be written back
	sta	r1H				; to disk
	lda	dirEntryBuf+1
	sta	r1L				; load r1 w/ 1st t/s pointer of photo scrap
	ldy	#$00
	sty	$712E
	sty	r3H
	sty	r2L
	iny
	sty	r3L				; sets variables
	jsr	SetNextFree			; find next free block and allocate it
	txa					; check error
	beq	@2
	jmp	@7				; bne L5116?
@2:	lda	r3H
	pha
	lda	r3L
	pha					; saves the first t/s of the file chain
	inc	r2L
@8:	jsr	L5117				; loads r4 w/ diskBlkBuf
	jsr	SetProgDevice
	jsr	pGetBlock			; gets the first block of the photo scrap
	jsr	SetDataDevice
	txa					; check error
	bne	@7
	lda	$712E				; already set to zero earlier
	bne	@3
	lda	diskBlkBuf+2
	sta	$712E				; contains width (cards) of photo scrap
	lda	diskBlkBuf+3
	sta	$712F				; contains height (word value) (scanlines) of PS
	lda	diskBlkBuf+4
	sta	$7130
@3:	lda	diskBlkBuf+1		; get next T/S of the photo scrap
	sta	r5H
	lda	diskBlkBuf
	sta	r5L
	lda	r3H
	sta	r1H
	lda	r3L
	sta	r1L				; copies the newly allocated t/s to r1
	lda	r5L				; are we done?
	bne	@4
	sta	diskBlkBuf
	lda	r5H
	sta	diskBlkBuf+1		; store the # of bytes left in last block
	clv
	bvc	@5
@4:	jsr	SetNextFree			; gets the next free block and allocates it
	txa					; check error
	bne	@7
	inc	r2L				; increment blocks (filesize) counter
	lda	r3H
	sta	diskBlkBuf+1
	lda	r3L				; mint the new T/S link in the file chain
	sta	diskBlkBuf
@5:	jsr	L5117				; loads r4 w/ $8000
	jsr	pPutBlock			; and writes the block to disk.
	txa					; check error.
	bne	@7				; basically, the routine copies a photo scrap
	lda	r5H				; to geoPublish datafile's VLIR record
	sta	r1H
	lda	r5L				; checks to see if the T/S link has $00, xx
	sta	r1L				; copies the t/s of the next block of photo scrap
	bne	@8				; and repeats the process all over again.
	lda	r2L				; get filesize counter
	clc
	adc	fileSize
	sta	fileSize
	bcc	@6
	inc	fileSize+1
@6:	lda	curRecord
	asl	a
	tay					; gets the VLIR offset in fileHeader of datafile
	pla					; gets the starting t/s of the newly copied
	sta	fileHeader+2,y		; photo scrap and stores it in the VLIR index block
	pla
	sta	fileHeader+3,y
@7:	rts

L5117:
	lda	#>diskBlkBuf
	sta	r4H
	lda	#<diskBlkBuf
	sta	r4L
	rts

testObj:					; test for certain graphics objects
	ldy	#$00
	lda	(r2L),y
	cmp	#$07				; is it a Text Object?
	beq	@1
	cmp	#$08				; is it a Photo Scrap?
	beq	@1
	cmp	#$04				; is it a Rectangle?
	beq	@1
	cmp	#$02				; is it a Circle?
	beq	@1
	ldy	#$0F
	lda	(r2L),y
@1:	rts

;eZoomBox:					; erases the zoom toolbox
;	jsr	EZoomBox
;	jmp	L4144				; and set x/y positions

;rZoomBox:					; imprints the zoom toolbox
;	txa					; check error
;	php
;	jsr	RZoomBox
;	plp
;	bne	@5				; if there is an error, then RTS.
;	pla
;	pla					; make this a quasi-JSR routine
;@5:	rts

tNoPS:					; photo scrap missing
.byte $18

.byte "No "
permname:					; permanent name string
.asciiz "Photo Scrap"

tPSFull:					; no room for photo scraps
.byte $18
.asciiz "File's picture area full."
