; da65 V2.9.3 - (C) Copyright 2000-2003 Ullrich von Bassewitz
; Input file: gpb01v01.bin

.out "Source Code (c) 2003 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"

.org $3180

; module equates
iBox			=	$05d6		; icon table for a box
pWriteFile		=	$1419
pPutBlock		=	$141c
pReadFile		=	$1425
pOpenDisk		=	$1428
pGetBlock		=	$1434
pBlkAlloc		=	$1436
SetProgDevice	=	$1817
SetDataDevice	=	$181c
toggleZP		=	$1761
toggleLib		=	$1a00		; toggles library file pointers for MP or PG modes
delObj		=	$1a13		; routine to delete a graphics object
GetNextGONum	=	$1a26		; gets start address for next available graphics object
freeRAM		=	$2486
PGData		=	$5a80		; start address of Page Graphics data
GOData		=	PGData+9	; start address of Graphics Object data
EGOData		=	$6a80		; end address of Graphics Object data
progDrive		=	$6a81
dataDrive		=	progDrive-1
crFlag		=	$6a82		; copyright flag
dFileName		=	$6a83		; datafile's filename
gpvlir	=	$6a94			; geoPublish's VLIR records are located here
pglFlag	=	gpvlir		; flag to indicate if a Page Graphics library file exists.
pglPtrs	=	pglFlag+2		; contains pointer to Page Graphics Library VLIR index
fnBuffer		=	$6e23
GOAttrData		=	$6ed4		; Graphics Object attribute data start address is contained
						; at $6ed4-$6ed5
; equates
stack			=	$0100
t0e07			=	$0e07
L0EC5           = $0EC5
L100A           = $100A
L10D5           = $10D5
L1170           = $1170
L11AB           = $11AB
L128C           = $128C
L1295           = $1295
L1298           = $1298
L12AF           = $12AF
L12B8           = $12B8
L12C4           = $12C4
L12F0           = $12F0
L1305           = $1305
L1343           = $1343
L13A8           = $13A8
L13B2           = $13B2
L1404           = $1404
L1413           = $1413
L1416           = $1416
L142B           = $142B
L1431           = $1431
L144F           = $144F
L1460			=	$1460
L146C           = $146C
L1510           = $1510
L1516           = $1516
L155A           = $155A
L15B7           = $15B7
L170B           = $170B
L177E           = $177E
L1790           = $1790
L17AF           = $17AF
L17B9           = $17B9
L17D9           = $17D9
L1822           = $1822
l1867			=	$1867
l186f           = $186F
L187B           = $187B
l1896			=	$1896
L18AD           = $18AD
L18BF           = $18BF
L18C2           = $18C2
L18C5           = $18C5
L1946           = $1946
L1975			=	$1975
L1993           = $1993
L1999           = $1999
L199F           = $199F
L19BD           = $19BD
L1CAB           = $1CAB
L1CB4           = $1CB4
L1D1F           = $1D1F
L2154           = $2154
L2178           = $2178
L2180           = $2180
L2274           = $2274
L252A           = $252A
L2536           = $2536
L4A92           = $4A92
L4A95           = $4A95

l4c95			=	$4c95
l5a84			=	$5a84
l5a87			=	$5a87
l6d46			=	$6d46
l6d87			=	$6d87
l6da9			=	$6da9
l6dae			=	$6dae
l6daf			=	$6daf
l6e12			=	$6e12
l6e18			=	$6e18
l6ed9			=	$6ed9
l6ef9			=	$6ef9
l6f01			=	$6f01
l6f04			=	$6f04
l6f05			=	$6f05
l6f06			=	$6f06
l6f07			=	$6f07
l6f09			=	$6f09
l6f10			=	$6f10
l6f15			=	$6f15
l7125			=	$7125
l7126			=	$7126
l7129			=	$7129
l7131			=	$7131
l7136			=	$7136
l713a			=	$713a
l713e			=	$713e
l739f			=	$739f
l73bf			=	$73bf
l73c0			=	$73c0
l73c1			=	$73c1
l73c2			=	$73c2
l73c8			=	$73c8
l73c9			=	$73c9
l73c6			=	$73c6
l73cb			=	$73cb
l750c			=	$750c		; contains start address of graphics object (MP&PG) data
l75ad			=	$75ad
l7e40			=	$7e40

; module jump table
	jmp	aboutGP
        jmp     L37AE
        jmp     L3676
        jmp     L3750
	jmp	exitGP
	jmp	showSplashDB
        jmp     L353A
        jmp     L34AE
        jmp     L3768
	jmp	recoverGPfile
	jmp	DocSetup
        jmp     L31B3
	jmp	setGutters
	jmp	callLibrary
        jmp     L4261
        jmp     L3E1B
        jmp     L379C

L31B3:					; prompts the user for a geoWrite file.
	jsr	L1510				; not sure yet.
	jsr	SetDataDevice
	jsr	readDiskName		; gets name of the disk
	lda	#$07
	sta	r7L
	ldx	#r5
	jsr	L487B				; loads r5 w/ $6e12
;	lda	#>l6e12
;	sta	r5H
;	lda	#<l6e12			; why not use fnBuffer?
;	sta	r5L
	lda	#>tGWPermName
	sta	r10H
	lda	#<tGWPermName
	sta	r10L
	jsr	restoreDB			; restores the dbOpen table
	iny					; load .Y w/ zero
	sty	l6e12
	sty	renTable			; disable the drive & DISK icons
	lda	#<dbOpen
	ldx	#>dbOpen
;	jsr	toggleZP
	jsr	L1790
;	jsr	toggleZP			; not needed if no disk operations are used
	lda	#$02				; did the user CANCEL?
	ldx	r0L
	cpx	#$05				; did the user OPEN?
	bne	@1
	ldx	l6e12
	beq	@1
	jsr	L31FE
@1:	sta	r0L
	rts

L31FE:
	lda	#$10
	sta	l6d46+1			; seems to have up to 16 geoWrite file pointers
	lda	#$FF				; in article table?
	sta	l6d46
@1:	lda	l6d46+1
	beq	@4
	jsr	L1170
	ldx	#r2
	jsr	L487B				; load r2 w/ $6e12
;	lda	#>l6e12
;	sta	r2H
;	lda	#<l6e12
;	sta	r2L
	ldy	#$89
	ldx	#$06
	jsr	CmpString			; if the file is already in memory, do nothing.
	bne	@2
	lda	l6d46+1
	sta	l6d46
	clv
	bvc	@5
@2:	ldy	#$00
	lda	($89),y
	bne	@3
	lda	l6d46+1
	sta	l6d46
@3:	dec	l6d46+1
	bpl	@1
@4:	jmp	L3241
@5:	lda	#$05				; proxy for OPEN icon
	rts

L3241:
	lda	l6d46
	bpl	@1
	lda	#<t0e07
	ldy	#>t0e07			; article table full text error message
	jsr	L17AF
	lda	#$02				; proxy for CANCEL icon
	bne	@3
@1:	jsr	L1170
	ldy	#$89
	ldx	#$06
	jsr	CopyString			; make a new entry in the article table
	ldy	#$21
@2:	dey
	cpy	#$11
	beq	@3
	lda	#$00
	sta	($89),y			; not sure yet.
	beq	@2				; should it return a OPEN icon proxy here?
@3:	rts

tGWPermName:
.asciiz "Write Image"

showSplashDB:
	jsr	L1516				; not sure yet - something to do with the disk device
	ldx	#$18
	ldy	#$80
	jsr	L13A8				; zeroes out a memory region @ $7510 for some reason
	lda	#$01
	sta	l6f05				; no idea yet
	lda	#$00
	sta	l6f10
	sta	l6d87				; ditto here
	lda	#$35
	sta	$01				; enable i/o
	lda	#$01
	sta	$D015				; enable sprite zero
	lda	#$30
	sta	$01				; disable i/o
;	jsr	printCopyright		; prints out the geoPublish copyright box
	lda	#<dbSplash
	ldx	#>dbSplash
	jsr	L1790				; issues a DB
	lda	r0L
	cmp	#$15				; is it the CREATE icon?
	bne	@1
	jmp	fCreate
@1:  cmp	#$05				; is it the OPEN icon?
	bne	@2
	jmp	fOpen
@2:  jmp	L375C				; otherwise, QUIT the application

dbSplash:					; the opening splash DB of geoPublish
.byte $81					; default icon table
.byte $0B					; DBTXTSTR
.byte $10,$10				; position offsets
.word tSelectOption			; text pointer
.byte $12					; DBUSRICON
.byte $02,$18				; position offsets
.word itCreate				; pointer to icon table
.byte $0B					; DBTXTSTR
.byte $47,$22				; position offsets
.word tNewDoc				; text pointer
.byte $05					; OPEN icon
.byte $02,$30				; position offsets
.byte $0B					; DBTXTSTR
.byte $47,$3A				; position offsets
.word tExistDoc				; text pointer
.byte $12					; DBUSRICON
.byte $02,$48				; position offsets
.word itQuit				; icon table pointer
.byte $0B					; DBTXTSTR
.byte $47,$52				; position offsets
.word tDeskTop				; text pointer
.byte $00

itCreate:					; icon table for CREATE
.word iCreate				; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sCreate				; pointer to service routine
itQuit:
.word iQuit					; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sQuit					; pointer to service routine

iCreate:					; CREATE icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$9F,$03,$8f,$80
.byte $00,$00,$00,$03,$98,$c0,$00,$00
.byte $60,$03,$98,$1F,$9e,$3C,$F1,$E3
.byte $98,$1C,$33,$66,$63,$33,$98,$18
.byte $33,$3E,$63,$33,$A4,$98,$18,$3F
.byte $66,$63,$F3,$98,$18,$30,$66,$63
.byte $03,$98,$D8,$33,$66,$63,$33,$8F
.byte $98,$1E,$3E,$39,$E3,$80,$00,$00
.byte $00,$00,$03,$80,$00,$00,$00,$00
.byte $03,$06,$FF,$81,$7F,$05,$FF

iQuit:					; QUIT icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$9F,$03,$80,$07
.byte $C0,$0C,$C0,$03,$80,$0C,$60,$00
.byte $C0,$03,$80,$0C,$6C,$DD,$E0,$03
.byte $80,$0C,$6C,$CC,$C0,$03,$80,$0C
.byte $6C,$CC,$C0,$03,$A4,$80,$0C,$6C
.byte $CC,$C0,$03,$80,$0C,$6C,$CC,$C0
.byte $03,$80,$0D,$ED,$CC,$C0,$03,$80
.byte $07,$C7,$CC,$70,$03,$80,$00,$60
.byte $00,$00,$03,$80,$00,$00,$00,$00
.byte $03,$06,$FF,$81,$7F,$05,$FF

sSave:					; service routine for SAVE icon
	lda	keyVector+1
	beq	sProtect
	jsr	L4723
sCreateLib:					; service routine for CREATE icon
sProtect:					; service routine for PROTECT icon
	lda	#$FF
.byte $2c
sCreate:					; service routine for CREATE icon
	lda	#$15
.byte $2c					; BIT opcode
sQuit:					; service routine for QUIT icon
	lda	#$16

; these are the routines that get called when the user clicks on these icons
.byte $2c
iconADrive:
	lda	#$08
.byte $2c
iconBDrive:
	lda	#$09
.byte $2c
iconCDrive:
	lda	#$0a
.byte $2c
iconDDrive:
	lda	#$0b
	sta	sysDBData
	jmp	RstrFrmDialog

fCreate:					; this creates a new geoPublish datafile
	lda	#$12				; DBUSRICON
	jsr	queryFileName		; prompts the user for the filename
	cmp	#$02				; did the user CANCEL?
	beq	@3
	jsr	L12B8
	jsr	L18C5
	jsr	L142B
	cpx	#$05
	beq	@1
	txa
	bne	@2
	lda	#<tFileExists
	ldy	#>tFileExists
	jsr	L17AF
	clv
	bvc	fCreate
@1:	jsr	L3C6B
	txa
	bne	@2
	jmp	L3E1B
@2:	lda	#<tCreateFileErr
	ldy	#>tCreateFileErr
	jsr	L17D9
@3:	jmp	showSplashDB

.include "4drives.a"			; contains core 4-drive routines

L353A:
	jsr	SetDataDevice
	jsr	L1822				; copies fnBuffer to dFileName
	lda	dFileName
	beq	@3
	lda	#>dFileName
	sta	r0H
	lda	#<dFileName
	sta	r0L
	lda	#$00
	jsr	L1305				; not sure yet. I think it opens the file
	txa
	bne	@2
	lda	dirEntryBuf
	and	#$40				; is it write protected?
	beq	@1				; branch if it isn't.
	lda	#$00
	sta	l6f05				; write protect flag?
	jsr	L19BD				; calls VLIR #$0a
	lda	#<dbWriteProtect
	ldx	#>dbWriteProtect
	jsr	L1790				; issues DB
	lda	r0L
	cmp	#$02				; did the user CANCEL?
	beq	@3
@1:	jsr	L3E1B				; no idea yet.
	txa
	bne	@2
	rts
@2:	lda	#<tOpenFile
	ldy	#>tOpenFile
	jsr	L17D9				; issues an error DB
@3:	ldx	$FFFF				; why this location? - use ldx #$ff instead
	rts

dbWriteProtect:
.byte $81					; default icon table
.byte $0B					; DBTXTSTR
.byte $10,$10				; position offsets
.word tWarnFileProtect			; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$20				; position offsets
.word tWriteProtect			; text pointer
.byte $12					; DBUSRICON
.byte $01,$48				; position offsets
.word itProtect				; icon table pointer
.byte $02					; CANCEL icon
.byte $11,$48				; position offsets
.byte $00

itProtect:
.word iProtect				; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sProtect				; pointer to service routine

iProtect:					; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$C3,$03,$83,$00
.byte $00,$00,$00,$03,$83,$00,$00,$00
.byte $00,$03,$83,$3E,$F8,$F3,$F3,$C3
.byte $83,$66,$ED,$9B,$86,$63,$83,$66
.byte $CD,$9B,$06,$63,$83,$66,$CD,$9B
.byte $07,$E3,$83,$66,$CD,$9B,$06,$03
.byte $83,$66,$CD,$9B,$06,$63,$83,$3E
.byte $CC,$F3,$03,$C3,$80,$06,$00,$00
.byte $00,$03,$80,$7E,$00,$00,$00,$03
.byte $06,$FF,$81,$7F,$05,$FF

L3676:					; I think this is used to rename a file
	jsr	GotoFirstMenu
	jsr	L1946
	lda	#$00				; delimiter
	jsr	queryFileName
	cmp	#$02				; did the user CANCEL?
	beq	@3
	jsr	L1510
	jsr	L18C5
	jsr	L142B
	cpx	#$05
	bne	@2
	jsr	SetDataDevice
	lda	#>dFileName
	sta	r6H
	lda	#<dFileName
	sta	r6L
	jsr	L18BF
	jsr	toggleZP
	jsr	RenameFile
	jsr	toggleZP
	jsr	L1822
	lda	l6f05
	cmp	#$01
	bne	@1
	jmp	L2536
@1:	jmp	L252A
@2:	lda	#<tFileExists
	ldy	#>tFileExists
	jmp	L17AF
@3:	rts

L3750:
	jsr	L3E80
	jsr	L1975
	jmp	showSplashDB

exitGP:					; exits geoPublish
	jsr	L3E80				; 'updates' the geoPublish file
L375C:
	jsr	L1516				; I think this 'flushes' the disk/partition
	jsr	toggleLib			; switch in Page Graphics Library file pointers
	lda	#$01				; for the Master Pages Library File
	jsr	L1305				; set up pointers for MP lib file
	jsr	L1516				; flush the disk/partition again
	jsr	SetProgDevice
	jsr	toggleZP			; restore ZP page for GEOS
	jmp	freeRAM			; frees up expansion RAM & exits geoPublish

L3768:
	jsr	GotoFirstMenu
	jsr	L3E80
	jmp	L1516

recoverGPfile:				; used to recover a geoPublish file
	jsr	GotoFirstMenu
	lda	l6dae
	beq	@1
	jsr	SetDataDevice
	lda	#$00
	sta	l75ad
	jsr	L3E1B
	txa
	bne	@1
	rts
@1:	lda	#<tCantRecover
	ldy	#>tCantRecover
	jmp	L17AF

L378F:
	txa
	beq	@1
	lda	#<tErrorLib
	ldy	#>tErrorLib
	jsr	L17D9
	lda	#$FF
@1:	rts

L379C:
	lda	#$00
	sta	l6f05
	jsr	L19BD				; does this reach the right module?
	lda	#<tWarnFull
	ldy	#>tWarnFull
	jsr	L17AF
	jmp	L375C

L37AE:					; I think this routine will execute the DA.
	pha					; investigate it more later.
        jsr     GotoFirstMenu
        jsr     L1516
        jsr     i_MoveData
.word $8a40					; source (sprite data area)
.word l7e40					; dest
.word $01c0					; # of bytes to move
        pla
        sta     r6L
        asl     a
        asl     a
        asl     a
        asl     a
        clc
        adc     r6L
        adc     #$99
        sta     r6L
        lda     #$00
        adc     #$6C			; what's at $6c99?
        sta     r6H
        lda     #$00
        sta     r0L
        sta     r10L
        jsr     SetProgDevice
        lda     $01
        sta     r15L
        lda     #$35
        sta     $01
        lda     $D017
        pha
        lda     #$00
        sta     $D017
        lda     r15L
        sta     $01
        lda     l4c95+1
        pha
        lda     l4c95
        pha
        jsr     L1413
        pla
        sta     l4c95
        pla
        sta     l4c95+1
        lda     $01
        sta     r15L
        lda     #$35
        sta     $01
        pla
        sta     $D017
        lda     r15L
        sta     $01
        txa
        pha
        jsr     i_MoveData
.word l7e40					; source
.word $8a40					; dest (sprite data area)
.word $01c0					; # of bytes to move
        lda     #$FF
        sta     l6da9
        lda     screencolors
        sta     r2L
        lda     #$8C
        sta     r1H
        lda     #$00
        sta     r1L
        lda     #$03
        sta     r0H
        lda     #$E8
        sta     r0L
        jsr     FillRam
        jsr     i_GraphicsString	; clears the screen w/ pattern #$02
.byte $05					; NEWPATTERN
.byte $02
.byte $01					; MOVEPENTO
.word $0000					; xpos
.byte $10					; ypos
.byte $03					; RECTANGLETO
.word $013f					; xpos
.byte $C7					; ypos
.byte $00
        pla
        tax
        beq     L385F
        cpx     #$03
        bne     L3858
        lda     #<tNotEnufSpace
        ldy     #>tNotEnufSpace
        jmp     L17AF
L3858:  lda     #<tRunDA
        ldy     #>tRunDA
        jsr     L17D9
L385F:  rts

aboutGP:					; issues the about box of geoPublish
	jsr	GotoFirstMenu
	lda	#<dbCredits
	ldx	#>dbCredits
	jmp	L177E				; issues DB

dbCredits:
.byte $81					; default icon table
.byte $0E					; DBSYSOPV
.byte $0B					; DBTXTSTR
.byte $10,$10				; position offsets
.word tGPDesign				; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$20				; position offsets
.word tNames				; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$50				; position offsets
.word tCopyright				; text pointer
.byte $00

tWarnFull:
.byte $18

.byte "WARNING!"
.byte $1B,$16,$50,$00,$40

.byte "Disk near full."
.byte $16,$50,$00,$50

.byte "Please move/delete files"
.byte $16,$50,$00,$60
.asciiz "from disk to continue."

tGPDesign:
.byte $18
.asciiz "  geoPublish designed by:"

tNames:

.byte "Jim Defrisco"
.byte $14,$A4,$00

.byte "Doug Fults"
.byte $14,$84,$00,$15,$4e

.byte "Alice Ng"
.byte $14,$4a,$00,$15,$5c

.byte "Tony Requist"
.byte $14,$A4,$00
.asciiz "Mike Vargas"

tCopyright:
.byte $1B
.asciiz "Copyright 1987, Berkeley Softworks"

tNotEnufSpace:
.byte $18

.byte "Not enough free space on"
.byte $16,$50,$00,$40
.asciiz "disk for desk accessory."

tSelectOption:
.byte $18

.byte "Please Select Option:"
.byte $1B,$00

tNewDoc:
.asciiz "new document"

tExistDoc:
.asciiz "existing document"

tDeskTop:
.asciiz "to deskTop"

tFileExists:
.byte $18

.byte "File exists, choose another."
.byte $1B,$00

; unassigned label
;.byte $18					; remove this text?
;.asciiz "Data file is beyond V1.0"

tOnDisk:
.byte $18

.byte "On disk:"
.byte $1B,$00

tWarnFileProtect:
.byte $18
.asciiz "WARNING!"

tWriteProtect:
.asciiz "This file is write protected"

tNewName:
.byte $18

.byte "Please enter new filename:"
.byte $1B,$00

tInsertDisk:
.byte $18
.asciiz "Insert new disk into disk drive"

tRunDA:
.asciiz "running desk accessory"

tOpenFile:
.asciiz "opening file"

tCreateFileErr:
.asciiz "creating file"

tCantRecover:
.byte $18

.byte "Can't recover"
.byte $1B,$00

tFILE:
.asciiz "FILE: "

tStartPage:
.asciiz "Starting page #"

tMasterPage:
.asciiz "Master pages: 1    2"

tFirstPage:
.asciiz "First page:    L    R"

tDefGutters:
.byte $18

.byte "Setting default gutters"
.byte $1B,$00

tLeft:

.byte "Left"
.byte $14,$9A,$00
.asciiz "Right"

tTop:

.byte "Top"
.byte $14,$9A,$00
.asciiz "Bottom"

tCantEmptyLib:
.byte $18

.byte "Can't load empty library"
.byte  $1B,$00

tNewLib:

.byte "new "
tLibrary:
.asciiz "Library"

tNoLayoutLib:
.byte $18
.asciiz "No layout"			; library on disk"

tNoMasterLib:
.byte $18
.asciiz "No master page"		; library on disk"

tNoPageGfxLib:
.byte $18
.asciiz "No Page Graphics"

tLibDisk:

.byte "library on disk"
.byte $1b,$00

tLayoutLib:
.asciiz "Layout lib"

tMasterLib:
.asciiz "Master lib"

tGraphicsLib:
.asciiz "Graphx lib"

tEmpty:
.byte $19

.byte "Empty"
.byte $1B,$00

tErrorLib:
.byte $18

.byte "Error accessing library"
.byte $1B,$00

; not needed as the library routines can strip bitmaps from the library file
;tCantSaveMaster:
;.byte $18
;.asciiz "Can't save master page with"

;tBitmapsLib:

;.byte "bitmaps in library"
;.byte $1B,$00

tWarnLayout:
.byte $18
.asciiz "WARNING: This will overwrite"

tCurLayout:

;.byte "current layout"
.byte "current page mode"
.byte $1B,$00

;tCurMaster:
;
;.byte "current master page"
;.byte $1B,$00

;tLibrary:
;.asciiz "Library"

;tFNameExists:
;.byte $18
;.asciiz "File name already exists"

tArticle:
.byte $18

.byte "Article:"
.byte $1B,$00

L3C6B:  jsr     SetDataDevice
        lda     #>fnBuffer
        sta     L3D85+1
        lda     #<fnBuffer
        sta     L3D85
        jsr     L1510
        lda     #>L3D85
        sta     r9H
        lda     #<L3D85
        sta     r9L
        lda     #$00
        sta     r10L
        jsr     L1416
        txa
        bne     L3D05
        jsr     L1822
        lda     #>dFileName
        sta     r0H
        lda     #<dFileName
        sta     r0L
        lda     #$00
        jsr     L1305
        txa
        bne     L3D05
        jsr     L2178
        lda     #$7F
        sta     l6f07
L3CA8:  jsr     L144F
        dec     l6f07
        bne     L3CA8
	jsr	i_FillRam
.word $0245
.word l6ef9
.byte $00
        lda     #$01
        sta     l6f07+1
        sta     l6f01
        jsr     L3D06
        lda     #$00
        sta     l6d87
        lda     #$02
        sta     l6f04
        jsr     L0EC5
        ldy     #$05
        sty     l7125
        sty     l7126
        sty     l7126+1
        sty     l7126+2
        ldx     #$08
        lda     #$FF
L3CE2:  sta     l6f09,x
        dex
        bpl     L3CE2
        jsr     L3E58
        txa
        bne     L3D05
        jsr     L3D42
        jsr     L1295
        txa
        bne     L3D05
        jsr     L1298
        txa
        bne     L3D05
        jsr     L4261
        txa
        bne     L3D05
        ldx     #$00
L3D05:  rts
L3D06:  ldy     #$0B
        lda     #$00
L3D0A:  sta     l7131+2,y
        dey
        bpl     L3D0A
        lda     #$09
        sta     l7131+3
        inc     l713a
        lda     #$18
        sta     l7136
        lda     #$AA
        sta     l7136+1
        sta     l7136+2
        lda     #$02
        sta     l7136+3
        ldy     #$01
        sty     l7131+1
        sty     l7129
        dey
        sty     l7131
        sty     l7129+1
        lda     #$18
        sta     l7129+2
        sta     l7129+3
        rts

L3D42:
	jsr	i_FillRam
.word $016c
.word l739f
.byte $00
	lda	#<l3d51
	ldx	#>l3d51
	jmp	L4296				; issues InitRam

l3d51:
.word l739f					; start address
.byte $20					; initalize 32 bytes
.byte $fc,$FF,$FC,$FF,$FC,$FF,$FC,$FF; data
.byte $fc,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.byte $fc,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.byte $fc,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.word l73c2					; start address
.byte $02					; initialize 2 bytes
.word l73c2					; data
.word l73c9					; start address
.byte $02					; initialize 2 bytes
.byte $ff,$FF				; data
.word l73c6					; start address
.byte $02					; initialize 2 bytes
.byte $0B,$75				; data
.word $0000

L3D85:
.byte $00,$00				; appears to be file icon data
.byte $03,$15,$BF,$FF,$FF,$FF,$80	; It is for a geoPublish data file
.byte $00,$01,$A2,$E8,$BD,$B2,$88,$A1
.byte $AA,$CA,$BD,$A6,$8A,$85,$A2,$EF
.byte $BD,$80,$00,$01,$FF,$FF,$FF,$80
.byte $00,$01,$BF,$7E,$FD,$BF,$7E,$FD
.byte $BF,$7E,$FD,$BF,$7E,$FD,$BF,$7E
.byte $FD,$BF,$7E,$FD,$BF,$7E,$FD,$BF
.byte $7E,$FD,$BF,$7E,$FD,$80,$00,$01
.byte $FF,$FF,$FF
.byte $83,$07,$01,$00,$00,$FF,$FF,$00,$00
.asciiz "Publish Doc V1.0"		; this should be dPermName?
.byte $00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.asciiz "geoPublish  V1.0"
.byte $00,$00,$00

dPermName:					; is it a bug? this label should go up two labels more
.asciiz "Publish Doc "

L3E1B:  jsr     L2178
        txa
        bne     L3E31
        jsr     L3E32
        txa
        bne     L3E31
        jsr     L0EC5
        lda     #$FF
        sta     l6dae
        ldx     #$00
L3E31:  rts
L3E32:  jsr     L3E42
        txa
        bne     L3E41
        jsr     L2154
        txa
        bne     L3E41
        jsr     L2180
L3E41:  rts

L3E42:
	jsr	L3E68				; calls vlir #$00 of geoPub datafile
	jsr	L1431				; and reads it in
	txa
	bne	@1
	ldx	#$07
@2:	lda	l6ef9,x			; sets zp variables.
	sta	$B1,x
	dex
	bpl	@2
	ldx	#$00
@1:	rts

L3E58:
	ldx	#$07
@1:	lda	$B1,x
	sta	l6ef9,x			; copies some variables to $6ef9.
	dex
	bpl	@1
	jsr	L3E68				; opens geoPub datafile's VLIR #$00
	jmp	L1404				; calls WriteRecord, on VLIR #$00
L3E68:
	jsr	L2178				; opens the geoPublish data file
	lda	#>l6ef9
	sta	r7H
	lda	#<l6ef9
	sta	r7L				; buffer $6ef9 for the VLIR module
	lda	#$02
	sta	r2H
	lda	#$45				; max # of $0245 bytes loaded in
	sta	r2L
	lda	#$00				; calls VLIR #$00 of the geoPublish data file
	jmp	PointRecord

L3E80:
	jsr	L3E58				; calls the datafile's VLIR #$00 and writes it back
	txa					; to disk.
	bne	@2
	jsr	L1CAB				; calls the datafile's VLIR #$xx and writes it back
	txa					; to disk. Also calls the relevant geoPublish data's
	bne	@2				; VLIR module, moves geoPublish data around, and writes
	ldx	#$1F				; it back to disk.
@1:	lda	fileHeader+4,x
	sta	l6ed9,x
	dex
	bpl	@1
	lda	#$FF
	sta	l6dae
	ldx	#$00
@2:	rts

DocSetup:
	lda	#<dbDocSetup
	ldx	#>dbDocSetup
	jmp	L177E

rBox:
	lda	#>l3eb1
	sta	appMain+1
	lda	#<l3eb1
	sta	appMain
	rts

l3eb1:
        lda     #$00
        sta     appMain
        sta     appMain+1
        sta     iconSelFlag
        lda     #$F5
        ldx     #$00
        jsr     L128C
        lda     #$00
        sta     r11H
        lda     #$88
        sta     r11L
        lda     #$2C
        sta     r1H
        lda     #>dFileName
        sta     r0H
        lda     #<dFileName
        sta     r0L
        jsr     PutString
        lda     l6f01+1
        beq     L3EE5
        lda     #$01
        ldy     #$00
        beq     L3EE7
L3EE5:  ldy     #$01
L3EE7:  jsr     L3F49
        lda     l6f01+2
        beq     L3EF5
        lda     #$01
        ldy     #$00
        beq     L3EF7
L3EF5:  ldy     #$01
L3EF7:  jsr     L3F15
        jmp     L3F65

sBox0:
        lda     #$00
        pha
        ldy     #$01
L3F02:  jsr     L3F15
        pla
        beq     L3F0A
        lda     #$FF
L3F0A:  sta     l6f01+2
        rts

sBox1:
        lda     #$01
        pha
        ldy     #$00
        beq     L3F02
L3F15:  pha
	tya
	jsr	SetPattern
	jsr	i_Rectangle
.byte $49,$4e				; y coordinates
.word $0099					; x1
.word $009e					; x2
	pla
	jsr	SetPattern
	jsr	i_Rectangle
.byte $49,$4e				; y coordinates
.word $00b1					; x1
.word $00b6					; x2
	rts

sBox2:
        lda     #$00
        pha
        ldy     #$01
L3F36:  jsr     L3F49
        pla
        beq     L3F3E
        lda     #$FF
L3F3E:  sta     l6f01+1
        rts

sBox3:
        lda     #$01
        pha
        ldy     #$00
        beq     L3F36
L3F49:  pha
	tya
	jsr	SetPattern
	jsr	i_Rectangle
.byte $55,$5a				; y coordinates
.word $0099					; x1
.word $009e					; x2
	pla
	jsr	SetPattern
	jsr	i_Rectangle
.byte $55,$5a				; y coordinates
.word $00b1					; x1
.word $00b6					; x2
	rts
L3F65:  jsr     L12F0
	jsr	i_Rectangle
.byte $36,$42				; y coordinates
.word $0098					; x1
.word $00ae					; x2
	jsr	i_FrameRectangle
.byte $36,$42				; y coordinates
.word $0098					; x1
.word $00ae					; x2
.byte $ff					; pattern
        jsr     L3FB7
        lda     #$39
        sta     r1H
        lda     #$00
        sta     r1L
        lda     #$03
        sta     r2L
        lda     #$00
        sta     r11H
        lda     #$9A
        sta     r11L
        lda     #>l3fa2
        sta     keyVector+1
        lda     #<l3fa2
        sta     keyVector
        jsr     L18BF
        jmp     GetString

l3fa2:
        jsr     L18BF
        jsr     L100A
        bne     L3FB0
        lda     r1L
        cmp     #$F1
        bcc     L3FB3
L3FB0:  jmp     L3F65
L3FB3:  sta     l6f01
        rts
L3FB7:  ldx     #$00
        lda     l6f01
        sec
L3FBD:  sbc     #$64
        bcc     L3FC4
        inx
        bpl     L3FBD
L3FC4:  ldy     #$00
        txa
        beq     L3FDD
        clc
        adc     #$30
        sta     fnBuffer
        lda     l6f01
        sec
        sbc     #$64
        dex
        beq     L3FDA
        sbc     #$64
L3FDA:  iny
        bpl     L3FE0
L3FDD:  lda     l6f01
L3FE0:  jsr     L10D5
        pha
        txa
        cmp     #$30
        bne     L3FED
        cpy     #$00
        beq     L3FF1
L3FED:  sta     fnBuffer,y
        iny
L3FF1:  pla
        sta     fnBuffer,y
        lda     #$00
        iny
        sta     fnBuffer,y
        rts

dbDocSetup:
.byte $81					; default icon table
.byte $0B					; DBTXTSTR
.byte $34,$0C				; position offsets
.word tFILE					; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$1E				; position offsets
.word tStartPage				; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$2E				; position offsets
.word tMasterPage				; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$3A				; position offsets
.word tFirstPage				; text pointer
.byte $12					; DBUSRICON
.byte $0B,$28				; position offsets
.word itBox0				; box icon table pointer
.byte $12					; DBUSRICON
.byte $0E,$28				; position offsets
.word itBox1				; box icon table pointer
.byte $12					; DBUSRICON
.byte $0E,$34				; position offsets
.word itBox3				; box icon table pointer
.byte $12					; DBUSRICON
.byte $0B,$34				; position offsets
.word itBox2				; box icon table pointer
.byte $01					; OK ICON
.byte $11,$48				; position offsets
.byte $13					; DB_USR_ROUT
.word rBox					; pointer to DB routine
.byte $00

itBox0:
.word iBox					; pointer to icon data
.byte $00,$00				; position offsets
.byte $01,$08				; width/height attributes
.word sBox0					; pointer to service routine
itBox1:
.word iBox					; pointer to icon data
.byte $00,$00				; position offsets
.byte $01,$08				; width/height attributes
.word sBox1					; pointer to service routine
itBox2:
.word iBox					; pointer to icon data
.byte $00,$00				; position offsets
.byte $01,$08				; width/height attributes
.word sBox2					; pointer to service routine
itBox3:
.word iBox					; pointer to icon data
.byte $00,$00				; position offsets
.byte $01,$08				; width/height attributes
.word sBox3					; pointer to service routine

setGutters:  jsr     L1993
        bne     L4060
        jsr     L4A92
        beq     L4060
        stx     L41FA
        ldx     #$12			; DBUSRICON
        stx     L41F5
        bne     L4078
L4060:  ldx     #$03
L4062:  lda     l7125,x
        sta     l6daf,x
        dex
        bpl     L4062
        lda     #>tDefGutters
        sta     r5H
        lda     #<tDefGutters
        sta     r5L
        lda     #$00			; delimiter
        sta     L41F5
L4078:  pha
        lda     #$00
        sta     L49A3
        lda     #<dbSetGutters
        ldx     #>dbSetGutters
        jsr     L177E
        lda     #$FF
        sta     L49A3
        jsr     L4111
        pla
        beq     L4096
        jsr     L4A95
        clv
        bvc     L40A1
L4096:  ldx     #$03
L4098:  lda     l6daf,x
        sta     l7125,x
        dex
        bpl     L4098
L40A1:  rts

l40a2:
	lda	#$00
	sta	appMain+1
	sta	appMain
L40AA:
	lda	#$03
	sta	L49A2
@1:	jsr	L4190				; draws a rectangle onto the DB
	jsr	L417D				; sets more pseudoregs (r1H & r11)
	lda	l6daf,x
	sta	r0L
	lda	#$00
	sta	r0H
	lda	#$C0
	jsr	PutDecimal
	dec	L49A2
	bne	@1
;	jmp	L40CB				; remove this line.

L40CB:
	jsr	L4190				; draws a rectangle onto the DB
	ldx	L49A2
	lda	l6daf,x
	jsr	L10D5
	ldy	#$00
	cpx	#$30
	beq	@2
	stx	L49A4
	iny
@2:  sta	L49A4,y
	iny
	lda	#$00
	sta	L49A4,y
	jsr	L417D				; sets pseudoregs for GetString
	sec
	lda	r1H
	sbc	#$06
	sta	r1H
	lda	#>L49A4
	sta	r0H
	lda	#<L49A4
	sta	r0L
	lda	#$02
	sta	r2L
	lda	#$00
	sta	r1L
	lda	#>L4111
	sta	keyVector+1
	lda	#<L4111
	sta	keyVector
	jmp	GetString

L4111:  lda     #>L49A4
        sta     r0H
        lda     #<L49A4
        sta     r0L
        jsr     L100A
        beq     L4120
        bne     L4133
L4120:  lda     #$51
        ldx     L49A2
        cpx     #$02
        bcc     L412B
        lda     #$49
L412B:  sta     r0H
        lda     r1L
        cmp     r0H
        bcc     L4151
L4133:  ldx     L49A2
        lda     l7125,x
        sta     r0L
        pha
        bit     L49A3
        bmi     L4150
        jsr     L4190
        jsr     L417D
        lda     #$00
        sta     r0H
        lda     #$C0
        jsr     PutDecimal
L4150:  pla
L4151:  ldx     L49A2
        sta     l6daf,x
        inc     L49A2
        lda     L49A2
        cmp     #$04
        bne     L4166
        lda     #$00
        sta     L49A2
L4166:  bit     L49A3
        bmi     L416E
        jsr     L40CB
L416E:  rts

sDefault:
	ldx	#$03
@1:	lda	l7125,x
	sta	l6daf,x
	dex
	bpl	@1
	jmp	L40AA

L417D:					; sets registers for the PutDecimal routine
	ldx	L49A2
	lda	L41C8,x
	sta	r1H
	lda	L41D0,x
	sta	r11H
	lda	L41CC,x
	sta	r11L
	rts

L4190:					; Draws an appropriate rectangle onto the DB
	ldx	L49A2
	lda	L41D4,x
	sta	r2L
	clc
	adc	#$0B
	sta	r2H
	lda	L41D8,x
	sta	r3L
	sta	r4L
	lda	L41DC,x
	sta	r3H
	sta	r4H
	lda	#$0F
	ldx	#$0A
	jsr	l186f
	jsr	L12F0
	jsr	Rectangle
	lda	#$FF
	jmp	FrameRectangle

rGutters:
	lda	#>l40a2
	sta	appMain+1
	lda	#<l40a2
	sta	appMain
	rts

L41C8:
.byte $50,$50,$60,$60			; used for PutDecimal & GetString
L41CC:
.byte $64,$BE,$64,$BE
L41D0:
.byte $00,$00,$00,$00

L41D4:					; used in drawing rectangles in the DB
.byte $48,$48,$58,$58
L41D8:
.byte $63,$BD,$63,$BD
L41DC:
.byte $00,$00,$00,$00

; once the gutters are set with new values, then the DEFAULT icon will show up, allowing
; the user to revert to default values.
dbSetGutters:
.byte $81					; default icon table
.byte $0C					; DBVARSTR
.byte $28,$10				; position offsets
.byte r5					; pseudo-register used
.byte $0B					; DBTXTSTR
.byte $10,$30				; position offsets
.word tLeft					; text pointer
.byte $0B					; DBTXTSTR
.byte $10,$40				; position offsets
.word tTop					; text pointer
.byte $01					; OK ICON
.byte $11,$48				; position offsets
.byte $13					; DB_USR_ROUT
.word rGutters				; pointer to DB routine
L41F5:
;.byte $00					; temporary measure
.byte $12					; DBUSRICON
.byte $01,$48				; position offsets
.word itDefault				; DEFAULT icon table pointer
L41FA:
.byte $0B					; DBTXTSTR
.byte $10,$20				; position offsets
.word tArticle				; text pointer
.byte $0C					; DBVARSTR
.byte $38,$20				; position offsets
.byte r7					; pseudo-register used
.byte $00

itDefault:
.word iDefault				; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sDefault				; pointer to service routine

iDefault:					; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$B8,$03,$9F,$00
.byte $0F,$00,$0E,$63,$99,$80,$18,$00
.byte $06,$63,$98,$CF,$3C,$F3,$36,$F3
.byte $98,$D9,$99,$1B,$36,$63,$98,$D9
.byte $98,$FB,$36,$63,$98,$DF,$99,$9B
.byte $36,$63,$98,$D8,$19,$9B,$36,$63
.byte $99,$99,$99,$9B,$76,$63,$9F,$0F
.byte $18,$F9,$F6,$33,$80,$04,$00,$82
.byte $03,$80,$04,$00,$81,$03,$06,$FF
.byte $81,$7F,$05,$FF

L4261:
	jsr	i_FillRam
.word $0261					; # of bytes to fill
.word l713e					; start address
.byte $00					; fill byte
	jsr	L426F
	jmp	L1CAB

L426F:
	jsr	L15B7
	jsr	i_FillRam
.word $0ffc					; # of bytes to fill
.word l5a84					; start address
.byte $00					; fill byte
	ldy	#$FF
	sty	l5a87+1
	sty	l5a87
	sty	l75ad+1
	lda	#>dataDrive
	sta	l5a84+1
	lda	#<dataDrive
	sta	l5a84
	jmp	L155A
	lda	#<l429d
	ldx	#>l429d
L4296:
	sta	r0L
	stx	r0H
	jmp	InitRam

l429d:
.word l739f					; start address
.byte $20					; initalize 32 bytes
.byte $FC,$FF,$FC,$FF,$FC,$FF,$FC,$FF; data
.byte $FC,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.byte $FC,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.byte $FC,$FF,$FC,$FF,$FC,$FF,$FC,$FF
.word l73bf					; start address
.byte $02					; initalize 2 bytes
.byte $00,$00				; data
.word $0000

L42C7:
	ldx	a5H				; check PG mode
	bpl	@3
	ldx	#<tNoPageGfxLib
	ldy	#>tNoPageGfxLib
	bne	@1				; relative JMP
@3:	ldx	#<tNoLayoutLib
	ldy	#>tNoLayoutLib
	jsr	L1993
	beq	@1
	ldx	#<tNoMasterLib
	ldy	#>tNoMasterLib
@1:	stx	r5L
	sty	r5H
	lda	#<dbCreateLib
	ldx	#>dbCreateLib
	jsr	L177E
	lda	r0L
	bpl	@2				; did the user cancel?
	jsr	L42E7
@2:  rts

L42E7:
	jsr	SetProgDevice
	jsr	readDiskName
	sta	fnBuffer			; .A was already set to $00 in readDiskName
	sta	renTable			; turn off drive/disk icons
	jsr	replaceDB			; restores the DB table for renaming a file
	jsr	L18C2				; loads r5 w/ $6e23
	lda	#<dbNameFile
	ldx	#>dbNameFile
	jsr	L177E
	lda	fnBuffer
	beq	@3
	lda	r0L
	cmp	#$02
	beq	@1
	jsr	L18C5				; loads r6 w/ $6e23
	jsr	L142B				; issues FindFile
	cpx	#$05				; FILE NOT FOUND error code
	beq	@2
	lda	#<tFileExists
	ldy	#>tFileExists
	jsr	L17AF
	clv
	bvc	L42E7
@2:  jmp	createLibFile
;	rts
@3:	lda     #$02
@1:	rts

createLibFile:				; creates a geoPublish library file.
	jsr	L43B2				; checks progDevice for at least 4 disk blocks free
	bpl	@4
	lda	a5H				; check PG mode
	bpl	@5				; branch if it isn't
	jsr	PgGrLibFile			; set the file header for Page Graphics
	bra	@2

@5:	jsr	L1993				; check operating mode
	bne	@1				; Branch on Master Pages mode
	jsr	L438C
	clv
	bvc	@2
@1:	jsr	L439F
@2:	lda	#>fnBuffer
	sta	L43E0+1
	lda	#<fnBuffer
	sta	L43E0				; icon header points to the filename
	lda	#>L43E0
	sta	r9H
	lda	#<L43E0
	sta	r9L				; r9 points to icon header.
	lda	#$00
	sta	r10L
	jsr	L1416				; calls SaveFile
	jsr	L18BF				; loads r0 with $6e23
	lda	L49A2
	jsr	L1305				; saves file pointers associated w/ library file
	lda	L49A2
	jsr	L1343				; and 'opens' the file somehow.
	lda	#$20
	sta	L49A3
@3:	jsr	L144F				; calls AppendRecord/InsertRecord
	dec	L49A3
	bpl	@3				; filling 32 VLIR records
	ldx	#r1
	jsr	l4900				; load r1 w/ $6f15
	lda	#$01
	sta	r0H
	lda	#$A0
	sta	r0L
	jsr	ClearRam			; zero out $6f15-70b4
	jsr	L44A2				; writes VLIR #$00 of library file.
	lda	#$00
@4:	rts

L438C:					; moves text pointers & icon data for layout lib file
	jsr	i_MoveData
.word tLayoutLib				; source
.word t442d					; dest
.word $0006					; # of bytes to move
	jsr	i_MoveData
.word iPage					; source
.word l43e5					; dest
.word $000F					; # of bytes to move
	rts

L439F:					; moves text pointers & icon data for Master lib file
	jsr	i_MoveData
.word tMasterLib				; source
.word t442d					; dest
.word $0006					; # of bytes to move
	jsr	i_MoveData
.word iMaster
.word l43e5
.word $000F
	rts

PgGrLibFile:				; moves text pointers & icon data for Master lib file
	jsr	i_MoveData
.word tGraphicsLib			; source
.word t442d					; dest
.word $0006					; # of bytes to move
	jsr	i_MoveData
.word iGraphics
.word l43e5
.word $000F
	rts

L43B2:
	lda	#$82
	sta	r5H
	lda	#$00
	sta	r5L
	jsr	CalcBlksFree
	lda	r4H
	cmp	#$00				; if the high byte is set, skip block space checking
	bne	@1
	lda	r4L
	cmp	#$04				; must have at least 4 cbm disk blocks free.
@1:	bcs	@2
	lda	#<tCreateFileErr
	ldy	#>tCreateFileErr
	ldx	#$03
	jsr	L17D9				; otherwise, issue error message
	lda	#$02
	rts
@2:	lda	#$FF
	rts

L43E0:
.byte $00,$00
.byte $03,$15,$BF				; appears to be datafile icon data
l43e5:
.byte $00,$00,$00,$00,$00,$00,$00,$00; icon data to show PL or MP
.byte $00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$7F,$FF
.byte $F0,$75,$D7,$58,$7A,$EB,$AC,$5D
.byte $75,$D6,$4F,$FF,$FE,$48,$20,$82
.byte $48,$20,$82,$48,$20,$82,$48,$20
.byte $82,$48,$20,$82,$48,$20,$82,$48
.byte $20,$82,$28,$20,$82,$18,$20,$82
.byte $0F,$FF,$FE
						; GEOS file, DATA & VLIR & null pointers
.byte $83,$03,$01,$00,$00,$FF,$FF,$00,$00
t442d:					; Permanent name
.byte $00,$00,$00,$00,$00,$00,$20,$6C,$69,$62,$20,$20,$56,$31,$2E,$30
.byte $00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00
.byte $00,$00,$00,$00,$00,$00,$00,$00

dbCreateLib:
.byte $81					; default icon table
.byte $0C					; DBVARSTR
.byte $10,$10				; position offsets
.byte r5					; pseudo-register used
.byte $0b					; DBTXTSTR
.byte $70,$10				; position offsets
.word tLibDisk				; text pointer
.byte $12					; DBUSRICON
.byte $02,$30				; position offsets
.word itCreateLib				; CREATE icon table pointer
.byte $0B					; DBTXTSTR
.byte $47,$3A				; position offsets
.word tNewLib				; text pointer
.byte $02					; CANCEL icon
.byte $02,$48				; position offsets
.byte $00

itCreateLib:
.word iCreate				; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sCreateLib				; pointer to service routine

iPage:					; part of icon data saying 'PL' (Page Layout)
.byte $07,$C8,$00,$04,$48,$00,$07,$C8,$00,$04,$08,$00,$04,$0F,$80
iMaster:					; part of icon data saying 'MP' (Master Pages)
.byte $18,$C7,$C0,$15,$44,$40,$12,$47,$C0,$10,$44,$00,$10,$44,$00
iGraphics:					; part of icon data saying 'PG' (Page Graphics)
.byte $07,$cf,$80,$04,$48,$00,$07,$c9,$80,$04,$08,$80,$04,$0f,$80

L44A2:					; writes VLIR #$00 of a library file
	jsr	L44A8				; sets params for VLIR #$00
	jmp	L1404				; issues WriteRecord
L44A8:					; opens VLIR #$00, which contains library name entries
	ldx	#r7
	jsr	l4900				; loads r7 w/ $6f15 for buffer area.
	lda	#$01
	sta	r2H
	lda	#$A0
	sta	r2L				; read up to $01a0 bytes
	lda	#$00				; library name entries are in VLIR #$00
	jmp	PointRecord
;	rts

callLibrary:				; calls the MP or PL library file.
	jsr	L12C4				; calls calcblksfree, but on DataDevice
	jsr	L3E80				; calls in the geoPublish datafile and somehow
						; saves it with VLIR #$00, $01 & geoPub data VLIR
	lda	$d6				; check PG or MP mode as $d6 is tinkered with in the
	cmp	#$73				; L3E80 call. Branch on MP mode.
	beq	@6
	lda	#$5a				; restore $d6 for PG mode usage
	sta	$d6
@6:	jsr	L1516				; seems to modify dirEntryBuf of datafile and writes it
	ldx	l6f06				; seems to contain current operating mode
	cpx	#$12				; is it Page Graphics mode?
	bne	@4				; take branch if it isn't Page Graphics
	jsr	toggleLib			; toggle in PG file pointers
	ldx	#$ff				; Page Graphics flag
.byte $2c
@4:	ldx	#$00
	stx	a5H				; flag - $00 = MP or PL, $ff = PG mode

	ldx	#$02
	jsr	L1993				; checks to see if MP or PL mode is current mode.
	beq	@1				; if equal, PL mode is current. Otherwise, it's MP
	ldx	#$01
@1:	stx	L49A2				; flag for master pages/page layout mode
	txa
	jsr	L13B2				; checks to see if the layout library exists
	bne	@2
	jsr	L42C7				; doesn't exist - prompt the user for a new library
						; and create it if necessary
	cmp	#$02				; did the user CANCEL?
	beq	@3
@2:	jsr	L44E9				; opens VLIR #$00 of library file & loads $af w/ $6f15
	bne	@3
	jmp	L4507				; goes to the requestor portion of the library file.
@3:	lda	a5H				; check PG mode
	bpl	@5				; take branch if it isn't.
	jsr	toggleLib			; put in file pointers for MP library mode
@5:	clc
	rts

L44E9:
	lda	L49A2
	jsr	L1343				; opens the library file
	bne	@1
	jsr	L44A8				; opens VLIR #$00 of library file.
	jsr	L1431				; calls ReadRecord
	jsr	L378F				; checks for disk error
	bne	@1
	ldx	#$af
	jsr	l4900				; loads $af w/ 6f15 pointing to library entry names
	lda	#$00
@1:	rts

L4507:
	lda	#<dbLibrary
	ldx	#>dbLibrary
	jsr	L177E
	lda	r0L
	cmp	#$16				; did the user CANCEL?
	bne	@1
	clc
	bcc	@4
@1:	cmp	#$05				; is it OPEN?
	bne	@2
	jsr	L45C1
	bne	@3
	sec
	bcs	@4
@2:	jsr	L4530				; was it a SAVE icon?
@3:	clc
@4:	php
	jsr	L44A2				; writes VLIR #00 of library file
	jsr	L3E42				; opens VLIR #$00 of geoPub datafile and reads it in
						; this routine also 'closes' the library file.
	lda	a5H				; check PG mode
	bpl	@5				; take branch if it isn't.
	jsr	toggleLib			; put in file pointers for MP library mode
@5:	plp
	rts

L4530:
	ldx	L49A3				; get index
	stx	$ff				; save it
	jsr	L4822				; loads r0 w/ pointer to library entry
	jsr	L4845				; guessing here, but loads .A with VLIR # of lib file
	sta	r11H				; save it
;	sta	r15L
;	jsr	L1999				; compares value at $6f04 for PG or MP mode
;	bne	@1				; take branch if PL/PG mode is present
; the following JSR is not needed because bitmaps can be stripped
;	jsr	L457A				; checks to see if bitmaps are present in MP mode
;	bpl	@1
;	pla
;	pla
;	rts
;@1:
;	lda	r15L
	jsr	PointRecord
	jsr	InitLibValues		; sets variables for MP, PL & PG mode
	jsr	RemoveBMP			; removes bitmaps from geoPublish data
	jsr	L1404				; calls WriteRecord
	jsr	restoreBMP			; and restore the geoPublish data
	jsr	L378F				; checks disk error
;	txa
	bne	L4530-1			; @3
	ldx	$ff				; get index
;	stx	L49A3				; save index
	jsr	L4822				; set r0 again
	lda	l6e12				; check name of library entry
	bne	@2
	jsr	L4591				; assign a default name for library entry
@2:	ldx	#r1
	jsr	L487B				; loads r1 w/ $6e12
	ldx	#r1
	ldy	#r0
	jmp	CopyString			; copies the library entryname to its buffer
;@3:	rts

L4591:					; assigns a default library name
	lda	a5H				; check PG mode
	bpl	@4				; take branch if PG mode isn't used
	ldx	#<tGraphicsLib
	ldy	#>tGraphicsLib
	bne	@1				; relative JMP
@4:	ldx	#<tLayoutLib
	ldy	#>tLayoutLib
	jsr	L1993
	beq	@1
	ldx	#<tMasterLib
	ldy	#>tMasterLib
@1:	stx	r1L
	sty	r1H
	ldy	#$06
@2:	lda	(r1L),y
	sta	l6e12,y			; seems to copy Master/Layout to library name
	dey					; entry in case if user did not input one
	bpl	@2
;	lda	L49A3				; get library name index number - or $ff?
	lda	r11H
	jsr	L10D5				; not sure - seems to 'ASCII' the index number
	cpx	#$30
	beq	@3
	stx	l6e18
@3:	sta	l6e18+1
	lda	#$00
	sta	l6e18+2			; seems to add a decimal number after the default
	rts					; library name entry

L45C1:					; opens a library entry
	ldx	L49A3				; index into library entry
	jsr	L4822				; loads r0 w/ library entry
	jsr	L4840				; checks to make sure it isn't empty.
	bne	@1
	lda	#<tCantEmptyLib
	ldy	#>tCantEmptyLib
	jsr	L17AF
	lda	#$02				; stimulate CANCEL
	rts
@1:	jsr	L4607				; checks to see if data actually exists and prompts
	cpx	#$02				; the user to overwrite contents
	beq	@4				; maybe not needed for PG mode?
	jsr	L49A7				; opens the geopublish file & clears bitmaps
	ldx	L49A3				; get library entry index
	jsr	L4822				; loads r0 w/ library entry
	jsr	L4845				; gets VLIR # in the library file for the requested data
	jsr	InitLibValues		; sets variables for MP, PL & PG mode
	jsr	PointRecord
	jsr	L1431				; calls ReadRecord to read in the library data at that
	txa					; VLIR #
	bne	@3				; branch on error
	jsr	L1993				; check MP or PL mode
	beq	@2				; branch on PL mode
	jsr	L155A				; resets the values at $6ed4-$6ed8
	lda	a5H				; check PG mode
	bpl	@5				; take branch if PG mode isn't used
	jsr	restorePGLib		; cleans up the PG object datastream as loaded in by
						; the PG library file.
	lda	#$ff				; set flags to force geoPublish into saving the
	sta	l75ad				; the newly imported graphics object data into
	sta	l75ad+1			; the relevant geoPublish datafile's VLIR record

@5:	jsr	L170B				; seems to go through the graphic objects in memory
@2:	ldx	#$00				; for some reason.
@3:	jsr	L378F				; check error
@4:	txa
	rts

L4607:					; (52 bytes)
	ldx	#<tCurLayout
	ldy	#>tCurLayout
	stx	r14L
	sty	r14H
	lda	a5H				; check PG mode
	bpl	@1				; take branch if PG mode is not used
	lda	PGData+6			; check # of items in PG mode
	pha
	bra	@3				; relative JMP
@1:	lda	l713e				; is there data in PL mode?
	pha
	jsr	L1993				; check library flag (MP or PL)
	beq	@3
	pla
	lda	l73c8				; is there data in MP mode?
	ora	l73bf
	ora	l73c0
	pha
@3:	pla
	beq	@2
	lda	#<tWarnLayout
	ldy	#>tWarnLayout
	jsr	L199F				; issue DB
	ldx	r0L
@2:	rts

InitLibValues:				; set initial library file values
	pha
	lda	a5H				; check to see of PG mode is used
	bpl	@2				; take branch if it isn't used
	LoadW	r7, PGData			; loads r7 w/ $5a80
	ldx	#$00				; max size is $1000
	ldy	#$10
	bne	@1				; relative JMP
@2:	lda	#>l713e
	sta	r7H
	lda	#<l713e
	sta	r7L				; start address $713e for PL mode
	ldx	#$21
	ldy	#$02				; max size $0221 for Page Layout mode
	jsr	L1993
	beq	@1				; take branch in PL mode
;	lda	#>l73c2
;	sta	l73c2+1
;	lda	#<l73c2
;	sta	l73c2				; this code snippet doesn't make sense
	lda	#>l739f
	sta	r7H
	lda	#<l739f
	sta	r7L				; start address $739f for Master Pages mode
	ldx	#$6C
	ldy	#$01				; max size $016c for Master Pages mode
@1:	stx	r2L
	sty	r2H
	pla
	rts

RemoveBMP:					; removes the bitmaps from MP or PG modes
	ldx	L49A2				; check to see of PL mode is used
	cpx	#$02
	beq	RemoveBMP-1			; take branch if PL mode is used
	pha					; preserve .A
	jsr	stashGPData			; stash geoPublish data into the REU
	lda	#$00				; flag for deleting bitmaps from memory
	sta	r12H
	jsr	hBitmaps			; and hunt for bitmaps in datafile and RTS'es.

	lda	a5H				; check for PG mode
	bmi	@6				; take branch if it is PG mode
	sta	l73c1				; zero out the bitmap counter
	beq	RemoveBMP-10		; relative JMP and RTS'es in MP mode

@6:	jsr	l4a00				; set source address and transfer length
	ldx	#r15
	ldy	#r1
	jsr	l1896				; copies r15 to r1 for destination address
	jsr	MoveData

	sec
	lda	r15L				; contains end address of GO data stream
	sbc	r7L				; and subtract the start address
	sta	r3L				; to arrive at a length byte
	lda	r15H
	sbc	r7H
	sta	r3H
	clc
	lda	r3L
	adc	r2L
	sta	r2L
	lda	r3H
	adc	r2H
	sta	r2H				; and create a new length
						; should I issue a comparison at l1889 to restrict
						; the size of the library entry?
	pla					; restore .A
	rts					; and RTS'es

restoreBMP:					; restores the geoPublish data from the REU
	jsr	L1993				; check to see of PL mode is used
	beq	restoreBMP-1		; take branch if PL mode is used
	txa
	pha					; preserve disk error value
	jsr	InitLibValues		; fetch data for PG or MP modes
	jsr	stashGPData-3		; and fetch it from expansion RAM
	jsr	L155A				; and restore the values at $6ed4-$6ed8
	pla
	tax					; restore disk error value
	rts

	ldy	#$91				; FETCH data
.byte $2c					; BIT opcode
stashGPData:				; stashes geoPublish data into bank #$00 of the REU
	ldy	#$90				; STASH data
	MoveW r7, r0			; move CBM start address
	lda	#$00
	sta	r1L
	sta	r1H				; REU address is $0000
	sta	r3L				; use the first bank of the REU
	jmp	DoRAMOp			; and stash it into the REU

sUpArrow:					; service routine for the UP arrow of the library DB
	lda	$B0
	cmp	#$6F
	bne	@1
	lda	$AF
	cmp	#$15
@1:	beq	@3
	lda	#$0D
	ldx	#$AF
	jsr	L187B
	lda	L49A3
	cmp	#$03
	beq	@2
	inc	L49A3
@2:	jsr	L474F
@3:	lda	mouseData
	bpl	sUpArrow
	rts

sDownArrow:
	ldx	#r0
	jsr	l4900				; loads r0 w/ $6f15
;	lda	#>l6f15
;	sta	r0H
;	lda	#<l6f15
;	sta	r0L				; loads r0 w/ $6f15
	clc
	lda	#$6C
	adc	r0L
	sta	r0L
	lda	#$01
	adc	r0H
	sta	r0H				; adds $016c to $6f15
	lda	$B0
	cmp	r0H
	bne	@1
	lda	$AF
	cmp	r0L				; compares r0 against pointer in $af
@1:	beq	@3
	lda	#$0D
	ldx	#$AF
	jsr	l186f				; adds $0d to zp pointer at $af
	lda	L49A3
	beq	@2
	dec	L49A3
@2:	jsr	L474F				; sets up GetString
@3:	lda	mouseData
	bpl	sDownArrow
	rts

rLibrary:					; this allows the user to select a library entry
						; onto the library DB and acts accordingly.
	bit	mouseData			; was there a mouse click?
	bmi	@3
	lda	#$00
	sta	r3H
	lda	#$4A
	sta	r3L
	lda	#$00
	sta	r4H
	lda	#$C0
	sta	r4L
	lda	#$61
	sta	r2H
	lda	#$55
	sta	r2L
	ldx	#$03
@1:	jsr	IsMseInRegion
	bne	@2
	sec
	lda	r2L
	sbc	#$0C
	sta	r2L
	sec
	lda	r2H
	sbc	#$0C
	sta	r2H				; need to winnow the window until the correct
	dex					; library entry is found.
	bpl	@1
	rts
@2:	txa
	pha
	ldx	L49A3
	jsr	l4795				; unselects the old library entry
	pla
	sta	L49A3
	tax
	jsr	l4795				; selects the new library entry by inverting it
	jsr	L47B6				; sets up GetString
@3:	rts

L4723:
	lda	#$0D
	sta	keyData			; stimulate the RETURN keypress
	jmp	(keyVector)

sDelete:					; service routine for the DELETE icon
	ldx	L49A3				; of the library file DB
	jsr	L4822
	jsr	L4840
	beq	@1
	lda	#$00
	sta	(r0L),y
	jsr	L4845
	jsr	PointRecord
	jsr	L12AF
	jsr	L474F
@1:	rts

rLib:
	lda	#$00
	sta	L49A3				; initially zero out the index
	jsr	L4870				; frames the entry list
L474F:
	jsr	L4866				; draws a rectangle inside the DB
	ldx	#$03
@1:	txa
	pha
	jsr	L4822				; loads r0 pointing to library entry
	jsr	L476A				; prints 4 entries in the library DB
	pla
	tax
	dex
	bpl	@1
	ldx	L49A3				; used as an index into the entry window
	jsr	l4795				; will invert that entry in the library DB
	jmp	L47B6

L476A:
	lda	l4791,x			; this routine will print entries on the Library DB
	sta	r1H
	lda	#$BF
	ldx	#$00
	jsr	L128C				; sets the rightMargin value
	lda	#$00
	sta	r11H
	lda	#$4E
	sta	r11L				; r11 points to $004e
	jsr	L4840				; checks for a null value for the library entry
	bne	@1
	lda	#>tEmpty
	sta	r0H
	lda	#<tEmpty
	sta	r0L
@1:	jsr	PutString
	jmp	L18AD				; sets values at windowTop...

l4791:
.byte $39,$45,$51,$5d

l4795:
	lda	l47b2,x
	sta	r2L
	clc
	adc	#$0C
	sta	r2H
	lda	#$00
	sta	r3H
	lda	#$4B
	sta	r3L
	lda	#$00
	sta	r4H
	lda	#$BF
	sta	r4L
	jmp	InvertRectangle

l47b2:
.byte $30,$3b,$47,$53

L47B6:
	jsr	i_FillRam
.word $000d					; # of bytes to fill
.word l6e12					; start address
.byte $00					; fill byte
	jsr	L12F0				; SetPattern w/ $00
	jsr	i_Rectangle
.byte $6B,$7d				; y coordinates
.word $004a					; x1
.word $00c0					; x2
	ldx	L49A3				; index to library entry
	jsr	L4822				; loads r0 pointing to the library entry
	ldx	#r1
	jsr	L487B				; loads r1 with $6e12
	ldx	#r0
	ldy	#r1
	jsr	CopyString
	ldx	#r0
	jsr	L487B				; loads r0 with $6e12
	lda	#>l4802
	sta	keyVector+1
	lda	#<l4802
	sta	keyVector			; routine called when GetString is done
	lda	#$00
	sta	r1L				; use system fault routine
	lda	#$6D
	sta	r1H				; ypos
	lda	#$00
	sta	r11H
	lda	#$4A
	sta	r11L				; load r11 w/ $004a (xpos)
	lda	#$0C
	sta	r2L				; max length ($0c) of library entry
	jmp	GetString

l4802:
	ldx	L49A3				; get index into library entry
	jsr	L4822				; load r0 with library entry pointer
	jsr	L4840				; checks to see if its empty or not.
	bne	@1
	sta	keyVector
	sta	keyVector+1			; zeroes out keyVector if the string is empty
	rts
@1:	ldx	#r1
	jsr	L487B				; load r1 w/ $6e12
	dex
	ldy	#r0
	jmp	CopyString			; try a JMP here to ward off a geoPublish bug.

;	jmp	L474F				; and repeats the library DB

L4822:					; loads r0 with the appropriate library entry pointer
	lda	$B0
	sta	r0H
	lda	$AF
	sta	r0L
	txa
	pha
	tay
@2:	dey
	bmi	@3
	lda	#$0d
	ldx	#r0
	jsr	l186f				; adds #$0d to the library entry stored in r0
	clv
	bvc	@2
@3:	pla
	tax
	rts

L4840:
	ldy	#$00
	lda	(r0L),y
	rts

L4845:					; get VLIR # of library entry's data in library file.
	sec
	lda	r0L
	sbc	#<l6f15
	sta	r0L
	lda	r0H
	sbc	#>l6f15
	sta	r0H
	ldy	#$01
@1:  lda	r0L
	ora	r0H
	beq	@2
	lda	#$0D
	ldx	#r0
	jsr	L187B				; subtracts $0d from value in r0
	iny
	bne	@1
@2:	tya					; .Y holds the VLIR # of the library file to read in
	rts

L4866:
	jsr	i_Rectangle
.byte $30,$60				; y coordinates
.word $004B					; x1
.word $00BF					; x2
	rts
L4870:					; draws the little rectangle around the entry list
	jsr	i_FrameRectangle
.byte $2F,$61				; y coordinates
.word $004A					; x1
.word $00C0					; x2
.byte $FF					; pattern
	rts

L487B:
	lda	#<l6e12
	sta	$00,x
	inx
	lda	#>l6e12
	sta	$00,x
	rts

l4900:
	lda	#<l6f15
	sta	$00,x
	inx
	lda	#>l6f15
	sta	$00,x
	rts

dbLibrary:
.byte $81					; default icon table
.byte $0B					; DBTXTSTR
.byte $10,$0B				; position offsets
.word tLibrary				; text pointer
.byte $05					; OPEN icon
.byte $11,$08				; position offsets
.byte $12					; DBUSRICON
.byte $11,$1C				; position offsets
.word itSave				; SAVE icon table pointer
.byte $12					; DBUSRICON
.byte $11,$30				; position offsets
.word itDelete				; DELETE icon table pointer
.byte $12					; DBUSRICON
.byte $11,$44				; position offsets
.word itQuit1				; QUIT icon table pointer
.byte $12					; DBUSRICON
.byte $07,$41				; position offsets
.word itUpArrow				; UP icon table pointer
.byte $12					; DBUSRICON
.byte $09,$41				; position offsets
.word itDownArrow				; DOWN icon table pointer
.byte $11					; DBOPVEC
.word rLibrary				; pointer to routine
.byte $13					; DB_USR_ROUT
.word rLib					; pointer to DB routine
.byte $00

itSave:
.word iSave					; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sSave					; pointer to service routine
itDelete:
.word iDelete				; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sDelete				; pointer to service routine
itQuit1:
.word iQuit					; pointer to icon data
.byte $00,$00				; position offsets
.byte $06,$10				; width/height attributes
.word sQuit					; pointer to service routine
itUpArrow:
.word iUpArrow				; pointer to icon data
.byte $00,$00				; position offsets
.byte $02,$08				; width/height attributes
.word sUpArrow				; pointer to service routine
itDownArrow:
.word iDownArrow				; pointer to icon data
.byte $00,$00				; position offsets
.byte $02,$08				; width/height attributes
.word sDownArrow				; pointer to service routine

iUpArrow:					; icon data
.byte $8A,$FF,$FF,$81,$81,$83,$C1,$87
.byte $E1,$8F,$F1,$04,$81,$84,$FF,$ff; should be $82,$ff,$ff

iDownArrow:					; icon data
.byte $82,$FF,$FF,$04,$81,$8C		; should be $8a
.byte $8F,$F1,$87,$E1,$83,$C1,$81,$81
.byte $FF,$FF

iDelete:					; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$B8,$03,$87,$C0
.byte $0E,$00,$C0,$03,$86,$60,$06,$00
.byte $C0,$03,$86,$33,$C6,$79,$E3,$C3
.byte $86,$36,$66,$CC,$C6,$63,$86,$36
.byte $66,$CC,$C6,$63,$86,$37,$E6,$FC
.byte $C7,$E3,$86,$36,$06,$C0,$C6,$03
.byte $86,$66,$66,$CC,$C6,$63,$87,$C3
.byte $C6,$78,$73,$C3,$80,$04,$00,$82
.byte $03,$80,$04,$00,$81,$03,$06,$FF
.byte $81,$7F,$05,$FF

iSave:					; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$B8,$03,$80,$3E
.byte $00,$00,$00,$03,$80,$63,$00,$00
.byte $00,$03,$80,$60,$3C,$CC,$F0,$03
.byte $80,$60,$66,$CD,$98,$03,$80,$3E
.byte $3E,$CD,$98,$03,$80,$03,$66,$79
.byte $F8,$03,$80,$03,$66,$79,$80,$03
.byte $80,$63,$66,$31,$98,$03,$80,$3E
.byte $3E,$30,$F0,$03,$80,$04,$00,$82
.byte $03,$80,$04,$00,$81,$03,$06,$FF
.byte $81,$7F,$05,$FF

L49A2:  .byte   $00
L49A3:  .byte   $00			; used as an index into the entries of the library DB

L49A4:  .byte   $00,$00,$00		; used for the PutDecimal/GetString routines

L49A7:					; (25 bytes)
	jsr	L2178				; opens the geoPublish datafile
	jsr	L1993				; check MP or PL mode
	bne	@1
	lda	#$02
	pha
	jsr	L49C0				; PL mode - not sure - seems to write a VLIR record
	pla
	bpl	@2
@1:	jsr	L49DE				; MP mode - checks for bitmaps in memory & frees them up
	lda	#$01
@2:	jmp	L1343				; opens the geoPublish library.

L49C0:					; for PL mode (30 bytes)
	jsr	L1CB4				; not sure yet - seems to fiddle w/ $80-$85 locations
	bcs	@3
@1:	lda	$81
	sta	a8L
	lda	$80
	sta	a7H
	jsr	L11AB				; not sure yet
	bne	@2
	txa
	beq	@2
	jsr	L4A1A				; opens geoPublish datafile's VLIR record & writes it back
@2:	jsr	L1D1F				; not sure yet - seems to fiddle w/ $80-$85 locations
	bcc	@1
@3:	rts

L49DE:					; works for both MP & PG modes
	lda	#$ff				; flag for removing bitmaps from datafile
	sta	r12H

hBitmaps:					; hunts for bitmaps
	lda	#$00
	sta	r13L				; object index

	ldx	l750c				; get start address of graphic object data stream
	ldy	l750c+1
	stx	r15L				; r15 contains proper offset for either MP/PG modes
	sty	r15H
	ldy	#$06
	lda	($d5),y			; get # of graphics objects in memory
	sta	r13H

@1:	dec	r13H				; dec # of objects until we are done
	bmi	@3
	ldy	#$00
	lda	(r15L),y
	cmp	#$08				; looks for a value of #$08 - value for a bitmap
	bne	@2
	
	lda	r12H				; check flag
	bmi	@4				; take branch if bitmaps need to be removed from datafile

	lda	r13L				; get object index #
	jsr	delObj			; and removes the graphics object
	inc	r13L				; increment graphics object index
	bne	@1				; relative JMP

@4:	ldy	#$0E
	lda	(r15L),y
	sta	r14L
	iny
	lda	(r15L),y
	sta	r14H				; extracts the last word value of graphics object
	ldy	#$00
	lda	(r14L),y			; gets value pointed by last word value of graphics object
	jsr	L4A1A				; calls the VLIR record (datafile)
	bra	@1

@2:	inc	r13L				; increment graphics object index
	ldx	#r15
	jsr	l1867
	clv
	bvc	@1

@3:	rts

;	lda	#>l73cb
;	sta	r15H				; work for both MP & PG modes
;	lda	#<l73cb			; object graphics located at $73cb
;	sta	r15L
;	dec	l73c1				; # of bitmap objects in memory
;	bmi	@3
;@1:	dec	l73c8				; # of graphics objects in memory
;	bmi	@3

;	ldy	#$00
;	lda	(r15L),y
;	cmp	#$08				; looks for a value of #$08 - value for a bitmap
;	bne	@2

;	ldy	#$0E
;	lda	(r15L),y
;	sta	r14L
;	iny
;	lda	(r15L),y
;	sta	r14H				; extracts the last word value of graphics object
;	ldy	#$00
;	lda	(r14L),y			; gets value pointed by last word value of graphics object
;	jsr	L4A1A				; calls the VLIR record (datafile)
;	dec	l73c1				; and writes it
;	bmi	@3

;@2:	lda	#$10
;	ldx	#$20				; adds 16 to value in r15 and cycles through
;	jsr	l186f				; the graphics objects
;	clv
;	bvc	@1
;@3:	rts

restorePGLib:				; restores a PG library entry that has been loaded in.
	ldy	#$06
	lda	($d5),y			; get # of graphics objects in memory
	jsr	GetNextGONum
	lda	r2L
	pha
	lda	r2H
	pha					; temporarily save r2
	jsr	l4a00				; set transfer length
	ldx	#r0
	ldy	#r1
	jsr	l1896				; copies contents to set destination address at r1
	pla
	sta	r0H
	pla
	sta	r0L				; and set the source address
	jmp	MoveData			; and RTS'es

l4a00:
	lda	GOAttrData			; get source address & copy GO's attribute data
	sta	r0L
	lda	GOAttrData+1		; use ($d5) instead?
	sta	r0H
	sec
	lda	#<EGOData			; $6a80
	sbc	r0L
	sta	r2L				; store length
	lda	#>EGOData
	sbc	r0H
	sta	r2H
	rts

L4A1A:
	jsr	PointRecord			; shouldn't it be a pseudo call?
	jmp	L12AF				; calls WriteRecord w/ r2=$0000, freeing up the VLIR record
						; of the geoPub datafile
tDiskName:					; buffer containing disk name as used in DB routines
