; da65 V2.9.5 - (C) Copyright 2000-2003 Ullrich von Bassewitz
; Input file: gpb01v00.bin

.out "Source Code (c) 2003 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"

; equates
; pseudo-register a5 might be freed up for any purpose.
; used a5L for reuBank
; used a5H for PG flag

L2500           = $2500
L2503           = $2503
L2506           = $2506
L2509           = $2509
L2512           = $2512
L2518           = $2518
L251B           = $251B
L2521           = $2521
L2524           = $2524
L2528           = $2528
L252A           = $252A
L252D           = $252D
L2530           = $2530
L253C           = $253C
L3180           = $3180
L3183           = $3183
L3186           = $3186
L3189           = $3189
L318C           = $318C
L318F           = $318F
L3192           = $3192
L3195           = $3195
L3198           = $3198
L319B           = $319B
L319E           = $319E
L31A1           = $31A1
L31A4           = $31A4
L31A7           = $31A7
L31AA           = $31AA
L31AD           = $31AD
L31B0           = $31B0
l3368		=	$3368			; routine in VLIR #$02, which redraws the graphics
						; objects currently in memory.
l3472		=	$3472			; routine in VLIR #$02, which sets address of next
						; available graphics object in memory.
InsertObj	=	$395e			; inserts a graphics object in a geoPub page
l3b75		=	$3b75			; routine in VLIR #$02, which deletes a graphics object
L4214		=	$4214			; routine in VLIR #$02, which handles VLIR module loading
dbJPEGReq	=	$4880			; calls the JPEG dialog box requestor
pJPEG		=	dbJPEGReq+3		; routine to process a JPEG file.
attrImage	=	pJPEG+3		; routine to modify image attributes
L4A80           = $4A80
L4A98           = $4A98
L4A9B           = $4A9B
L4A9E           = $4A9E
L4C94           = $4C94
L4C95           = $4C95
l4f4a		=	$4f4a			; routine to paste in a photo scrap
l4fd2		=	$4fd2			; routine to calculate the ending dimensions of an image
L5280           = $5280
L5283           = $5283
L5286           = $5286
L5289           = $5289
L528C           = $528C
L528F           = $528F
L5292           = $5292
L5620           = $5620
l57a2		=	$57a2			; routine to erase the rulers in PG editing mode.
L7518		=	$7518			; buffer containing MP&PG library file pointers
dFileName	=	$6a83			; datafile's filename
gpvlir	=	$6a94			; geoPublish's VLIR records are located here
gwvlir	=	$6d32			; geoWrite's VLIR records are located here
pglFlag	=	gpvlir		; flag to indicate if a Page Graphics library file exists.
pglPtrs	=	pglFlag+2		; pointers for MP & PG library files
l6d87		=	$6d87			; unknown
fnBuffer	=	$6e23			; filename buffer used for DBGETFILES
L7369           = $7369

progDrive	=	$6a81
dataDrive	=	progDrive-1

;.include "gpb02v00.a"			; contains switcher code needed for geoPublish to
.include "switcher.a"			; function entirely from expansion RAM.

L0400:  jmp     initgP
        jmp     L2500
L0406:  lda     #$01
        sta     $88
        lda     #$6F
        sta     $8A
        lda     #$15
        sta     $89
        rts
L0413:  clc
        lda     #$21
        adc     $89
        sta     $89
        bcc     L041E
        inc     $8A
L041E:  inc     $88
        lda     $88
        cmp     #$11
        rts
L0425:  jsr     L1993
        beq     L0448
        jmp     L1568
L042D:  jsr     L1993
        bne     L0440
        jsr     L4A9B
        jsr     L0484
        bcs     L0448
        jsr     L049B
	jmp	l19dd
L0440:  jsr     L1999
        bne     L0448
        jsr     L528C
L0448:  rts

L0449:
	lda	$6F05
	bne	@2
	jsr	L1124
	beq	@1
	ldx	$6DB8
	ldy	$6DB9
	lda	$6DBA
	rts
@1:	jsr	L2512
	ldx	$D2
	ldy	$D3
	lda	$D4
	rts
@2:	lda	$6DAA
	beq	@3
	clc
	lda	$3A
	adc	#$04
	tax
	lda	$3B
	adc	#$00
	tay
	clc
	lda	$3C
	adc	#$04
	rts
@3:	ldx	$3A
	ldy	$3B
	lda	$3C
	rts

L0484:  jsr     L0406
L0487:  ldy     #$00
        lda     ($89),y
        beq     L0492
        jsr     L1D3D
        bmi     L0499
L0492:  jsr     L0413
        bcs     L049A
        bcc     L0487
L0499:  clc
L049A:  rts
L049B:  jsr     L1AF6
        jsr     L0484
        bcs     L04AA
        jsr     L1BDB
        jsr     L1AF6
        clc
L04AA:  rts
L04AB:  jsr     l12c4
        jsr     l19dd
        ldy     $6F04
        lda     L04D5,y
        ldx     L04D8,y
        jsr     CallRoutine
        ldy     $6F05
        lda     L04DB,y
        ldx     l04dd,y
        jsr     CallRoutine
        ldy     $6F04
        lda     L04DF,y
        ldx     L04E2,y
        jmp     CallRoutine
L04D5:
.byte $e5,$00,$eb
L04D8:
.byte $04,$00,$04
L04DB:
.byte $7e,$8d
l04dd:
.byte $1b,$1b
L04DF:
.byte $99,$93,$00
L04E2:
.byte $1B,$1B,$00

L04E5:  jsr     L1598
        jmp     L1BA5
L04EB:  jsr     L15B7
        jmp     L1BA5
L04F1:
	ldx	#$03
	lda	#$FF
@1:	sta     a2H,x			; Used by geoPublish's VLIR routines
	dex
	bpl	@1
	rts

L04FB:  jsr     L0406
L04FE:  jsr     L1D3D
        beq     L0506
        jsr     L1244
L0506:  jsr     L0413
        bcc     L04FE
        jsr     L1CB4
L050E:  ldy     #$0A
        lda     #$00
        sta     ($80),y
        jsr     L1D1F
        bcc     L050E
        lda     #$FF
        sta     $6DA6
        rts
l051f:					; Process tables (13 of them.)
.byte $8C,$4A,$06,$00
.byte $0C,$25,$0A,$00
.byte $8F,$4A,$06,$00
.byte $1E,$25,$01,$00
.byte $8F,$31,$06,$00
.byte $92,$31,$06,$00
.byte $21,$25,$0F,$00
.byte $27,$25,$06,$00
.byte $95,$31,$06,$00
.byte $9B,$31,$06,$00
.byte $33,$25,$03,$00
.byte $39,$25,$01,$00
.byte $8F,$31,$1E,$00

.byte $AD,$14,$6F,$10,$28
L0558:  .byte   $49,$FF,$8D,$14,$6F,$49,$FF,$18
        .byte   $69,$01,$20,$39,$C1,$20,$9F,$C1
        .byte   $2B,$30,$A1,$00
        ldx     $00
        lda     $6F14
        clc
        adc     #$01
        jsr     SetPattern
        jsr     i_Rectangle
        .byte   $3B
        rti
        lda     ($00,x)
        ldx     $00
L0580:  rts
	lda	$6F14
	bmi	L0580
	jmp	L0558
	lda	#$05
	sta	appMain+1
	lda	#$94
	sta	appMain
	rts
	lda	#$00
	sta	appMain
	sta	appMain+1
	sta	iconSelFlag
	lda	$6F14
L05A2:
	eor	#$FF
	sta	$6F14
	jmp	L0558

        .byte   $81,$0B,$10,$10,$E4,$0D,$0B,$10
        .byte   $20,$F6,$0D,$12,$0C,$0A,$C6,$05
        .byte   $12,$0C,$1A,$CE,$05,$01,$11,$48
        .byte   $13,$89,$05,$00,$D6,$05,$00,$00
        .byte   $01,$08,$81,$05,$D6,$05,$00,$00
        .byte   $01,$08,$53,$05,$81,$FF,$06,$81
        .byte   $82,$FF

l05dc:					; main menu table
.byte $00,$0F,$00,$00,$8F,$00,$05
.word tGeos
.byte $40
.word l0a56					; geos menu entry
.word tFile
.byte $40
.word l0a61					; file menu entry
.word tMode
.byte $40
.word l0a6c					; mode menu entry
.word tDisp
.byte $40
.word l0a85					; disp menu entry
.word tOptions
.byte $40
.word l0a77					; options menu entry

.byte $10

L05FD:  .byte   $1F,$00,$00,$4F,$00
L0602:  .byte   $81,$33,$0C,$00,$C0,$1A,$AA,$6C
        .byte   $00,$CC,$1A,$BB,$6C,$00,$CC,$1A
        .byte   $CC,$6C,$00,$CC,$1A,$DD,$6C,$00
        .byte   $CC,$1A,$EE,$6C,$00,$CC,$1A,$FF
        .byte   $6C,$00,$CC,$1A,$10,$6D,$00,$CC
        .byte   $1A,$21,$6D,$00,$CC,$1A

mFile:					; file sub menu table
.byte $10,$81,$1D,$00,$51,$00,$88
.word tClose
.byte $00
.byte $0E,$1B				; close menu entry
.word tLibrary
.byte $00
.word library				; library menu entry
.word tDocSetup
.byte $00
.byte $2D,$08				; doc setup menu entry
.word tUpdate
.byte $00
.byte $D7,$1A				; update menu entry
.word tRecover
.byte $00
.byte $AB,$1B				; recover menu entry
.word tRename
.byte $00
.byte $02,$1B				; rename menu entry
.word tPrint
.byte $00
.word Print					; print menu entry
.word tQuit
.byte $00
.word quit					; quit menu entry

.byte $10,$49,$31
        .byte   $00,$8E,$00,$84,$2D,$0D,$00,$5F
        .byte   $07,$59,$0D,$00,$B3,$07,$44,$0D
        .byte   $00,$81,$07,$A4,$0D,$00,$D2,$07
        .byte   $10,$8F,$51,$00,$AC,$00,$89,$6F
        .byte   $0D,$00,$F8,$07,$81,$0D,$00,$13
        .byte   $08,$8E,$0C,$00,$A3,$08,$80,$0C
        .byte   $00,$A6,$08,$9C,$0C,$00,$A9,$08
        .byte   $74,$0C,$00,$AC,$08,$AB,$0C,$00
L06A2:  .byte   $AF,$08,$B2,$0C,$00,$B2,$08
L06A9:  .byte   $BC,$0C,$00,$B5,$08,$10,$8F,$69
        .byte   $00,$CB,$00,$89,$AC,$0D,$00,$84
        .byte   $08,$90,$0D,$00,$8E,$08,$17,$0D
        .byte   $00,$98,$08,$CD,$0C,$00,$E6,$07
        .byte   $DF,$0C,$00,$DC,$07,$E8,$0C,$00
        .byte   $4F,$08,$F7,$0C,$00,$6A,$08,$09
        .byte   $0D,$00,$41,$08,$D6,$0D,$00,$5A
        .byte   $1B

l06e2:					; keyboard routine wedged at keyVector
        jsr     L0739
        bcs     L070E
        lda     keyData
        cmp     #$E1
        bcc     L06F5
        cmp     #$FB
        bcs     L06F5
        sec
        sbc     #$20
L06F5:  ldy     #$0A
        ldx     $6D48
        beq     L06FE
        ldy     #$01
L06FE:  cmp     L0718,y
        beq     L070F
        dey
        bpl     L06FE
        lda     $6F05
        bne     L070E
        jsr     L252D
L070E:  rts
L070F:  ldx     L072E,y
        lda     L0723,y
        jmp     CallRoutine
L0718:  .byte   $D3
        .byte   $D2
        .byte   $C7
        cmp     $D0CC
        .byte   $DA
        sty     $AB,x
        cmp     ($D4,x)
L0723:  .byte   $4F
        ror     a
        .byte   $5F
        .byte   $B3
        sta     ($F8,x)
        .byte   $13
        sty     $8E
        lda     ($E6,x)
L072E:  php
        php
        .byte   $07
        .byte   $07
        .byte   $07
        .byte   $07
        php
        php
        php
        and     (r2H),y
L0739:  lda     $6D48
        bmi     L075D
        lda     keyData
        cmp     #$BA
        bcs     L075D
        sec
        sbc     #$B1
        bcc     L075D
        cmp     $6F08
        bcs     L075D
        tay
        ldx     #$15
        jsr     L18D1
        beq     L075B
        tya
        jsr     L0FE7
L075B:  sec
        rts
L075D:  clc
        rts
pgMode:					; starts PG mode editing
        ldx     #$0E
        jsr     L18D1
        beq     L07D1
        jsr     L07C8
        bcs     L077B
        jsr     L1993
        bne     L077B
        jsr     L049B
        lda     #$02
        sta     $6F04
        jmp     L04AB
L077B:  jsr     L042D
        jmp     L1FE9
plMode:					; starts PL editing mode
        ldx     #$0F
        jsr     L18D1
        beq     L07D1
        jsr     L1C16
        jsr     L0425
        jsr     L0440
        lda     $6F04
        pha
        lda     #$01
        sta     $6F04
        pla
        cmp     #$02
        bne     L07AD
        lda     $6F05
        bne     L07AD
        jsr     L0EC5
        jsr     L1F8E
        clv
        bvc     L07B0
L07AD:  jsr     L1B7E
L07B0:  jmp     L1B93
        ldx     #$10
mpMode:					; starts MP mode editing
        jsr     L18D1
        beq     L07D1
        jsr     L07C8
        bcs     L07C5
        jsr     L049B
        jsr     l19dd
L07C5:  jmp     L1B3D
L07C8:  jsr     L1C16
        jsr     L0425
        jsr     L0484
L07D1:  rts

editor:
	ldx	#$14
	jsr	L18D1				; checks a value in $6f06 for some reason.
	beq	L07D1
        jmp     L4A98
        ldx     #$08
        jsr     L18D1
        beq     L0812
        jmp     L2518
        ldx     #$07
        jsr     L18D1
        beq     L0812
        jmp     L18FC
        lda     menuNumber
        beq     L0812
        jmp     ReDoMenu
        ldx     #$11
        jsr     L18D1
        beq     L0812
        jsr     L1C16
        jsr     L1B7E
        jsr     L1999
        bne     L0812
        jmp     L5292
L080D:
	lda	#$00
	sta	l6d87
L0812:
	rts

        ldx     #$12
        jsr     L18D1
        beq     L0812
        jsr     L1C16
        jmp     L2524

library:					; handles the library menu entry ($0820)
	ldx	#$0D
	jsr	L18D1				; checks a value in $6f06 to see if the library
	beq	L0812				; can be executed. Also calls GotoFirstMenu
	jsr	L1C16				; no idea yet.
	jmp	L1A9E

        jsr     GotoFirstMenu
        jsr     L1C16
        jsr     L1B29
        lda     $6F05
        bne     L083E
        jmp     L252A
L083E:  jmp     L253C
        ldx     #$0B
        jsr     L18D1
        beq     L0869
        lda     #$AA
        ldx     #$05
        jmp     L1790
        ldx     #$09
        jsr     L18D1
        beq     L0869
        lda     $6F12
        eor     #$FF
        sta     $6F12
        lda     #$00
        sta     $6F13
        jsr     L0EC8
        jsr     L2530
L0869:  rts
        ldx     #$0A
        jsr     L18D1
        beq     L0869
        lda     $6F13
        eor     #$FF
        sta     $6F13
        lda     #$00
        sta     $6F12
        jsr     L0EC8
        jmp     L2530
        ldx     #$15
        jsr     L18D1
        beq     L08A2
        jmp     L0F59
        ldx     #$13
        jsr     L18D1
        beq     L08A2
        jmp     L0F64
        ldx     #$0C
        jsr     L18D1
        beq     L08A2
        jmp     L0FB7
L08A2:  rts
	ldx	#$02
.byte $2c
	ldx	#$01
.byte $2c
	ldx	#$03
.byte $2c
	ldx	#$00
.byte $2c
	ldx	#$04
.byte $2c
	ldx	#$05
.byte $2c
	ldx	#$06
	jsr	L18D8
        beq     L08C7
        lda     $6F09,x
        eor     #$FF
        sta     $6F09,x
        jsr     L0EC8
L08C7:  jmp     ReDoMenu

Print:					; handles the Print menu call
	jmp	GotoFirstMenu		; and exit for now.
	jsr	L1C16				; this code can be freed up for any purpose
	jsr	L042D
	jsr	L1AF6
	lda	L05FD
	pha
	lda	L0602
	pha
	jsr	L1A98
	pla
	sta	L0602
	pla
	sta	L05FD
	jsr	L1AFC
	jmp	L04AB

.byte $08,$FF,$D0,$80,$00,$80,$00,$80
.byte $00,$80,$01,$9F,$C0,$8D,$6C,$9F
.byte $FC,$9F,$E1,$9F,$80,$80,$00,$98
.byte $0C,$93,$21,$9F,$00,$88,$04,$97
.byte $F4,$83,$01,$9F,$80,$80,$00,$96
.byte $B4,$83,$01,$9B,$C0,$88,$04,$95
.byte $54,$83,$01,$91,$E0,$80,$00,$97
.byte $F4,$83,$01,$80,$F0,$8D,$B4,$98
.byte $0C,$87,$81,$80,$78,$80,$00,$9F
.byte $FC,$80,$01,$80,$00,$80,$00,$80
.byte $00,$80,$01,$08,$FF,$D8,$80,$00
.byte $80,$00,$80,$00,$80,$01,$83,$E0
.byte $83,$E0,$80,$00,$80,$01,$86,$30
.byte $86,$30,$83,$E0,$80,$31,$86,$18
.byte $86,$18,$8E,$B8,$80,$61,$83,$08
.byte $83,$18,$95,$5C,$80,$C1,$83,$08
.byte $83,$00,$9A,$AC,$81,$81,$8E,$18
.byte $8E,$00,$95,$54,$83,$01,$98,$30
.byte $98,$00,$9A,$AC,$86,$01,$98,$E0
.byte $98,$00,$8D,$78,$8C,$01,$8F,$80
.byte $8F,$80,$83,$E0,$80,$01,$80,$00
.byte $80,$00,$80,$00,$80,$01,$08,$FF
.byte $D8,$80,$00,$80,$00,$80,$00,$80
.byte $01,$80
; L09A9:
.byte $00,$80,$00,$80,$00,$80,$01,$9F
.byte $F0,$8F,$F8,$9F,$FC,$BF,$F9,$98
.byte $30,$8C,$18,$9A,$AC,$B5,$59,$8C
.byte $18,$8C,$30,$95,$54,$AA,$F9,$8C
.byte $18,$8E,$60,$9A,$AC,$B5,$F9,$86
.byte $0C,$83,$C0,$95,$54,$AF,$F9,$86
.byte $0C,$81,$E0,$9A,$AC,$BF,$F9,$83
.byte $06,$83,$38,$9F,$FC,$BF,$F9,$83
.byte $FE,$86,$0E,$80,$00,$80,$01,$80
.byte $00,$80,$00,$80,$00,$80,$01,$08
.byte $FF,$D8,$80,$00,$80,$00,$80,$00
.byte $80,$01,$8F,$F0,$84,$08,$9F,$C0
.byte $BF,$81,$88,$10,$86,$18,$9F,$C0
.byte $BF,$81,$8B,$D0,$83,$30,$9F,$C0
.byte $BF,$81,$88,$10,$81,$E0,$9F,$FC
.byte $BF,$F9,$8B,$D0,$80,$C0,$9E,$04
.byte $BF,$89,$88,$10,$81,$E0,$9E,$04
.byte $BF,$89,$8B,$D0,$83,$30,$9E,$04
.byte $BF,$89,$88,$10,$85,$28,$82,$04
.byte $84,$09,$8F,$F0,$87,$38,$83,$FC
.byte $87,$F9,$80,$00,$80,$00,$80,$00
.byte $80,$01,$08,$FF,$30

l0a56:					; handles the geos menu selection
	ldx	#$04
	jsr	L0A93
	lda	#$FC
	ldy	#$05
	bne	L0A8E
l0a61:					; handles the file menu selection
	ldx	#$08
	jsr	L0A93
	lda	#<mFile
	ldy	#>mFile
	bne	L0A8E
l0a6c:					; handles the mode menu selection
	ldx	#$0C
	jsr	L0A93
	lda	#$5F
	ldy	#$06
	bne	L0A8E
l0a77:					; handles the options menu selection
	jsr	L1946
	ldx	#$10
	jsr	L0A93
	lda	#$AE
	ldy	#$06
	bne	L0A8E
l0a85:					; handles the disp menu selection
	ldx	#$14
	jsr	L0A93
	lda	#$7A
	ldy	#$06
L0A8E:
	sta	r0L
	sty	r0H
	rts

L0A93:  txa
        pha
        jsr     L1C16
        pla
        tax
        stx     a2L
        jsr     L0AA4
        ldx     a2L
        jmp     L0B1C
L0AA4:  lda     $6F05
        beq     L0AB6
L0AA9:  ldx     #$06
        jsr     BlockProcess
        ldx     #$0A
        jsr     BlockProcess
        clv
        bvc     L0AC3
L0AB6:  ldx     #$01
        jsr     BlockProcess
        jsr     L0ACC
        ldx     #$03
        jsr     BlockProcess
L0AC3:  lda     #$00
        sta     keyVector+1
        sta     keyVector
        rts
L0ACC:  jsr     L12EA
        lda     #$03
        sta     r3L
        jmp     DisablSprite
l0ad6:					; Custom RecoverVector for geoPublish
        bit     $75B0
        bmi     L0AE4
        lda     #$02
        jsr     SetPattern
        jsr     Rectangle
        rts
L0AE4:  ldx     a2L
        jsr     L0B21
        lda     a2L
        cmp     #$10
        bne     L0AF2
        jsr     L1913
L0AF2:  lda     #$06
        sta     keyVector+1
        lda     #$E2
        sta     keyVector
        lda     $6F05
        beq     L0B13
        ldx     #$0A
        jsr     UnBlockProcess
        lda     l6d87
        bmi     L0B1B
        ldx     #$06
        jsr     UnBlockProcess
        clv
        bvc     L0B1B
L0B13:  ldx     #$01
        jsr     UnBlockProcess
        jsr     L2530
L0B1B:  rts

L0B1C:
	lda	#$00				; copies screen to buffer
	clv
	bvc	L0B21+2
L0B21:
	lda	#$FF				; copies buffer to screen
	sta	r4H
	jsr	L0B7B				; preps r2/r3 w/ coordinates
@1:	ldx	r2H
	jsr	GetScanLine
	lda	r2L
	asl	a
	asl	a
	asl	a
	bcc	@2
	inc	r5H
@2:	tay
	lda	r3L
	sta	r4L
@3:	bit	r4H
	bpl	@4
	jsr	L0B6D
	clv
	bvc	@5
@4:	jsr	L0B61
@5:	inc	r1L
	bne	@6
	inc	r1H
@6:	clc
	adc	#$08
	bcc	@7
	inc	r5H
@7:	tay
	dec	r4L
	bne	@3
	inc	r2H
	dec	r3H
	bne	@1
	rts

L0B61:					; copies contents at screen (r5) to buffer (r1)
	lda	(r5L),y
	tax
	tya
	pha
	ldy	#$00
	txa
	sta	(r1L),y
	pla
	rts

L0B6D:					; copies contents at buffer (r1) to screen (r5)
	tya
	pha
	ldy	#$00
	lda	(r1L),y
	tax
	pla
	tay
	txa
	sta	(r5L),y
	tya
	rts

L0B7B:
	lda	$6DA8
	beq	@1
	lda	#$7C
	sta	r1H
	lda	#$00
	sta	r1L
	clv
	bvc	@2
@1:	lda	#$75
	sta	r1H
	lda	#$D8
	sta	r1L
@2:	ldy	#$00
@3:	lda	L0BA2,x
	sta	r2L,y
	inx
	iny
	cpy	#$04
	bne	@3
	rts

L0BA2:					; table of coordinates? for screen imprinting routines
.byte $08,$20,$19,$68,$00,$10,$0A,$80
.byte $03,$10,$08,$72,$06,$10,$0C,$3A
.byte $0D,$10,$0D,$80,$0A,$10,$0C,$80
.byte $09,$10,$0B,$56,$04,$28,$09,$31

dbWarnText:
.byte $18

.byte "Both geoPublish and data file"
.byte $16,$50,$00,$40

.byte "must be on the same disk"
.byte $16,$50,$00,$50

.byte "in a one drive system."
.byte $00

tGeos:					; text for geos menu entry

.byte "geos"
.byte $00

tFile:					; text for file menu entry

.byte "file"
.byte $00

tMode:					; text for mode menu entry

.byte "mode"
.byte $00

tDisp:					; text for disp menu entry

.byte "disp"
.byte $00

tOptions:					; text for options menu entry

.byte "options"
.byte $00

.byte $67,$65,$6F,$50,$75,$62,$6C
        .byte   $69,$73,$68,$20,$69,$6E,$66,$6F
        .byte   $00

tClose:

.byte "close"
.byte $00

tDocSetup:

.byte "doc setup"
.byte $00

tUpdate:

.byte "update"
.byte $00

tRecover:

.byte "recover"
.byte $00

tRename:

.byte "rename"
.byte $00

tPrint:
.byte $19					; italics on

.byte "tse"					; short for my initials
.byte $1b					; regular text on
.byte $00					; delimiter

;.asciiz "print"

tQuit:

.byte "quit"
.byte $00

.byte $1B,$20,$4D,$50,$20,$67
        .byte   $75,$69,$64,$65,$73,$00,$1B,$20
        .byte   $4D,$50,$20,$67,$72,$61,$70,$68
        .byte   $69,$63,$73,$00,$1B,$20,$46,$47
        .byte   $20,$67

L0C94:  .byte   $72,$61,$70,$68,$69,$63,$73,$00
        .byte   $1B,$20,$73,$70,$65,$63
L0CA2:  .byte   $69,$61,$6C,$20,$74,$65,$78,$74
        .byte   $00,$1B,$20,$74,$65,$78,$74,$00
        .byte   $1B,$20,$62,$69,$74,$6D,$61,$70
        .byte   $73,$00,$1B,$20,$72,$65,$67,$69
        .byte   $6F,$6E,$20,$62,$6F,$72,$64,$65
        .byte   $72,$73,$00,$1B,$20,$74,$6F,$6F
        .byte   $6C,$62,$6F,$78,$14,$B6,$00,$1B
        .byte   $80,$18,$54,$1B,$00,$1B,$20,$72
        .byte   $75,$6C,$65,$72,$73,$00,$1B,$20
        .byte   $73,$6E,$61,$70,$14,$B6,$00,$1B
        .byte   $80,$18,$53,$1B,$00,$1B,$20,$72
        .byte   $61,$74,$63,$68,$65,$74,$14,$B6
        .byte   $00,$1B,$80,$18,$52,$1B,$00,$1B
        .byte   $20,$73,$65,$74,$20,$72,$61,$74
        .byte   $63,$68,$65,$74,$00,$1B,$20,$67
        .byte   $6F,$74,$6F,$20,$70,$61,$67,$65
        .byte   $00

tLibrary:
.byte $1B

.byte "library"
.byte $1b,$00

.byte $1b,$70,$61,$67,$65
        .byte   $20,$67,$72,$61,$70,$68,$69,$63
        .byte   $73,$14,$79,$00,$1B,$80,$18,$47
        .byte   $1B,$00,$1B,$70,$61,$67,$65,$20
        .byte   $6C,$61,$79,$6F,$75,$74,$14,$79
        .byte   $00,$1B,$80,$18,$4C,$1B,$00,$1B
        .byte   $6D,$61,$73,$74,$65,$72,$20,$70
        .byte   $61,$67,$65,$73,$14,$79,$00,$1B
        .byte   $80,$18,$4D,$1B,$00,$1B,$20,$70
        .byte   $72,$65,$76,$69,$65,$77,$14,$97
        .byte   $00,$1B,$80,$18,$50,$1B,$00,$1B
        .byte   $20,$7A,$6F,$6F,$6D,$14,$97,$00
        .byte   $1B,$80,$18,$5A,$1B,$00,$1B,$20
        .byte   $6E,$65,$78,$74,$20,$70,$61,$67
        .byte   $65,$14,$B6,$00,$1B,$80,$18,$2B
        .byte   $1B,$00,$1B,$65,$64,$69,$74,$6F
        .byte   $72,$00,$1B,$20,$70,$72,$65,$76
        .byte   $69,$6F,$75,$73,$20,$70,$61,$67
        .byte   $65,$1B,$14,$B6,$00,$80,$10,$01
        .byte   $C6,$00,$16,$02,$C0,$00,$16,$02
        .byte   $C2,$00,$14,$02,$C2,$00,$18,$02
        .byte   $C0,$00,$16,$00,$1B,$20,$73,$65
        .byte   $74,$20,$67,$75,$74,$74,$65,$72
        .byte   $73,$00,$54,$77,$6F,$20,$70,$69
        .byte   $78,$65,$6C,$20,$72,$61,$74,$63
        .byte   $68,$65,$74,$00,$31,$2F,$32,$20
        .byte   $69,$6E,$63,$68,$20,$72,$61,$74
        .byte   $63,$68,$65,$74,$00,$18,$41,$72
        .byte   $74,$69,$63,$6C,$65,$20,$74,$61
        .byte   $62,$6C,$65,$20,$66,$75,$6C,$6C
        .byte   $1B,$00,$18,$45,$52,$52,$4F,$52
        .byte   $3A,$20,$52,$65,$67,$69,$6F,$6E
        .byte   $20,$74,$6F,$6F,$20,$73,$6D,$61
        .byte   $6C,$6C,$20,$66,$6F,$72,$1B,$00
        .byte   $50,$61,$67,$65,$3A,$20,$00,$18
        .byte   $45,$6E,$74,$65,$72,$20,$70,$61
        .byte   $67,$65,$20,$74,$6F,$20,$67,$6F
        .byte   $20,$74,$6F,$1B,$00,$18,$43,$61
        .byte   $6E,$27,$74,$20,$67,$6F,$20,$74
        .byte   $6F,$20,$67,$69,$76,$65,$6E,$20
        .byte   $70,$61,$67,$65,$00,$43,$72,$65
        .byte   $61,$74,$65,$20,$6E,$65,$78,$74
        .byte   $20,$70,$61,$67,$65,$20,$3F,$00
        .byte   $18,$45,$52,$52,$4F,$52,$3A,$20
        .byte   $63,$61,$6E,$27,$74,$20,$66,$69
        .byte   $6E,$64,$20,$74,$65,$78,$74,$20
        .byte   $66,$69,$6C,$65,$1B,$00,$18,$45
L0EA2:  .byte   $52,$52,$4F,$52,$3A,$20,$54,$6F
        .byte   $6F,$20,$6D,$61,$6E,$79,$20,$63
        .byte   $68,$69,$6C,$64,$72,$65,$6E,$20
        .byte   $72,$65,$63,$74,$61,$6E,$67,$6C
        .byte   $65,$73,$00

L0EC5:  jsr     L0F24
L0EC8:  lda     #$0C
        sta     r0H
        lda     #$74
        sta     r0L
        ldx     #$00
        ldy     #$00
L0ED4:  lda     L18E6,x
        and     $6F06
        beq     L0EE7
        lda     #$19			; italics font
        sta     (r0L),y
        lda     L18E6,x
        bmi     L0EFF
        bpl     l0ef8
L0EE7:  lda     #$1B			; bold font
        sta     (r0L),y
        lda     L18E6,x
        bmi     L0EFF
        lda     $6F09,x
        bpl     l0ef8
	lda	#$2A
.byte $2c
l0ef8:
	lda	#$20
        jsr     L0F1C
        sta     (r0L),y
L0EFF:  jsr     L0F1C
        lda     (r0L),y
        beq     L0F13
        cmp     #$14
        bne     L0EFF
        jsr     L0F1C
        jsr     L0F1C
        clv
        bvc     L0EFF
L0F13:  jsr     L0F1C
        inx
        cpx     #$16
        bcc     L0ED4
        rts
L0F1C:  iny
        cpy     #$00
        bne     L0F23
        inc     r0H
L0F23:  rts
L0F24:  ldx     $6F04
        lda     L0F40,x
        ldx     $6F05
        ora     L0F43,x
        ldx     $6F0B
        bne     L0F3C
        ldx     $6F0A
        bne     L0F3C
        ora     #$20
L0F3C:  sta     $6F06
        rts
L0F40:  .byte   $04,$08,$10
L0F43:  .byte   $02,$01
l0f45:					; this area may be freed up for any purpose
	lda	a5H				; check which MP or PG mode is being used
	bpl	@1				; branch on MP mode
	jmp	l3368				; this code will 'refresh' the PG page currently
						; in memory. The code is in VLIR #$02
@1:	jmp	L1B9F				; calls geoPublish module #$04 and executes code there
.res 10					; Reserve 10 bytes of free space
;.byte "swapping geoPublish"
;.byte $00

L0F59:  lda     $6F07
        beq     L0FAD
        sec
        sbc     #$01
        jmp     L0FE7
L0F64:  lda     $6F08
        ldx     $6F07
        cpx     #$0F
        bne     L0F72
        cmp     #$10
        beq     L0FAD
L0F72:  sec
        sbc     $6F07
        sbc     #$01
        beq     L0F83
        lda     $6F07
        clc
        adc     #$01
        jmp     L0FE7
L0F83:  lda     #$0E
        sta     r14H
        lda     #$6F
        sta     r14L
        ldy     #$0E
        lda     #$57
        jsr     L199F
        lda     r0L
        cmp     #$02
        bne     L0F9B
        jmp     L1913
L0F9B:  jsr     L049B
        inc     $6F08
        inc     $6F07
        jsr     L1B51
        jsr     L2154
        jmp     L0FF2
L0FAD:  lda     #$57
        ldy     #$0E
        jsr     L17AF
        jmp     L1913
L0FB7:  lda     #$00
        sta     fnBuffer
	jsr	l18c2
        lda     #$FB
        ldx     #$0F
        jsr     L177E
        jsr     L1913
        lda     fnBuffer
        bne     L0FCF
        rts
L0FCF:  jsr     L18BF
        jsr     L100A
        bne     L0FAD
        lda     r1L
        cmp     $6F01
        bcc     L0FAD
        sec
        sbc     $6F01
        cmp     $6F08
        bcs     L0FAD
L0FE7:  pha
        jsr     L049B
        pla
        sta     $6F07
        jsr     L0FF5
L0FF2:  jmp     L04AB
L0FF5:  jsr     L2180
        jmp     L2154
        .byte   $81,$0B,$10,$10,$41,$0E,$0D,$10
        .byte   $30,$0C,$03,$02,$11,$48,$00
L100A:  ldy     #$00
        sty     r1L
        lda     #$0A
        sta     r2L
L1012:  lda     (r0L),y
        beq     L1040
        sec
        sbc     #$30
        cmp     #$09
        beq     L101F
        bcs     L1043
L101F:  sta     r3L
        tya
        pha
        ldx     #$04
        ldy     #$06
        jsr     BBMult
        pla
        tay
        lda     r3L
        clc
        adc     r1L
        sta     r1L
        bcc     L1037
        inc     r1H
L1037:  lda     r1H
        bne     L1043
        iny
        cpy     #$03
        bne     L1012
L1040:  lda     #$00
        rts
L1043:  lda     #$FF
        rts
        sta     a7H
        lda     #$00
        sta     a8L
        lda     #$12
        sta     r4L
        ldy     #$0A
        ldx     #$7B
        jsr     BMult
        lda     #$71
        sta     r4H
        lda     #$3F
        sta     r4L
        lda     r4L
        clc
        adc     a7H
        sta     a7H
        lda     r4H
        adc     a8L
        sta     a8L
        rts
        ldy     #$03
L106F:  lda     (a7H),y
        sta     r0L,y
        dey
        bpl     L106F
        lda     r0H
        sta     r10H
        lda     r0L
        sta     r10L
        lda     r1H
        sta     r11H
        lda     r1L
        sta     r11L
        jsr     L1250
        lda     r0H
        sta     r3H
        lda     r0L
        sta     r3L
        lda     r1L
        sta     r2L
        lda     r6H
        sta     r7H
        lda     r6L
        sta     r7L
        lda     a7H
        clc
        adc     #$04
        sta     r5L
        lda     a8L
        adc     #$00
        sta     r5H
        ldy     #$03
L10AD:  lda     (r5L),y
        sta     r0L,y
        dey
        bpl     L10AD
        lda     r0H
        sta     r12H
        lda     r0L
        sta     r12L
        lda     r1H
        sta     r13H
        lda     r1L
        sta     r13L
        jsr     L1250
        lda     r0H
        sta     r4H
        lda     r0L
        sta     r4L
        lda     r1L
        sta     r2H
        rts
        ldx     #$30
        sec
L10D8:  sbc     #$0A
        bcc     L10DF
        inx
        bcs     L10D8
L10DF:  adc     #$3A
        rts
        pha
        lda     r3L
        clc
        adc     r4L
        sta     r4L
        lda     r3H
        adc     #$00
        sta     r4H
        clc
        lda     r2L
        adc     r2H
        sta     r2H
        jsr     InvertRectangle
        pla
        beq     L1103
        jsr     L112B
        jsr     InvertRectangle
L1103:  rts
        ldx     #$0C
L1106:  jsr     BlockProcess
        dex
        bpl     L1106
        rts
L110D:  lda     #$11
        sta     r0H
        lda     #$18
        sta     r0L
        jmp     DoIcons
        .byte   $01,$00,$00,$00,$00,$00,$00,$00
        .byte   $00,$00,$00,$00
L1124:  lda     $6F13
        ora     $6F12
        rts
L112B:  ldx     #$32
L112D:  ldy     #$FA
L112F:  dey
        bne     L112F
        dex
        bne     L112D
        rts
        lda     $6F12
        ora     $6F13
        eor     #$FF
        and     $6DAA
        sta     $6DAB
        rts
        lda     $01,x
        cmp     $01,y
        bcc     L116F
        bne     L1159
        lda     $00,x
        cmp     $00,y
        bcc     L116F
        beq     L116F
        bne     L1165
L1159:  pha
        lda     $01,y
        sta     $01,x
        pla
        sta     $01,y
        lda     $00,x
L1165:  pha
        lda     $00,y
        sta     $00,x
        pla
        sta     $00,y
L116F:  rts

L1170:
	sta	r0L
	dec	r0L
	lda	#$00
	sta	r0H
	lda	#$21
	sta	r1L
	ldx	#$00
@1:	lda	r6L,x
	pha
	inx
	cpx	#$06
	bne	@1
	ldx	#r0
	ldy	#r1
	jsr	BMult
	lda	#$6F
	sta	$8A
	lda	#$15
	sta	$89
	lda	r0L
	clc
	adc	$89
	sta	$89
	lda	r0H
	adc	$8A
	sta	$8A
	ldx	#$05
@2:	pla
	sta	r6L,x
	dex
	bpl	@2
	rts

	ldy	#$0A
	lda	(a7H),y
	tax
	beq	@3
	cmp	#$11
	bcs	@3
	pha
	jsr	L1170				; seems to add an offset into $6f15
	pla
	tax
	lda	#$FF
	rts
@3:	lda	#$00
	rts

        lda     #$00
        ldx     $CD
        cpx     $C5
        bne     L11CE
        ldx     $CC
        cpx     $C4
L11CE:  beq     L11D2
        bcs     L11D4
L11D2:  ora     #$08
L11D4:  ldx     $C9
        cpx     $D1
        bne     L11DE
        ldx     $C8
        cpx     $D0
L11DE:  beq     L11E2
        bcs     L11E4
L11E2:  ora     #$04
L11E4:  ldx     $CB
        cpx     $C3
        bne     L11EE
        ldx     $CA
        cpx     $C2
L11EE:  beq     L11F2
        bcs     L11F4
L11F2:  ora     #$02
L11F4:  ldx     $C7
        cpx     $CF
        bne     L11FE
        ldx     $C6
        cpx     $CE
L11FE:  beq     L1202
        bcs     L1204
L1202:  ora     #$01
L1204:  sta     $C1
        rts
        lda     #$00
        ldx     $C9
        cpx     $CD
        bne     L1213
        ldx     $C8
        cpx     $CC
L1213:  bcs     L1217
        ora     #$08
L1217:  ldx     $D1
        cpx     $C5
        bne     L1221
        ldx     $D0
        cpx     $C4
L1221:  bcs     L1225
        ora     #$04
L1225:  ldx     $C7
        cpx     $CB
        bne     L122F
        ldx     $C6
        cpx     $CA
L122F:  bcs     L1233
        ora     #$02
L1233:  ldx     $CF
        cpx     $C3
        bne     L123D
        ldx     $CE
        cpx     $C2
L123D:  bcs     L1241
        ora     #$01
L1241:  sta     $C1
        rts
L1244:  lda     #$11
        clc
        adc     $6F07
        tay
        lda     #$80
        sta     ($89),y
        rts
L1250:  lda     r0L
        and     #$03
        sta     r6L
        ldy     #$02
        ldx     #$02
        jsr     DShiftRight
        lda     #$98
        ldx     #$02
        jsr     l186f
        lda     r1L
        and     #$03
        sta     r6H
        ldy     #$02
        ldx     #$04
        jsr     DShiftRight
        lda     #$0B
        ldx     #$04
        jmp     l186f
L1278:  ldx     #$07
L127A:  lda     $C2,x
        sta     r10L,x
        dex
        bpl     L127A
        rts
        ldy     #$11
        lda     (a7H),y
        rts
        ldy     #$09
        lda     (a7H),y
        rts
        sta     rightMargin
        stx     rightMargin+1
        rts
        jsr     L213D
.byte $2c
	lda	#$11
.byte $2c
	lda	#$12
        ldx     #$FF
        stx     $6DAE
        jsr     L2199
        lda     #$73
        sta     $73C3
        lda     #$C2
L12A9:  sta     $73C2
        jmp     l1404

	lda	#$00
	sta	r2L
	sta	r2H				; free up the VLIR record
	jmp	l1404

        jsr     L1510
        jsr     SetDataDevice
        jsr     l142e

	lda	#$00
.byte $2c
l12c4:
	lda	#$ff				; flag to indicate Library file.
	pha
	jsr	SetDataDevice
	lda	#$82
	sta	r5H
	lda	#$00
	sta	r5L
	jsr	CalcBlksFree
	lda	r4H
	bne	@2				; if more than 256 blocks free, we're clear
	lda	r4L
	cmp	#$14				; must have at least 20 blocks free
	bcs	@2
	pla
	beq	@1
	jsr	L1AF6
@1:	jmp	L1A92				; I assume it displays some sort of an error message
@2:	pla
	rts

L12EA:
	lda	#$28
        sta     $8FF8
        rts
        lda     #$00
        jmp     SetPattern

L12F5:
.word $8401,$8402				; get the file's VLIR index block
.byte $04,$00,$05,$00			; pseudo-register r1 as used for T/S pointer
.byte $0C,$00				; pseudo-register r5L
.word $75a9					; sounds like device number
.word $841c,$841d				; # of blocks the file occupies

l1305:
	pha
	ldx	#r0
	ldy	#r6
	jsr	l1896				; copies contents of r0 to r6
	jsr	L1516				; seems to manipulate dirEntryBuf, among other things
	jsr	l142b				; issues FindFile
	pla
	cpx	#$00				; check disk error
	bne	L1342
	asl	a
	asl	a
	asl	a
	pha
	tay
	ldx	#$00
L131F:
	lda	L12F5,x
	sta	l132e
	inx
	lda	L12F5,x
	sta	l132e+1
	inx
.byte $ad		; LDA absolute
l132e:
.word $ffff
	sta	$7510,y
	iny
	cpx	#$10
	bcc	L131F
	pla
	tax
	lda	curDrive
	sta	$7515,x
	ldx	#$00
L1342:
	rts

; calling this with .A=$00 opens the geoPublish datafile
; calling this with .A=$01 opens the Master Page Library file.
; calling this with .A=$02 opens the Page Layout Library file.
L1343:					; not sure yet.
	cmp	$75A8				; don't know yet.
	bne	@1
	ldx	#$00
	lda	$75A9				; gets device number for dataDrive
	jmp	selectDevice
@1:	pha
	jsr	L14D8				; modifies dirEntryBuf and issues a PutBlock
	pla					; for fileHeader
	jsr	L13BA				; modifies some parts of dirEntryBuf
	ldy	#$1D
@2:	lda	dirEntryBuf,y		; copies the name of the data file
	sta	(r5L),y			; to diskBlkBuf
	dey
	bpl	@2
	clc
	lda	#$0E
	adc	$C275
	sta	$C275				; modifies GEOS jump table for OpenRecordFile
	bcc	@3				; to skip the FindFile call
	inc	$C276
@3:	jsr	L141F				; calls OpenRecordFile
	sec
	lda	$C275
	sbc	#$0E
	sta	$C275				; restores the GEOS jump table entry for OpenRecordFile
	lda	$C276
	sbc	#$00
	sta	$C276
	txa					; check disk error
	beq	@4
	bne	L139C
@4:	rts

	ldx	#$00
	ldy	#$98
	jsr	L13A8
L1391:
	lda	#$00
	sta	$75AB
	sta	$75AA
	sta	$8498
L139C:
	lda	#$FF
	sta	$75A8
	rts

        asl     a
        asl     a
        asl     a
        tax
        ldy     #$08
L13A8:  lda     #$00
L13AA:  sta     $7510,x
        inx
        dey
        bne     L13AA
        rts

l13b2:
	asl	a
	asl	a
	asl	a
	tay
	lda	$7510,y
	rts

L13BA:					; copies area at $7510 to various locations
	sta	$75A8				; determined by a table @ $12f5
	asl	a				; the table seems to contain pointers to dirEntryBuf
	asl	a
	asl	a
	pha
	tay
	ldx	#$00
L13C4:
	lda	L12F5,x
	sta	l13d6
	inx
	lda	L12F5,x
	sta	l13d6+1
	inx
	lda	$7510,y
.byte $8d					; STA absolute
l13d6:
.word $ffff
	iny
	cpx	#$10
	bcc	L13C4
	and	#$7F
	sta	dirEntryBuf+29		; high byte of file size in direntry
	lda	#$80
	sta	r5H
	sta	r4H
	lda	#$00
	sta	r4L
	lda	#$83
	sta	dirEntryBuf			; GEOS/USR filetype
	lda	#$01
	sta	dirEntryBuf+21		; type VLIR
	lda	$75A9
	beq	@1
	jsr	selectDevice		; issues SetDevice
@1:	pla
	tax
	rts

	lda	#$9F
.byte $2c
l1404:
	lda	#$ab				; calls WriteRecord
	jsr	L1481				; checks the directory header and writes/reads it
						; as necessary
	beq	L140C				; check disk error
	rts
L140C:
.byte $2c
	lda	#$b1
.byte $2c
	lda	#$ab
.byte $2c
	lda	#$24
.byte $2c
l1416:
	lda	#$09				; SaveFile
.byte $2c
	lda	#$15				; WriteFile
.byte $2c
l141c:
	lda	#$03				; PutBlock
.byte $2c
L141F:					; calls OpenRecordFile
	lda	#$90
.byte $2c
	lda	#$93
.byte $2c
pReadFile:
	lda	#$1b
.byte $2c
pOpenDisk:					; calls OpenDisk
	lda	#$bd
.byte $2c
l142b:
	lda	#$27				; FindFile
.byte $2c
l142e:
	lda	#$63				; GetDirHead
.byte $2c
l1431:
	lda	#$a8				; ReadRecord
.byte $2c
l1434:
	lda	#$00				; GetBlock
.byte $2c
	lda	#$57
	clc
	adc	#$E4
	sta	L144A
	lda	#$00
	adc	#$C1
	sta	L144A+1
	jsr	toggleZP
.byte $20					; JSR instruction
L144A:
.byte $e4,$c1
	jmp	toggleZP

L144F:
	jsr	L1481				; calls GetDirHead
	bne	@1
	jmp	AppendRecord		; no toggleZP?
	jsr	L1481
	bne	@1
	jmp	InsertRecord		; no toggleZP?
@1:	rts

L1460:
	jsr	toggleZP
	jsr	EnterTurbo
	jsr	PutDirHead
	jmp	toggleZP

selectDevice:				; used to select the disk device
	cmp	curDrive			; if the drive is already active, do nothing
	beq	@1
	jsr	toggleZP
	tay
	txa
	pha
	tya
	jsr	SetDevice
	pla
	tax
	jsr	toggleZP
@1:	rts

L1481:
	pha
	ldx	#$00
	lda	$75A8
	bmi	@3
	lda	$8498				; fileWritten flag
	bne	@2
	lda	$75AB
	beq	@1
	lda	curDrive
	cmp	$75AC
	beq	@2
	jsr	L14BC				; calls PutDirHead
@1:	lda	curDrive
	sta	$75AC
	jsr	l142e				; calls GetDirHead
	txa
	bne	@3
@2:	lda	#$FF
	sta	$8498				; fileWritten flag
	sta	$75AB
	sta	$75AA
@3:	pla
	cpx	#$00
	rts

l14b9:					; Main Loop for geoPublish
	jsr	L14D8
L14BC:
	lda	$75AB
	beq	@1
	lda	#$00
	sta	$75AB
	lda	curDrive
	pha
	lda	$75AC
	jsr	selectDevice
	jsr	L1460				; calls PutDirHead
	pla
	jsr	selectDevice
@1:	rts

L14D8:
	ldy	$75AA
	beq	@1
	lda	#$00
	sta	$75AA
	lda	curDrive
	pha
	lda	$75A8
	jsr	L13BA				; modifies some parts of dirEntryBuf
	lda	$8499				; fileSize
	sta	$7516,x
	lda	$849A				; fileSize+1
	ora	#$80
	sta	$7517,x
	lda	$7510,x
	sta	r1L				; t/s pointers
	lda	$7511,x
	sta	r1H
	lda	#$81				; data at fileHeader
	sta	r4H
	jsr	l141c				; issues PutBlock
	pla
	jsr	selectDevice		; issues SetDevice
@1:	rts

L1510:
	jsr	l14b9
	jmp	L1391

L1516:
	lda	curDrive
	pha
	jsr	L161E				; reads in geoPublish data, moves it and writes it
	jsr	l14b9				; modifies dirEntryBuf and calls PutBlock, if necessary
	lda	#$12				; calls PutDirHead, if necessary
@1:	pha
	jsr	L13BA				; modifies dirEntryBuf of the file in question
	lda	$7517,x
	bpl	@3
	and	#$7F
	sta	$7517,x
	jsr	l1434				; calls GetBlock
	ldy	#$17
@2:	lda	$84FF,y
	sta	(r5L),y
	iny
	cpy	#$1C
	bne	@2
	lda	dirEntryBuf+28
	sta	(r5L),y
	iny
	lda	dirEntryBuf+29
	sta	(r5L),y
	jsr	l141c				; calls PutBlock
@3:	pla
	sec
	sbc	#$01
	bpl	@1
	jsr	L1391				; not sure yet
	pla
	jmp	selectDevice

L155A:
	ldy	#$08
	ldx	#$04
@1:	lda	($D5),y			; copies data for graphics objects
	sta	$6ED4,x
	dey
	dex
	bpl	@1
	rts

L1568:
	ldy	#$08
	ldx	#$04
@1:	lda	$6ED4,x
	sta	($D5),y
	dey
	dex
	bpl	@1
	ldy	#$00
	lda	$D5
	sta	($D5),y
	iny
	lda	$D6
	sta	($D5),y
	rts

        lda     $D6
        cmp     #$5A
        bne     L158C
        lda     #$FF
        sta     $75AE
L158C:  rts

L158D:  lda     $D6
        beq     L158C
        cmp     #$5A
        bne     L1598
        jmp     L15B7

L1598:
	lda	#$73
	sta	$D6
	lda	#$C2
	sta	$D5
	lda	#$73
	sta	$750D
	lda	#$CB
	sta	$750C
	lda	#$75
	sta	$750F
	lda	#$0B
	sta	$750E
	jmp	L155A

L15B7:  lda     r0H
        pha
        lda     r0L
        pha
        jsr     L15C7
        pla
        sta     r0L
        pla
        sta     r0H
        rts

L15C7:					; opens the vlir record containing geoPublish data
	ldy	#$5A				; and reads it in, if necessary
	sty	$D6
	ldy	#$80
	sty	$D5				; start address of geoPublish data, I believe
	ldy	#$5A
	sty	$750D
	ldy	#$89				; area where graphics objects are stored $5a89
	sty	$750C
	ldy	#$6A
	sty	$750F
	ldy	#$80				; area containing geoPublish data - not sure which
	sty	$750E
	jsr	L155A				; copies area at $d5 to $6ed4
	lda	#$FF
	cmp	$75AD
	beq	@1
	sta	$75AD
	ldy	#$00
	sty	$75AE
	jsr	L1661				; opens the geoPublish datafile's VLIR record
	lda	r1L				; pointing to geoPublish data
	beq	@1
	lda	#$10
	sta	r2H
	lda	#$00
	sta	r2L
	jsr	l1431				; issues ReadRecord
	txa
	bne	@1
	jsr	L155A				; copies area at $d5 to $6ed4
	jsr	L16E3				; issues a MoveData command, moving some data around
	jsr	L170B				; sets some psuedo registers and copies data from $6ed4
@1:	lda	#$00				; to $d5
	sta	$AC
	sta	$AA
	sta	$AB
	jmp	L2267				; calls the BSW system font and returns

L161E:					; reads in geoPublish data, moves it around and
	lda	#$00				; writes it back to disk
	cmp	$75AD
	beq	@2
	ldy	$75AE
	beq	@2
	lda	$D6
	pha
	jsr	L15C7				; opens the vlir geoPublish data and reads it in
	jsr	L1676				; uses MoveData to move data around somewhere
	jsr	L1661				; opens the geoPublish data file and the vlir record
	sec					; containing geoPublish data
	lda	r2L
	sbc	#$80
	sta	r2L
	lda	r2H
	sbc	#$5A
	sta	r2H				; subtract start address of $5a80 to arrive at max length
	jsr	L1568				; sets the $d5 pointer
	jsr	l1404				; calls WriteRecord and writes the geoPublish data
	pla
	sta	$D6
	lda	$D6
	cmp	#$73
	beq	@1
	lda	#$00
	sta	$D6
	beq	@2
@1:	jsr	L1598				; not sure yet, but does set $d5 pointers
@2:	lda	#$00
	sta	$75AD
	rts

L1661:
	jsr	L2178				; opens the geoPublish data file
	lda	$6F07
	clc
	adc	#$13				; offset of $13 vlir records
	jsr	PointRecord
	lda	#$5A
	sta	r7H
	lda	#$80
	sta	r7L
	rts

L1676:					; sets pseudo registers for the MoveData action
	lda	$6ED5
	sta	r0H
	lda	$6ED4
	sta	r0L
	lda	$750E
	sec
	sbc	r0L
	sta	r2L
	lda	$750F
	sbc	r0H
	sta	r2H
	ldy	#$02
	lda	r2L
	sta	($D5),y
	iny
	lda	r2H
	lda	r2H
	sta	($D5),y
	jsr	L16BE				; sets value in r1
	lda	r1L
	clc
	adc	r2L
	pha
	lda	r1H
	adc	r2H
	pha
	jsr	L16B4				; issues MoveData
	pla
	sta	r2H
	pla
	sta	r2L
	rts

L16B4:
	lda	r2L
	ora	r2H
	beq	@1
	jsr	MoveData
@1:	rts

L16BE:
	lda	#$00
	sta	r1H
	lda	$6ED6
	asl	a
	rol	r1H
	asl	a
	rol	r1H
	asl	a
	rol	r1H
	asl	a
	rol	r1H
	sta	r1L
	lda	$750C
	clc
	adc	r1L
	sta	r1L
	lda	$750D
	adc	r1H
	sta	r1H
	rts

L16E3:					; sets pseudo registers for the MoveData command
	jsr	L16BE				; sets a value in r1H
	lda	r1H
	sta	r0H
	lda	r1L
	sta	r0L
	ldy	#$02
	lda	($D5),y
	sta	r2L
	iny
	lda	($D5),y
	sta	r2H
	lda	$750E
	sec
	sbc	r2L
	sta	r1L
	lda	$750F
	sbc	r2H
	sta	r1H
	jmp	L16B4

L170B:
	ldy	#$00
	lda	($D5),y			; sets r2 to a value pointed by $d5 subtracted
	sec					; by actual value at $d5.
	sbc	$D5				; In my single-stepping, I observed $73c2 value
	sta	r2L				; at $73c2. This value, $73c2, was subtracted by
	iny					; value at $d5-$d6, which is $73c2, resulting in $0000
	lda	($D5),y			; being loaded into r2.
	sbc	$D6
	sta	r2H
	lda	$6ED4				; in my single-stepping, I observed $6ed4 having a
	sec					; value which would end the graphics object region.
	sbc	r2L				; r2 contained a zero, essentially leaving the
	sta	$6ED4				; ending value untouched.
	lda	$6ED5
	sbc	r2H
	sta	$6ED5
	lda	$750D
	sta	r0H
	lda	$750C
	sta	r0L				; r0 is loaded with start of graphics object data
	ldx	$6ED6				; # of graphics objects.
	beq	@4
@1:	ldy	#$0F				; each graphics object is 16 bytes long
	lda	(r0L),y			; check the last word value of each graphics object
	beq	@2
	dey
	lda	(r0L),y
	sec
	sbc	r2L
	sta	(r0L),y
	iny
	lda	(r0L),y
	sbc	r2H
	sta	(r0L),y			; in single-stepping, having r2 as $0000 doesn't
@2:	clc					; affect the last word value of each graphics object
	lda	#$10
	adc	r0L
	sta	r0L
	bcc	@3
	inc	r0H
@3:	dex
	bne	@1				; cycle through the graphics objects
@4:	jmp	L1568				; restore the values at start of graphics object region

toggleZP:					; BSW's favorite routine, allowing geoPublish to use
	php					; more of the zp region. This routine will swap in/out the
	pha					; actual zp region and geoPublish zp region as needed.
	txa
	pha
	tya
	pha
	ldx	#$7F
@1:	ldy	$80,x
	lda	$6E34,x
	sta	$80,x
	tya
	sta	$6E34,x
	dex
	bpl	@1
	pla
	tay
	pla
	tax
	pla
	plp
	rts

L177E:  pha
        txa
        pha
        jsr     L182C
        jsr     L1946
        jsr     L1C16
        jsr     L1849
        pla
        tax
        pla
L1790:  stx     r0H
        sta     r0L
        bit     $75B0
        bpl     L17AC
        lda     r5H
        pha
        lda     r5L
        pha
        ldx     #$00
        stx     a2L
        jsr     L0B1C
        pla
        sta     r5L
        pla
        sta     r5H
L17AC:  jmp     DoDlgBox
L17AF:  pha
        lda     #>l17d8
        sta     r14H
        lda     #<l17d8
        sta     r14L			; point to NULL string
        pla
L17B9:  sta     r5L
        sty     r5H
        txa
        pha
L17BF:  lda     #<db17c9
        ldx     #>db17c9
        jsr     L177E
        pla
        tax
        rts

db17c9:
.byte $81					; standard DB
.byte $0c					; DBVARSTR
.byte $10,$10				; x/y positions
.byte $0c					; r5 (error message)
.byte $0c					; DBVARSTR
.byte $10,$20				; x/y positions
.byte $1e					; r14
.byte $01					; OK icon
l17d3:
.byte $11,$48				; x/y positions
l17d5:
.byte $00					; delimiter (& CANCEL icon)
.byte $11,$48				; x/y positions
l17d8:
.byte $00

L17D9:
	sta	r14L
	sty	r14H
	txa
        pha
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        jsr     L17FD
        sta     l1813
        txa
        and     #$0F
        jsr     L17FD
        sta     l1813+1
        lda     #$18
        sta     r5H
        lda     #$0A
        sta     r5L
        jmp     L17BF
L17FD:  cmp     #$0A
        bcs     L1806
        clc
        adc     #$30
        bne     L1809
L1806:  clc
        adc     #$37
L1809:  rts

.byte $18
.byte "Error I:"
l1813:
.byte $20,$20,$20,$00

SetProgDevice:
	lda	progDrive
	bne	SetDataDevice+3
SetDataDevice:
	lda	dataDrive
	jmp	selectDevice

l1822:
	jsr	i_MoveData
.word fnBuffer				; source address
.word dFileName				; dest address
.word $0011					; # of bytes to move
	rts

L182C:
	pla					; saves pseudo-registers r0..r15
	sta	l1847
	pla
	sta	l1847+1
	inc	l1847
	bne	@1
	inc	l1847+1
@1:	ldx	#$00
@2:	lda	r0L,x
	pha
	inx
	cpx	#$20
	bne	@2
.byte $4c					; JMP instruction
l1847:
.word Panic

L1849:
	pla					; restores pseudo-registers r0..r15
	sta	L1862
	pla
	sta	L1862+1
	inc	L1862
	bne	@1
	inc	L1862+1
@1:	ldx	#$1F
@2:	pla
	sta	r0L,x
	dex
	bpl	@2
.byte   $4C					; JMP instruction
L1862:
.word Panic
;.byte   $C2
;.byte   $C2

.include "gpd02v00.asm"			; contains decoded geoPublish code.

;L1864:					; this is valid code and needs to be decoded.
;.byte $3C,$8E,$B9,$3C,$85,$B9,$3C,$9D,$B9,$3C,$91
;.byte $8D,$E0,$95,$00,$95,$05,$97,$63,$94,$F5,$3C,$9D,$10,$EA,$AD,$20
;.byte $95,$70,$EA,$00,$95,$25,$97,$43,$94,$F5
;.byte $20,$94,$4c,$94,$95,$45,$90,$20,$95,$4c,$95,$95,$f5,$20,$95,$0c
;.byte $95,$95,$20,$94,$0c,$94,$95,$f5

	ldy	#$05
@4:	lda	$18b9,y
	sta	$84b8,y
	dey
	bpl	@4
	rts
L18AD:  ldy     #$05
L18AF:  lda     L18B9,y
        sta     windowTop,y
        dey
        bpl     L18AF
        rts
L18B9:  .byte   $00,$C7,$00,$00,$3F,$01

L18BF:
	ldx	#r0			; $02
.byte $2c
l18c2:
	ldx	#r5
.byte $2c
L18C5:
	ldx	#r6			; $0e
	lda	#$23
	sta	$00,x
	inx
	lda	#$6E
	sta	$00,x
	rts

L18D1:
	txa
	pha
	jsr	GotoFirstMenu
	pla
	tax
L18D8:
	lda	L18E6,x
	and	$6F06
	beq	@1
	lda	#$00
	rts
@1:	lda	#$FF
	rts

L18E6:
.byte $00,$04,$0C,$20,$0E,$00,$0C,$02
.byte $02,$01,$01,$81,$84,$a1,$90,$88; the first $90 will disable the library menu function
.byte $84,$8A,$89,$84,$95,$84		; under Page Graphics mode.
	; Page Graphics mode has $12 in $6f06, Page Layout has $0a in $6f06, Master Pages has
	; $06 in $6f06. The zoom mode for MP is $05, and for PG is $11

L18FC:  lda     $6F10
        beq     L190A
        inc     $6F10
        jsr     L1955
        clv
        bvc     L1910
L190A:  dec     $6F10
        jsr     L1922
L1910:  jmp     L0EC8

L1913:					; saves the screen under the zoom toolbox
	lda	$6F05
	beq	l1945
	lda	$6F10
	beq	l1945
	lda	$6DA9
	beq	l1945
L1922:
	lda	#$FF
	sta	$6DA8
	ldx	#$1C
	stx	a2L
	jsr	L0B1C
	inc	$6DA8
L1931:
	lda	#$00
	sta	$6DA9
	jsr	i_BitmapUp			; draws the zoom toolbox
.byte $EF,$08,$04,$28,$08,$30
	jsr	l19dd				; load in VLIR #$02
	jsr	L3189				; sets up the zoom toolbox
l1945:
	rts

L1946:					; restores the screen under the zoom toolbox
	lda	$6F05
	beq	L1965
	lda	$6F10
	beq	L1965
	lda	$6DA9
	bne	L1965
L1955:
	lda	#$FF
	sta	$6DA9
	sta	$6DA8
	ldx	#$1C
	jsr	L0B21				; actually copies the buffer contents onto the screen
	inc	$6DA8
L1965:
	rts

        jsr     i_GraphicsString
        ora     r0L
        ora     (r15L,x)
        brk
        plp
        .byte   $03
        rts
        brk
        pla
        brk
        rts
L1975:
        jsr     i_GraphicsString
        ora     r0L
        ora     ($90,x)
        brk
        brk
        .byte   $03
        .byte   $3F
        ora     (r7L,x)
        .byte   $03
        brk
        brk
        .byte   $C7
        brk
        rts
L1988:  lda     $6F05
        beq     L1990
        jmp     L2530
L1990:  jmp     L2518
L1993:
	lda	$6F04				; flag to indicate which MP or PL mode is in use
	cmp	#$01				; PL mode
	rts

L1999:
	lda	$6F04				; PL or MP mode?
	cmp	#$00				; MP mode
	rts

L199F:  ldx     #$02
        stx     l17d5
        ldx     #$01
        stx     l17d3
        jsr     L17B9
        lda     #$00
        sta     l17d5
        ldx     #$11
        stx     l17d3
        rts

;.include "gpb03v00.a"
.include "modman.a"			; improved VLIR routine using expansion RAM

						; ($1a80)
	jsr	l19d7				; calls VLIR #$01
	jsr	L3192				; executes code there
	txa
	bne	@10
	jsr	l19f2				; calls VLIR #$0e & #$05
	jmp	L5280				; executes code there
@10:	jmp	EnterDeskTop

L1A92:  jsr     l19d7
        jmp     L31B0
L1A98:
	jsr	l19f2
	jmp	L5283
L1A9E:
	jsr	l19d7				; calls geoPublish module #$01
	jsr	L31A7				; and executes the callLibrary function
	php
	jsr	l19dd				; calls geoPublish module #$02
	plp
	bcc	@2				; take branch if library used in SAVE function
						; or a OPEN function failed
						; code here deals with the user OPENing a library
						; file's contents.
	jsr	L1993				; check MP or PL mode
	bne	@1				; take branch if in MP mode
	jsr	L04FB				; no idea yet.
	jsr	L4A9E				; executes some code in vlir #$03
	clv
	bvc	@3
@1:	jsr	l0f45				; handle both MP & PG modes
;	jsr	L1B9F				; calls geoPublish module #$04 and executes code there
@2:	jsr	L1913				; no idea yet.
@3:	rts

        jsr     l19d7
        jsr     L3180
        jsr     l19dd
        jmp     L1913
        pha
        jsr     l19d7
        pla
        jsr     L3183
        jmp     L04AB
        jsr     L1999
        bne     L1AE2
        jsr     L5289
        jmp     l12c4
L1AE2:  jsr     L049B
        php
        jsr     l12c4
        jsr     l19dd
        jsr     L15C7
        plp
        bcs     L1AF5
        jsr     L04AB
L1AF5:  rts
L1AF6:  jsr     l19d7
        jmp     L3198
L1AFC:  jsr     l19d7
        jmp     L31AD
        jsr     l19d7
        jsr     L3186
        jsr     l19dd
        jmp     L1913
        jsr     GotoFirstMenu
        jsr     L042D
        jsr     l19d7
        jsr     L3189
        jmp     L04AB
quit:						; quits geoPublish
	jsr	GotoFirstMenu
	jsr	L042D				; no idea yet.
	jsr	l19d7				; loads VLIR #$01
	jmp	L318C				; executes code there

L1B29:  jsr     L0440
        jsr     l19d7
        jsr     L319E
        jsr     l19dd
        jsr     L2154
        jsr     L1999
        bne     L1B46
L1B3D:  jsr     L04E5
        jsr     L1B99
        jmp     L1B9F
L1B46:  jsr     L1993
        bne     L1B4E
        jmp     L4A9E
L1B4E:  jmp     L1F8E
L1B51:  jsr     l19d7
        jsr     L31AA
        jmp     l19dd
        jsr     GotoFirstMenu
        jsr     l19d7
        jsr     L31A4
        jsr     l19dd
        jmp     L1913
        jsr     l19d7
        jsr     L31A1
        jmp     l19dd
        jsr     l19d7
        jsr     L318F
        jsr     L04F1
        jmp     L04AB
L1B7E:  jsr     l19bd
        jmp     L2503
        jsr     l19d7
        jsr     L3195
        jmp     L04AB
L1B8D:  jsr     l19ba
        jmp     L2500
L1B93:  jsr     l19f9
        jmp     L4A80
L1B99:  jsr     l1a02
        jmp     L5280

L1B9F:
	jsr	l1a02				; calls module #$04
	jmp	L5286

L1BA5:  jsr     l19dd
        jmp     L3180
        jsr     L1999
        bne     L1BB3
        jmp     L528F
L1BB3:  jsr     l19d7
        jsr     L319B
        jsr     l19dd
        lda     $6DAE
        bne     L1BC4
        jmp     L1913
L1BC4:  jmp     L04AB
        jsr     L0484
        bcs     L1BD2
        jsr     L049B
        jsr     L04AB
L1BD2:  rts
L1BD3:  lda     l6d87
        beq     L1BD2
        jmp     L3198
L1BDB:  jsr     L161E
        jsr     L04F1
        jsr     l19ca
        jsr     L2503
        ldx     $6DA5
        bne     L1BEF
        jsr     L2500
L1BEF:  txa
        beq     L1BF5
        jsr     L1244
L1BF5:  jmp     l19bd
L1BF8:  jsr     l19da
        jmp     L3180
L1BFE:  jsr     l19da
        jmp     L3183
        jsr     l19da
        jsr     L3186
        jmp     l19dd
        jsr     l19da
        jsr     L3189
        jmp     l19dd

L1C16:
	lda	l6d87
	bne	@1
	rts
@1:	lda	$6F04
	cmp	#$01
	beq	@2
	jmp	L31AA
@2:	jmp	L080D

        jmp     L2521
        jmp     L2500
L1C2F:  jmp     L1250
        jmp     L2509
        jmp     L251B
        jmp     L2506
L1C3B:  lda     #$00
        ldx     r7H
        cpx     r11H
        bne     L1C47
        ldx     r7L
        cpx     r11L
L1C47:  beq     L1C4B
        bcs     L1C4D
L1C4B:  ora     #$08
L1C4D:  ldx     r13H
        cpx     r9H
        bne     L1C57
        ldx     r13L
        cpx     r9L
L1C57:  beq     L1C5B
        bcs     L1C5D
L1C5B:  ora     #$04
L1C5D:  ldx     r6H
        cpx     r10H
        bne     L1C67
        ldx     r6L
        cpx     r10L
L1C67:  beq     L1C6B
        bcs     L1C6D
L1C6B:  ora     #$02
L1C6D:  ldx     r12H
        cpx     r8H
        bne     L1C77
        ldx     r12L
        cpx     r8L
L1C77:  beq     L1C7B
        bcs     L1C7D
L1C7B:  ora     #$01
L1C7D:  sta     $6DA7
        rts
L1C81:  ldx     #$12
        ldy     #$16
        jsr     l1889
        bcc     L1CA8
        ldx     #$1A
        ldy     #$0E
        jsr     l1889
        bcc     L1CA8
        ldx     #$14
        ldy     #$18
        jsr     l1889
        bcc     L1CA8
        ldx     #$1C
        ldy     #$10
        jsr     l1889
        bcc     L1CA8
        lda     #$FF
        rts
L1CA8:  lda     #$00
        rts

	jsr	L2186				; opens vlir #$xx of geoPublish datafile
	jsr	l1404				; and writes it to disk via WriteRecord
	jmp	L161E				; opens geoPublish data at the relevant VLIR module
						; moves some data around and writes it back to disk
L1CB4:					; not sure what it does.
	sec
	lda	$713E
	beq	@1
	lda	#$71
	sta	$81
	lda	#$3F
	sta	$80
	lda	#$01
	sta	$82
	jsr	L1CCB
	clc
@1:	rts

L1CCB:
	ldy	$81
	sty	$84
	ldy	$80
	sty	$83
	ldy	#$11
	lda	($80),y
	beq	@1
	cmp	#$FF
	beq	@1
	ldy	#$0F
	lda	($80),y
	clc
	adc	#$5F
	sta	$83
	iny
	lda	($80),y
	adc	#$72
	sta	$84
	lda	#$01
@1:	sta	$85
	rts

        jsr     L1D01
        bcc     L1D00
        jsr     L1D1F
        bcs     L1D00
        jsr     L1CCB
        clc
L1D00:  rts
L1D01:  lda     $85
        bmi     L1D07
        bne     L1D0A
L1D07:  sec
        bcs     L1D1E
L1D0A:  ldy     #$11
	cmp	($80),y
        beq     L1D1E
        clc
        lda     #$0A
        adc     $83
        sta     $83
        bcc     L1D1B
        inc     $84
L1D1B:  inc     $85
        clc
L1D1E:  rts

L1D1F:
	lda	$82
	cmp	$713E
	beq	@1
	inc	$82
	clc
	lda	#$12
	adc	$80
	sta	$80
	bcc	@2
	inc	$81
@2:	lda	$81
	sta	$84
	lda	$80
	sta	$83
	clc
@1:	rts

L1D3D:  lda     $6F07
        clc
        adc     #$11
        tay
        lda     ($89),y
        rts
L1D47:  lda     #$00
        sta     $A9
        sta     $A8
        jsr     L1CB4
        bcs     L1D62
        lda     $81
        sta     $84
        lda     $80
        sta     $83
L1D5A:  jsr     L1D70
        jsr     L1D1F
        bcc     L1D5A
L1D62:  lda     #$00
        sta     $6DBB
        sta     $6DBD
        jsr     L18AD
        jmp     L2267
L1D70:  lda     $6F05
        beq     L1D81
        jsr     L1EB2
        jsr     L1278
        jsr     L1C81
        tax
        beq     L1DB5
L1D81:  lda     #$FF
        sta     $6EB6
        ldy     #$0A
        lda     ($80),y
        pha
        lda     #$00
        jsr     L1E46
        pla
        beq     L1DA0
        cmp     #$11
        bcs     L1D9D
        jsr     L1DB6
        clv
        bvc     L1DA0
L1D9D:  jsr     L1BFE
L1DA0:  jsr     L1993
        beq     L1DAA
        lda     $6F0F
        beq     L1DB5
L1DAA:  lda     $81
        sta     $84
        lda     $80
        sta     $83
        jsr     L1DFC
L1DB5:  rts
L1DB6:  jsr     L1170
        jsr     L1D3D
        sta     $6DBF
        bmi     L1DEC
        ldy     #$11
        lda     ($80),y
        bmi     L1DFB
        jsr     L1CCB
L1DCA:  ldy     #$08
        lda     ($83),y
        sta     $6EB6
        lda     $6F05
        beq     L1DEC
        jsr     L1EB2
        jsr     L1278
        jsr     L1C81
        beq     L1DF6
        lda     $6F0D
        beq     L1DEC
        jsr     L1BF8
        clv
        bvc     L1DF6
L1DEC:  lda     #$14
        jsr     L1E46
        lda     $6DBF
        bmi     L1DFB
L1DF6:  jsr     L1D01
        bcc     L1DCA
L1DFB:  rts
L1DFC:  ldx     #$0F
L1DFE:  lda     #$06
L1E00:  pha
        jsr     L1E23
        pla
        sec
        sbc     #$02
        bpl     L1E00
        stx     r15L
        lda     $6F05
        beq     L1E19
        jsr     L1278
        jsr     L1C81
        beq     L1E1E
L1E19:  lda     #$02
        jsr     L1E76
L1E1E:  ldx     r15L
        bpl     L1DFE
        rts
L1E23:  ldy     L1E36,x
        stx     r2L
        tax
        lda     ($83),y
        sta     r6L,x
        iny
        lda     ($83),y
        sta     r6H,x
        ldx     r2L
        dex
        rts
L1E36:  .byte   $00,$02,$04,$02,$00,$06,$04,$06
        .byte   $00,$02,$00,$06,$04,$02,$04,$06
L1E46:  pha
        jsr     L1EB2
        lda     $6EB6
        cmp     #$FF
        beq     L1E75
        pla
        lda     #$0B
        pha
        lda     #$00
        sta     $6EB7
        asl     $6EB6
        rol     $6EB7
        asl     $6EB6
        rol     $6EB7
        lda     r7L
        clc
        adc     $6EB6
        sta     r9L
        lda     r7H
        adc     $6EB7
        sta     r9H
L1E75:  pla
L1E76:  jsr     SetPattern
        lda     $6F05
        beq     L1E87
        jsr     L1EBD
        jsr     L1EF8
        clv
        bvc     L1E8A
L1E87:  jsr     L1F4B
L1E8A:  lda     r6H
        sta     r3H
        lda     r6L
        sta     r3L
        lda     r8L
        ldx     r8H
        cpx     r3H
        bne     L1E9C
        cmp     r3L
L1E9C:  bcc     L1EB1
        sta     r4L
        stx     r4H
        lda     r7L
        sta     r2L
        lda     r9L
        cmp     r2L
        bcc     L1EB1
        sta     r2H
        jsr     Rectangle
L1EB1:  rts
L1EB2:  ldy     #$07
L1EB4:  lda     ($83),y
        sta     r6L,y
        dey
        bpl     L1EB4
        rts
L1EBD:  jsr     L1C3B
        lda     $6DA7
        tax
        and     #$08
        beq     L1ED0
        lda     $C5
        sta     r7H
        lda     $C4
        sta     r7L
L1ED0:  txa
        and     #$04
        beq     L1EDD
        lda     $C9
        sta     r9H
        lda     $C8
        sta     r9L
L1EDD:  txa
        and     #$02
        beq     L1EEA
        lda     $C3
        sta     r6H
        lda     $C2
        sta     r6L
L1EEA:  txa
        and     #$01
        beq     L1EF7
        lda     $C7
        sta     r8H
        lda     $C6
        sta     r8L
L1EF7:  rts
L1EF8:  lda     r6L
        ldy     r6H
        jsr     L1F25
        sta     r6L
        sty     r6H
        lda     r8L
        ldy     r8H
        jsr     L1F25
        sta     r8L
        sty     r8H
        lda     r7L
        ldy     r7H
        jsr     L1F3A
        sta     r7L
        sty     r7H
        lda     r9L
        ldy     r9H
        jsr     L1F3A
        sta     r9L
        sty     r9H
        rts
L1F25:  sec
        sbc     $B1
        tax
        tya
        sbc     $B2
        tay
        txa
        clc
        adc     $75B3
        tax
        tya
        adc     $75B4
        tay
        txa
        rts
L1F3A:  sec
        sbc     $B3
        tax
        tya
        sbc     $B4
        tay
        txa
        clc
        adc     $75B1
        bcc     L1F4A
        iny
L1F4A:  rts
L1F4B:  ldx     #$06
L1F4D:  jsr     L1F70
        dex
        dex
        bpl     L1F4D
        lda     #$98
        ldx     #$0E
        jsr     l186f
        lda     #$98
        ldx     #$12
        jsr     l186f
        lda     #$0B
        ldx     #$10
        jsr     l186f
        lda     #$0B
        ldx     #$14
        jmp     l186f
L1F70:  lsr     r6H,x
        ror     r6L,x
        lsr     r6H,x
        ror     r6L,x
        rts
        lda     $6F07
        beq     L1F8D
        clc
        adc     #$11
        tay
        dey
        lda     #$00
L1F85:  clc
        adc     ($89),y
        dey
        cpy     #$11
        bcs     L1F85
L1F8D:  rts
L1F8E:  jsr     L1988
        lda     $D6
        pha
        jsr     L1FA3
        pla
        sta     $D6
        jsr     L158D
        jsr     L1BD3
        jmp     L1913
L1FA3:  lda     $6F05
        bne     L1FAD
        jsr     L1999
        beq     L1FB8
L1FAD:  lda     $6F09
        beq     L1FB8
        jsr     L201E
        jsr     L2079
L1FB8:  jsr     L1999
        beq     L1FC7
        ldx     #$01
        jsr     L18D8
        and     $6F0A
        beq     L1FCD
L1FC7:  jsr     L1598
        jsr     L3186
L1FCD:  jsr     L1993
        bcc     L1FD8
        jsr     L1D47
        jsr     l19dd
L1FD8:  ldx     #$02
        jsr     L18D8
        and     $6F0B
        beq     L1FE8
        jsr     L15B7
        jsr     L3186
L1FE8:  rts
L1FE9:  jsr     L04EB
        lda     $6F04
        pha
        lda     #$02
        sta     $6F04
        jsr     L0EC5
        lda     $6F05
        beq     L2007
        jsr     L1946
        jsr     L1FCD
        pla
        clv
        bvc     L201B
L2007:  pla
        cmp     #$01
        bne     L2018
        jsr     L110D
        jsr     L1FD8
        jsr     L1931
        clv
        bvc     L201B
L2018:  jsr     L1B7E
L201B:  jmp     L1913
L201E:  lda     $73BF
        sta     $6ABF
        beq     L2078
        lda     #$0B
        sta     r3L
        lda     #$C6
        sta     r3H
        lda     $6F05
        beq     L2053
        lda     $C5
        sta     r1H
        lda     $C4
        sta     r1L
        jsr     L1C2F
        lda     r1L
        pha
        lda     $C9
        sta     r1H
        lda     $C8
        sta     r1L
        jsr     L1C2F
        lda     r1L
        sta     r3H
        pla
        sta     r3L
L2053:  lda     #$00
        sta     r5H
        lda     #$C2
        sta     r5L
        lda     #$9F
        ldx     #$73
        jsr     L20DE
        cmp     #$00
        beq     L2073
        lda     r0H
        sta     r4H
        lda     r0L
        sta     r4L
        lda     #$88
        jsr     VerticalLine
L2073:  dec     $6ABF
        bne     L2053
L2078:  rts
L2079:  lda     $73C0
        sta     $6ABF
        beq     L20DD
        lda     #$00
        sta     r3H
        lda     #$98
        sta     r3L
        lda     #$01
        sta     r4H
        lda     #$37
        sta     r4L
        lda     $6F05
        beq     L20BC
        lda     $C3
        sta     r0H
        lda     $C2
        sta     r0L
        jsr     L1C2F
        lda     r0H
        sta     r3H
        lda     r0L
        sta     r3L
L20A9:  lda     $C7
        sta     r0H
        lda     $C6
        sta     r0L
        jsr     L1C2F
        lda     r0H
        sta     r4H
        lda     r0L
        sta     r4L
L20BC:  lda     #$00
        sta     r5H
        lda     #$C4
        sta     r5L
        lda     #$AF
        ldx     #$73
        jsr     L20DE
        cmp     #$00
        beq     L20D8
        lda     r1L
        sta     r11L
        lda     #$88
        jsr     HorizontalLine
L20D8:  dec     $6ABF
        bne     L20BC
L20DD:  rts
L20DE:  sta     r2L
        stx     r2H
        lda     $6ABF
        asl     a
        tay
        dey
        lda     (r2L),y
        sta     r0H
        dey
        lda     (r2L),y
        sta     r0L
        lda     $6F05
        beq     L2120
        ldx     #$01
        ldy     #$01
        lda     r0H
        cmp     (r5L),y
        bcc     L213A
        bne     L210B
        dey
        lda     r0L
        cmp     (r5L),y
        bcc     L213A
        beq     L213A
L210B:  ldx     #$01
        ldy     #$05
        lda     (r5L),y
        cmp     r0H
        bcc     L213A
        bne     L2120
        dey
        lda     (r5L),y
        cmp     r0L
        bcc     L213A
        beq     L213A
L2120:  lda     r2H
        cmp     #$73
        bne     L212A
        lda     r2L
        cmp     #$AF
L212A:  bne     L2134
        lda     r0H
        sta     r1H
        lda     r0L
        sta     r1L
L2134:  jsr     L1C2F
        lda     #$FF
        rts
L213A:  lda     #$00
        rts
L213D:  ldx     #$11
        lda     $6F03
        beq     L2152
        lda     $6F07
        lsr     a
        lda     #$00
        ror     a
        eor     $6F02
        bpl     L2152
        ldx     #$12
L2152:  txa
        rts
L2154:  jsr     L213D
.byte $2c
l2158:
	lda	#$11
.byte $2c
l215b:
	lda	#$12
        jsr     L2199
        jsr     l1431
        txa
        bne     L2177
        lda     $D6
        pha
        jsr     L1598
        jsr     L170B
        pla
        sta     $D6
        jsr     L158D
        ldx     #$00
L2177:  rts

L2178:
	pha
	lda	#$00
	jsr	L1343				; opens a geoPublish datafile
	pla
	rts

L2180:  jsr     L2186
        jmp     l1431
L2186:
	ldx	$6F07				; current datafile vlir #?
	inx					; this seems to select vlir #$01
	txa
	ldy	#$02
	sty	r2H
	ldy	#$61
	sty	r2L				; max size of module $0261
	ldx	#$3E
	ldy	#$71				; start address is $713e
	bne	L21A5
L2199:
	ldy	#$01
	sty	r2H
	ldy	#$6C
	sty	r2L
	ldx	#$9F
	ldy	#$73
L21A5:
	stx	r7L
	sty	r7H
	jsr	L2178				; opens the geoPublish datafile
	jmp	PointRecord
	rts

        jsr     L182C
        jsr     L21BA
        jsr     L1849
        rts
L21BA:  lda     r1H
        cmp     #$00
        bne     L21C4
        lda     r1L
        cmp     #$09
L21C4:  beq     L21D4
        lda     r1H
        cmp     $A9
        bne     L21D0
        lda     r1L
        cmp     $A8
L21D0:  beq     L21D7
        bne     L21E1
L21D4:  jsr     UseSystemFont
L21D7:  lda     r1H
        sta     $A9
        lda     r1L
        sta     $A8
        clc
        rts
L21E1:  jsr     L238A
        bcs     L21F9
        jsr     L227B
        lda     $6DEA,x
        sta     r0H
        lda     $6DE2,x
        sta     r0L
        jsr     LoadCharSet
        clv
        bvc     L21D7
L21F9:  jsr     L23B5
        bcs     L2267
        lda     $6BBA,x
        beq     L2267
        txa
        pha
        lda     $6C2A,x
        sta     r3L
        lda     $6C2B,x
        sta     r3H
        jsr     L229C
        jsr     L227B
        lda     r1L
        sta     $6DD2,x
        lda     r1H
        sta     $6DDA,x
        lda     $6DEA,x
        sta     r7H
        lda     $6DE2,x
        sta     r7L
        pla
        tax
        lda     r1H
        pha
        lda     r1L
        pha
        lda     r7H
        pha
        lda     r7L
        pha
        lda     $6BBA,x
        sta     r1L
        lda     $6BBB,x
        sta     r1H
        lda     #$10
        sta     r2H
        lda     #$00
        sta     r2L
        jsr     SetProgDevice
        jsr     pReadFile
        jsr     SetDataDevice
        pla
        sta     r0L
        pla
        sta     r0H
        pla
        sta     $A8
        pla
        sta     $A9
        cpx     #$00
        bne     L2267
        jsr     LoadCharSet
        clc
        rts

L2267:
	jsr	UseSystemFont
	lda	#$00
	sta	$A9
	lda	#$09
	sta	$A8
	sec
	rts
L2274:  lda     #$00
        sta     currentMode
        jmp     L2267
L227B:  lda     $AA
        sta     $6E02,x
        lda     $AB
        sta     $6E0A,x
        inc     $AA
        bne     L228B
        inc     $AB
L228B:  bne     L229B
        ldy     #$00
        tya
L2290:  sta     $6E02,y
        sta     $6E0A,y
        iny
        cpy     $AC
        bne     L2290
L229B:  rts
L229C:  ldx     $AC
        beq     L22D7
        cpx     #$08
        beq     L22C5
        lda     $6DE1,x
        clc
        adc     $6DF1,x
        tay
        lda     $6DE9,x
        adc     $6DF9,x
        tax
        tya
        clc
        adc     r3L
        tay
        txa
        adc     r3H
        cmp     #$6A
        bne     L22C1
        cpy     #$80
L22C1:  bcc     L22DE
        beq     L22DE
L22C5:  lda     r1H
        pha
        lda     r1L
        pha
        jsr     L2304
        pla
        sta     r1L
        pla
        sta     r1H
        clv
        bvc     L229C
L22D7:  ldy     #$80
        lda     #$5A
        clv
        bvc     L22EE
L22DE:  ldx     $AC
        lda     $6DE1,x
        clc
        adc     $6DF1,x
        tay
        lda     $6DE9,x
        adc     $6DF9,x
L22EE:  ldx     $AC
        sta     $6DEA,x
        tya
        sta     $6DE2,x
        lda     r3L
        sta     $6DF2,x
        lda     r3H
        sta     $6DFA,x
        inc     $AC
        rts
L2304:  ldy     #$00
        ldx     #$01
L2308:  cpx     $AC
        beq     L2322
        lda     $6E0A,x
        cmp     $6E0A,y
        bne     L231A
        lda     $6E02,x
        cmp     $6E02,y
L231A:  bcs     L231E
        txa
        tay
L231E:  inx
        clv
        bvc     L2308
L2322:  tya
        tax
        jmp     L2327
L2327:  inx
        cpx     $AC
        beq     L2387
        dex
        lda     $6DFB,x
        sta     r2H
        lda     $6DF3,x
        sta     r2L
        lda     $6DEB,x
        sta     r0H
        lda     $6DE3,x
        sta     r0L
        lda     $6DEA,x
        sta     r1H
        lda     $6DE2,x
        sta     r1L
        txa
        pha
        jsr     MoveData
        pla
        tax
        lda     $6DD3,x
        sta     $6DD2,x
        lda     $6DDB,x
        sta     $6DDA,x
        lda     $6E03,x
        sta     $6E02,x
        lda     $6E0B,x
        sta     $6E0A,x
        lda     $6DF3,x
        sta     $6DF2,x
        clc
        adc     $6DE2,x
        sta     $6DE3,x
        lda     $6DFB,x
        sta     $6DFA,x
        adc     $6DEA,x
        sta     $6DEB,x
        inx
        clv
        bvc     L2327
L2387:  dec     $AC
        rts
L238A:  lda     r1H
        pha
        lda     r1L
        pha
        jsr     L161E
        pla
        sta     r1L
        pla
        sta     r1H
        ldx     #$00
L239B:  cpx     $AC
        beq     L23B1
        lda     $6DD2,x
        cmp     r1L
        bne     L23AD
        lda     $6DDA,x
        cmp     r1H
        beq     L23B3
L23AD:  inx
        clv
        bvc     L239B
L23B1:  sec
        rts
L23B3:  clc
        rts
L23B5:  lda     r1H
        cmp     #$00
        bne     L23BF
        lda     r1L
        cmp     #$09
L23BF:  bne     L23CD
        lda     #$6A
        sta     r0H
        lda     #$C4
        sta     r0L
        lda     #$09
        clc
        rts
L23CD:  ldx     #$10
L23CF:  lda     $6B4A,x
        cmp     r1L
        bne     L23DD
        lda     $6B4B,x
        cmp     r1H
        beq     L23E5
L23DD:  inx
        inx
        cpx     #$80
        bne     L23CF
        sec
        rts
L23E5:  txa
        pha
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        jsr     L23F6
        pla
        tax
        lda     r1L
        and     #$3F
        clc
        rts
L23F6:  sta     r3L
        lda     #$13
        sta     r0L
        ldy     #$08
        ldx     #$02
        jsr     BBMult
        lda     #$C4
        clc
        adc     r0L
        sta     r0L
        lda     #$6A
        adc     r0H
        sta     r0H
        rts
;.include "gpbffv00.a"
.include "gpbinit.a"			; contains geoPublish's initalization code
