; geoWizard VLIR #$01 Source Code
; Disassembly/Source Copyright (c) 2004 by Todd Elliott

.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/inputdrv.inc"
.include "../include/geos/printdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.include "../include/geos/cbmarch.inc"

geosapp		= $0200	; start of GEOS application space
vidBuffer		= $1000	; copy of video matrix at $8c00
l13e8			= $13e8	; unknown buffer
l1668			= $1668	; unknown buffer
l18e8			= $18e8	; unknown buffer
brspace		= $1b55	; dialog box buffer in backRAM
fnBuffer		= $2000	; filename buffer
l7f40			= $7f40	; index?
l7f55			= $7f55
M128Loop		= $9d83	; location of GEOS 128 Main Loop
M64Loop		= $c0df	; location of GEOS 64 Main Loop

L8B01           = $8B01
l8b05           = $8B05
L903C           = $903C
LA960           = $A960
himem			= $e000	; alternative location for the geoWizard module
LEDBB           = $EDBB
LEEA3           = $EEA3
LF35A           = $F35A
LF363           = $F363
LF438           = $F438
LF441           = $F441

.org $4000				; executes @ $4000

cMainLoop:
.word $c0dd
reuBank:
.byte $07

entry:				; entry point for geoWizard
	pla
	sta	return
	pla
	sta	return+1		; saves the return address from JSR $4003
	ldy	#$00			; loop should be in the L463b routine?
@1:	lda	stack,y
	sta	bufStack,y		; preserves the stack area
	iny
	bne	@1
	tsx
	stx	stackPtr
	jsr	L463B			; basically copies resident memory into the REU
	jsr	detGEOS		; detect GEOS config
	lda	cVideo
	sta	copyVideo
	lda	cMode
	bmi	@2			; take branch in GEOS 128
	lda	#$20			; jsr instruction
	sta	M64Loop
	lda	cMainLoop+1
	sta	M64Loop+2
	lda	cMainLoop
	sta	M64Loop+1		; restore GEOS 64 MainLoop
	clv
	bvc	@3
@2:	lda	cMainLoop+1
	sta	M128Loop+2
	lda	cMainLoop
	sta	M128Loop+1		; restores GEOS 128 MainLoop
	jsr	TempHideMouse	; hides the mouse
@3:	jsr	i_FillRam
.word $00a4				; fill range
.word appFName			; start address to fill
.byte $00				; w/ zeroes

	jsr	saveIO		; preserve some i/o registers
	jsr	L489F			; preserves dialog box space & (reboot space? da space?)
	lda	#$00
	sta	r0L
	lda	#>gwStart		; $40
	sta	r7H
	lda	#<gwStart		; $6B
	sta	r7L
	jmp	StartAppl		; initializes GEOS for a new application (warm start?)

gwStart:				; starts up geoWizard
	lda	curDrive
	sta	ccurDrive		; preserves curDrive
	jsr	initDrives		; sets up a 2 or 3 drive system and initializes the disk device
	jsr	getDrvNames		; gets the names for the disk drives
	jsr	MouseUp		; activates the mouse
	jsr	setRectangle
	jsr	ImprintRectangle	; saves the visible rectangle area to the background screen.
	lda	#>L421E
	sta	r0H
	lda	#<L421E
	sta	r0L
	jsr	dblAddr		; bitmap double certain addresses
	lda	#$80
	sta	dispBufferOn	; write to foreground screen only.
	lda	#>COLOR_MATRIX
	sta	r1H
	lda	#<COLOR_MATRIX
	sta	r1L
	lda	#$03
	sta	r0H
	lda	#$E8
	sta	r0L			; fill $03e8 bytes (entire screen) of 
	lda	screencolors	; this color at $8c00
	sta	r2L			; but doesn't really work on 80 column mode
	jsr	FillRam
	lda	#$00
	jsr	SetPattern		; clears an area
	jsr	setRectangle
	lda	#$1F
	sta	r2H			; not sure what this is
	jsr	Rectangle
	lda	#$00
	ora	cVideo
	sta	r11H
	lda	#$01
	sta	r11L
	lda	#$0A
	sta	r1H
	lda	#>tCpyright
	sta	r0H
	lda	#<tCpyright
	sta	r0L			; prints out the geoWizard copyright notice
	jsr	PutString		; and brief instructions
	jsr	setRectangle
	lda	#$1F
	sta	r11L
	lda	#$FF
	jsr	HorizontalLine
	lda	#>itDummy
	sta	r0H
	lda	#<itDummy		; create a dummy icon table
	sta	r0L
	jsr	DoIcons
	lda	#$00
	sta	eggsIdx		; for the easter eggs
	lda	#>srKeys
	sta	keyVector+1
	lda	#<srKeys
	sta	keyVector
	lda	#>srOther
	sta	otherPressVec+1
	lda	#<srOther
	sta	otherPressVec
	rts				; exits back to GEOS MainLoop!

exitgeoWiz:				; exits the geoWizard interface
	lda	#$00			; clear flag
	sta	r1L
altExit:
	lda	r0H
	sta	indCall+1
	lda	r0L
	sta	indCall
	lda	r1L
	sta	indCall+2
	jsr	rstrVideo		; restores original video mode.
	jsr	chkDNames		; checks disk names to make sure they are all the same
	lda	cnumDrives
	sta	numDrives
	lda	ccurDrive
	jsr	SetDevice		; restore original disk configuration
	lda	turboFlags+1	; preserve state of diskTurbo in all 4 drives
	sta	cturboFlags+1
	lda	turboFlags
	sta	cturboFlags
	lda	turboFlags+3
	sta	cturboFlags+3
	lda	turboFlags+2
	sta	cturboFlags+2
	jsr	setRectangle
	jsr	RecoverRectangle	; recovers the area under the imprinted rectangle
	jsr	restoreRAM
	sei				; there's no corresponding CLI instruction?
	lda	cturboFlags+3	; restore state of diskTurbo in all 4 drives
	sta	turboFlags+3
	lda	cturboFlags+2
	sta	turboFlags+2
	lda	cturboFlags+1
	sta	turboFlags+1
	lda	cturboFlags
	sta	turboFlags
	jsr	restoreIO
	jsr	GetDirHead		; this is where Jim Collette messed up
	lda	#$80
	sta	mouseData		; set mouse button press to 'released'
	ldy	#$00
@1:	lda	bufStack,y
	sta	stack,y		; restores original stack
	iny
	bne	@1
	ldx	stackPtr
	txs				; and stack pointer
	lda	indCall+1
	sta	r4H
	lda	indCall
	sta	r4L
	lda	indCall+2
	sta	r5L
	lda	#>cMainLoop
	sta	r0H
	lda	#<cMainLoop
	sta	r0L
	lda	#>cMainLoop
	sta	r1H
	lda	#<cMainLoop
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00			; length $2000 bytes for geoWizard module at $4000
	sta	r2L
	lda	reuBank
	sta	r3L
	lda	return+1
	pha
	lda	return		; restores the return address from jsr $4003
	pha				; geoWizard returns execution to the activator code
	rts

return:				; holds the return address for geoWizard
.word $011A
stackPtr:
.byte $00				; holds the previous stack pointer
copyVideo:				; holds the operating video mode
.byte $00
ccurDrive:				; holds the current drive
.byte $08
cscroly:				; holds the scroly register value
.byte $00
cspena:				; holds the sprite enable register value
.byte $00
cvmcsb:				; holds the vmcsb register value
.byte $00
cci2pra:				; holds the ci2pra register value
.byte $00

.byte $00

rstrVideo:
	lda	cMode
	bne	@1
@2:	rts
@1:	lda	copyVideo		; restore original video mode
	cmp	graphMode
	beq	@2
	sta	graphMode
	jsr	SetNewMode
	rts				; redundant

srOther:				; handle the mouse button press fault vector
	lda	mouseData
	bpl	@1
	rts
@1:	jmp	exitgeoWiz		; if the mouse button is pressed, then exit geoWizard

srKeys:				; handle keypresses from within geoWizard
	lda	keyData
	sta	a1L			; save it temporarily
	cmp	#$41			; letter 'A'?
	bcc	@1
	ora	#$20			; uppercase any letters, but not #'s
@1:	sta	a0L
	ldy	#$00
@2:	lda	keyTable,y
	cmp	a0L
	beq	@3
	iny
	cpy	#$06			; go through the table to see any recognized keypresses
	bcc	@2
	jmp	easterEggs		; handle unrecognized keypresses
@3:	tya
	asl	a
	tay
	lda	keyJump,y
	sta	r0L
	lda	keyJump+1,y
	sta	r0H			; create an indirect JMP
	jmp	(r0L)
	rts

keyTable:				; table of recognized keypresses.
.byte $0D,$F1,$F0,$F2,$E4,$EC	; CR, C=Q, P, R, D, L

keyJump:
.word exitgeoWiz			; CR entry
.word exitDeskTop			; deskTop entry
.word screenDump			; screen dump entry
.word exitRBoot			; Reboot entry
.word runDA				; run a DA
.word runApp			; run an application

; code seems abandoned
	lda	#$00
	jsr	SetPattern
	jmp	Rectangle

L421E:				; table of addresses used for bitmap doubling
.word bdd
.word bde
.word bdb
.word bdc
.word bd8
.word bd1
.word bd2
.word bd3
.word bd4
.word bd5
.word bd6
.word bd7
.word bd9
.word bda
.byte NULL
; abandoned byte?
.byte   $00

easterEggs:				; activates easter eggs within geoWizard
	ldy	eggsIdx
	lda	eggsTbl,y
	eor	#$5C
	cmp	a1L
	beq	@2
@1:	lda	#$00
	sta	eggsIdx
	rts

@2:	iny
	sty	eggsIdx
	cpy	#$09			; must type in all 9 keys in sequence
	beq	@3
	rts

@3:	lda	#>dbEggs1		; activates two dialog boxes
	sta	r0H
	lda	#<dbEggs1
	sta	r0L
	jsr	DoDlgBox
	lda	#>dbEggs2
	sta	r0H
	lda	#<dbEggs2
	sta	r0L
	jsr	DoDlgBox
	clv
	bvc	@1

eggsTbl:				; Christine
.byte $1F,$34,$2E,$35,$2F,$28,$35,$32,$39

eggsIdx:
.byte $00

runApp:				; runs an application
	lda	#$06			; APPLICATION GEOS filetype
	sta	a7L
	lda	a1L			; checks copy of keyData
	cmp	#$CC
	bne	@1
	lda	#$0E			; AUTOEXEC GEOS filetype
	sta	a7L
@1:	lda	#>appFName
	sta	r14H
	lda	#<appFName
	sta	r14L
	jsr	fileReq		; issues a file requestor DB
	bcc	@2
	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile
	txa
	beq	@3			; branch if the application/autoexec is found
	jsr	L53E5			; otherwise, issue a disk error DB
@2:	rts				; redundant

@3:	lda	EnterDeskTop+2	; preserve address for the EnterDeskTop call
	sta	deskTopAddr+1
	lda	EnterDeskTop+1
	sta	deskTopAddr
	lda	deskTopAddr+1
	sta	r0H
	lda	deskTopAddr
	sta	r0L			; EnterDeskTop code is source
	lda	#>bufDT
	sta	r1H
	lda	#<bufDT		; dest
	sta	r1L
	lda	#$24
	sta	r2L
	lda	#$00
	sta	r2H			; move only $24 bytes worth of code (Does it really work?)
	jsr	MoveData
	lda	#>DeskTopCode
	sta	r0H
	lda	#<DeskTopCode
	sta	r0L
	lda	deskTopAddr+1
	sta	r1H
	lda	deskTopAddr
	sta	r1L
	lda	#$24
	sta	r2L
	lda	#$00			; maybe a different approach can be used within Wheels OS
	sta	r2H			; replaces the EnterDeskTop code with new code that can
	jsr	MoveData		; handle geoWizard as a 'deskTop'
	lda	LdDeskAcc
	sta	indCall
	lda	LdDeskAcc+2
	sta	indCall+2
	lda	LdDeskAcc+1
	sta	indCall+1
	lda	#$A2			; ldx #$00
	sta	LdDeskAcc
	lda	#$00			; induce no error in the call
	sta	LdDeskAcc+1
	lda	#$60			; rts
	sta	LdDeskAcc+2
	lda	stack			; wrong location?
	sta	prevstk		; preserve original value in the stack
	lda	reuBank
	sta	stack			; and put the reuBank into the stack
	lda	cnumDrives
	sta	numDrives
	tsx
	stx	pstkptr		; preserve stack pointer
	jsr	savScreens		; saves the fg/bg screens under GEOS 128
	lda	#>cMainLoop
	sta	r0H
	lda	#<cMainLoop
	sta	r0L
	lda	#>himem
	sta	r1H
	lda	#<himem
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	StashRAM		; stash geoWizard VLIR #$01 into the reu, at $e000 instead
@4:	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	lda	#$00
	sta	r0L
	jsr	GetFile		; gets the application/autoexec file into memory
	txa				; check error
	cmp	#$0E
	bne	@5
	jsr	L43E0			; warns user of GEOS 128 or changes video modes (40/80)
	bcs	@4
	clv
	bvc	L4366
@5:	jsr	L53E5			; issue a disk error DB

L4366:				; entered by the EnterDeskTop modified code
	ldx	pstkptr
	tsx				; restore stack pointer
	pla				; eliminate a JSR call?
	pla
	lda	#$00
	sta	r0L
	lda	#>rsGeoWiz
	sta	r7H
	lda	#<rsGeoWiz
	sta	r7L
	jmp	StartAppl		; conducts a (warm?) start

rsGeoWiz:				; restarts geoWizard
	lda	indCall
	sta	LdDeskAcc		; restores the Load Desk Accessory call in the GEOS Kernal
	lda	indCall+2
	sta	LdDeskAcc+2
	lda	indCall+1
	sta	LdDeskAcc+1
	lda	#>bufDT
	sta	r0H
	lda	#<bufDT
	sta	r0L
	lda	deskTopAddr+1
	sta	r1H
	lda	deskTopAddr
	sta	r1L
	lda	#$24
	sta	r2L
	lda	#$00
	sta	r2H
	jsr	MoveData		; restores EnterDeskTop code in the GEOS Kernal
	lda	prevstk
	sta	stack			; restores original stack value
	jsr	rstrVideo		; restores original video mode
	jsr	retScreens		; restores bg/fg screens
	jsr	initDrives		; initializes the drives
	jmp	exitgeoWiz		; sure we want to do this?

DeskTopCode:			; replaces code for EnterDeskTop call
	sei
	lda	#>cMainLoop
	sta	r0H
	lda	#<cMainLoop
	sta	r0L
	lda	#>himem		; $e000 on the REU
	sta	r1H			; solves problem of preserving contents of $4000-$5fff
	lda	#<himem
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L			; length - $2000 bytes
	lda	stack			; wrong location for the reuBank - bug?
	sta	r3L
	jsr	FetchRAM		; fetches the geoWizard module from the REU
	jmp	L4366

L43E0:
	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo
	lda	fileHeader+96
	cmp	#$80			; checks operating mode of application
	bne	@2
	lda	#>dbNo128
	sta	r0H
	lda	#<dbNo128
	sta	r0L			; warn user that application cannot run under GEOS 128
	jsr	DoDlgBox
@1:	clc
	rts

@2:	lda	#>dbNoVid
	sta	r0H
	lda	#<dbNoVid
	sta	r0L
	jsr	DoDlgBox
	lda	r0L
	cmp	#$01			; OK icon?
	bne	@1
	lda	cVideo
	eor	#$80
	sta	cVideo
	sta	graphMode
	jsr	SetNewMode		; change video mode
	sec
	rts

exitDeskTop:			; exits back to deskTop
	lda	#>dbDeskTop
	sta	r0H
	lda	#<dbDeskTop
	sta	r0L
	jsr	DoDlgBox
	lda	r0L
	cmp	#$01			; OK icon?
	beq	@3
	rts

@3:	lda	#$FF			; set flag
	sta	r1L
	lda	#>EnterDeskTop
	sta	r0H
	lda	#<EnterDeskTop
	sta	r0L			; perform indirect call
	jmp	altExit		; and exit geoWizard

exitRBoot:				; exits to RBoot facility
	lda	#>dbDeskTop
	sta	r0H
	lda	#<dbDeskTop
	sta	r0L
	jsr	DoDlgBox		; warn user that program will be lost in memory.
	lda	r0L
	cmp	#$01
	beq	@4			; OK icon?
	rts

@4:	lda	numDrives
	sta	a0L
@5:	jsr	L5551			; changes to active drive
	jsr	PurgeTurbo		; and purges all GEOS traces in the drive
	dec	a0L			; do the same for all other drives
	bne	@5
	sei
	lda	cMode			; 64 or 128?
	bne	@6
	lda	#$35			; GEOS 64
	sta	$01
@6:	jmp	BootGEOS		; and exit to GEOS RBoot facilities


screenDump:				; geoWizard's screen dump facilities
	jsr	i_MoveData		; needed as the printer driver overwrites the bg screen
.word BACK_SCR_BASE		; src background screen
.word fnBuffer			; dest ($2000)
.word $2000				; xfer length
	lda	#>vidBuffer		; but what about the foreground screen?!?
	sta	r0H
	lda	#<vidBuffer
	sta	r0L			; src (REU) $1000
	lda	#>COLOR_MATRIX	; dest (CPU) $8c00
	sta	r1H
	lda	#<COLOR_MATRIX
	sta	r1L
	lda	#$03			; length - $03e8 
	sta	r2H
	lda	#$E8
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	FetchRAM		; retrieves color matrix ram from the REU
	lda	#>PrntFilename
	sta	r6H
	lda	#<PrntFilename
	sta	r6L
	lda	#$00
	sta	r0L
	jsr	GetFile		; gets the current printer driver into memory
	txa				; rewrite this to utilize Photo Scraps or Albums instead.
	beq	@7
	lda	#>dbNoPrint
	sta	r0H
	lda	#<dbNoPrint		; issues a DB warning user that printer driver isn't available
	sta	r0L
	jsr	DoDlgBox
	rts

@7:	jsr	L4622			; sets pseudoregisters r0-r2
	jsr	InitForPrint
	jsr	L4622			; sets pseudoregisters r0-r2
	jsr	StartPrint		; initializes the GEOS Kernal for printing
	lda	#$05
	sta	r0H
	lda	#$00
	sta	r0L			; clear $0500 bytes
	lda	#>l13e8
	sta	r1H
	lda	#<l13e8		; $13e8? area to clear
	sta	r1L
	jsr	ClearRam
	jsr	i_FillRam
.word $0050				; # of bytes to fill
.word l18e8				; area to fill - shouldn't it be 13e8?
.byte $11				; fill byte
	lda	cVideo
	bpl	@8
	jmp	L4571			; for GEOS 128 - 80 column mode

@8:	lda	#$19
	sta	a0L			; go 25 rows!
	lda	#>fnBuffer
	sta	a1H
	lda	#<fnBuffer
	sta	a1L
	lda	#>vidBuffer
	sta	a2H
	lda	#<vidBuffer
	sta	a2L
@9:	lda	a1H
	sta	r0H
	lda	a1L
	sta	r0L			; $2000 - (src)
	lda	#>l13e8
	sta	r1H
	lda	#<l13e8
	sta	r1L			; $13e8 - (dest)
	lda	#$01
	sta	r2H
	lda	#$40
	sta	r2L			; $0140 - length (320 bytes) - one cardrow
	jsr	MoveData		; and moves the screen data
	lda	a2H
	sta	r0H
	lda	a2L
	sta	r0L			; $1000 - (src)
	lda	#>l18e8
	sta	r1H
	lda	#<l18e8
	sta	r1L			; l18e8 - (dest)
	lda	#$00
	sta	r2H
	lda	#$28
	sta	r2L			; $0028 - length (40 bytes) - one color row
	jsr	MoveData		; and moves the color data
	jsr	L4622			; and resets the psuedoregisters r0..r2
	lda	#>l18e8
	sta	r2H
	lda	#<l18e8
	sta	r2L
	jsr	PrintBuffer		; prints the screen dump!
	clc
	lda	a1L
	adc	#$40
	sta	a1L
	lda	a1H
	adc	#$01
	sta	a1H			; go down a cardrow (another 320 bytes)
	clc
	lda	a2L
	adc	#$28
	sta	a2L
	lda	a2H
	adc	#$00
	sta	a2H			; go down a color row (another 40 bytes)
	lda	mouseData		; checks mouse button press? (perhaps to CANCEL printing)
	bpl	@1
	dec	a0L			; go down all 25 rows of the screen dump
	bne	@9
@1:	jsr	L4622			; and resets the psuedoregisters r0..r2
	jsr	StopPrint		; stops the printing process
	rts				; redundant

L4571:				; GEOS 128 80 column screen
	lda	#$02			; double height?
	sta	a8L
	lda	#$00
	sta	a5H
	lda	#$32
	sta	a5L			; 50 rows?
	lda	a1L			; checks copy of keyData
	cmp	#$D0
	bne	@1
	lda	#$01			; single height?
	sta	a8L
	lda	#$19			; 25 rows
	sta	a5L
@1:	lda	a8L
	sta	a9L
	lda	#$00
	sta	a6L
	lda	#>fnBuffer
	sta	a1H
	lda	#<fnBuffer
	sta	a1L
@2:	lda	#>l13e8
	sta	a2H
	lda	#<l13e8
	sta	a2L
	lda	#$08			; go through eight scanlines
	sta	a4L
@3:	ldx	#$00
	ldy	#$00
@4:	lda	(a1L),y		; copies content of fnBuffer (screen) to $13e8
	sta	($70,x)		; a2L
	clc
	lda	a2L
	adc	#$08
	sta	a2L
	lda	a2H
	adc	#$00
	sta	a2H			; gets next card value
	iny
	cpy	#$50			; up to 80 columns
	bcc	@4
	dec	a9L			; double height?
	bne	@5
	clc
	lda	a1L
	adc	#$50
	sta	a1L
	lda	a1H
	adc	#$00
	sta	a1H			; adds 80 to the screen offset
	lda	a8L
	sta	a9L			; repeat double/single height value
@5:	lda	a6L
	bne	@7
	lda	a1H
	cmp	#$3F			; are we done w/ screen? - but won't work w/ other half of
	bne	@6			; bg screen?
	lda	a1L
	cmp	#$40
@6:	bcc	@7
	lda	#$A0			; set it to the other half of bg screen
	sta	a1H
	lda	#$40
	sta	a1L
	lda	#$01
	sta	a6L			; get the other half of bg screen
@7:	sec
	lda	a2L
	sbc	#$7F
	sta	a2L
	lda	a2H
	sbc	#$02
	sta	a2H			; subtracts 640 bytes from the offset & repeats in that cardrow
	dec	a4L			; go through all 8 scanlines of a cardrow
	bne	@3
	jsr	L4622			; and resets the psuedoregisters r0..r2
	jsr	PrintBuffer
	lda	mouseData
	bpl	@8			; did the user CANCEL?
	dec	a5L
	bne	@2
@8:	jsr	L4622			; and resets the psuedoregisters r0..r2
	jsr	StopPrint		; kills the printing device
	jsr	i_MoveData
.word fnBuffer			; and restores the first half of the background screen
.word BACK_SCR_BASE		; dest
.word $2000				; xfer length
	rts

L4622:				; sets pseudoregisters r0-r2 - used by printing routines
	lda	#>l13e8
	sta	r0H
	lda	#<l13e8
	sta	r0L
	lda	#>l1668
	sta	r1H
	lda	#<l1668
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$00
	sta	r2L
	rts

L463B:
	lda	#$00
	sta	r0H
	lda	#$08			; $0008
	sta	r0L			; preserve zp space
	lda	#>bufZP
	sta	r1H
	lda	#<bufZP
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$F8
	sta	r2L			; length $00f8
	jsr	L4738			; performs the copy of zp space
	lda	#>bufZP
	sta	r0H
	lda	#<bufZP
	sta	r0L			; source
	lda	#$00
	sta	r1H
	lda	#$08
	sta	r1L			; $0008 (dest)
	lda	#$01
	sta	r2H
	lda	#$F8			; includes zp+stack
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	StashRAM		; copies zp+stack to REU @ $0008
	lda	#>BACK_SCR_BASE
	sta	r0H
	lda	#<BACK_SCR_BASE
	sta	r0L
	lda	#>BACK_SCR_BASE
	sta	r1H
	lda	#<BACK_SCR_BASE
	sta	r1L
	lda	#$70
	sta	r2H
	lda	#$10
	sta	r2L			; length $7010
	lda	reuBank		; copies $6000-$d00f to the REU @ $6000
	sta	r3L
	jsr	StashRAM
	lda	#>geosapp
	sta	r0H
	lda	#<geosapp
	sta	r0L
	lda	#>geosapp
	sta	r1H
	lda	#<geosapp
	sta	r1L
	lda	#$3E
	sta	r2H
	lda	#$00
	sta	r2L			; length $3e00
	lda	reuBank		; copies $0200-$3fff to the REU @ $0200
	sta	r3L
	jsr	StashRAM
	rts				; omit

restoreRAM:				; restores much of GEOS RAM contents
	lda	#>geosapp
	sta	r0H
	lda	#<geosapp
	sta	r0L
	lda	#>geosapp
	sta	r1H
	lda	#<geosapp
	sta	r1L
	lda	#$3E
	sta	r2H
	lda	#$00
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	FetchRAM		; retrieves $0200-$3fff from the REU to the CPU @ $0200
	sei				; redundant
	jsr	L48E5			; restores GEOS DB and backRAM space
	sei				; redundant
	lda	#>BACK_SCR_BASE
	sta	r0H
	lda	#<BACK_SCR_BASE
	sta	r0L
	lda	#>BACK_SCR_BASE
	sta	r1H
	lda	#<BACK_SCR_BASE
	sta	r1L
	lda	#$70
	sta	r2H
	lda	#$10
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	FetchRAM		; retrieves $6000-$d00f from the REU to the CPU @ $6000
	lda	#>bufZP
	sta	r0H
	lda	#<bufZP
	sta	r0L
	lda	#$00
	sta	r1H
	lda	#$08
	sta	r1L
	lda	#$01
	sta	r2H
	lda	#$F8
	sta	r2L
	lda	reuBank
	sta	r3L
	jsr	FetchRAM		; retrieves $0008-$01f8 from the REU to the CPU @ $5d61
	lda	#>bufZP
	sta	r0H
	lda	#<bufZP
	sta	r0L
	lda	#$00
	sta	r1H
	lda	#$08
	sta	r1L
	lda	#$00
	sta	r2H
	lda	#$F8			; restores original zero page (What about the stack?)
	sta	r2L
	jsr	L4738
	rts

L4738:				; copies a region of memory
	ldy	#$00
@1:	lda	(r0L),y
	sta	(r1L),y
	lda	r2L
	ora	r2H
	beq	@5
	inc	r0L
	bne	@2
	inc	r0H
@2:	inc	r1L
	bne	@3
	inc	r1H
@3:	lda	r2L
	bne	@4
	dec	r2H
@4:	dec	r2L
	clv
	bvc	@1
@5:	rts

savScreens:				; for GEOS 128 - saves bg/fg 40-column screens
	lda	cMode
	bne	@1
	rts				; do nothing in GEOS 64

@1:	lda	sysRAMFlg
	sta	prevREU		; preserve state of REU
	and	#$7F			; clears bit 7
	sta	sysRAMFlg		; disable MoveData REU xfers (not needed for Wheels?)
	lda	#>BACK_SCR_BASE
	sta	r0H
	lda	#<BACK_SCR_BASE
	sta	r0L
	lda	#$00
	sta	r1H
	lda	#$00
	sta	r1L			; dest $0000 of the REU
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L			; xfer $6000-$7fff (CPU) to $0000 of the REU
	lda	#$00			; uses bank $00 of the reu - can see why MoveData
	sta	r3L			; was disabled.
	jsr	StashRAM
	lda	#>SCREEN_BASE
	sta	r0H
	lda	#<SCREEN_BASE
	sta	r0L
	lda	#$20
	sta	r1H
	lda	#$00			; dest $2000 of the REU
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L			; xfer $a000-$bfff (CPU) to $2000 of the REU
	lda	#$00			; uses bank $00 of the REU
	sta	r3L
	jsr	StashRAM
	rts				; kinda redundant

retScreens:				; for GEOS 128 - restores fg/bg screens in 40 column mode
	lda	cMode
	bne	@1
	rts

@1:	lda	#>SCREEN_BASE
	sta	r0H
	lda	#<SCREEN_BASE
	sta	r0L
	lda	#$20
	sta	r1H
	lda	#$00
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L
	lda	#$00
	sta	r3L
	jsr	FetchRAM		; retrieves $a000-$bfff (CPU) from the REU @ $2000
	lda	#>BACK_SCR_BASE
	sta	r0H
	lda	#<BACK_SCR_BASE
	sta	r0L
	lda	#$00
	sta	r1H
	lda	#$00
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L
	lda	#$00
	sta	r3L
	jsr	FetchRAM		; retrieves $6000-$7fff (CPU) from the REU @ $0000
	lda	prevREU
	sta	sysRAMFlg		; restores MoveData capabilities

	php				; no idea what this does yet!
	sei
	lda	mmurcr
	pha				; save 128's configuration registers
	lda	#$08			; eight pages to xfer?
	sta	r4L
	lda	#>BootGEOS
	sta	r5H
	lda	#<BootGEOS
	sta	r5L
	lda	#>diskBlkBuf	; $8000 source CPU
	sta	r0H
	lda	#<diskBlkBuf
	sta	r0L
	lda	#$39			; $3900 dest REU
	sta	r1H
	lda	#$00
	sta	r1L
	lda	#$01
	sta	r2H			; stash only $0100 bytes
	lda	#$00
	sta	r2L
	lda	#$00			; use bank $00 of the REU
	sta	r3L
@2:	lda	mmurcr
	and	#$F0
	ora	#$0B			; 16K common area at top of memory
	sta	mmurcr		; monkeys with the 128's configuration register
	lda	#$7F			; ALL ram block 01 (frontRAM)
	sta	$FF00
	ldy	#$00
@3:	lda	(r5L),y		; copy contents at BootGEOS for 2K
	sta	diskBlkBuf,y
	iny
	bne	@3
	lda	#$7E
	sta	$FF00			; frontRAM + I/O block in
	lda	mmurcr
	and	#$F0			; no common ram
	sta	mmurcr
	jsr	StashRAM
	inc	r5H
	inc	r1H			; go through 2K of RAM
	dec	r4L
	bne	@2
	pla
	sta	mmurcr
	plp
	rts

prevREU:				; preserves state of REU usage
.byte $00

detGEOS:				; detects GEOS config and sets flags accordingly
	ldy	#$00
	sty	cMode
	lda	version
	cmp	#$13
	bcc	@1
	lda	c128Flag
	bpl	@1
	lda	#$FF
	sta	cMode
	ldy	graphMode
@1:	sty	cVideo
	rts

setRectangle:			; sets up a rectangle coordinates, no matter which 40/80 mode
	lda	#$00
	sta	r2L
	lda	#$C7
	sta	r2H
	lda	#$00
	sta	r3H
	lda	#$00
	sta	r3L
	lda	cVideo
	bmi	@1
	lda	#$01
	sta	r4H
	lda	#$3F
	sta	r4L
	rts

@1:	lda	#$02
	sta	r4H
	lda	#$7F
	sta	r4L
	rts

L489F:
	lda	cMode
	bmi	@1
	jsr	L4A7B			; for GEOS 64, calling a GEOS Kernal routine directly
	clv
	bvc	@2
@1:	jsr	LEDBB			; directly calling a GEOS routine is a no/no!
	lda	#>brspace
	sta	r0H
	lda	#<brspace
	sta	r0L			; source $1b55
	lda	#>bufbackRAM
	sta	r1H
	lda	#<bufbackRAM
	sta	r1L			; dest $5bbf
	lda	#$01
	sta	r2H
	lda	#$98
	sta	r2L			; xfer $0198 bytes
	lda	#$01
	sta	r3H			; $01 - frontRAM (dest)
	lda	#$00
	sta	r3L			; $00 - backRAM (src)
	jsr	MoveBData		; copies backRAM to frontRAM - not sure what it contains
	lda	#$00			; reboot space? da space?
	sta	r0H
	lda	#$00
	sta	r0L
	jsr	SetMousePicture	; zeroes out the mouse, I'm guessing
@2:	jsr	i_MoveData		; copies the dialog box buffer
.word dlgBoxRamBuf		; source
.word bufDBSpace			; dest
.word $01a1				; xfer length
	rts

L48E5:
	jsr	i_MoveData
.word bufDBSpace			; source
.word dlgBoxRamBuf		; dest
.word $01a1				; xfer length - restore DB buffer space
	lda	cMode
	bmi	@1			; $04
	jmp	L4A86			; jmp's into GEOS kernal - not a good idea
@1:	jsr	LEEA3			; jmp's into GEOS 128 kernal - not a good idea
	lda	#>bufbackRAM
	sta	r0H
	lda	#<bufbackRAM
	sta	r0L
	lda	#>brspace
	sta	r1H
	lda	#<brspace
	sta	r1L
	lda	#$01
	sta	r2H
	lda	#$98			; xfer length
	sta	r2L
	lda	#$00			; backRAM (dest)
	sta	r3H
	lda	#$01			; frontRAM (src)
	sta	r3L
	jmp	MoveBData		; restores contents of backRAM - I assume is DA space

enableIO:
	lda	cMode
	bne	@1
	lda	$01
	sta	cio
	lda	#$35			; enable i/o on GEOS 64
	sta	$01
@1:	rts

enableGEOS:
	lda	cMode
	bne	@1
	lda	cio
	sta	$01			; enable GEOS 64
@1:	rts

cio:					; copy of GEOS 64 i/o value
.byte $00

getDrvNames:			; gets up to 4 disk drive names
	lda	$BA			; saves CBM Kernal's device number
	pha
	lda	#$00
	sta	aDiskName
	lda	#$00
	sta	bDiskName
	lda	#$00
	sta	cDiskName
	lda	#$00
	sta	dDiskName
	lda	#$00			; code is kinda redundant
	sta	a0L
	lda	#$08
	sta	a0H
	lda	#>aDiskName
	sta	a1H
	lda	#<aDiskName
	sta	a1L

@1:	ldy	a0L
	lda	driveType,y		; checks for existence of a drive
	beq	@2
	lda	a0H			; gets disk device #
	jsr	SetDevice		; sets it up properly
	jsr	OpenDisk		; opens it up
	txa				; check error
	bne	@2
	ldx	#r8
	jsr	GetPtrCurDkNm	; feed disk name into r8
	ldx	#r8
	ldy	#a1
	lda	#r8
	jsr	CopyFString		; copies the disk name into respective buffers
@2:	clc
	lda	a1L
	adc	#$12
	sta	a1L
	lda	a1H
	adc	#$00
	sta	a1H			; cycles through the disk names
	inc	a0H
	inc	a0L
	lda	a0L			; cycles through all four drives
	cmp	#$04
	bcc	@1
	pla				; restores the original drive
	jsr	SetDevice		; and does the honors
	jsr	OpenDisk
	rts

chkDNames:
	lda	$BA			; save CBM kernal's drive #
	pha
	lda	#$00
	sta	a0L
	lda	#$08			; start w/ dev #8
	sta	a0H
	lda	#>aDiskName
	sta	a1H
	lda	#<aDiskName
	sta	a1L
@1:	ldy	#$00
	lda	(a1L),y
	beq	@2			; is it empty?
	lda	a0H
	jsr	SetDevice
	jsr	OpenDisk		; opens the disk and compares the disk name
	ldx	#r8
	jsr	GetPtrCurDkNm
	ldx	#r8
	ldy	#a1
	lda	#r8
	jsr	CmpFString
	beq	@2
	jsr	L49F6			; the disk name does not match the stored disk name
	lda	r0L
	cmp	#$01			; is it the OK icon?
	beq	@1
@2:	clc
	lda	a1L
	adc	#$12			; cycle through the disk names (all 4 of them)
	sta	a1L
	lda	a1H
	adc	#$00
	sta	a1H
	inc	a0H
	inc	a0L
	lda	a0L
	cmp	#$04
	bcc	@1
	pla
	jsr	SetDevice		; restore original drive before exiting the routine
	jsr	OpenDisk
	rts

L49F6:
	lda	a0L
	clc
	adc	#$41			; ascii the number
	sta	drvLtr
	lda	#>drvName
	sta	r0H
	lda	#<drvName
	sta	r0L
	ldx	#a1
	ldy	#r0
	lda	#r7
	jsr	CopyFString		; copies string pointed by a1 to r7
	lda	#$00
	sta	drvName+16		; null terminate it
	lda	#>dbInsDisk
	sta	r0H
	lda	#<dbInsDisk
	sta	r0L
	jsr	DoDlgBox		; warns the user about wrong disk name
	rts

initDrives:
	lda	numDrives
	sta	cnumDrives
@1:	lda	numDrives
	cmp	#$03			; should it be 4 for 4-drive GEOS systems?
	bcc	@2
	dec	numDrives		; forces geoWizard into a 2 drive system
	bne	@1
@2:	jsr	L5519			; initializes the current disk device and sees if a
	rts				; three drive system is possible.

saveIO:				; preserves i/o registers
	jsr	enableIO		; for GEOS 64
	lda	scroly
	sta	cscroly
	lda	spena
	sta	cspena
	lda	vmcsb
	sta	cvmcsb
	lda	ci2pra
	and	#$03
	sta	cci2pra
	jsr	enableGEOS
	rts

restoreIO:
	jsr	enableIO		; for GEOS 64
	lda	ci2pra
	and	#$FC
	ora	cci2pra
	sta	ci2pra
	lda	cvmcsb
	sta	vmcsb
	lda	cspena
	sta	spena
	lda	cscroly
	sta	scroly
	jsr	enableGEOS
	rts

L4A7B:
	lda	$C010
	bne	@1
	jmp	LF35A			; JMP'ing into GEOS kernal isn't a good idea!
@1:	jmp	LF363

L4A86:
	lda	$C010
	bne	@1
	jmp	LF438			; ditto here for GEOS Kernal
@1:	jmp	LF441

tCpyright:				; text pointer for geoWizard copyright notice
.byte $1A,$18

.byte "GEOWIZARD!"
.byte $1B
.byte $16,$91
bd1:
.byte $00,$09		; sounds like gotoxy
.byte $18

.byte "Copyright (C) 1990, Jim Collette"
.byte $16,$01
bd2:
.byte $00,$13

.byte "Click to exit"
.byte $14,$5f			; .text   "_"
bd3:
.byte $00,$80

.byte "L - Load a Program"
.byte $14,$E3
bd4:
.byte $00,$80

.byte "D - Load a DA"
.byte $16,$01
bd5:
.byte $00,$1C
.byte $80

.byte "P - Screen Dump"
.byte $14,$71			; .text   "q"
bd6:
.byte $00,$80

.byte "Q - Quit to DeskTop"
.byte $14,$F6
bd7:
.byte $00,$80
.asciiz "R - Reboot"

itDummy:				; dummy icon table
.byte $01				; one icon
.byte $a0
bd8:
.byte $00				; mouse xpos
.byte $64				; mouse ypos
.word $0000				; pointer to icon data
.byte $00,$00			; x/y pos of icon
.byte $01,$01			; width/height of icon
.word exitgeoWiz			; service routine

dbDeskTop:				; db table for exiting to deskTop
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10
.word tDestroy
.byte DBTXTSTR
.byte $10,$1E
.word tRamdata
.byte DBTXTSTR
.byte $10,$2C
.word tTrash
.byte DBTXTSTR
.byte $10,$40
.word tSure
.byte OK
.byte $01,$48
.byte CANCEL
.byte $11,$48
.byte NULL

tDestroy:				; text
.byte $18
.asciiz "This will destroy the program"
tRamdata:				; text
.asciiz "in RAM and data may be lost."
tTrash:				; text
.asciiz "Any open files may be trashed."

tSure:				; text

.byte "Sure you want to do this?"
.byte $1B,$00

dbNoVid:				; db table
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10
.word tProg
.byte DBTXTSTR
.byte $10,$20
.word tVMode
.byte DBTXTSTR
.byte $10,$40
.word tSwitch
.byte OK
.byte $01,$48
.byte CANCEL
.byte $11,$48
.byte NULL

tProg:				; text
.byte $18
.asciiz "This program cannot be"
tVMode:				; text
.asciiz "run in this video mode."
tSwitch:				; text

.byte "Switch video mode?"
.byte $1B,$00

dbNo128:				; dialog box table
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10
.word tCannot
.byte DBTXTSTR
.byte $10,$20
.word tGEOS128
.byte OK
.byte $01,$48
.byte NULL

tCannot:				; text
.byte $18
.asciiz "This program cannot be"
tGEOS128:				; text

.byte "run under GEOS 128."
.byte $1B,$00

dbNoPrint:				; dialog box table
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10
.word tNoPrint
.byte DBTXTSTR
.byte $10,$20
.word PrntFilename
.byte OK
.byte $01,$48
.byte NULL

tNoPrint:				; text
.byte $18
.asciiz "Couldn't find printer driver:"

dbEggs1:				; Easter Eggs DB
.byte $81
.byte DBTXTSTR
.byte $0A,$10
.word tCopyright
.byte DBTXTSTR
.byte $0A,$20
.word tFriends
.byte DBTXTSTR
.byte $0A,$30
.word tDedicate
.byte DBTXTSTR
.byte $0A,$40
.word tPeace
.byte $0E				; DBSYSOPV
.byte NULL

tCopyright:				; text
.byte $18
.asciiz "GEOWIZARD - (C) Jim Collette!"
tFriends:				; text
.asciiz "For all my friends on Q-Link."
tDedicate:				; text
.asciiz "Dedicated to Christine!"
tPeace:				; text
.byte $22				; quote mark

.byte "Peace sells, but who's buying?"
.byte $22,$1B,$00

dbEggs2:				; second Easter Eggs DB
.byte $01
.byte $20,$7F
.byte $10
bd9:
.byte $00
.byte $2f
bda:
.byte $01
.byte DBTXTSTR
.byte $10,$10
.word tLie
.byte DBTXTSTR
.byte $10,$20
.word tPale
.byte DBTXTSTR
.byte $10,$30
.word tWitness
.byte DBTXTSTR
.byte $10,$40
.word tKingdom
.byte DBTXTSTR
.byte $C8,$50
.word tBurton
.byte $0E				; DBSYSOPV
.byte NULL

tLie:					; text
.byte $1B,$22
.asciiz "When a man lies, he murders some part of the world."
tPale:				; text
.asciiz "These are the pale deaths which men miscall their lives."
tWitness:				; text
.asciiz "All of this I cannot bear to witness any longer."
tKingdom:				; text

.byte "Cannot the kingdom of salvation take me home?"
.byte $22,$00
tBurton:				; text

.byte "- Cliff Burton"
.byte $1B,$00

.byte "Ok hacker you found me! Pretty "
.byte "complex code, eh? Well at least"
.byte " I think it is. Took me long en"
.byte "ough to write it!! Now quit sno"
.byte "oping around and Get Out!!! Cla"
.byte "ss of 1992 rules forever!!"

L4EDC:  .byte   $00
L4EDD:  .byte   $00
L4EDE:  .byte   $00
L4EDF:  .byte   $00,$00
L4EE1:  .byte   $00
L4EE2:  .byte   $00
L4EE3:  .byte   $00

L4EE4:
	sty	L4EDF
	sta	L4EDC
	lda	r15H
	sta	L4EE3
	lda	r15L
	sta	L4EE2			; $4ef1
	lda	#$02
	jsr	SetPattern
	jsr	L4F51			; sets params for the rectangle call
	lda	#$76
	sta	r2L
	lda	#$85
	sta	r2H
	jsr	Rectangle		; draws up the boundaries of the dialog box
	lda	#$FF
	jsr	FrameRectangle
	lda	#$2E
	sta	r2L
	lda	#$FF
	jsr	FrameRectangle
	lda	cVideo
	bpl	@1			; take branch in 40 column mode
	inc	r4L
	dec	r3L
	lda	#$FF
	jsr	FrameRectangle
@1:	lda	L4EDC
	cmp	#$08
	bcc	@3
	lda	cVideo
	bpl	@2			; take branch in 40 column mode
	jsr	i_BitmapUp
.word bmp1
.byte $8c,$76
.byte $8c,$10
	clv
	bvc	@3
@2:	jsr	i_BitmapUp
.word bmp1
.byte $0C,$76
.byte $0C,$10
@3:	lda	#>L50BE
	sta	otherPressVec+1
	lda	#<L50BE		; services the custom file requestor
	sta	otherPressVec
	jmp	L5077			; prints out the initial filename and exits (guessing)

L4F51:
	lda	#$00
	sta	r3H
	lda	#$43
	sta	r3L
	lda	#$00
	sta	r4H
	lda	#$BF
	sta	r4L
	lda	cVideo
	bpl	@1			; take branch in 40 column mode
	lda	#$00
	sta	r3H
	lda	#$87
	sta	r3L
	lda	#$01
	sta	r4H
	lda	#$7E
	sta	r4L
@1:	lda	#$2E
	sta	r2L
	lda	#$75
	sta	r2H
	rts

L4F7F:
	sta	r0L
	lda	#$0A
	sta	r1L
	ldy	#r1
	ldx	#r0
	jsr	BBMult
	jsr	L4F51			; set params for a rectangle
	inc	r2L
	lda	r0L
	clc
	adc	r2L
	sta	r2L
	adc	#$0A
	sta	r2H
	inc	r3L
	bne	@1
	inc	r3H
@1:	ldx	#$0A
	jmp	Ddec

L4FA7:
	lda	L4EDC
	beq	@1
	lda	rightMargin+1
	pha
	lda	rightMargin
	pha
	jsr	L4F51			; set params for a rectangle
	lda	r4H
	sta	rightMargin+1
	lda	r4L
	sta	rightMargin
	dec	rightMargin
	lda	#$00
	jsr	SetPattern
	lda	#$18
	jsr	PutChar		; seems to write a character to the screen
	lda	#$00
	sta	L4EE1
@2:	jsr	L4F7F			; compute params for a rectangle
	jsr	Rectangle
	lda	r3H
	sta	r11H
	lda	r3L
	sta	r11L
	lda	r2L
	clc
	adc	#$07
	sta	r1H
	lda	L4EE1
	clc
	adc	L4EDD
	tay
	dey
	cpy	L4EDC
	bcs	@3
	sty	r15L
	lda	L4EDF
	sta	r0L
	ldx	#r0
	ldy	#r15
	jsr	BBMult
	clc
	lda	L4EE2
	adc	r0L
	sta	r0L
	lda	L4EE3
	adc	r0H
	sta	r0H
	jsr	PutString		; I assume this prints out the filenames
	inc	L4EE1			; for the various requestors
	lda	L4EE1
	cmp	#$07
	bne	@2
@3:	jsr	L5059			; inverts a rectangle, I assume, over the filename
	pla
	sta	rightMargin
	pla
	sta	rightMargin+1
@1:	rts

L5025:
	ldx	L4EDD
	dex
	bne	L503C
	beq	L5059-1

L502D:
	ldx	L4EDD
	inx
	lda	L4EDC
	sec
	sbc	L4EDD
	cmp	#$07
	bcc	L5059-1
L503C:
	txa
	pha
	jsr	L5059			; compute params for a rectangle
	pla
	sta	L4EDD
	cmp	L4EDE
	bcs	@1
	clc
	adc	#$06
	cmp	L4EDE
	bcs	@2
@1:	sta	L4EDE
@2:	jmp	L50B8			; prints out a filename entry for the requestor
	rts				; kinda out of place here.

L5059:
	lda	L4EDE
	sec
	sbc	L4EDD
	jsr	L4F7F			; compute params for a rectangle
	jmp	InvertRectangle

L5066:
	lda	L4EDC
	sta	L4EDE
	sec
	sbc	#$06
	bcs	L5077+5
	bne	L5077+5
	lda	#$01
	bne	L5077+5

L5077:
	lda	#$01
	sta	L4EDE
	sta	L4EDD
	jmp	L4FA7		; prints out a filename for the requestor

L5082:
	lda	L4EDD
	cmp	#$01
	beq	L5059-1
	cmp	#$07
	bcc	L5077
	sec
	sbc	#$06
	sta	L4EDD
	sta	L4EDE
	jmp	L50B8		; prints out a filename for the requestor

L5099:
	lda	L4EDC
	sec
	sbc	#$07
	sta	L4EE1
	cmp	L4EDD
	bcc	L5059-1
	lda	L4EDD
	clc
	adc	#$06
	cmp	L4EE1
	bcs	L5066
	sta	L4EDD
	sta	L4EDE
L50B8:
	jsr	L4FA7			; prints out a filename for the requestor
	jmp	L50BE			; goes back to the mouse service routine
					; kinda redundant
L50BE:
	lda	mouseData
	bmi	@1
	lda	L4EDC
	beq	@1
	jsr	L4F51			; sets params for a rectangle
	lda	#$73
	sta	r2H
	jsr	IsMseInRegion
	cmp	#$00			; redundant
	beq	@3
	jsr	L5059			; invert a rectangular region
	jsr	L4F51			; set params for a rectangle
	lda	mouseYPos
	sec
	sbc	#$2E
	sta	r0L
	lda	#$00
	sta	r0H
	sta	r1H
	lda	#$0A
	sta	r1L
	ldx	#r0
	ldy	#r1
	jsr	Ddiv
	lda	r0L
	clc
	adc	L4EDD
	cmp	L4EDC
	bcc	@2
	lda	L4EDC
@2:	sta	L4EDE
	jsr	L5059			; inverts a rectangular region
@1:	rts

@3:	lda	L4EDC
	cmp	#$08
	bcc	@7
	lda	#$05
	sta	L4EE1
@4:	lda	#$76
	sta	r2L
	lda	#$85
	sta	r2H
	ldy	L4EE1
	lda	L5163,y
	sta	r4L
	sec
	sbc	#$0F
	sta	r3L
	lda	cVideo
	and	#$80
	sta	r3H
	sta	r4H
	jsr	IsMseInRegion
	cmp	#$00			; redundant
	beq	@6
	jsr	InvertRectangle
	ldy	#$00
	ldx	#$60
	lda	cVideo
	bpl	@5
	ldx	#$C0			; some sort of a delay loop?
@5:	dey
	bne	@5
	dex
	bne	@5
	jsr	InvertRectangle
	ldy	L4EE1
	lda	L516FLo,y
	ldx	L5169Hi,y
	jmp	CallRoutine
@6:	dec	L4EE1
	bpl	@4
@7:	rts

L5163:				; used for mouse boundary checking
.byte $BF,$AF,$9F,$8F,$7F,$6F
L5169Hi:
.byte >L502D,>L5025,>L5082,>L5099,>L5077,>L5066
L516FLo:
.byte <L502D,<L5025,<L5082,<L5099,<L5077,<L5066

runDA:				; runs a DA
	pla
	sta	retAddr
	pla
	sta	retAddr+1		; saves the return address
	tsx
	stx	retSPtr		; saves the stack pointer
	jsr	L55A6			; saves a memory region
	jmp	L55F3			; executes the loading/running of the DA

L5187:
	lda	driveTwo
	jsr	SetDevice
	jsr	L55B0			; restores a memory region
	ldx	retSPtr
	txs				; restore stack pointer and return address
	lda	retAddr+1
	pha
	lda	retAddr
	pha
	rts

retSPtr:				; holds the stack pointer
.byte $00

retAddr:				; holds the return address
.byte $00,$00

tNewDsk:				; text
.byte $18

.byte "Insert new disk into drive."
.byte $1B,$00

tNoDA:				; text
.byte $18

.byte "Can't load this DA."
.byte $1B,$00

dbNewDsk:				; db prompting the user to insert new disk
.byte $81				; default
.byte $0C				; DBVARSTR
.byte $10,$10
.byte r6
.byte OK
.byte $01,$48
.byte $00

dbAppReq:				; application/autoexec file requestor - Modify for Wheels OS
.byte $01
.byte $20,$89
.byte $40
bdb:
.byte $00
.byte $ff
bdc:
.byte $00
.byte $13				; DB_USR_ROUT
.word srFileReq			; services the custom file requestor
.byte DBTXTSTR
.byte $03,$0A
.word tSelect
.byte DBTXTSTR
.byte $82,$0A
.word tDrive
.byte DBTXTSTR
.byte $82,$14
.word tOnDisk
.byte DBTXTSTR
.byte $82,$1E
.word diskName
.byte OPEN
.byte $11,$23
.byte $12				; DBUSRICON
.byte $11,$56
.word itIcon1
.byte DISK
.byte $11,$34
L5206:
.byte $12				; DBUSRICON
.byte $11,$45
.word itIcon2
.byte NULL

tOnDisk:				; text
.byte $18

.byte "On disk:"
.byte $1B,$00

tSelect:				; text
.byte $18

.byte "Please select a file:"
.byte $1B,$00

tDrive:				; text
.byte $18

.byte "(Drive "
L5237:

.byte "A)"
.byte $1B,$00

dbDskErr:				; error message db
.byte $81				; default
.byte OK
.byte $11,$48
.byte DBTXTSTR
.byte $10,$10
.word tErrMsg
.byte DBTXTSTR
.byte $10,$20
.word l7f40
.byte NULL

tErrMsg:				; text
.byte $18

.byte "Disk Error:"
.byte $1B,$00

itIcon1:				; icon table
.word iIcon1
.byte $00,$00
bdd:
.byte $06,$10
.word srIcon1
itIcon2:				; icon table
.word iIcon2
.byte $00,$00
bde:
.byte $06,$10
.word srIcon2

iIcon1:				; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82
.byte $03,$80,$04,$00,$BE,$03,$80,$03
.byte $E0,$06,$60,$03,$80,$06,$30,$00
.byte $60,$03,$80,$06,$36,$6E,$F0,$03
.byte $80,$06,$36,$66,$60,$03,$80,$06
.byte $36,$66,$60,$03,$80,$06,$36,$66
.byte $60,$03,$80,$06,$36,$66,$60,$03
.byte $80,$06,$B6,$E6,$60,$03,$80,$03
.byte $E3,$E6,$38,$03,$80,$00,$30,$00
.byte $00,$03,$80,$04,$00,$81,$03,$06
.byte $FF,$81,$7F,$05,$FF,$0C,$BF
iIcon2:				; icon data
.byte $05,$FF,$82,$FE,$80,$04,$00,$82,$03
.byte $80,$04,$00,$B8,$03,$80,$F8,$00
.byte $C0,$00,$03,$80,$CC,$00,$00,$00
.byte $03,$80,$C6,$FD,$D9,$9E,$03,$80
.byte $C6,$E0,$D9,$B3,$03,$80,$C6,$C0
.byte $D9,$B3,$03,$80,$C6,$C0,$CF,$3F
.byte $03,$80,$C6,$C0,$CF,$30,$03,$80
.byte $CC,$C0,$C6,$33,$03,$80,$F8,$C0
.byte $C6,$1E,$03,$80,$04,$00,$82,$03
.byte $80,$04,$00,$81,$03,$06,$FF,$81
.byte $7F,$05,$FF

bmp1:					; bitmap data
.byte $0C,$FF,$DB,$80,$00
.byte $80,$00,$80,$00,$80,$00,$80,$00
.byte $80,$01,$BC,$00,$BF,$00,$BE,$3C
.byte $BE,$3C,$80,$80,$81,$C1,$B2,$00
.byte $8C,$00,$B3,$62,$B3,$62,$81,$C0
.byte $81,$C1,$BC,$00,$8C,$00,$B3,$60
.byte $B3,$60,$83,$E0,$81,$C1,$B2,$00
.byte $8D,$C0,$BE,$6E,$BE,$6E,$87,$F0
.byte $81,$C1,$BD,$C0,$83,$60,$B0,$66
.byte $B0,$66,$8F,$F8,$81,$C1,$83,$60
.byte $83,$60,$B0,$3C,$B0,$3C,$81,$C0
.byte $81,$C1,$83,$60,$81,$C0,$81,$C0
.byte $80,$CD,$80,$81,$C0,$81,$C1,$81
.byte $C0,$80,$3C,$81,$C0,$81,$C0,$81
.byte $C0,$8F,$F9,$80,$7E,$80,$36,$87
.byte $F0,$83,$E0,$81,$C0,$87,$F1,$80
.byte $18,$80,$3C,$83,$E0,$87,$F0,$81
.byte $C0,$83,$E1,$80,$18,$80,$30,$81
.byte $C0,$81,$C0,$81,$C0,$81,$C1,$80
.byte $18,$80,$30,$80,$80,$81,$C0,$81
.byte $C0,$80,$81,$80,$00,$80,$00,$80
.byte $00,$80,$00,$80,$00,$80,$01,$0C
.byte $FF,$18,$63

L53C3:
	sta	sysDBData
	jmp	RstrFrmDialog
srIcon1:				; service routine for icon1
	lda	#$08
	jmp	L53C3
srIcon2:				; service routine for icon2
	lda	#$07
	jmp	L53C3

L53D3:
	lda	#$12			; DBUSRICON
	sta	L5206
	lda	numDrives
	cmp	#$02
	bcs	@1
	lda	#$00
	sta	L5206			; if only one drive system, remove icons
@1:	rts

L53E5:
	stx	l587C
	lda	l587C
	sta	r15L
	lda	#$00
	sta	r15H
	lda	#$00
	sta	r2H
	lda	#$0A
	sta	r2L
	ldx	#r15
	ldy	#r2
	jsr	Ddiv
	lda	#$18
	sta	l7f40
	lda	#$3A
	sta	l7f40+2
	lda	#$49
	sta	l7f40+1
	ldy	#$03
	lda	r15L
	beq	@1
	ora	#$30
	sta	l7f40,y
	iny
@1:	lda	r8L
	ora	#$30
	sta	l7f40,y
	iny
	lda	#$1B
	sta	l7f40,y
	iny
	lda	#$00
	sta	l7f40,y
	lda	#>dbDskErr
	sta	r0H
	lda	#<dbDskErr
	sta	r0L
	jsr	DoDlgBox		; issues a disk error db
	rts

fileReq:
	lda	driveOne
	jsr	SetDevice
	ldx	#r8
	jsr	GetPtrCurDkNm
	ldy	#$0F
@1:	lda	(r8L),y
	sta	diskName,y
	dey
	bpl	@1
	lda	#$00
	sta	diskName+16		; null terminate it
	lda	curDrive
	clc
	adc	#$39
	sta	L5237			; ascii the drive #
	lda	#>fnBuffer
	sta	r6H
	lda	#<fnBuffer
	sta	r6L			; buffer containing filenames
	lda	a7L
	sta	r7L			; GEOS file type
	lda	#$64
	sta	r7H			; up to 100 files
	lda	#$00
	sta	r10H
	lda	#$00
	sta	r10L			; no permanent name
	jsr	FindFTypes
	sec
	lda	#$64
	sbc	r7H
	sta	l7f40			; index into filename buffer?
	lda	#>fnBuffer
	sta	r15H
	lda	#<fnBuffer
	sta	r15L
	lda	#>dbAppReq
	sta	r0H
	lda	#<dbAppReq
	sta	r0L
	jsr	DoDlgBox		; calls the app/autoexec file requestor
	lda	r0L
	cmp	#$05			; OPEN?
	beq	@5
	cmp	#$08			; ICON?
	bne	@2
	clc
	rts

@2:	cmp	#$07			; ICON?
	beq	@3
	cmp	#$06			; DISK?
	beq	@4
	jmp	fileReq		; goes back to the top of the file requestor loop
@3:	jsr	L5551			; changes drives
	jmp	fileReq		; and starts again at the top of the file requestor loop
@4:	lda	#>dbNewDsk
	sta	r0H
	lda	#<dbNewDsk
	sta	r0L
	lda	#>tNewDsk
	sta	r6H
	lda	#<tNewDsk
	sta	r6L
	jsr	DoDlgBox		; prompts the user to insert a new disk
	jsr	OpenDisk
	jmp	fileReq		; starts again at the top of file requestor loop
@5:	ldy	L4EDE
	dey
	sty	r2L
	lda	#$11
	sta	r1L
	ldx	#r1
	ldy	#r2
	jsr	BBMult
	clc
	lda	r1L
	adc	#$00			; <fnBuffer?
	sta	r1L
	lda	r1H
	adc	#$20			; >fnBuffer?
	sta	r1H
	ldy	#$10
@6:	lda	(r1L),y
	sta	(r14L),y
	dey
	bpl	@6
	sec
	rts

dblAddr:				; bitmap doubles certain addresses
	lda	c128Flag
	beq	@2				; do nothing in GEOS 64
	lda	#$7F
	ora	graphMode
	sta	r15L
	ldy	#$00
@1:	lda	(r0L),y
	sta	r1L
	iny
	lda	(r0L),y
	beq	@2				; seems to 'bitmap double' the addresses
	sta	r1H
	iny
	ldx	#$00
	lda	($04,x)			; r1L
	ora	graphMode
	and	r15L
	sta	($04,x)			; r1L
	clv
	bvc	@1
@2:	rts

L5519:
	lda	curDrive
	sta	driveTwo
	sta	driveOne
	lda	numDrives
	cmp	#$01			; is it a single drive system?
	beq	@2
	lda	version
	cmp	#$20
	bcc	@2
	lda	driveType+2		; checks existence of a third drive
	beq	@2
	and	#$0F
	sta	driveThree
	lda	driveType
	and	#$0F
	cmp	driveThree		; are they equal?
	beq	@1			; if so, bump the # of drives up to three
	lda	sysRAMFlg
	and	#$40			; is there the existence of a third drive?
	beq	@2
@1:	inc	numDrives		; only increments up to 3 drives
@2:	jmp	NewDisk		; initializes the current disk device

L5551:
	ldx	numDrives
	dex
	beq	@2			; do nothing in single drive systems
@1:	jsr	L5575			; sets the drive #
	sta	driveOne
	jsr	SetDevice		; opens the disk at that device #
	jsr	OpenDisk
	txa				; check error
	beq	@2
	cmp	#$0D			; specific error code
	beq	@1
	cmp	#$21			; specific error code
	beq	@1
	jsr	L53E5			; issues a disk error DB
	clv
	bvc	@1
@2:	rts

L5575:
	lda	numDrives
	cmp	#$01			; do nothing in single drive systems
	beq	@3
	clc
	adc	#$08
	sta	driveThree
	lda	driveOne
@1:	clc
	adc	#$01
	cmp	driveThree		; are we done w/ three drives?
	bcc	@2
	lda	#$08
@2:	tay
	lda	PrntDiskName+16,y
	beq	@1
	tya
	rts

@3:	lda	driveOne
	rts

srFileReq:				; service routine for the app/auto file requestors
	jsr	L53D3			; modifies the db table to include/remove user icons
	lda	l7f40
	ldy	#$11
	jmp	L4EE4			; sets up the custom file requestor

L55A6:
	jsr	i_MoveData
.word l7f40				; src
.word l588f				; dest
.word $00C0				; xfer length
	rts

L55B0:
	jsr	i_MoveData
.word l588f				; src
.word l7f40				; dest
.word $00C0				; xfer length
	rts

dbInsDisk:				; db table urging user to insert disk
.byte $81				; default db
.byte DBTXTSTR
.byte $10,$10
.word tInsDisk
.byte DBTXTSTR
.byte $10,$20
.word drvName
.byte DBTXTSTR
.byte $10,$30
.word tDrve
.byte OK
.byte $01,$48
.byte CANCEL
.byte $11,$48
.byte NULL

tInsDisk:				; text
.byte $18
.asciiz "Please insert disk:"

tDrve:				; text

.byte "In Drive "

drvLtr:

.byte "A."
.byte $1B,$00

L55F3:				; loads/executes a DA
	lda	#$05
	sta	a7L
	lda	#>appFName
	sta	r14H
	lda	#<appFName
	sta	r14L
	jsr	fileReq		; prompts the user for the DA via a dialog box
	bcs	@1
	jmp	L5187			; otherwise, exit the runDA option

@1:	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile		; finds the DA
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo		; gets its file header
	clv
	bvc	L5636

L5620:				; move this out of the way
	lda	#>dbNewDsk
	sta	r0H
	lda	#<dbNewDsk
	sta	r0L
	lda	#>tNoDA
	sta	r6H
	lda	#<tNoDA		; text pointer
	sta	r6L
	jsr	DoDlgBox		; warn user about DA not running
	jmp	L55F3			; go back to the file requestor again

L5636:
	ldy	#$02
@1:	lda	RstrAppl,y
	sta	cRstrAppl,y		; save contents of the RstrAppl call
	dey
	bpl	@1
	lda	fileHeader+76	; initialization address of DA
	sta	deskTopAddr+1
	lda	fileHeader+75
	sta	deskTopAddr
	lda	fileHeader+72	; start (load) address of DA
	cmp	#$40
	bne	@2
	lda	fileHeader+71
	cmp	#$00			; ensure it is at least $4000+
@2:	bcs	@4
	lda	#$40
	sta	fileHeader+72
	lda	#$00
	sta	fileHeader+71	; otherwise, make the load address $4000
	lda	fileHeader+74
	cmp	#$40
	bne	@3
	lda	fileHeader+73	; compares the end address w/ $4000
	cmp	#$00
@3:	bcs	@4
	lda	#$00
	sta	l7f40+1
	lda	#$00
	sta	l7f40
	jmp	L56E5

@4:	lda	#>appFName
	sta	r0H
	lda	#<appFName
	sta	r0L
	lda	#>(DAName+1)
	sta	r1H
	lda	#<(DAName+1)
	sta	r1L
	ldx	#r0
	ldy	#r1
	jsr	CopyString
	lda	#$18			; special character
	sta	DAName
	lda	#$00			; null-terminate it
	sta	DAName+16		; wrong value?
	lda	#>DAName
	sta	fileHeader+1
	lda	#<DAName
	sta	fileHeader
	lda	#$0D			; temporary file type
	sta	fileHeader+69
	inc	fileHeader+77	; increment the DA filename's first character
	lda	#>fileHeader
	sta	r9H
	lda	#<fileHeader
	sta	r9L
	lda	#$00
	sta	r10L
	jsr	SaveFile		; 'saves' the DA w/ the modded fileHeader
	txa
	beq	@5
	jmp	L5620			; warn user of error DB

@5:	lda	#>DAName
	sta	r0H
	lda	#<DAName
	sta	r0L
	lda	#>l7f40
	sta	r1H
	lda	#<l7f40
	sta	r1L
	ldx	#r0
	ldy	#r1
	jsr	CopyString
	lda	curDrive
	sta	l7f55			; preserves current drive

L56E5:
	jsr	i_MoveData
.word l578d				; moves code to $7f56
.word l7f55+1
.word $002B
	jsr	i_MoveData
.word l5722
.word l8b05				; stashes code within sprite #4
.word $0065

	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile
	txa
	beq	@1
	jmp	L5620			; issue error DB

@1:	ldy	#$02
@2:	lda	rRstrAppl,y
	sta	RstrAppl,y		; wedge in the RstrAppl call w/ geoWizard's routines
	dey
	bpl	@2
	lda	deskTopAddr+1
	sta	$8B02
	lda	deskTopAddr		; $8b01/$8b02 contains DA's initialization address
	sta	L8B01
	jmp	l8b05			; continues w/ code recently moved to $8b05 ($5722)

l5722:
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo
	txa
	bne	@2			; take branch on disk error
	lda	fileHeader+70
	cmp	#$01			; is the DA a VLIR file?
	bne	@1
	ldy	#$01
	lda	(r9L),y
	sta	r1L
	iny
	lda	(r9L),y
	sta	r1H			; get the VLIR index block
	jsr	L903C			; goes directly to disk driver code - NO NO!
	txa				; I assume this is the GetBlock call
	bne	@2			; branch on disk error
	ldx	#$08
	lda	diskBlkBuf+2
	sta	r1L
	beq	@2
	lda	diskBlkBuf+3
	sta	r1H			; r1 points to first t/s of vlir #$01 of the DA
@1:	lda	#$FF
	sta	r2L
	sta	r2H			; up to $ffff bytes to load - r7 supplied by GetFHdrInfo?
	jsr	ReadFile		; reads in VLIR #$00 of the DA into address pointed by r7
	lda	c128Flag
	bmi	@3
	jsr	LF35A			; JMP's directly into GEOS 64 Kernal NO NO!
	clv
	bvc	@4
@3:	jsr	LEDBB			; ditto for GEOS 128 Kernal NO NO!
@4:	jmp	(L8B01)		; executes the DA via the indirect JMP!

; abandoned code?
	lda	c128Flag
	bmi	@5
	jsr	LF438			; JMP's directly into GEOS 64 Kernal NO NO!
	clv
	bvc	@6
@5:	jsr	LEEA3			; JMP's directly into GEOS 128 Kernal NO NO!
@6:	ldx	#$63
@2:	txa
	jsr	L53E5			; not sure
	jmp	L55F3			; repeats the DA loading/excuting loop

rRstrAppl:				; replace the GEOS Kernal call with this jump
	jmp	l7f55+1

cRstrAppl:				; contains copy of the RstrAppl GEOS Kernal call
.byte $00,$00,$00

l578d:				; used by the exiting DA
	lda	l7f40
	beq	@1
	lda	l7f55
	jsr	SetDevice
	lda	#>l7f40
	sta	r6H
	lda	#<l7f40
	sta	r6L
	lda	#$00
	sta	r0L
	jsr	GetFile		; gets the DA's fileheader
@1:	lda	c128Flag
	bmi	@2
	jsr	LF438			; JMP's directly into GEOS 64 Kernal NO NO!
	clv
	bvc	@3
@2:	jsr	LEEA3			; ditto for GEOS 128 Kernal NO NO!
@3:	jmp	L57B8			; redundant

L57B8:
	ldy	#$02
@4:	lda	cRstrAppl,y
	sta	RstrAppl,y		; restore the DA exit call
	dey
	bpl	@4
	lda	l7f40
	beq	@5
	lda	#>DAName
	sta	r0H
	lda	#<DAName
	sta	r0L
	jsr	DeleteFile		; delete the DA if it was specially modified (guessing)
	txa
	beq	@5
	jsr	L53E5			; not sure, but will it be there?
	jmp	L5620			; warn the user about the DA disk error
@5:	jmp	L5187			; restores the stack, etc. and exits back to geoWizard loop

cMode:
.byte $00				; $00 = GEOS 64 - $ff = GEOS 128
cVideo:				; $00 = 40 col - $ff = 80 col
.byte $00

.byte $08,$08
driveThree:
.byte $08				; holds drive #3 device number
driveOne:				; holds drive #1 device number
.byte $08
driveTwo:				; holds drive #2 device number
.byte $08
cnumDrives:				; holds the # of drives available
.byte $02

.bss					; $57e7
cturboFlags:			; holds copy of turbo flags used by the GEOS kernal
.res 4
appFName:				; application/autoexec filename
.res 17
; bl2:				; blank area
; .res 2
diskName:				; name of disk/partition
.res 17
drvName:				; name of drive - same as diskName?
.res 18
aDiskName:				; name of drive X
.res 18
bDiskName:
.res 18
cDiskName:
.res 18
dDiskName:
.res 18
DAName:				; desk accessory filename
.res 17
bl4:					; blank area
.res 4
l587C:				; unknown buffer
.res 5
deskTopAddr:			; contains address for the EnterDeskTop call
.res 2
pstkptr:				; contains previous stack pointer
.res 1
prevstk:				; contains previous stack value
.res 1
bl11:					; blank area
.res 10
l588f:				; unknown buffer
.res 384
bufDBSpace:				; buffer holding dialog box space
.res 432
bufbackRAM:				; buffer holding backRAM contents
.res 408
indCall:				; holds the indirect JMP call
.res 5				; only need 3 bytes to hold this value?
bufDT:				; buffer holding EnterDeskTop code
.res 5				; only need 3 bytes to hold this value?
bufZP:				; buffer holding zp region
.res 248
bufStack:				; buffer holding the stack ($5e59)
.res 1				; last buffer, so no need to specify a range
