; geoWizard VLIR #$00 Source Code
; Disassembly/Source Copyright (c) 2004 by Todd Elliott

.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/inputdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.include "../include/geos/cbmarch.inc"

gWizMod		= $4000	; load address of geowizard's VLIR #$01 module
L4003			= $4003
gateWay		= $c006	; location to mark if gateWay is active or not
M128Loop		= $9d83	; location of GEOS 128 Main Loop
M64Loop		= $c0df	; location of GEOS 64 Main Loop
gWiz128Code		= $bfb0	; wrong location - should be in the stack, at $0100
gWiz64Code		= $f914	; ditto for 64 mode - should be in stack area at $0100

; start address $0400
	ldy	#$00
	sty	cMode			; default 64 mode
	lda	version		; check GEOS version
	cmp	#$20
	bcc	@2			; above v2.0?
	lda	c128Flag
	bpl	@1
	lda	#$FF
	sta	cMode			; notify geoWizard about GEOS 128
	ldy	graphMode		; why is it checking this vector? (reliable?)
@1:	sty	cVideo
	clv
	bvc	@3

@2:	lda	#>dbNoGo		; requires GEOS v2.0 or higher
	sta	r0H
	lda	#<dbNoGo
	sta	r0L
	jsr	DoDlgBox
	jmp	exitGWiz		; and eventually exits to deskTop

@3:	bit	cVideo
	bmi	@4			; compensate for 40/80 column usage
	jsr	i_GraphicsString
.byte $05				; NEWPATTERN
.byte $02				; pattern
.byte $01				; MOVEPENTO
.word $0000				; xpos
.byte $00				; ypos
.byte $03				; RECTANGLETO
.word $013F				; xpos
.byte $C7				; ypos
.byte $05				; NEWPATTERN
.byte $01				; pattern
.byte $01				; MOVEPENTO
.word $0050				; xpos
.byte $96				; ypos
.byte $03				; RECTANGLETO
.word $00FF				; xpos
.byte $C5				; ypos
.byte NULL

	jsr	i_BitmapUp
.word bmpGW
.byte $09				; xpos
.byte $8E				; ypos
.byte $16				; width
.byte $30				; height
	clv
	bvc	@7

@4:	jsr	i_GraphicsString
.byte $05				; NEWPATTERN
.byte $02				; pattern
.byte $01				; MOVEPENTO
.word $0000				; xpos
.byte $00				; ypos
.byte $03				; RECTANGLETO
.word $027F				; xpos
.byte $C7				; ypos
.byte $05				; NEWPATTERN
.byte $01				; pattern
.byte $01				; MOVEPENTO
.word $00A0				; xpos
.byte $96				; ypos
.byte $03				; RECTANGLETO
.word $01FF				; xpos
.byte $C5				; ypos
.byte NULL

	jsr	i_BitmapUp
.word bmpGW
.byte $89				; xpos
.byte $8E				; ypos
.byte $96				; width
.byte $30				; height

@7:	jsr	L0AD3			; checks autoexec mode & saves $5000-$5fff if needed.
	lda	#>nBuffer
	sta	r6H
	lda	#<nBuffer
	sta	r6L
	lda	#$0E			; AUTO_EXEC
	sta	r7L
	lda	#$01			; 1 filename returned
	sta	r7H
	lda	#>permName
	sta	r10H
	lda	#<permName
	sta	r10L
	jsr	FindFTypes		; find geoWizard itself
	txa
	beq	@5
	jmp	exitGWiz		; disk error - abort to deskTop
@5:	lda	#>nBuffer
	sta	r0H
	lda	#<nBuffer
	sta	r0L
	jsr	OpenRecordFile
	lda	#$01			; open up VLIR #$01 of geoWizard
	jsr	PointRecord
	lda	#>gWizMod
	sta	r7H
	lda	#<gWizMod
	sta	r7L
	lda	#$20
	sta	r2H
	lda	#$00			; load in up to $2000 bytes worth
	sta	r2L
	jsr	ReadRecord		; and read in the VLIR #$01 module
	txa
	pha
	jsr	CloseRecordFile
	pla
	cmp	#$0B			; trap the Buffer Overflow error
	beq	@6
	jmp	L04DB

@6:	lda	#>dbLoadErr
	sta	r0H
	lda	#<dbLoadErr
	sta	r0L
	jsr	DoDlgBox
exitGWiz:
	jsr	L0B08			; finds autoexec mode and restores $5000-$5fff if needed.
	jmp	EnterDeskTop

L04DB:
	jsr	checkRAM
	bcs	@1
	lda	#>dbNoREU
	sta	r0H
	lda	#<dbNoREU
	sta	r0L
	jsr	DoDlgBox		; issue a warning DB and exit.
	jmp	exitGWiz

@1:	sta	a9L			; a9L now holds the REU bank needed for geoWizard itself
	jsr	checkSN		; checks geoWizard's serial number against GEOS Kernal ID
	lda	#>nBuffer
	sta	r6H
	lda	#<nBuffer
	sta	r6L
	jsr	FindFile		; find geoWizard all over again.
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo		; and get its file header
	lda	fileHeader+160
	cmp	#$2A			; is it the asterisk?
	bne	@2
	lda	fileHeader+161	; check mouse/joystick mode
	ora	#$20			; force uppercase
	cmp	#$6A			; is it 'J'?
	bne	@2
	lda	#$00			; joystick mode
	sta	clickMode
@2:	lda	cMode
	bmi	patchG128		; take branch in 128 mode
	jmp	patchG64		; otherwise handle 64 mode

clickMode:
.byte $FF				; default mouse mode

patchG128:				; for GEOS 128 operation
	lda	clickMode
	bne	@3
	jmp	L05C3			; handle joystick mode
@3:	lda	M128Loop+2		; get hi byte of re-entry for GEOS 128 MainLoop
	cmp	#>gWiz128Code
	bne	@4
	lda	M128Loop+1		; get lo byte of re-entry for GEOS 128 MainLoop
	cmp	#<gWiz128Code	; is it already pointing to geoWizard activator code?
@4:	bne	@5
	sei
	lda	gWiz128Code+51
	sta	M128Loop+2
	lda	gWiz128Code+50		; copy the original GEOS 128 MainLoop re-entry from
	sta	M128Loop+1		; the geoWizard activator code back to its original place
	cli
@5:	lda	M128Loop+2
	sta	gWizMod+1
	lda	M128Loop+1		; copy the re-entry address for GEOS 128 MainLoop
	sta	gWizMod		; onto the geoWizard module itself.
	lda	a9L
	sta	gWizMod+2		; copy the REU bank byte onto the geoWizard module as well
	lda	#>gWizMod
	sta	r0H
	lda	#<gWizMod
	sta	r0L			; source/dest same address - $4000 for CPU/REU
	lda	#>gWizMod
	sta	r1H
	lda	#<gWizMod
	sta	r1L
	lda	#$20			; copy $2000 bytes to the REU
	sta	r2H
	lda	#$00
	sta	r2L
	lda	a9L
	sta	reuMBank		; store the REU bank onto the stack code
	lda	a9L			; redundant code
	sta	r3L
	jsr	StashRAM		; stash geoWizard module #$01 into the REU
	lda	M128Loop+2
	sta	MLMReEntry+1
	lda	M128Loop+1
	sta	MLMReEntry
	jsr	i_MoveData		; moves the geoWizard activator code to a 'safe' location
.word gWizMSwitcher
.word gWiz128Code			; wrong address!!! Should be $0100
.word $003b
	lda	#>gWiz128Code
	sta	r0H
	lda	#<gWiz128Code
	sta	r0L
	lda	#>gWiz128Code
	sta	r1H
	lda	#<gWiz128Code
	sta	r1L
	lda	#$3B
	sta	r2L
	lda	#$00			; move only $003b bytes
	sta	r2H
	lda	a9L
	sta	r3L			; use correct REU bank byte
	jsr	StashRAM		; and stash the geoWizard activation code into the REU
	sei
	lda	#>gWiz128Code
	sta	M128Loop+2
	lda	#<gWiz128Code
	sta	M128Loop+1		; modify the GEOS 128 Main Loop to redirect to geoWizard
	cli				; activator code
	jmp	splashDB

L05C3:				; handle the joystick mode for geoWizard activation
	lda	M128Loop+2
	cmp	#>gWiz128Code
	bne	@1
	lda	M128Loop+1
	cmp	#<gWiz128Code	; checks to see if geoWizard code is wedged into MainLoop
@1:	bne	@2
	sei
	lda	gWiz128Code+49
	sta	M128Loop+2
	lda	gWiz128Code+48	; copy the re-entry code from geoWizard activator code
	sta	M128Loop+1		; back into GEOS 128 MainLoop
	cli
@2:	lda	M128Loop+2
	sta	gWizMod+1
	lda	M128Loop+1		; copy the re-entry address for GEOS MainLoop onto
	sta	gWizMod		; geoWizard's module
	lda	a9L
	sta	gWizMod+2		; copy the REU bank byte there as well.
	lda	#>gWizMod
	sta	r0H
	lda	#<gWizMod
	sta	r0L
	lda	#>gWizMod
	sta	r1H
	lda	#<gWizMod
	sta	r1L			; both src/dest addresses the same - $4000 CPU/REU
	lda	#$20
	sta	r2H
	lda	#$00			; transfer $2000 bytes
	sta	r2L
	lda	a9L
	sta	reuJBank
	lda	a9L			; redundant
	sta	r3L
	jsr	StashRAM		; stash the geoWizard module into the REU
	lda	M128Loop+2
	sta	MLJReEntry+1
	lda	M128Loop+1
	sta	MLJReEntry		; stash the GEOS 128 MainLoop re-entry address
	jsr	i_MoveData
.word gWizJSwitcher
.word gWiz128Code			; wrong location!!! - Should be in the stack area
.word $0039				; transfer length
	lda	#>gWiz128Code
	sta	r0H
	lda	#<gWiz128Code
	sta	r0L
	lda	#>gWiz128Code
	sta	r1H
	lda	#<gWiz128Code
	sta	r1L
	lda	#$39
	sta	r2L
	lda	#$00
	sta	r2H
	lda	a9L
	sta	r3L
	jsr	StashRAM
	sei
	lda	#>gWiz128Code
	sta	M128Loop+2
	lda	#<gWiz128Code
	sta	M128Loop+1
	cli
	jmp	splashDB

patchG64:				; for GEOS 64 operation
	lda	clickMode
	bne	@1
	jmp	L0714			; handle joystick mode
@1:	lda	M64Loop+2
	cmp	#>gWiz64Code
	bne	@2
	lda	M64Loop+1
	cmp	#<gWiz64Code	; is geoWizard already wedged into 64 GEOS Kernal?
@2:	bne	@3
	sei
	lda	gWiz64Code+50
	sta	M64Loop+1		; copy original GEOS 64 code back into GEOS 64 MainLoop
	lda	gWiz64Code+49
	sta	M64Loop
	lda	gWiz64Code+51
	sta	M64Loop+2
	lda	gWiz64Code+50	; kinda redundant
	sta	M64Loop+1		; ditto
	cli
@3:	lda	M64Loop+2
	sta	gWizMod+1
	lda	M64Loop+1
	sta	gWizMod		; copy GEOS 64 Mainloop re-entry address into geoWizard
	lda	a9L
	sta	gWizMod+2		; copy REU bank into geoWizard's VLIR #$01 as well.
	lda	#>gWizMod
	sta	r0H
	lda	#<gWizMod
	sta	r0L
	lda	#>gWizMod
	sta	r1H
	lda	#<gWizMod
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L
	lda	a9L
	sta	reu64MBank
	lda	a9L			; kinda redundant
	sta	r3L
	jsr	StashRAM		; stash geoWizard VLIR #$01 module @ 4000-5fff into REU @ 4000
	lda	M64Loop
	sta	L0835
	lda	M64Loop+2
	sta	ML64MReEntry+1
	lda	M64Loop+1
	sta	ML64MReEntry
	jsr	i_MoveData
.word Wiz64MSwitcher
.word gWiz64Code
.word $003e				; copies the switcher code to its place in GEOS 64 Kernal
	lda	#>gWiz64Code
	sta	r0H
	lda	#<gWiz64Code
	sta	r0L
	lda	#>gWiz64Code
	sta	r1H
	lda	#<gWiz64Code
	sta	r1L
	lda	#$3E
	sta	r2L
	lda	#$00
	sta	r2H
	lda	a9L
	sta	r3L
	jsr	StashRAM		; copies the GEOS 64 switcher code into the REU
	sei
	lda	#$4C			; JMP opcode
	sta	M64Loop
	lda	#>gWiz64Code
	sta	M64Loop+2
	lda	#<gWiz64Code
	sta	M64Loop+1		; wedges the geoWizard activator code into 64 Kernal
	lda	#$BF
	sta	$F568
	lda	#$58
	sta	$F567			; no idea what this is.
	cli
	jmp	splashDB

L0714:				; handle joystick mode for GEOS 64
	lda	M64Loop+2
	cmp	#>gWiz64Code
	bne	@1
	lda	M64Loop+1
	cmp	#<gWiz64Code	; has geoWizard wedged itself into GEOS 64 Mainloop?
@1:	bne	@2
	sei
	lda	gWiz64Code+48
	sta	M64Loop+1
	lda	gWiz64Code+47	; By switching M to J modes, a bug could be introduced here
	sta	M64Loop
	lda	gWiz64Code+49	; copy original GEOS 64 code from geoWizard's into
	sta	M64Loop+2		; GEOS 64 Mainloop.
	lda	gWiz64Code+48	; kinda redundant
	sta	M64Loop+1		; ditto
	cli
@2:	lda	M64Loop+2
	sta	gWizMod+1
	lda	M64Loop+1
	sta	gWizMod		; copy GEOS 64 MainLoop re-entry address into geoWizard
	lda	a9L
	sta	gWizMod+2		; copy REU bank into geoWizard's VLIR #$01 as well.
	lda	#>gWizMod
	sta	r0H
	lda	#<gWizMod
	sta	r0L
	lda	#>gWizMod
	sta	r1H
	lda	#<gWizMod
	sta	r1L
	lda	#$20
	sta	r2H
	lda	#$00
	sta	r2L
	lda	a9L
	sta	reu64JBank
	lda	a9L			; kinda redundant
	sta	r3L
	jsr	StashRAM		; stash geoWizard VLIR #$01 module @ 4000-5fff into REU @ 4000
	lda	M64Loop
	sta	L08AA
	lda	M64Loop+2
	sta	ML64JReEntry+1
	lda	M64Loop+1
	sta	ML64JReEntry	; modify the end code for GEOS 64 to re-enter GEOS MainLoop
	jsr	i_MoveData
.word Wiz64JSwitcher
.word gWiz64Code
.word $003c				; moves the geoWizard switcher code into GEOS 64 Kernal
	lda	#>gWiz64Code
	sta	r0H
	lda	#<gWiz64Code
	sta	r0L
	lda	#>gWiz64Code
	sta	r1H
	lda	#<gWiz64Code
	sta	r1L
	lda	#$3C
	sta	r2L
	lda	#$00
	sta	r2H
	lda	a9L
	sta	r3L
	jsr	StashRAM		; copies the geoWizard switcher code into REU
	sei
	lda	#$4C			; JMP opcode
	sta	M64Loop
	lda	#>gWiz64Code
	sta	M64Loop+2
	lda	#<gWiz64Code
	sta	M64Loop+1		; modifies the GEOS Kernal MainLoop to wedge in geoWizard
	lda	#$BF
	sta	$F568
	lda	#$58
	sta	$F567			; no idea what this is
	cli
	jmp	splashDB

gWizMSwitcher:			; the actual switcher (mouse) code used by geoWizard
	lda	ciaprb
	and	#$11
	bne	@1
@2:  lda	ciaprb
	and	#$11
	eor	#$11
	bne	@2
	php
	sei
	jsr	UpdateMouse		; updates the mouse.
	ldy	#$06
@3:	lda	$BFE4,y		; get preset REU information for swapping in VLIR #$01
	sta	r0L,y			; module of geoWizard itself
	dey
	bpl	@3
	jsr	SwapRAM
	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
	plp
	lda	r5L			; must have been passed on by VLIR #$01
	beq	@1
	jmp	(r4L)			; passed via VLIR #$01
@1:	.byte $4C			; JMP instruction
MLMReEntry:
.word   $c0dd			; aka JMP $C0DD for GEOS 128 MainLoop re-entry

.byte $00,$40,$00,$40,$00,$20	; $bfe4, actually.
reuMBank:
.byte $0F

Wiz64MSwitcher:			; for the GEOS 64 version of the switcher (mouse) code
	lda	$01
	pha
	lda	#$35			; enable i/o
	sta	$01
	lda	ciaprb
	and	#$11
	tay
	pla
	sta	$01			; enable GEOS Kernal
	tya
	bne	L0835
	php
	sei
	ldy	#$06			; get preset REU information for swapping in VLIR #$01
@1:	lda	$F94B,y		; module of geoWizard itself
	sta	r0L,y
	dey
	bpl	@1
	jsr	SwapRAM
	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
	plp
	lda	r5L			; must have been passed on by VLIR #$01
	beq	L0835
	jmp	(r4L)			; passed via VLIR #$01

L0835:  .byte   $20		; JSR instruction
ML64MReEntry:
.word $fa56
	jmp	$c0e2			; and continue w/ GEOS 64 MainLoop

.byte $00,$40,$00,$40,$00,$20	; $f94b, actually.
reu64MBank:
.byte $0F

gWizJSwitcher:			; geoWizard Switcher Activator (joystick) code
	lda	mouseData
	bmi	@1
	lda	keyData
	cmp	#$14
	bne	@1
	lda	#$00
	sta	keyData
	php
	sei
	ldy	#$06
@2:	lda	$BFE2,y		; get preset REU information for swapping in VLIR #$01
	sta	r0L,y
	dey
	bpl	@2
	jsr	SwapRAM
	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
	plp
	lda	r5L			; must have been passed on by VLIR #$01
	beq	@1
	jmp	(r4L)			; passed via VLIR #$01

@1:	.byte	$4C			; JMP opcode
MLJReEntry:
.word $c0dd				; GEOS 128 MainLoop re-entry address

.byte $00,$40,$00,$40,$00,$20	; actually $bfe2
reuJBank:
.byte $0F

Wiz64JSwitcher:			; GEOS 64/geoWizard Switcher Activator code (joystick)
	lda	mouseData
	bmi	L08AA
	lda	keyData
	cmp	#$14
	bne	L08AA
	lda	#$00
	sta	keyData
	php
	sei
	ldy	#$06
@1:	lda	$F949,y		; get preset REU information for swapping in VLIR #$01
	sta	r0L,y
	dey
	bpl	@1
	jsr	SwapRAM
	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
	plp
	lda	r5L			; must have been passed on by VLIR #$01
	beq	L08AA
	jmp	(r4L)			; passed via VLIR #$01

L08AA:
.byte $20				; JSR opcode
ML64JReEntry:			; for GEOS 64 MainLoop re-entry
.word $fa56
	jmp	$c0e2

.byte $00,$40,$00,$40,$00,$20	; actually $f949
reu64JBank:
.byte $0F

splashDB:				; displays the successful splash DB
	lda	firstBoot		; are we into booting sequence?
	bne	@1
	jmp	exitGWiz		; exit cleanly w/o db displayer

@1:	lda	clickMode
	bne	@2
	lda	#>tLeftArrow
	sta	L0CB6+1
	lda	#<tLeftArrow	; self-modify the DB table to point to joystick mode
	sta	L0CB6			; in the text prompt
@2:	lda	#>dbSplash
	sta	r0H
	lda	#<dbSplash
	sta	r0L
	jsr	DoDlgBox		; displays that geoWizard has been installed!
	lda	r0L
	cmp	#$08			; what is this return value?
	beq	@3
	jmp	exitGWiz
@3:	jsr	MouseUp
	bit	cVideo		; check video mode
	bmi	@4
	jsr	i_BitmapUp		; for GEOS 64
.word femBMP			; bitmap pointer
.byte $06				; xpos
.byte $01				; ypos
.byte $1c				; width
.byte $90				; height
	bra	@5

@4:	jsr	i_BitmapUp		; for GEOS 128
.word femBMP			; bitmap pointer
.byte $86
.byte $01
.byte $9C
.byte $90

@5:	lda	mouseData
	bmi	@5
	jmp	exitGWiz		; finally exit geoWizard

checkRAM:				; rewrite this routine for Wheels OS usage!
	lda	ramExpSize		; checks ram expansion
	bne	@1
	clc				; clear flag if there isn't any.
	rts

@1:	lda	#>tGateWay		; remove this gateWay check entirely
	sta	a0H
	lda	#<tGateWay
	sta	a0L
	lda	#>gateWay
	sta	a1H
	lda	#<gateWay
	sta	a1L
	ldx	#a0
	ldy	#a1
	lda	#$07
	jsr	CmpFString		; checks to see if gateWay is active
	bne	@2
	jmp	rGateWay		; go to the routine handler

@2:	lda	#$FF
	sta	ramBAM		; mark the first REU bank as used.
	ldy	#$03
@3:	lda	ramBase,y		; go through the REU device
	beq	@12
	sta	a0L			; store the REU offset
	lda	driveType,y		; check driveType to see if
	cmp	#$40			; shadowed or ramdisk
	bcs	@13
@12:	dey
	bpl	@3
	clv
	bvc	@14
@13:	cmp	#$43			; shadowed?
	bne	@4
	lda	driveData,y
	cmp	#$FF
	beq	@5
	lda	#$01
	clv
	bvc	@7
@5:	lda	#$0D
	clv
	bvc	@7
@4:	ldx	#$00			; handle ramdisk
@6:	cmp	reuDsk,x		; find disk value
	beq	@8
	inx
	cpx	#$06
	bcc	@6
	clv
	bvc	@12

@8:	lda	reuOff,x		; get reu offset value
@7:	clc
	adc	a0L
	sta	a1L			; a1L now holds updated REU offset
	ldx	a0L
	lda	#$FF
@9:	sta	ramBAM,x		; and mark the BAM for the REU accordingly.
	inx
	cpx	a1L			; up to the area occupied by the ramdisk
	bcc	@9
	clv
	bvc	@12

@14:	ldy	ramExpSize
	dey
@10:	lda	ramBAM,y		; checks the next to last bank of the REU
	beq	@11			; to see if it is available.
	dey
	bpl	@10
	clc
	rts
@11:	sec				; it is available! set flag accordingly.
	tya
	rts

reuDsk: .byte $43,$81,$82,$83,$41,$42
reuOff: .byte $01,$03,$06,$0D,$03,$06
tGateWay:				; text for locating gateWay ram
.asciiz "GATEWAY"

rGateWay:				; handle gateWay ram - remove this routine entirely
	jsr	L09B2			; for Wheels OS usage
	cpx	#$00
	beq	@1
	clc
	rts
@1:	sec
	rts

L09B2:
	ldx	#$FF
	lda	#$00
	sta	a0L
	lda	#$80
	sta	a1L
	ldy	#$00
@1:	lda	ramBase,y
	and	a1L
	beq	@2
	inc	a0L
	lda	a0L
	cmp	ramExpSize
	bcs	@3
	lsr	a1L
	bcc	@1
	ror	a1L
	iny
	cpy	#$04
	bcc	@1
	bcs	@3
@2:	lda	ramBase,y
	ora	a1L
	sta	ramBase,y
	lda	a0L
	ldx	#$00
@3:	rts

srInstall:				; service routine for the geoWizard Install Splash DB
	lda	#>keypressRout
	sta	keyVector+1
	lda	#<keypressRout	; wedge in a keyboard handler routine
	sta	keyVector
	lda	#$00
	sta	L0AD2
	lda	#$54
	sta	r1H
	lda	#$00
	sta	r11H
	lda	#$50
	sta	r11L
	lda	r11H
	ora	cVideo		; check 40/80 column modes
	sta	r11H
	lda	#>tInstBank
	sta	r0H
	lda	#<tInstBank
	sta	r0L
	jsr	PutString		; prints out the text string
	lda	a9L			; get bank #
	sta	r0L
	lda	#$00
	sta	r0H
	lda	#$C0
	jsr	PutDecimal		; and print out the bank #
	lda	#$29			; closing parenthesis
	jsr	PutChar
	rts

tInstBank:				; text pointer
.byte $18
.asciiz "(Installed in bank "

keypressRout:			; handle keypresses for the DB
	lda	keyData
	sta	a0L
	cmp	#$0D			; is it RETURN?
	bne	@1
	lda	#$01
	sta	sysDBData		; indicate so and exit the DB
	jmp	RstrFrmDialog

@1:	ldy	L0AD2
	lda	L0A99,y		; checks for certain keypresses from a table
	eor	#$96
     cmp	a0L
	beq	@2
	lda	#$00
	sta	L0AD2
	rts

@2:	iny
	sty	L0AD2
	cpy	#$12
	beq	@3
	cpy	#$1C
	beq	@4
	rts

@3:	lda	#$00
	sta	r11H
	lda	#$50
	sta	r11L
	lda	r11H
	ora	cVideo		; utilize correct video mode
	sta	r11H
	lda	#$62
	sta	r1H
	lda	#>tGutter
	sta	r0H
	lda	#<tGutter
	sta	r0L
	jsr	PutString
	rts

@4:	lda	#$00
	sta	L0AD2
	lda	#$08
	sta	sysDBData
	jmp	RstrFrmDialog

L0A99:				; keypresses table
.byte $D3,$B8,$C0,$DF,$DA,$B6,$D8,$B8; E.VIL N.
.byte $D3,$C0,$D3,$C4,$B6,$D2,$B8,$DF; EVER D.I
.byte $D3,$C5,$B2,$D5,$FE,$E4,$FF,$E5; ES$Chris
.byte $E2,$FF,$F8,$F3		; tine

tGutter:				; what is this text?
.byte $1B,$18,$0E,$19

.byte "Hello from the Gutter!!"
.byte $1B,$00

L0AD2:
.byte $00

L0AD3:
	lda	firstBoot
	bne	@1			; are we in autoexec mode?
	lda	sysRAMFlg		; continue w/ code in autoexec mode.
	sta	cRAMFlag
	and	#$7F
	sta	sysRAMFlg
	lda	ramExpSize
	beq	@1
	lda	#$50
	sta	r0H
	lda	#$00
	sta	r0L			; move $5000-$5fff into RAM expansion starting at $0000
	lda	#$00
	sta	r1H
	lda	#$00
	sta	r1L
	lda	#$10
	sta	r2H
	lda	#$00
	sta	r2L
	lda	#$00
	sta	r3L			; into bank $00 of REU. Will this crash Wheels OS?
	jsr	StashRAM
@1:	rts

L0B08:
	lda	firstBoot
	bne	@1
	lda	ramExpSize
	beq	@1
	lda	#$50
	sta	r0H
	lda	#$00
	sta	r0L			; get contents at $0000 in REU back to CPU $5000-$5fff
	lda	#$00
	sta	r1H
	lda	#$00
	sta	r1L
	lda	#$10
	sta	r2H
	lda	#$00
	sta	r2L
	lda	#$00
	sta	r3L			; use bank $00 of the REU - conflicts with Wheels OS?
	jsr	FetchRAM
	lda	cRAMFlag
	sta	sysRAMFlg
@1:	rts

checkSN:				; verifies geoWizard - get rid of this completely.
	lda	#>nBuffer
	sta	r6H
	lda	#<nBuffer
	sta	r6L
	jsr	FindFile		; find geoWizard file again.
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo		; loads in geoWizard's file header
	lda	fileHeader+144	; checks for flag embedded in geoWizard's file header
	bne	@1			; take branch if it hasn't been 'installed'
	jmp	instGWiz
@1:	jsr	L0BF7			; get GEOS Kernal ID #
	lda	r0H
	cmp	fileHeader+149	; geoWizard's Kernal ID is imprinted in the file header
	bne	@2
	lda	r0L
	cmp	fileHeader+148
@2:	beq	@3
	lda	#>dbInst
	sta	r0H
	lda	#<dbInst
	sta	r0L
	jsr	DoDlgBox		; issue warning DB and exit to deskTop
	jmp	exitGWiz

@3:	lda	#$04			; perform a checksum on geoWizard itself
	sta	r0H
	lda	#$00
	sta	r0L
	lda	#$1C			; from $0400 to $20cd
	sta	r1H
	lda	#$CD
	sta	r1L
	jsr	createCRC		; conducts the checksumming & returns value in r2
	lda	r2H
	cmp	fileHeader+147
	bne	@4
	lda	r2L
	cmp	fileHeader+146
@4:	beq	@5			; if the checksum matches, geoWizard hasn't been 'hacked'
	lda	#>dbCRC
	sta	r0H
	lda	#<dbCRC
	sta	r0L
	jsr	DoDlgBox		; issue warning DB & exit to deskTop
	jmp	exitGWiz
@5:	rts

instGWiz:				; installs geoWizard - remove this completely
	lda	#$FF
	sta	fileHeader+144	; mark the install flag into its file header
	lda	#$0F
	sta	fileHeader+97	; puts an $0f before his name in the file header
	lda	#$04			; in the Author Field.
	sta	r0H
	lda	#$00
	sta	r0L
	lda	#$1C
	sta	r1H
	lda	#$CD
	sta	r1L
	jsr	createCRC		; conducts a checksum for $0400-$20cd
	lda	r2H
	sta	fileHeader+147
	lda	r2L
	sta	fileHeader+146	; and puts the checksum value into its file header
	jsr	L0BF7			; gets the GEOS Kernal ID
	lda	r0H
	sta	fileHeader+149
	lda	r0L
	sta	fileHeader+148	; and installs it into its file header
	lda	fileTrScTab+1
	sta	r1H
	lda	fileTrScTab
	sta	r1L
	lda	#>fileHeader
	sta	r4H
	lda	#<fileHeader
	sta	r4L
	jsr	PutBlock		; writes back the modified geoWizard's file header to disk
	txa
	beq	@4
	jmp	exitGWiz		; branch on disk error w/ DB and exit to deskTop
@4:	jmp	checkSN		; go through the serial number check again.

L0BF7:
	jsr	GetSerialNumber
	rts

createCRC:				; goes through geoWizard's code and creates a checksum
	lda	#$00			; remove this entirely
	sta	r2H
	lda	#$00
	sta	r2L
	ldy	#$00
@1:	lda	(r0L),y
	clc
	adc	r2L
	sta	r2L
	lda	r2H
	adc	#$00
	sta	r2H
	inc	r0L
	bne	@2
	inc	r0H
@2:	lda	r1L
	bne	@3
	dec	r1H
@3:	dec	r1L
	lda	r1H
	bne	@1
	lda	r1L
	bne	@1
	rts

dbNoREU:				; db table for REU bank not found error
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tNoFreeRAM
.byte DBTXTSTR
.byte $10,$20			; x/y position
.word tAbortInst
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tNoFreeRAM:				; text for no REU bank being available
.byte $18
.asciiz "Can't find a free REU bank."

tAbortInst:				; text for aborting the installation procedure

.byte "Installation aborted."
.byte $1B,$00

dbLoadErr:				; db table for the error in loading geoWizard
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tResMod
.byte DBTXTSTR
.byte $10,$20			; x/y position
.word tOFlowErr
.byte DBTXTSTR
.byte $10,$30			; x/y position
.word tAbortInst
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tResMod:				; text showing resident module
.byte $18
.asciiz "geoWizard resident module"
tOFlowErr:				; text showing overflow error
.asciiz "overflow error!!!"

dbSplash:				; the splash DB table
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tGWInstall
.byte DBTXTSTR
.byte $10,$1C			; x/y position
L0CB6:
.word tClickMouse
.byte DBTXTSTR
.byte $10,$28			; x/y position
.word tActivate
.byte DB_USR_ROUT
.word srInstall
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tGWInstall:				; text
.byte $18
.asciiz "geoWizard installed!"
tClickMouse:			; text
.asciiz "Click both mouse buttons"
tActivate:				; text

.byte "to activate."
.byte $1B,$00

tLeftArrow:				; text for left arrow
.asciiz "Hit <- (left arrow) then fire"

dbInst:				; db table for installing geoWizard
.byte $81				; remove this entirely
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tReboot
.byte DBTXTSTR
.byte $10,$20			; x/y position
.word tSystem1
.byte DBTXTSTR
.byte $10,$30			; x/y position
.word tGWiz
.byte OK
.byte $01,$48			; x/y position
.byte NULL


tReboot:				; text for rebooting prompt
.byte   $18
.asciiz "Please reboot GEOS with the"

tSystem1:				; text for first system
.asciiz "system first used to run"

tGWiz:				; text for geoWizard

.byte "GEOWIZARD."
.byte $1B,$00

dbCRC:				; db table for CRC mismatch
.byte $81				; default DB params
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tMisCRC
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tMisCRC:				; text for CRC mismatch
.byte $18

.byte "Internal checksum mismatch."
.byte $1B,$00

dbNoGo:			; db table for notifying user of GEOS v2.0+ requirement
.byte $81			; default DB params
.byte DBTXTSTR
.byte $10,$10		; x/y position
.word tNoGo
.byte DBTXTSTR
.byte $10,$20		; x/y position
.word tReqGEOS
.byte OK
.byte $01,$48		; x/y position
.byte NULL

tNoGo:			; text used for the above DB table
.byte $18
.asciiz "Can't install on this system."

tReqGEOS:			; text used for the above DB table

.byte "Requires GEOS 64/128 2.0."
.byte $1B,$00		; omit trailing $1b?

bmpGW:			; bitmap used for the geoWizard splash screen
.byte $16,$FF,$81,$80,$14,$00,$82,$01
.byte $80,$14,$00,$82,$01,$80,$07,$00
.byte $83,$78,$00,$3C,$08,$00,$84,$78
.byte $00,$01,$80,$07,$00,$84,$78,$00
.byte $3C,$3C,$07,$00,$84,$78,$00,$01
.byte $80,$07,$00,$84,$78,$78,$7C,$3C
.byte $07,$00,$84,$F8,$00,$01,$80,$07
.byte $00,$84,$78,$78,$7C,$3C,$07,$00
.byte $DB,$F8,$00,$01,$80,$00,$00,$00
.byte $01,$FE,$00,$00,$78,$F8,$F8,$00
.byte $00,$00,$0F,$E0,$00,$00,$00,$F0
.byte $00,$01,$80,$00,$00,$1F,$83,$FF
.byte $00,$FC,$78,$F8,$F8,$78,$07,$F0
.byte $3F,$FC,$F0,$00,$1F,$F0,$00,$01
.byte $80,$00,$00,$7F,$C7,$FF,$83,$FE
.byte $79,$F9,$F0,$78,$3F,$F8,$7F,$FC
.byte $FF,$E0,$7F,$F0,$00,$01,$80,$00
.byte $00,$FF,$C7,$CF,$87,$FF,$79,$F9
.byte $F0,$78,$FF,$F8,$FE,$7C,$FF,$F0
.byte $FF,$F0,$00,$01,$DB,$80,$00,$01
.byte $FF,$CF,$8F,$8F,$FF,$79,$FB,$E0
.byte $78,$FF,$F9,$F8,$7C,$7F,$F1,$FF
.byte $E0,$00,$01,$80,$00,$03,$F3,$CF
.byte $BF,$9F,$8F,$7F,$FB,$E0,$F8,$F9
.byte $F9,$F0,$78,$7E,$F3,$F1,$E0,$00
.byte $01,$80,$00,$03,$E3,$CF,$FF,$1F
.byte $0F,$7F,$FB,$C0,$F8,$03,$F3,$E0
.byte $F8,$7C,$03,$E1,$E0,$00,$01,$80
.byte $00,$07,$C3,$DF,$FE,$3E,$0F,$3F
.byte $FF,$C0,$F0,$07,$E3,$E0,$F8,$F8
.byte $07,$C1,$E0,$00,$01,$80,$00,$07
.byte $DB,$C3,$DF,$F8,$3E,$0F,$3F,$FF
.byte $C0,$F0,$0F,$C3,$C1,$F0,$F8,$07
.byte $C1,$E0,$00,$01,$80,$00,$07,$87
.byte $DF,$C0,$3C,$0F,$3F,$FF,$80,$F0
.byte $1F,$83,$C1,$F0,$F0,$07,$83,$E0
.byte $00,$01,$80,$00,$07,$87,$CF,$00
.byte $3C,$1F,$3F,$FF,$81,$F0,$3F,$03
.byte $C3,$F0,$F0,$07,$83,$E0,$00,$01
.byte $80,$00,$07,$8F,$CF,$0F,$3C,$1F
.byte $3F,$BF,$01,$F0,$7E,$03,$E7,$F1
.byte $F0,$07,$CF,$C0,$00,$01,$80,$00
.byte $07,$DF,$CF,$BF,$DB,$3C,$3E,$1F
.byte $BF,$01,$E0,$FC,$7B,$FF,$F1,$F0
.byte $07,$DF,$C0,$00,$01,$80,$00,$07
.byte $FF,$CF,$FF,$3E,$FE,$1F,$BF,$01
.byte $E1,$FB,$F9,$FF,$F9,$E0,$03,$FF
.byte $C0,$00,$01,$80,$00,$03,$FF,$C7
.byte $FE,$3F,$FC,$0F,$1E,$01,$E1,$FF
.byte $F9,$FF,$F9,$E0,$03,$FF,$C0,$00
.byte $01,$80,$00,$01,$FF,$83,$F8,$1F
.byte $F8,$0F,$1E,$01,$E1,$FF,$F0,$FC
.byte $79,$E0,$01,$FF,$C0,$00,$01,$80
.byte $00,$00,$0F,$80,$00,$0F,$E0,$00
.byte $88,$00,$01,$E0,$FF,$80,$00,$01
.byte $E0,$04,$00,$86,$01,$80,$00,$00
.byte $0F,$80,$10,$00,$85,$01,$80,$00
.byte $03,$DF,$11,$00,$92,$01,$80,$00
.byte $03,$FF,$00,$17,$40,$00,$A4,$00
.byte $40,$0E,$E6,$30,$09,$54,$0A,$04
.byte $00,$92,$01,$80,$00,$03,$FE,$00
.byte $22,$62,$0A,$B1,$A3,$64,$10,$89
.byte $40,$AC,$46,$A9,$04,$00,$92,$01
.byte $80,$00,$01,$FC,$00,$22,$55,$0A
.byte $A5,$55,$4A,$10,$E9,$20,$A9,$54
.byte $A9,$04,$00,$82,$01,$80,$04,$00
.byte $8C,$22,$56,$0A,$A5,$55,$4C,$12
.byte $89,$10,$A9,$54,$A1,$04,$00,$82
.byte $01,$80,$04,$00,$8C,$12,$53,$06
.byte $95,$53,$26,$0E,$E6,$60,$65,$52
.byte $6A,$04,$00,$82,$01,$80,$0F,$00
.byte $81,$40,$04,$00,$82,$01,$80,$14
.byte $00,$DB,$01,$87,$40,$00,$00,$10
.byte $0C,$00,$04,$75,$00,$43,$8E,$38
.byte $01,$C8,$00,$03,$A0,$66,$00,$00
.byte $01,$8C,$C0,$00,$00,$00,$04,$00
.byte $08,$CC,$80,$C4,$D3,$6C,$00,$80
.byte $00,$06,$60,$22,$00,$00,$01,$88
.byte $40,$00,$00,$00,$04,$10,$08,$84
.byte $81,$44,$51,$44,$00,$80,$00,$04
.byte $20,$22,$00,$84,$01,$90,$0C,$F3
.byte $35,$B3,$C7,$3C,$11,$00,$40,$44
.byte $51,$44,$00,$9A,$D8,$08,$06,$22
.byte $31,$EF,$31,$90,$12,$DB,$49,$23
.byte $14,$84,$90,$11,$00,$40,$46,$59
.byte $44,$00,$89,$24,$08,$09,$22,$48
.byte $84,$49,$90,$12,$49,$62,$14,$84
.byte $90,$11,$00,$40,$43,$CF,$44,$00
.byte $89,$24,$08,$09,$22,$78,$84,$79
.byte $88,$52,$49,$42,$17,$04,$90,$10
.byte $84,$40,$40,$82,$44,$00,$89,$24
.byte $04,$29,$22,$40,$84,$41,$8C,$D2
.byte $48,$C2,$12,$04,$90,$10,$CC,$40
.byte $41,$86,$6C,$02,$89,$24,$06,$69
.byte $22,$64,$84,$65,$87,$8C,$70,$87
.byte $3B,$9F,$8E,$CC,$10,$78,$40,$E6
.byte $18,$38,$83,$1F,$B6,$03,$C6,$77
.byte $38,$63,$39,$80,$00,$40,$80,$04
.byte $40,$00,$08,$00,$80,$00,$00,$00
.byte $80,$07,$00,$8E,$01,$80,$00,$41
.byte $00,$04,$40,$00,$08,$00,$80,$00
.byte $00,$01,$08,$00,$8A,$01,$80,$00
.byte $E3,$00,$03,$80,$00,$04,$01,$0C
.byte $00,$82,$01,$80,$14,$00,$82,$01
.byte $80,$14,$00,$81,$01,$16,$FF

femBMP:				; bitmap of a female face
.byte $0B
.byte $FF,$86,$FD,$36,$FF,$6E,$DB,$24
.byte $11,$FF,$8F,$FD,$B6,$DB,$6D,$BB
.byte $7C,$D3,$F5,$B5,$B6,$98,$96,$D6
.byte $DF,$6F,$0C,$FF,$96,$DD,$B7,$FF
.byte $FF,$FF,$F7,$EC,$9B,$6D,$5E,$D9
.byte $4A,$6D,$FB,$7B,$FF,$FF,$FD,$B7
.byte $FF,$FB,$6D,$04,$FF,$CF,$BF,$DD
.byte $FF,$FE,$DB,$55,$56,$BE,$F8,$CD
.byte $F5,$B5,$B6,$90,$93,$5E,$FE,$DD
.byte $DE,$EF,$FE,$DD,$DF,$FF,$BF,$FF
.byte $FF,$DD,$FD,$FF,$B7,$6F,$FF,$FF
.byte $FF,$ED,$DA,$96,$DA,$DB,$55,$AD
.byte $2A,$EB,$DB,$FF,$FF,$FF,$DF,$FF
.byte $FF,$6D,$FD,$FD,$BB,$FF,$FF,$FB
.byte $FF,$FD,$AD,$6D,$B6,$DF,$F1,$5B
.byte $66,$DD,$AA,$52,$95,$7D,$7F,$6F
.byte $FF,$FE,$FB,$FF,$FB,$05,$FF,$DB
.byte $DF,$7F,$6D,$B7,$FF,$FF,$FF,$7B
.byte $72,$A5,$B5,$64,$DD,$ED,$6A,$AF
.byte $B6,$FD,$DF,$FF,$DF,$EE,$FF,$6D
.byte $BF,$FF,$FF,$6D,$FB,$EF,$FF,$FE
.byte $DB,$6D,$B5,$DF,$B2,$5A,$DA,$AE
.byte $D6,$4A,$95,$75,$FB,$FF,$FE,$ED
.byte $FF,$7F,$EF,$FF,$F7,$FF,$F7,$FF
.byte $DF,$FD,$B6,$D7,$F7,$FF,$FF,$75
.byte $E3,$49,$A9,$D5,$6B,$B2,$6D,$9F
.byte $5F,$6F,$FF,$FF,$EF,$FF,$FD,$B6
.byte $FF,$FD,$BF,$FE,$FD,$BF,$FF,$FD
.byte $6E,$DB,$6B,$C5,$EF,$B6,$B6,$DB
.byte $2A,$D4,$45,$12,$AD,$EB,$FD,$F7
.byte $FF,$FF,$F7,$FF,$FF,$DF,$FF,$FE
.byte $DB,$EF,$ED,$BB,$6F,$FF,$FF,$FD
.byte $7D,$C9,$49,$B3,$C5,$6F,$48,$4B
.byte $5E,$DE,$DF,$FF,$FE,$F7,$7F,$BD
.byte $DB,$7F,$FF,$F7,$FF,$7D,$BF,$FF
.byte $FB,$56,$DB,$B7,$DF,$E6,$F2,$D9
.byte $53,$50,$A5,$00,$47,$77,$76,$FF
.byte $6F,$04,$FF,$DB,$FB,$FB,$FF,$6D
.byte $EF,$FB,$6D,$B7,$FF,$FF,$ED,$BA
.byte $CB,$29,$B7,$6A,$BE,$A8,$AC,$96
.byte $EE,$FF,$DB,$FF,$FF,$F7,$FF,$6D
.byte $FF,$FF,$BB,$FF,$7B,$6F,$FF,$FD
.byte $5A,$DB,$6F,$FF,$D5,$F5,$79,$53
.byte $52,$55,$00,$05,$DB,$B6,$FF,$FF
.byte $76,$FF,$77,$FF,$BF,$FF,$FF,$6B
.byte $B7,$FE,$DB,$5B,$FF,$FF,$DA,$B6
.byte $AA,$AA,$DD,$EC,$DB,$62,$D6,$43
.byte $BD,$DF,$FF,$DF,$FF,$FF,$FF,$BB
.byte $F7,$FB,$B7,$FD,$DE,$DB,$FF,$93
.byte $FF,$6A,$B6,$B7,$F7,$CD,$F5,$FA
.byte $6E,$A9,$24,$08,$12,$EB,$7B,$76
.byte $FF,$FF,$DB,$04,$FF,$DB,$FD,$5E
.byte $ED,$FF,$EE,$ED,$FF,$FF,$5B,$6F
.byte $6B,$7E,$BF,$3D,$56,$A9,$A2,$81
.byte $BD,$B7,$FF,$FE,$FF,$FF,$76,$ED
.byte $BF,$FE,$DF,$F7,$7F,$B6,$FF,$FF
.byte $55,$6A,$B7,$FF,$B7,$DB,$FE,$B7
.byte $B4,$48,$48,$51,$D6,$DF,$EF,$EF
.byte $F7,$FF,$FF,$FF,$F7,$EF,$F6,$DD
.byte $AB,$7F,$DB,$B6,$FF,$FD,$B6,$FB
.byte $DB,$7F,$7F,$9D,$EE,$96,$A5,$08
.byte $EB,$7B,$7F,$7F,$FF,$EF,$DF,$DF
.byte $BF,$FD,$BF,$FE,$FF,$DB,$FF,$FF
.byte $D5,$DB,$56,$DF,$FF,$B7,$FF,$FB
.byte $9F,$F5,$A9,$48,$4B,$3D,$BF,$FF
.byte $FF,$7F,$FD,$FB,$FD,$FF,$FF,$ED
.byte $B7,$6A,$FF,$7F,$76,$FF,$FB,$6E
.byte $F7,$DE,$FF,$7F,$CA,$DF,$76,$AA
.byte $20,$AB,$ED,$B6,$FB,$FD,$FF,$FF
.byte $7F,$B7,$DB,$7F,$ED,$DF,$6D,$F7
.byte $FF,$AA,$97,$BF,$7F,$6B,$FE,$FD
.byte $CF,$FF,$A9,$52,$4A,$76,$BF,$FF
.byte $FF,$EF,$DF,$B7,$ED,$FF,$FF,$ED
.byte $BF,$77,$FF,$FE,$FB,$7F,$FD,$6D
.byte $EF,$F7,$EF,$FF,$E6,$DB,$ED,$FE
.byte $AA,$10,$1D,$ED,$BF,$DE,$FF,$FB
.byte $FE,$FF,$EF,$EF,$7F,$F6,$DD,$5B
.byte $6F,$DF,$EA,$96,$DE,$DD,$7B,$FE
.byte $FD,$DF,$7F,$A5,$55,$42,$96,$FF
.byte $F6,$FF,$FE,$FF,$BF,$DE,$FD,$FF
.byte $ED,$BF,$EF,$FF,$FF,$FE,$F7,$ED
.byte $EE,$FF,$AF,$B7,$FF,$DA,$DB,$FE
.byte $A8,$90,$0B,$AD,$BF,$ED,$B7,$DB
.byte $F6,$FF,$DF,$BB,$7F,$F5,$76,$DB
.byte $76,$DF,$BA,$5E,$DB,$5B,$7B,$FD
.byte $6C,$9F,$6F,$63,$55,$24,$16,$FF
.byte $F7,$DB,$7F,$FF,$FF,$BF,$ED,$FB
.byte $FF,$FB,$7F,$BF,$FF,$FF,$FB,$EF
.byte $B6,$DA,$FF,$5D,$1F,$FE,$DD,$7B
.byte $F9,$A2,$10,$03,$6A,$FF,$FB,$FD
.byte $DD,$FB,$7F,$BF,$F7,$DF,$DB,$6A
.byte $B6,$DF,$FF,$79,$7B,$6D,$4B,$6E
.byte $F6,$A6,$1E,$B5,$51,$74,$49,$05
.byte $DF,$B6,$DF,$B7,$FF,$DF,$F7,$FB
.byte $FF,$7E,$FE,$FF,$FF,$FB,$6F,$EF
.byte $95,$6A,$BD,$B5,$BE,$FE,$57,$3B
.byte $B8,$8A,$24,$02,$FD,$FF,$FD,$FF
.byte $6D,$FB,$6E,$DF,$DF,$DB,$FF,$DB
.byte $AB,$6D,$BF,$FD,$D9,$B5,$29,$4B
.byte $3B,$AF,$27,$14,$B9,$D8,$68,$11
.byte $01,$6F,$DF,$7F,$FB,$FF,$B7,$BF
.byte $FD,$FB,$DB,$7F,$7D,$FF,$ED,$DF
.byte $FF,$52,$9A,$54,$D5,$76,$DD,$1B
.byte $1D,$BD,$16,$48,$84,$F6,$FB,$ED
.byte $BF,$6D,$FE,$ED,$BF,$FF,$7F,$F6
.byte $DB,$AD,$BF,$FB,$53,$B6,$D5,$2A
.byte $AB,$5B,$2F,$8C,$8D,$D2,$01,$12
.byte $40,$DF,$BF,$7F,$F7,$FF,$BB,$BF
.byte $F7,$DF,$FD,$BF,$EE,$FF,$FB,$7F
.byte $FD,$DB,$4A,$92,$B6,$D6,$B7,$B1
.byte $4B,$2C,$FD,$4C,$80,$24,$6B,$77
.byte $ED,$FE,$DB,$FF,$DA,$DF,$FB,$6F
.byte $F6,$DD,$DB,$6F,$ED,$AA,$BA,$CD
.byte $12,$4C,$D5,$4E,$84,$8E,$CA,$82
.byte $55,$01,$6F,$FD,$FF,$AF,$FF,$6D
.byte $BF,$F7,$FF,$FE,$FF,$76,$FF,$FF
.byte $7F,$ED,$55,$25,$7A,$DA,$6E,$B3
.byte $26,$C9,$DA,$69,$00,$92,$6D,$5F
.byte $6D,$FB,$6D,$FF,$ED,$BF,$B7,$F7
.byte $B6,$EF,$4A,$DB,$FB,$62,$AA,$B2
.byte $92,$48,$D9,$AD,$A2,$DB,$26,$16
.byte $94,$A2,$01,$5B,$F7,$F7,$77,$FF
.byte $BB,$7F,$FB,$FE,$DF,$FF,$B5,$FF
.byte $FF,$6F,$D5,$54,$8D,$59,$29,$AE
.byte $DA,$95,$53,$AA,$49,$00,$52,$AD
.byte $BB,$6E,$DE,$AB,$FF,$ED,$FF,$FF
.byte $FB,$55,$DE,$56,$DB,$FE,$A8,$A5
.byte $62,$4A,$49,$52,$55,$60,$94,$06
.byte $2A,$90,$01,$56,$DF,$F7,$BB,$FE
.byte $DB,$7F,$B7,$6D,$DF,$FF,$6B,$FD
.byte $FF,$DF,$D3,$18,$99,$52,$18,$AD
.byte $A9,$29,$26,$93,$15,$00,$10,$AD
.byte $F6,$DB,$BA,$F7,$57,$FF,$FD,$FD
.byte $FF,$FB,$6D,$BD,$2F,$B6,$FA,$98
.byte $A6,$44,$99,$09,$52,$49,$42,$11
.byte $0C,$89,$80,$03,$33,$6F,$EF,$6E
.byte $FB,$6E,$DF,$DF,$FE,$DF,$F7,$D7
.byte $F6,$FF,$DF,$EA,$71,$59,$10,$90
.byte $A9,$24,$20,$0A,$12,$0A,$40,$20
.byte $96,$FD,$BB,$BB,$B7,$FF,$FB,$FB
.byte $B7,$FB,$6D,$7A,$BF,$DB,$FD,$52
.byte $9A,$84,$92,$08,$44,$89,$01,$21
.byte $0A,$C5,$82,$09,$2B,$5B,$DD,$DE
.byte $FD,$6D,$FF,$7F,$FF,$DB,$7F,$FF
.byte $AF,$D5,$BF,$6F,$B5,$51,$29,$21
.byte $00,$A4,$10,$10,$00,$24,$12,$40
.byte $10,$15,$FE,$F6,$ED,$AF,$FF,$B7
.byte $ED,$DF,$DB,$56,$F5,$7F,$FB,$FB
.byte $6A,$BA,$44,$44,$24,$11,$00,$80
.byte $04,$01,$02,$48,$85,$2A,$AB,$BF
.byte $77,$F5,$B6,$FE,$FF,$FB,$7F,$FF
.byte $6F,$AD,$6F,$7F,$B5,$A2,$68,$81
.byte $00,$40,$24,$00,$00,$48,$25,$00
.byte $30,$05,$FE,$D5,$BA,$BF,$FF,$DB
.byte $ED,$FF,$F6,$DB,$B5,$FB,$FF,$D5
.byte $AA,$DB,$72,$24,$22,$20,$10,$00
.byte $00,$08,$00,$01,$48,$8A,$8A,$D7
.byte $FF,$DF,$DA,$AD,$FF,$FF,$DB,$BF
.byte $FD,$EE,$B7,$6D,$FF,$5B,$92,$D0
.byte $80,$08,$02,$00,$00,$00,$01,$00
.byte $90,$24,$45,$7A,$54,$EA,$F7,$FF
.byte $6D,$B7,$FF,$FB,$6F,$77,$DE,$FF
.byte $6D,$B4,$E4,$12,$00,$81,$20,$20
.byte $00,$00,$00,$09,$20,$49,$22,$EF
.byte $FF,$BF,$6E,$DB,$FF,$FB,$BB,$7F
.byte $FB,$DD,$77,$B7,$FF,$6D,$29,$A0
.byte $48,$24,$00,$00,$00,$B7,$41,$10
.byte $00,$48,$12,$15,$76,$AA,$D5,$FD
.byte $FE,$D6,$DF,$FF,$ED,$BF,$77,$DA
.byte $FD,$AA,$F6,$C8,$4C,$00,$80,$82
.byte $01,$08,$00,$00,$01,$00,$81,$88
.byte $AD,$F7,$6E,$AF,$6B,$FF,$F7,$BB
.byte $FF,$F7,$FD,$BF,$DB,$FE,$DA,$4A
.byte $91,$20,$12,$00,$20,$04,$00,$DB
.byte $28,$04,$92,$5B,$5B,$77,$F6,$FF
.byte $6D,$BD,$FF,$6D,$BE,$DB,$D6,$FF
.byte $6D,$BD,$40,$48,$02,$40,$40,$00
.byte $00,$00,$10,$00,$00,$01,$01,$56
.byte $ED,$B5,$5F,$6D,$FF,$EF,$6F,$FF
.byte $FF,$FE,$FB,$AB,$FA,$EE,$92,$A5
.byte $90,$09,$02,$00,$00,$44,$00,$80
.byte $10,$00,$AA,$25,$B6,$DE,$EB,$BF
.byte $6D,$F7,$FD,$B6,$DB,$6D,$AF,$7E
.byte $B5,$FB,$21,$20,$01,$10,$00,$08
.byte $00,$00,$00,$04,$00,$40,$01,$1A
.byte $5B,$6B,$7D,$AB,$DB,$FF,$BD,$DF
.byte $FF,$FF,$FF,$7B,$F7,$FB,$B6,$49
.byte $36,$A0,$40,$00,$00,$04,$00,$10
.byte $00,$08,$01,$20,$49,$AD,$BD,$AE
.byte $EE,$DD,$F7,$FB,$6E,$DB,$6B,$B6
.byte $DD,$AD,$EE,$91,$01,$10,$01,$09
.byte $00,$BD,$99,$36,$D6,$F5,$BF,$FF
.byte $FF,$7F,$FF,$FF,$FD,$DF,$7B,$FB
.byte $B5,$12,$D9,$40,$00,$08,$80,$40
.byte $00,$81,$00,$00,$80,$08,$4A,$9B
.byte $7B,$5B,$AB,$6E,$DB,$ED,$B6,$EE
.byte $DE,$EB,$DE,$B3,$FA,$48,$00,$88
.byte $88,$00,$00,$00,$04,$00,$08,$00
.byte $08,$00,$24,$2D,$AD,$ED,$DF,$05
.byte $FF,$88,$FB,$5D,$77,$DF,$AD,$29
.byte $55,$20,$07,$00,$94,$12,$00,$10
.byte $45,$4B,$76,$B6,$B5,$BB,$BD,$6D
.byte $B6,$DB,$7F,$F7,$DA,$F7,$F6,$48
.byte $08,$04,$00,$8C,$02,$00,$04,$20
.byte $00,$40,$01,$10,$96,$DD,$DB,$DF
.byte $05,$FF,$A5,$EB,$3A,$F7,$7F,$69
.byte $16,$A1,$90,$00,$84,$08,$40,$10
.byte $00,$00,$00,$04,$24,$0A,$0A,$D6
.byte $ED,$6A,$DD,$ED,$B6,$DB,$6D,$FF
.byte $DD,$BD,$D7,$DC,$88,$08,$41,$10
.byte $04,$00,$8A,$40,$00,$40,$A0,$09
.byte $51,$4D,$BB,$5B,$B7,$05,$FF,$87
.byte $B6,$EF,$6F,$BB,$6A,$52,$41,$04
.byte $00,$A9,$02,$00,$00,$00,$04,$01
.byte $04,$04,$12,$DB,$ED,$6E,$DB,$6D
.byte $DB,$6D,$B6,$FD,$B5,$F5,$FF,$BC
.byte $0A,$04,$D2,$24,$80,$20,$00,$24
.byte $81,$24,$40,$A0,$89,$22,$8D,$36
.byte $6E,$DB,$BF,$04,$FF,$8A,$DF,$DE
.byte $BF,$57,$69,$64,$40,$20,$02,$04
.byte $05,$00,$DB,$01,$08,$00,$88,$46
.byte $DB,$DB,$76,$ED,$B7,$DB,$6D,$B7
.byte $F6,$ED,$D6,$FF,$F4,$0A,$45,$9A
.byte $A9,$20,$00,$22,$02,$09,$10,$08
.byte $20,$94,$11,$25,$6D,$6D,$AF,$6F
.byte $DD,$FF,$FF,$FE,$DF,$77,$FF,$ED
.byte $5A,$A4,$40,$44,$12,$00,$01,$00
.byte $10,$40,$01,$01,$00,$02,$42,$4B
.byte $B7,$B6,$F5,$BA,$FF,$6B,$5B,$6F
.byte $FB,$BD,$5B,$7F,$F9,$2A,$AA,$92
.byte $A5,$B4,$80,$00,$01,$09,$40,$00
.byte $90,$00,$20,$95,$59,$BB,$DB,$5E
.byte $DF,$6D,$FF,$FD,$FB,$6F,$DB,$FF
.byte $DF,$59,$24,$41,$24,$B6,$92,$20
.byte $00,$20,$10,$24,$12,$00,$12,$8A
.byte $4B,$AF,$6D,$EB,$6B,$BF,$6D,$AF
.byte $BF,$FD,$BF,$6D,$FB,$F5,$34,$A4
.byte $AA,$CB,$7B,$42,$00,$01,$06,$90
.byte $80,$A4,$00,$11,$12,$D5,$BB,$7E
.byte $FD,$F7,$FF,$FB,$76,$DF,$EB,$FE
.byte $DF,$59,$26,$52,$56,$B2,$A5,$A0
.byte $00,$00,$21,$24,$12,$00,$04,$A2
.byte $25,$6E,$DF,$AB,$AD,$BF,$DB,$6F
.byte $FF,$FA,$DB,$DE,$DB,$FF,$E9,$50
.byte $82,$AD,$89,$34,$94,$20,$00,$4D
.byte $A1,$21,$00,$00,$84,$4A,$B5,$E9
.byte $FD,$FB,$DB,$FF,$FD,$AD,$BF,$F7
.byte $FF,$7D,$D4,$8E,$65,$5A,$44,$05
.byte $A2,$00,$42,$02,$14,$8A,$00,$22
.byte $50,$05,$5B,$5F,$2E,$B6,$FF,$6D
.byte $B7,$FF,$ED,$BD,$B7,$EF,$EA,$50
.byte $94,$A4,$90,$A2,$10,$80,$00,$59
.byte $40,$10,$00,$00,$22,$AA,$DE,$EB
.byte $F7,$DF,$6D,$FF,$FE,$B5,$BF,$EF
.byte $FD,$FF,$59,$94,$66,$59,$DB,$01
.byte $11,$24,$00,$00,$02,$08,$01,$00
.byte $01,$20,$11,$56,$DD,$59,$76,$FF
.byte $DB,$6D,$FF,$F6,$F6,$DB,$BF,$D4
.byte $49,$2C,$A2,$2A,$4D,$09,$00,$01
.byte $12,$C1,$02,$04,$08,$89,$4D,$BB
.byte $BB,$EF,$BF,$D5,$FF,$FF,$DB,$7F
.byte $BF,$FF,$EB,$6B,$12,$4D,$54,$95
.byte $24,$D2,$40,$00,$14,$1A,$01,$80
.byte $02,$24,$24,$DB,$76,$BB,$76,$FF
.byte $B6,$DB,$FF,$DB,$EB,$5B,$FF,$92
.byte $48,$9A,$89,$69,$22,$89,$00,$00
.byte $42,$81,$DB,$00,$80,$49,$0A,$52
.byte $AB,$6F,$6D,$DF,$DB,$FF,$FE,$B6
.byte $FE,$FE,$FD,$EE,$D6,$92,$55,$6A
.byte $3E,$FC,$66,$80,$04,$2D,$A4,$93
.byte $44,$00,$A4,$29,$6D,$B5,$B6,$FB
.byte $FF,$B6,$DB,$FF,$B7,$B7,$DB,$F7
.byte $89,$49,$2A,$15,$EF,$F6,$29,$40
.byte $00,$9F,$F9,$20,$80,$2A,$28,$84
.byte $AA,$DE,$DD,$BF,$6D,$FF,$FE,$DB
.byte $7D,$DA,$EF,$FD,$A6,$92,$55,$A8
.byte $BB,$FC,$C6,$20,$00,$1D,$DC,$83
.byte $52,$01,$24,$69,$B7,$6B,$DB,$77
.byte $DB,$FF,$5B,$6F,$FF,$EF,$7F,$BD
.byte $ED,$01,$41,$24,$17,$F3,$B8,$25
.byte $80,$48,$4F,$E3,$40,$80,$48,$92
.byte $04,$99,$BD,$B6,$BF,$77,$FF,$F6
.byte $DB,$7B,$AD,$DF,$FB,$26,$48,$1B
.byte $48,$D9,$F8,$22,$60,$00,$07,$44
.byte $A4,$AC,$86,$49,$6B,$4D,$D7,$EF
.byte $F7,$FF,$6A,$BF,$FF,$DD,$FE,$ED
.byte $F7,$00,$92,$84,$2D,$60,$90,$4B
.byte $00,$00,$03,$A1,$00,$01,$21,$20
.byte $14,$AA,$BA,$75,$6D,$B7,$DF,$EB
.byte $6A,$EE,$DB,$B7,$7F,$EA,$44,$82
.byte $4B,$42,$5E,$E8,$02,$C0,$00,$04
.byte $0D,$00,$D8,$9A,$13,$6B,$57,$6F
.byte $DF,$FF,$FD,$FB,$7F,$BF,$DD,$ED
.byte $FA,$FE,$00,$44,$44,$28,$22,$12
.byte $15,$20,$00,$03,$50,$00,$04,$41
.byte $40,$12,$A9,$D9,$6D,$55,$BF,$5F
.byte $DB,$76,$FB,$FE,$DF,$EA,$C4,$82
.byte $4B,$02,$49,$40,$09,$40,$00,$00
.byte $02,$01,$52,$28,$32,$A4,$D6,$B7
.byte $BF,$FF,$ED,$F5,$BE,$FF,$B7,$4D
.byte $FD,$FC,$00,$05,$24,$A4,$BC,$00
.byte $00,$94,$A1,$08,$40,$00,$00,$08
.byte $85,$01,$12,$4B,$6D,$D5,$6D,$BF
.byte $BE,$ED,$DB,$7B,$FF,$FF,$6D,$91
.byte $42,$49,$00,$10,$00,$05,$10,$00
.byte $00,$20,$01,$20,$48,$A9,$2A,$B5
.byte $B6,$FF,$BF,$F7,$6B,$DF,$BD,$EF
.byte $6D,$DB,$F6,$40,$85,$94,$A9,$00
.byte $00,$12,$C0,$04,$00,$98,$8A,$40
.byte $00,$91,$2A,$DB,$55,$ED,$7B,$DE
.byte $F5,$EF,$BD,$FE,$FE,$B3,$00,$46
.byte $92,$40,$00,$02,$0C,$20,$04,$00
.byte $DB,$10,$94,$04,$9A,$55,$AD,$FE
.byte $DF,$DF,$6D,$BF,$BB,$77,$57,$FB
.byte $F6,$64,$86,$95,$08,$80,$10,$23
.byte $44,$00,$00,$00,$08,$88,$22,$82
.byte $44,$A9,$6E,$AB,$FB,$F7,$FF,$EE
.byte $F7,$EF,$FC,$DF,$67,$00,$27,$49
.byte $40,$04,$00,$18,$A0,$04,$02,$00
.byte $00,$02,$44,$24,$AA,$52,$D5,$FE
.byte $BF,$6D,$A5,$BF,$EE,$FA,$AF,$FB
.byte $ED,$A2,$46,$AA,$49,$00,$00,$45
.byte $00,$00,$20,$00,$80,$90,$02,$10
.byte $49,$AB,$6E,$B7,$DB,$F7,$FF,$7F
.byte $F5,$BF,$B7,$FB,$7E,$CA,$40,$83
.byte $92,$40,$00,$00,$2A,$E4,$00,$00
.byte $04,$00,$00,$21,$0A,$15,$54,$B7
.byte $DB,$7D,$AB,$D5,$6F,$F5,$FE,$D7
.byte $EF,$5E,$90,$07,$B5,$29,$00,$21
.byte $05,$00,$10,$00,$00,$00,$80,$02
.byte $20,$88,$AB,$6C,$FF,$BF,$FD,$FF
.byte $FE,$DF,$AD,$EF,$7D,$D6,$42,$81
.byte $92,$40,$22,$00,$59,$48,$00,$40
.byte $00,$00,$40,$41,$0C,$53,$52,$DF
.byte $A5,$ED,$57,$95,$5B,$FD,$FF,$6F
.byte $8A,$EF,$2C,$90,$43,$ED,$29,$00
.byte $00,$0A,$90,$04,$00,$98,$20,$02
.byte $20,$82,$6D,$55,$FF,$7F,$FB,$FF
.byte $FF,$6F,$6D,$DD,$BE,$DC,$00,$20
.byte $51,$40,$00,$00,$55,$40,$04,$00
.byte $DB,$81,$20,$88,$29,$52,$AE,$AD
.byte $D6,$B7,$B5,$B7,$FD,$FE,$EF,$F6
.byte $DA,$92,$41,$EC,$94,$84,$02,$1A
.byte $80,$02,$00,$00,$00,$60,$01,$04
.byte $84,$A9,$3B,$F7,$BB,$DF,$7F,$FD
.byte $AF,$B7,$B6,$BC,$DC,$00,$00,$65
.byte $20,$00,$00,$55,$40,$00,$20,$00
.byte $04,$21,$20,$44,$53,$36,$CD,$2D
.byte $EE,$EB,$D6,$B7,$FD,$FD,$EF,$B6
.byte $D9,$24,$C1,$B2,$92,$20,$00,$24
.byte $88,$00,$00,$10,$20,$70,$00,$80
.byte $2D,$4A,$B7,$FF,$DB,$77,$7F,$7F
.byte $FF,$BF,$5F,$6D,$7B,$D8,$08,$24
.byte $75,$24,$00,$11,$56,$A0,$01,$00
.byte $80,$00,$21,$50,$09,$54,$B5,$AC
.byte $D6,$DD,$D5,$EB,$6D,$ED,$FB,$EF
.byte $34,$AA,$13,$20,$B2,$90,$80,$00
.byte $90,$40,$10,$00,$00,$00,$70,$02
.byte $80,$2E,$CA,$77,$7B,$7B,$BF,$BF
.byte $FF,$7F,$EF,$6D,$EB,$D2,$04,$24
.byte $F5,$49,$00,$01,$2B,$B4,$0C,$04
.byte $00,$00,$29,$30,$10,$69,$29,$BA
.byte $DD,$DD,$ED,$F5,$B7,$DB,$7D,$DE
.byte $C2,$76,$74,$92,$10,$B2,$52,$11
.byte $04,$91,$22,$42,$20,$00,$00,$A4
.byte $82,$22,$5A,$92,$D6,$EB,$6E,$DB
.byte $DF,$FD,$FF,$DE,$ED,$D5,$D2,$05
.byte $18,$D9,$28,$40,$00,$AB,$54,$04
.byte $00,$00,$20,$52,$30,$00,$D5,$49
.byte $6D,$BD,$DB,$B7,$F6,$DF,$B6,$F7
.byte $77,$BA,$F4,$4A,$8C,$B6,$94,$80
.byte $04,$44,$89,$04,$00,$DB,$89,$01
.byte $25,$3A,$A9,$9B,$6B,$77,$7B,$7F
.byte $FB,$7F,$FF,$DD,$E5,$64,$02,$50
.byte $D9,$49,$00,$01,$29,$50,$00,$00
.byte $01,$00,$48,$24,$02,$A5,$12,$6D
.byte $BD,$B6,$DD,$EB,$7F,$F6,$DA,$F6
.byte $FE,$E4,$99,$2C,$BA,$64,$24,$40
.byte $44,$04,$20,$00,$00,$02,$8A,$00
.byte $44,$DD,$AA,$D6,$D6,$EF,$B7,$BF
.byte $ED,$FF,$FF,$BD,$A4,$D2,$05,$A2
.byte $B5,$15,$00,$09,$09,$40,$00,$00
.byte $20,$00,$94,$90,$13,$2A,$52,$5B
.byte $7B,$DB,$75,$DD,$FF,$7F,$B7,$B6
.byte $DA,$F7,$31,$2A,$59,$7A,$C8,$90
.byte $00,$20,$00,$00,$01,$00,$00,$88
.byte $02,$19,$B6,$AA,$AD,$AE,$FE,$EF
.byte $EF,$EF,$FF,$FF,$76,$DB,$72,$02
.byte $AC,$B9,$2A,$02,$42,$02,$00,$00
.byte $88,$00,$24,$53,$10,$4A,$55,$52
.byte $D5,$77,$A5,$B7,$FF,$7E,$F6,$DE
.byte $DD,$B6,$B2,$11,$46,$BD,$92,$A0
.byte $00,$48,$40,$04,$00,$00,$01,$28
.byte $00,$0D,$AB,$6D,$6D,$BD,$FF,$DB
.byte $FB,$F7,$FF,$F7,$B6,$DB,$ED,$D0
.byte $91,$6C,$BC,$A9,$09,$24,$00,$81
.byte $10,$00,$00,$00,$42,$22,$44,$94
.byte $8A,$9A,$D6,$DA,$FF,$DF,$DF,$B7
.byte $BD,$DD,$B5,$68,$90,$86,$FD,$49
.byte $00,$02,$AA,$74,$2D,$94,$01,$05
.byte $50,$00,$33,$6B,$6C,$DB,$7F,$B7
.byte $49,$FE,$FF,$FF,$F6,$ED,$AB,$08
.byte $A0,$E8,$7E,$A4,$A4,$95,$2D,$AB
.byte $55,$50,$00,$02,$42,$44,$88,$84
.byte $49,$9D,$92,$FB,$FF,$DF,$ED,$F6
.byte $FF,$7B,$65,$D2,$40,$47,$7E,$54
.byte $40,$DB,$0B,$F7,$DD,$B6,$A1,$08
.byte $0B,$20,$00,$15,$72,$92,$D6,$FF
.byte $B6,$AB,$FB,$7F,$BF,$B5,$AF,$DA
.byte $12,$20,$90,$7F,$A5,$24,$84,$AC
.byte $AA,$91,$10,$00,$01,$09,$04,$8A
.byte $11,$25,$5A,$4D,$DF,$7D,$FF,$FD
.byte $F7,$FF,$DA,$C9,$C2,$44,$A6,$FE
.byte $52,$40,$09,$5B,$44,$44,$80,$00
.byte $16,$60,$20,$54,$6A,$12,$D7,$7B
.byte $B5,$AB,$B7,$BF,$DE,$AA,$BF,$DA
.byte $4A,$41,$10,$7F,$AA,$24,$40,$A6
.byte $12,$02,$00,$00,$01,$DB,$0A,$04
.byte $22,$B0,$95,$5A,$9E,$FE,$F7,$FF
.byte $F6,$FD,$FF,$6B,$55,$82,$09,$49
.byte $7F,$D2,$90,$04,$9A,$88,$A4,$00
.byte $00,$56,$41,$01,$14,$90,$44,$AD
.byte $AB,$AD,$AD,$FD,$FF,$AF,$65,$FF
.byte $BA,$92,$44,$22,$7F,$C9,$44,$20
.byte $84,$92,$10,$20,$02,$04,$94,$24
.byte $42,$B2,$86,$D4,$AD,$FB,$77,$EF
.byte $6F,$FD,$FE,$AB,$A6,$8A,$09,$42
.byte $FF,$F6,$28,$04,$52,$40,$80,$00
.byte $10,$36,$88,$82,$24,$08,$24,$2B
.byte $56,$DB,$B7,$6D,$FF,$FD,$6E,$D7
.byte $FF,$BD,$92,$40,$29,$7F,$E9,$42
.byte $20,$89,$14,$20,$00,$00,$4C,$94
.byte $08,$82,$A1,$46,$9A,$2D,$DD,$B7
.byte $EE,$DF,$FF,$BE,$96,$A5,$04,$0A
.byte $80,$7F,$FA,$B0,$04,$10,$01,$01
.byte $00,$00,$B3,$4A,$41,$28,$48,$91
.byte $4D,$D6,$ED,$AD,$7F,$F6,$D6,$F7
.byte $77,$B3,$49,$00,$46,$7F,$FD,$0D
.byte $20,$81,$20,$00,$01,$01,$6C,$51
.byte $08,$06,$44,$AA,$2D,$3B,$5D,$B7
.byte $ED,$FF,$FF,$7B,$36,$A4,$D6,$09
.byte $13,$20,$7F,$FD,$B0,$04,$10,$00
.byte $00,$00,$08,$E7,$08,$22,$D1,$31
.byte $44,$96,$D3,$EB,$6B,$7F,$56,$D6
.byte $DE,$DB,$6B,$88,$01,$0A,$7F,$FE
.byte $8B,$49,$04,$00,$DB,$03,$D8,$B5
.byte $00,$08,$8A,$29,$43,$7A,$76,$B5
.byte $EF,$FF,$FF,$6A,$5B,$54,$CB,$0A
.byte $C1,$7F,$FD,$D4,$20,$90,$00,$00
.byte $08,$07,$EC,$80,$A6,$95,$64,$92
.byte $2A,$97,$AD,$DB,$DE,$DB,$6B,$FF
.byte $B6,$EB,$08,$82,$14,$3F,$FF,$69
.byte $8A,$01,$00,$02,$00,$26,$D1,$55
.byte $11,$4A,$48,$41,$91,$ED,$75,$2D
.byte $FF,$BF,$ED,$28,$B7,$55,$A6,$05
.byte $82,$7F,$FF,$5A,$51,$48,$08,$40
.byte $00,$1F,$A9,$80,$94,$ED,$B5,$24
.byte $91,$A6,$5B,$AD,$EB,$6D,$F6,$DF
.byte $FF,$6D,$B4,$91,$21,$24,$9F,$FF
.byte $B5,$92,$04,$00,$DB,$B5,$6A,$52
.byte $2A,$95,$48,$11,$33,$AD,$6A,$9B
.byte $FF,$BF,$F9,$29,$5B,$CD,$CC,$43
.byte $80,$9F,$FF,$6D,$54,$A4,$80,$00
.byte $00,$7F,$91,$80,$8D,$6A,$5A,$A0
.byte $94,$DB,$5D,$B5,$B5,$DA,$B7,$FE
.byte $F6,$B2,$42,$10,$84,$BF,$FF,$B6
.byte $AA,$40,$00,$00,$22,$DA,$D9,$21
.byte $05,$24,$21,$09,$4B,$5A,$E5,$5B
.byte $FF,$BF,$FB,$53,$3B,$57,$99,$89
.byte $08,$57,$FF,$6B,$69,$28,$00,$00
.byte $01,$FF,$59,$48,$46,$D2,$4C,$92
.byte $DB,$55,$AD,$3A,$A5,$AB,$DD,$6E
.byte $F6,$DB,$B9,$48,$12,$91,$3F,$FF
.byte $DB,$6D,$84,$88,$44,$0F,$F6,$E1
.byte $24,$84,$A8,$82,$44,$AA,$A6,$C5
.byte $DF,$FD,$B7,$DB,$B6,$FB,$CD,$A9
.byte $88,$08,$B7,$FF,$B6,$D4,$B2,$00
.byte $00,$47,$BF,$7A,$A8,$CA,$A6,$51
.byte $A9,$55,$5A,$7A,$65,$6F,$EE,$F7
.byte $5B,$2A,$B5,$D0,$4A,$51,$3F,$BF
.byte $EA,$BB,$48,$21,$01,$3F,$F5,$CC
.byte $30,$41,$69,$00,$44,$B6,$AB,$45
.byte $B7,$DD,$7F,$5B,$DB,$B6,$DF,$DA
.byte $A3,$11,$22,$56,$FF,$DB,$55,$A7
.byte $08,$4A,$4D,$6E,$B7,$26,$B6,$52
.byte $48,$B2,$62,$6C,$DA,$95,$F7,$D6
.byte $F6,$DD,$79,$2D,$E4,$88,$24,$2F
.byte $FF,$ED,$AA,$B4,$C5,$2B,$FF,$F7
.byte $CC,$A8,$40,$AA,$91,$15,$5D,$AA
.byte $AD,$DB,$6E,$FE,$DE,$B6,$2E,$F3
.byte $11,$55,$61,$57,$FF,$F5,$6D,$56
.byte $7A,$DA,$D5,$6D,$6E,$95,$6C,$64
.byte $48,$A4,$A5,$B5,$A4,$AB,$FF,$AB
.byte $EB,$6E,$F8,$4E,$C8,$20,$12,$33
.byte $AE,$FF,$EE,$D2,$A9,$97,$6D,$EE
.byte $F6,$95,$52,$42,$4B,$25,$51,$5A
.byte $D6,$B6,$D5,$55,$FE,$DE,$B4,$56
.byte $E9,$31,$89,$A0,$6D,$FF,$FB,$59
.byte $26,$69,$2B,$B6,$B6,$DA,$92,$64
.byte $82,$68,$88,$B6,$B5,$53,$5B

cMode:	.byte	$00		; Computer operating mode - 64=00 or 128=ff
cVideo:	.byte $00		; Computer video mode - 40=00 or 80=80/ff?
cRAMFlag:	.byte $00		; copy of sysRAMFlag
permName:
.asciiz "geoWizard   V1.0"

.bss
nBuffer:				; name buffer for the disk routines
.res $11
ramBAM:				; bam markup for RAM expansion
.res 256				; better reserve a block just in case.
