; Wheels 128's 1351D Mouse Driver
; Disassembly copyright 2004 by Todd Elliott

.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/inputdrv.inc"
.include "../include/geos/printdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.include "../include/geos/cbmarch.inc"

LC30D			= $C30D
joyPort		= $9fd3	; picks which joyport to query

.org $fd00
	rts
LFD01:
.byte $00
LFD02:
.byte $00
	rts
.byte $01
LFD05:
.byte $00

; mainloop calls this routine each interrupt
	jmp	LFD14

	lda	#$FF
	sta	ciddra
	lda	#$40
	sta	ciapra
	rts

LFD14:
	lda	ciddra
	pha
	lda	ciddrb
	pha				; preserve data dir regs
	lda	#$00
	sta	ciddra
	sta	ciddrb		; make all data dir bits all inputs
	lda	joyPort		; used to select either ciapra or ciaprb (I think!)
	and	#$01
	tax
	lda	ciapra,x		; check status of joy1 or joy2
	lsr	a			; check joystick up direction? or col 0, row 0 of keyboard?
	bcc	@1
	ldx	LFD05			; not sure
	bne	@1
	bit	LFE4F			; not sure
	bpl	@2
	stx	LFE4F			; mirror image of mouseData?
	dex
	stx	mouseData
	bne	@3
@1:	jsr	riteClick		; handle the mouse button right click (double-clicking)
	clv
	bvc	@3
@2:	jsr	leftClick
@3:	lda	joyPort
	jsr	LC30D
	tya
	pha
	txa
	ldy	LFD01
	jsr	LFDE4
	bit	graphMode
	bpl	@4
	asl	a
	pha
	txa
	rol	a
	tax
	pla
@4:	sty	LFD01
	tay
	beq	@6
	bpl	@5
	lda	#$08
.byte $2C				; BIT opcode
@5:	lda	#$04
@6:	sta	$04
	tya
	clc
	adc	mouseXPos
	sta	mouseXPos
	txa
	adc	mouseXPos+1
	sta	mouseXPos+1
	pla
	ldy	LFD02
	jsr	LFDE4
	sty	LFD02
	tax
	beq	@8
	bpl	@7
	lda	#$01
.byte $2C				; bit opcode
@7:	lda	#$02
	ora	$04
	sta	$04
	txa
@8:	sec
	eor	#$FF
	adc	mouseYPos
	sta	mouseYPos
	ldx	$04
	lda	mDelta,x
	sta	inputData
	pla
	sta	ciddrb
	pla
	sta	ciddra
	rts

mDelta:				; delta values used by the mouse driver
.byte $FF,$06,$02,$FF,$00,$07,$01,$ff,$04,$05,$03

leftClick:				; check left mouse button click
	lda	joyPort		; choose which joystick port (1 or 2)
	and	#$01
	tax
	lda	ciapra,x		; read fire button
	and	#$10
	eor	#$10
	beq	@1
	bit	mouseData		; at this point the left mouse button clicked
	bpl	LFDE4-1		; if it's $00, then the mouse button is still 'pressed'
	lda	#$00			; mark the button as 'pressed'
	beq	LFDDA			; relative JMP (needed?)
@1:	bit	mouseData
	bmi	LFDE4-1		; if it is $ff, then the mouse button has been 'released'
	lda	#$FF			; mark the button as 'released'
LFDDA:
	sta	mouseData
	lda	pressFlag
	ora	#$20
	sta	pressFlag		; indicate a change in button click status.
	rts

LFDE4:
	sty	r0L
	sta	r0H
	ldx	#$00
	sec
	sbc	r0L
	and	#$7F
	cmp	#$40
	bcs	@2
	lsr	a
	bne	@3
@1:	txa
	rts

@2:	ora	#$80
	cmp	#$FF
	beq	@1
	sec
	ror	a
	dex
@3:	ldy	r0H
	rts

riteClick:				; handle the mouse button right click (double-clicking)
	bit	LFE4F			; check internal copy of mouseData
	bmi	@4
	lda	LFD05
	bne	@1
	lda	#$02
	sta	LFD05
	jsr	LFE49
	lda	#$00
	beq	@3
@1:	dec	LFE50
	bne	LFE49+5
	jsr	LFE49
	dec	LFD05
	bne	@2
	lda	#$FF
	sta	LFE4F
	lda	menuNumber
	bne	@4
@2:	lda	#$FF
	eor	mouseData
@3:	jsr	LFDDA
	lda	menuNumber
	beq	LFE49+5
	lda	#$FF
	sta	LFE4F
@4:	lda	#$00
	sta	LFD05
.byte $2C				; BIT opcode

LFE49:
	lda	#$08
	sta	LFE50
	rts

.bss
LFE4F:
.res 1
LFE50:
.res 1
