; geoWizard VLIR #$01 Source Code
; Disassembly/Source Copyright (c) 2004 by Todd Elliott

.out "Source Code (c) 2005 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/inputdrv.inc"
.include "../include/geos/printdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.include "../include/geos/cbmarch.inc"

geosapp		= $0200	; start of GEOS application space
vidBuffer		= $1000	; copy of video matrix at $8c00
l13e8			= $13e8	; unknown buffer
l1668			= $1668	; unknown buffer
l18e8			= $18e8	; unknown buffer
brspace		= $1300	; backRAM start address
fnBuffer		= $2000	; filename buffer
xferarea		= $3f00	; 256 byte buffer for transferring RAM contents
exeDA			= $8B01	; vector for executing a DA within geoWizard
gWizSMod		= $9f0d	; start address for the GW Switcher code
gWizCode		= gWizSMod+7; execute address for geoWizard Switcher code

l8b05           = $8B05
L903C           = $903C
himem			= $e000	; alternative location for the geoWizard module

setdbBuf128		= $ed87	; part of DoDlgBox in Wheels 128 - sets up the DlgBoxRamBuf
retdbBuf128		= $ee69	; restores the DlgBoxRamBuf under Wheels 128
setdbBuf		= $f28e	; part of DoDlgBox in Wheels 64 - sets up the DlgBoxRamBuf
retdbBuf		= $f29a	; restores the DlgBoxRamBuf under Wheels 64

.org $4000				; executes @ $4000

cMainLoop:
.word $c0dd
reuBank:
.byte $07

entry:				; entry point for geoWizard
	pla
	sta	return
	pla
	sta	return+1		; saves the return address from JSR $4003
	ldy	#$00			; immediately save the stack. Do not subroutine this!
@1:	lda	stack,y
	sta	bufStack,y		; preserves the stack area
	iny
	bne	@1
	tsx
	stx	stackPtr
	jsr	saveRAM		; basically copies resident memory into the REU
	jsr	detGEOS		; detect GEOS config
	lda	cVideo
	sta	copyVideo

	lda	MainLoop+2
	sta	r0H
	lda	MainLoop+1
	sta	r0L			; patch Wheels OS MainLoop
	php
	sei
	ldy	#$00
	lda	#$2c			; BIT opcode
	sta	(r0),y
	iny
	lda	#$b4
	sta	(r0),y
	iny
	lda	#$88			; BIT $88B4
	sta	(r0),y		; and restore Wheels OS MainLoop
	plp

	lda	cMode
	bpl	@3			; take branch in Wheels 64
	jsr	TempHideMouse	; hides the mouse
@3:	jsr	i_FillRam
.word $00a4				; fill range
.word appFName			; start address to fill
.byte $00				; w/ zeroes

	jsr	saveIO		; preserve some i/o registers
	jsr	L489F			; preserves dialog box space & backRAM (inc. software sprites)

	clc
	lda	Panic+1		; get lo byte of Panic address
	adc	#$06			; get the proper address offset for the reuBank
	sta	appDA-7		; and modify the desktopcode segment
	lda	Panic+2		; get hi byte
	adc	#$00
	sta	appDA-6

	lda	#$00
	sta	r0L
	lda	#>gwStart		; $40
	sta	r7H
	lda	#<gwStart		; $6B
	sta	r7L
	jmp	StartAppl		; initializes GEOS for a new application (warm start?)

gwStart:				; starts up geoWizard
	lda	curDrive
	sta	ccurDrive		; preserves curDrive
	jsr	NewDisk		; initializes the disk device - doesn't preserve numDrives
	jsr	getDrvNames		; gets the names for the disk drives
	jsr	MouseUp		; activates the mouse
	jsr	setScrRectangle	; the entire 40 or 80 column screen
	jsr	ImprintRectangle	; saves the visible rectangle area to the background screen.

	lda	cVideo		; get geoWizard's video mode
	bpl	@1			; branch on 40 column mode
	lda	#$02
	jsr	SetColorMode	; set up the VDC color mode appropriately

@1:	jsr	goMono		; greys out the bottom portion of the screen
	lda	#>bdtbl
	sta	r0H
	lda	#<bdtbl
	sta	r0L
	jsr	dblAddr		; bitmap double certain addresses
	lda	#$80
	sta	dispBufferOn	; write to foreground screen only.
	lda	#$00
	jsr	SetPattern		; clears an area
	jsr	setScrRectangle
	lda	#$1F
	sta	r2H			; only the first 4 rows of the screen, though
	jsr	Rectangle

	jsr	ConvToCards
	lda	appDBColor		; based on prefs manager
	sta	r4H
	jsr	ColorRectangle	; and colorizes the screen, 40/80 column modes

	lda	#$00
	ora	cVideo
	sta	r11H
	lda	#$01
	sta	r11L
	lda	#$0A
	sta	r1H
	lda	#>tCpyright
	sta	r0H
	lda	#<tCpyright
	sta	r0L			; prints out the geoWizard copyright notice
	jsr	PutString		; and brief instructions
	jsr	setScrRectangle
	lda	#$1F
	sta	r11L
	lda	#$FF
	jsr	HorizontalLine	; draws a line under the instructions
	lda	#>itDummy
	sta	r0H
	lda	#<itDummy		; create a dummy icon table
	sta	r0L
	jsr	DoIcons
	lda	#>srKeys
	sta	keyVector+1
	lda	#<srKeys
	sta	keyVector
	lda	#>srOther
	sta	otherPressVec+1
	lda	#<srOther
	sta	otherPressVec
	rts				; exits back to GEOS MainLoop!

exitgeoWiz:				; exits the geoWizard interface
;	lda	#$00			; clear flag
;	sta	r1L			; code might not be needed after all.
;altExit:				; Wheels already has a Panic DB
;	lda	r0H
;	sta	indCall+1
;	lda	r0L
;	sta	indCall
;	lda	r1L
;	sta	indCall+2
	jsr	rstrVideo		; restores original video mode.
	jsr	chkDNames		; checks disk names to make sure they are all the same
	lda	ccurDrive
	jsr	SetDevice		; restore original disk configuration
	lda	turboFlags+1	; preserve state of diskTurbo in all 4 drives
	sta	cturboFlags+1	; necessary?
	lda	turboFlags
	sta	cturboFlags
	lda	turboFlags+3
	sta	cturboFlags+3
	lda	turboFlags+2
	sta	cturboFlags+2
	jsr	setScrRectangle
	jsr	RecoverRectangle	; recovers the entire 40/80 column screen
	jsr	restoreRAM		; in doing so, the disk BAM is overwritten with possibly
					; bad and outdated data
	php
	sei
	lda	cturboFlags+3	; restore state of diskTurbo in all 4 drives
	sta	turboFlags+3
	lda	cturboFlags+2
	sta	turboFlags+2
	lda	cturboFlags+1
	sta	turboFlags+1
	lda	cturboFlags
	sta	turboFlags
	jsr	restoreIO
;	lda	MainLoop+2
;	sta	r0H
;	lda	MainLoop+1
;	sta	r0L			; patch Wheels OS MainLoop
;	ldy	#$00			; is this needed? the restoreRAM took care of it
;	lda	#$4c			; JMP opcode
;	sta	(r0),y
;	iny
;	lda	#<gWizCode
;	sta	(r0),y
;	iny
;	lda	#>gWizCode		; JMP gWizCode
;	sta	(r0),y		; and restore geoWizard in MainLoop
	plp

	lda	#$00
	sta	curBamBlock 
	sta	bamAltered		; essentially wipe out the BAM for native disk drivers
	jsr	GetDirHead		; fails to restore the BAM @ $8900-$89ff,
	lda	#$80			; but good on 15xx disk drivers, I guess.
	sta	mouseData		; set mouse button press to 'released'

	jsr	rstrZP		; restore zero page & indirectly, the stack region as well.
	ldy	#$00
@1:	lda	bufStack,y
	sta	stack,y		; restores original stack
	iny
	bne	@1
	ldx	stackPtr
	txs				; and stack pointer
;	lda	indCall+1
;	sta	r4H
;	lda	indCall
;	sta	r4L
;	lda	indCall+2		; Might not be needed after all. Wheels already has a
;	sta	r5L			; Panic DB
	lda	#>cMainLoop
	sta	r0H
	sta	r1H
	lda	#<cMainLoop
	sta	r0L
	sta	r1L
	sta	r2L
	lda	#$20
	sta	r2H			; length $2000 bytes for geoWizard module at $4000
	lda	reuBank
	sta	r3L
	lda	return+1
	pha
	lda	return		; restores the return address from jsr $4003
	pha				; geoWizard returns execution to the activator code
	rts

rstrVideo:
	lda	cMode
	bne	@1
@2:	rts
@1:	lda	copyVideo		; restore original video mode
	cmp	graphMode
	beq	@2
	sta	graphMode
	jsr	SetNewMode
	lda	cvdc
	jmp	SetColorMode	; set up the VDC color mode appropriately

srOther:				; handle the mouse button press fault vector
	lda	mouseData
	bpl	@1
	rts
@1:	jmp	exitgeoWiz		; if the mouse button is pressed, then exit geoWizard

srKeys:				; handle keypresses from within geoWizard
	lda	keyData
	sta	a1L			; save it temporarily
	cmp	#$41			; letter 'A'?
	bcc	@1
	ora	#$20			; uppercase any letters, but not #'s
@1:	sta	a0L
	ldy	#$00
@2:	lda	keyTable,y
	cmp	a0L
	beq	@3
	iny
	cpy	#$06			; go through the table to see any recognized keypresses
	bcc	@2
	rts
@3:	tya
	asl	a
	tay
	lda	keyJump,y
	sta	r0L
	lda	keyJump+1,y
	sta	r0H			; create an indirect JMP
	jmp	(r0L)

keyTable:				; table of recognized keypresses.
.byte $0D,$F0,$E4,$EC		; CR, Not Q ($f1), P, not R ($f2), D, L

keyJump:
.word exitgeoWiz			; CR entry
;.word exitDeskTop		; deskTop entry - Wheels OS already has a Panic routine
.word screenDump			; screen dump entry
;.word exitRBoot			; Reboot entry - Doesn't really work!
.word runDA				; run a DA
.word runApp			; run an application

bdtbl:				; table of addresses used for bitmap doubling
.word bd8
.word bd1
.word bd2
.word bd3
.word bd4
.word bd5
.word bd6
.word bd7
.word bd9
.word bda
.word bdb
.word bdc
.word NULL

runApp:				; runs an application
	jsr	fileReq		; issues a file requestor DB
	bcc	@2
	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile
	txa
	beq	@3			; branch if the application/autoexec is found
	jsr	L53E5			; otherwise, issue a disk error DB
@2:	rts

@3:	lda	#>L4366
	sta	appDA+2		; modify the appDA exit routine
	lda	#<L4366
	sta	appDA+1
	lda	EnterDeskTop+2	; preserve address for the EnterDeskTop call
	sta	eDTop+1
	lda	EnterDeskTop+1	; EnterDeskTop code is source
	sta	eDTop
	lda	RstrAppl+2		; copies the RstrAppl address to the EnterDeskTop call
	sta	EnterDeskTop+2
	ldx	RstrAppl+1
	stx	EnterDeskTop+1
	jsr	setMDRegs
	lda	LdDeskAcc		; need to disable DA's from within the application
	sta	indCall
	lda	LdDeskAcc+2
	sta	indCall+2
	lda	LdDeskAcc+1
	sta	indCall+1
	lda	#$A2			; ldx #$00
	sta	LdDeskAcc
	lda	#$00			; induce no error in the call
	sta	LdDeskAcc+1		; this way, the application cannot call the DA.
	lda	#$60			; rts
	sta	LdDeskAcc+2
	tsx
	stx	pstkptr		; preserve stack pointer
;	lda	c128Flag		; is it Wheels 128?
;	bpl	@1			; take branch in Wheels 64
;	jsr	svbackRAM		; otherwise, save backRAM contents
;@1:
	jsr	savScreens		; saves the fg/bg screens under GEOS 128
	jsr	setScrRectangle
	jsr	goMono		; greys out the screen

@4:	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	lda	#$00
	sta	r0L
	jsr	GetFile		; gets the application/autoexec file and actually executes it?

	txa				; check error if it does return here!
	cmp	#$0E
	bne	@5
	jsr	L43E0			; warns user of GEOS 128 or changes video modes (40/80)
	bcs	@4
	clv
	bvc	L4366
@5:	jsr	L53E5			; issue a disk error DB

L4366:				; entered by the EnterDeskTop modified code
	ldx	pstkptr
	tsx				; restore stack pointer
	pla				; eliminate a JSR call?
	pla
	lda	#$00
	sta	r0L
	lda	#>rsGeoWiz
	sta	r7H
	lda	#<rsGeoWiz
	sta	r7L
	jmp	StartAppl		; conducts a (warm?) start

rsGeoWiz:				; restarts geoWizard
	lda	indCall
	sta	LdDeskAcc		; restores the Load Desk Accessory call in the GEOS Kernal
	lda	indCall+2
	sta	LdDeskAcc+2
	lda	indCall+1
	sta	LdDeskAcc+1
	lda	eDTop+1
	sta	EnterDeskTop+2	; restore address for the EnterDeskTop call
	lda	eDTop
	sta	EnterDeskTop+1
	jsr	retMDRegs		; restore RstrAppl code
	jsr	rstrVideo		; restores original video mode
	jsr	retScreens		; restores bg/fg screens
;	lda	c128Flag		; Is it Wheels 128?
;	bpl	@1			; take branch in Wheels 64
;	jsr	rtbackRAM		; restore the backRAM contents in Wheels 128
;@1:
	jsr	NewDisk		; initializes the drives
	jmp	exitgeoWiz

DeskTopCode:			; replaces code for EnterDeskTop call
	sei
	lda	#>cMainLoop
	sta	r0H
	lda	#<cMainLoop
	sta	r0L			; $4000 on the CPU
	sta	r1L
	sta	r2L
	lda	#>himem		; $e000 on the REU
	sta	r1H			; solves problem of preserving contents of $4000-$5fff
	lda	#$20
	sta	r2H			; length - $2000 bytes
	lda	gWizCode-1		; get reuBank from the geoWizard switcher.
	sta	r3L
	jsr	FetchRAM		; fetches the geoWizard module from the REU
appDA:				; used for self-modifying code purposes
	jmp	L4366			; for application's
;@1:	jmp	l578d			; for DA's

L43E0:
	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo
	lda	fileHeader+96
	cmp	#$80			; checks operating mode of application
	bne	@2
	ldx	#>tCannot		; warns user about not running under Wheels 128
	ldy	#<tCannot
	jsr	genericDB		; issue generic DB w/ OK icon
@1:	clc
	rts

@2:	ldx	#>tProg		; warns user about switching video modes
	ldy	#<tProg
	jsr	genericCDB		; issue generic DB w/ CANCEL icon
	lda	r0L
	cmp	#$01			; OK icon?
	bne	@1
	lda	cVideo
	eor	#$80
	sta	cVideo
	sta	graphMode
	jsr	SetNewMode		; change video mode
	sec
	rts

;exitDeskTop:			; exits back to deskTop
;@2:	ldx	#>tDestroy		; warns user that appl_space will be destroyed
;	ldy	#<tDestroy
;	jsr	genericCDB		; issue generic DB w/ CANCEL icon
;	lda	r0L
;	cmp	#$01			; OK icon?
;	beq	@3
;	rts
;
;@3:	lda	#$FF			; set flag
;	sta	r1L
;	lda	#>EnterDeskTop
;	sta	r0H
;	lda	#<EnterDeskTop
;	sta	r0L			; perform indirect call
;	jmp	altExit		; and exit geoWizard

screenDump:				; geoWizard's screen dump facilities
rts					; for now

;	jsr	i_MoveData		; needed as the printer driver overwrites the bg screen
;.word BACK_SCR_BASE		; src background screen
;.word fnBuffer			; dest ($2000)
;.word $2000				; xfer length
;	lda	#>vidBuffer		; but what about the foreground screen?!?
;	sta	r0H
;	lda	#<vidBuffer
;	sta	r0L			; src (REU) $1000
;	lda	#>COLOR_MATRIX	; dest (CPU) $8c00
;	sta	r1H
;	lda	#<COLOR_MATRIX
;	sta	r1L
;	lda	#$03			; length - $03e8 
;	sta	r2H
;	lda	#$E8
;	sta	r2L
;	lda	reuBank
;	sta	r3L
;	jsr	FetchRAM		; retrieves color matrix ram from the REU
;	lda	#>PrntFilename
;	sta	r6H
;	lda	#<PrntFilename
;	sta	r6L
;	lda	#$00
;	sta	r0L
;	jsr	GetFile		; gets the current printer driver into memory
;	txa				; rewrite this to utilize Photo Scraps or Albums instead.
;	beq	@7
;	lda	#>dbNoPrint
;	sta	r0H
;	lda	#<dbNoPrint		; issues a DB warning user that printer driver isn't available
;	sta	r0L
;	jsr	DoDlgBox
;	rts
;
;@7:	jsr	L4622			; sets pseudoregisters r0-r2
;	jsr	InitForPrint
;	jsr	L4622			; sets pseudoregisters r0-r2
;	jsr	StartPrint		; initializes the GEOS Kernal for printing
;	lda	#$05
;	sta	r0H
;	lda	#$00
;	sta	r0L			; clear $0500 bytes
;	lda	#>l13e8
;	sta	r1H
;	lda	#<l13e8		; $13e8? area to clear
;	sta	r1L
;	jsr	ClearRam
;	jsr	i_FillRam
;.word $0050				; # of bytes to fill
;.word l18e8				; area to fill - shouldn't it be 13e8?
;.byte $11				; fill byte
;	lda	cVideo
;	bpl	@8
;	jmp	L4571			; for GEOS 128 - 80 column mode
;
;@8:	lda	#$19
;	sta	a0L			; go 25 rows!
;	lda	#>fnBuffer
;	sta	a1H
;	lda	#<fnBuffer
;	sta	a1L
;	lda	#>vidBuffer
;	sta	a2H
;	lda	#<vidBuffer
;	sta	a2L
;@9:	lda	a1H
;	sta	r0H
;	lda	a1L
;	sta	r0L			; $2000 - (src)
;	lda	#>l13e8
;	sta	r1H
;	lda	#<l13e8
;	sta	r1L			; $13e8 - (dest)
;	lda	#$01
;	sta	r2H
;	lda	#$40
;	sta	r2L			; $0140 - length (320 bytes) - one cardrow
;	jsr	MoveData		; and moves the screen data
;	lda	a2H
;	sta	r0H
;	lda	a2L
;	sta	r0L			; $1000 - (src)
;	lda	#>l18e8
;	sta	r1H
;	lda	#<l18e8
;	sta	r1L			; l18e8 - (dest)
;	lda	#$00
;	sta	r2H
;	lda	#$28
;	sta	r2L			; $0028 - length (40 bytes) - one color row
;	jsr	MoveData		; and moves the color data
;	jsr	L4622			; and resets the psuedoregisters r0..r2
;	lda	#>l18e8
;	sta	r2H
;	lda	#<l18e8
;	sta	r2L
;	jsr	PrintBuffer		; prints the screen dump!
;	clc
;	lda	a1L
;	adc	#$40
;	sta	a1L
;	lda	a1H
;	adc	#$01
;	sta	a1H			; go down a cardrow (another 320 bytes)
;	clc
;	lda	a2L
;	adc	#$28
;	sta	a2L
;	lda	a2H
;	adc	#$00
;	sta	a2H			; go down a color row (another 40 bytes)
;	lda	mouseData		; checks mouse button press? (perhaps to CANCEL printing)
;	bpl	@1
;	dec	a0L			; go down all 25 rows of the screen dump
;	bne	@9
;@1:	jsr	L4622			; and resets the psuedoregisters r0..r2
;	jsr	StopPrint		; stops the printing process
;	rts				; redundant
;
;L4571:				; GEOS 128 80 column screen
;	lda	#$02			; double height?
;	sta	a8L
;	lda	#$00
;	sta	a5H
;	lda	#$32
;	sta	a5L			; 50 rows?
;	lda	a1L			; checks copy of keyData
;	cmp	#$D0
;	bne	@1
;	lda	#$01			; single height?
;	sta	a8L
;	lda	#$19			; 25 rows
;	sta	a5L
;@1:	lda	a8L
;	sta	a9L
;	lda	#$00
;	sta	a6L
;	lda	#>fnBuffer
;	sta	a1H
;	lda	#<fnBuffer
;	sta	a1L
;@2:	lda	#>l13e8
;	sta	a2H
;	lda	#<l13e8
;	sta	a2L
;	lda	#$08			; go through eight scanlines
;	sta	a4L
;@3:	ldx	#$00
;	ldy	#$00
;@4:	lda	(a1L),y		; copies content of fnBuffer (screen) to $13e8
;	sta	($70,x)		; a2L
;	clc
;	lda	a2L
;	adc	#$08
;	sta	a2L
;	lda	a2H
;	adc	#$00
;	sta	a2H			; gets next card value
;	iny
;	cpy	#$50			; up to 80 columns
;	bcc	@4
;	dec	a9L			; double height?
;	bne	@5
;	clc
;	lda	a1L
;	adc	#$50
;	sta	a1L
;	lda	a1H
;	adc	#$00
;	sta	a1H			; adds 80 to the screen offset
;	lda	a8L
;	sta	a9L			; repeat double/single height value
;@5:	lda	a6L
;	bne	@7
;	lda	a1H
;	cmp	#$3F			; are we done w/ screen? - but won't work w/ other half of
;	bne	@6			; bg screen?
;	lda	a1L
;	cmp	#$40
;@6:	bcc	@7
;	lda	#$A0			; set it to the other half of bg screen
;	sta	a1H
;	lda	#$40
;	sta	a1L
;	lda	#$01
;	sta	a6L			; get the other half of bg screen
;@7:	sec
;	lda	a2L
;	sbc	#$7F
;	sta	a2L
;	lda	a2H
;	sbc	#$02
;	sta	a2H			; subtracts 640 bytes from the offset & repeats in that cardrow
;	dec	a4L			; go through all 8 scanlines of a cardrow
;	bne	@3
;	jsr	L4622			; and resets the psuedoregisters r0..r2
;	jsr	PrintBuffer
;	lda	mouseData
;	bpl	@8			; did the user CANCEL?
;	dec	a5L
;	bne	@2
;@8:	jsr	L4622			; and resets the psuedoregisters r0..r2
;	jsr	StopPrint		; kills the printing device
;	jsr	i_MoveData
;.word fnBuffer			; and restores the first half of the background screen
;.word BACK_SCR_BASE		; dest
;.word $2000				; xfer length
;	rts
;
;L4622:				; sets pseudoregisters r0-r2 - used by printing routines
;	lda	#>l13e8
;	sta	r0H
;	lda	#<l13e8
;	sta	r0L
;	lda	#>l1668
;	sta	r1H
;	lda	#<l1668
;	sta	r1L
;	lda	#$00
;	sta	r2H
;	lda	#$00
;	sta	r2L
;	rts

saveRAM:
	lda	#$00
	sta	r0H
	sta	r2H
	lda	#$08			; $0008
	sta	r0L			; preserve zp space
	lda	#>bufZP
	sta	r1H
	lda	#<bufZP
	sta	r1L
	lda	#$F8
	sta	r2L			; length $00f8
	jsr	L4738			; performs the copy of zp space
	jsr	PutDirHead		; save the BAM/directory header info.
	jsr	svRAM			; saves much of the RAM space
	jmp	svZPS			; saves zero page+stack region to the REU as well.

restoreRAM:				; restores much of GEOS RAM contents
	jsr	L48E5			; restores GEOS DB and backRAM space
	jmp	rstrRAM		; restores much of the RAM space
	
rstrZP:				; restores zero page region
	jsr	rstrZPS		; gets zero page+stack from the REU
	lda	#$00
	sta	r2H			; restores original zero page
					; and fall through the zp copy routine

L4738:				; copies a region of memory
	ldy	#$00			; why not use MoveData?
@1:	lda	(r0L),y
	sta	(r1L),y
	lda	r2L
	ora	r2H
	beq	@5
	inc	r0L
	bne	@2
	inc	r0H
@2:	inc	r1L
	bne	@3
	inc	r1H
@3:	lda	r2L
	bne	@4
	dec	r2H
@4:	dec	r2L
	clv
	bvc	@1
@5:	rts

svRAM:
	ldy	#$90			; StashRAM
.byte $2c				; BIT opcode
rstrRAM:
	ldy	#$91			; FetchRAM
	lda	#>geosapp
	sta	r0H
	sta	r1H
	lda	#<geosapp
	sta	r0L
	sta	r1L
	sta	r2L
	lda	#$3E
	sta	r2H
	lda	reuBank
	sta	r3L
	jsr	DoRAMOp		; retrieves/stashes $0200-$3fff (REU) to (CPU) @ $0200
	lda	#>BACK_SCR_BASE
	sta	r0H
	sta	r1H
	lda	#$70
	sta	r2H
	lda	#$10
	sta	r2L
	jmp	DoRAMOp		; retrieves/stashes $6000-$d00f (REU) to (CPU) @ $6000

svZPS:
	ldy	#$90			; StashRAM
.byte $2c				; BIT opcode
rstrZPS:
	ldy	#$91			; FetchRAM
	lda	#>bufZP
	sta	r0H
	lda	#<bufZP
	sta	r0L
	lda	#$00
	sta	r1H
	lda	#$08
	sta	r1L
	lda	#$01
	sta	r2H
	lda	#$F8			; saves both zp and stack areas
	sta	r2L
	jmp	DoRAMOp		; retrieves/stashes $0008-$01f8 (REU) to (CPU) @ $5d61

savScreens:				; for GEOS 128 - saves bg/fg 40-column screens
	lda	#>cMainLoop
	sta	r0H
	lda	#<cMainLoop
	sta	r0L
	sta	r1L
	sta	r2L
	lda	#>himem
	sta	r1H
	lda	#$20
	sta	r2H
	lda	reuBank
	sta	r3L
	jsr	StashRAM		; saves geoWizard's working memspace @ $e000 of the REU

	lda	#$3f			; CPU $3f00
	sta	r0H
	lda	#$01
	sta	r2H			; xfer $0100 bytes
	lda	#$00
	sta	r1H			; REU $0000
@2:	sta	r3L			; bank $00 of the REU

	jsr	FetchRAM		; gets the first 32Kb of the REU
	ldx	reuBank		; get REU bank byte
	inx				; get the next bank and use that instead.
	txa
	sta	r3L
	jsr	StashRAM		; saves the first 32Kb of the REU
	lda	#$00			; reset bank $00 of the REU
	inc	r1H			; increment the REU offset
	bpl	@2			; only capture up to the first 32Kb
	jmp	svSCR			; and saves the screens

savGWScreen:			; saves geoWizard's VDC 80 column screen
	ldy	#$90			; conduct a STASH from the REU
.byte $2c				; BIT opcode
retGWScreen:			; retrieves geoWizard's VDC 80 column screen
	ldy	#$91
;	sta	a7L			; conduct a FETCH into the REU
	lda	#>BACK_SCR_BASE	; $6000 @ background screen
	sta	r0H
	lda	#$c0			; $c000 in the REU side
	sta	r1H
	lda	#$20			; length $2000 bytes
	sta	r2H
	lda	#$00
	sta	r0L
	sta	r1L
	sta	r2L
	ldx	reuBank		; get REU bank byte
	inx				; get the next bank and use that instead.
	txa
	sta	r3L
;	ldy	a7L			; get xfer mode
	jsr	DoRAMOp		; stashes/fetches geoWizard's VDC screen
	lda	#>SCREEN_BASE	; $8000 @ for the 2nd half of the background screen.
	sta	r0H
	lda	#$e0			; $e000 in the REU side
	sta	r1H
;	ldy	a7L			; get xfer mode
	jmp	DoRAMOp		; stashes/fetches geoWizard's VDC screen

retScreens:				; for GEOS 128 - restores fg/bg screens in 40 column mode
	lda	#$3f			; CPU $3f00
	sta	r0H
	lda	#$01
	sta	r2H			; xfer $0100 bytes
	lda	#$00
	sta	r0L
	sta	r1H
	sta	r1L			; REU $0000
	sta	r2L
@2:	ldx	reuBank		; get REU bank byte
	inx				; get the next bank and use that instead.
	txa
	sta	r3L

	jsr	FetchRAM		; gets the first 32Kb of the REU
	lda	#$00
	sta	r3L			; and store it in bank $00 of the REU
	jsr	StashRAM		; restores the first 32Kb of the REU
	inc	r1H			; increment the REU offset
	bpl	@2			; only capture up to the first 32Kb

	ldy	#$91			; FetchRAM
.byte $2c				; BIT opcode
svSCR:				; saves the screens
	ldy	#$90			; StashRAM
;	lda	cMode			; not needed for Wheels OS?
;	bne	@1
;	rts

;@1:
	lda	#>BACK_SCR_BASE	; cpu $6000
	sta	r0H			; dest $8000 of the REU
	lda	#$20
	sta	r2H			; xfer $6000-$7fff (CPU) from $8000 of the REU
	ldx	reuBank		; get REU bank byte
	inx				; get the next bank and use that instead.
	txa
	sta	r3L
	jsr	DoRAMOp		; stashes/restores the background screen
	lda	#>SCREEN_BASE
	sta	r0H			; @ $a000
	sta	r1H			; dest $a000 of the REU
	jmp	DoRAMOp		; xfer $a000-$bfff (CPU) from $a000 of the REU

detGEOS:				; detects GEOS config and sets flags accordingly
	ldy	#$00
	sty	cMode			; default Wheels 64 mode
	lda	version		; check GEOS version
	cmp	#$41			; is it Wheels?
	bcc	@1			; above v2.0?
	lda	driverVersion	; check disk device drivers
	cmp	#$52			; is it Wheels?
	bcc	@1
	lda	c128Flag
	bpl	@1
	lda	vdcClrMode		; preserve VDC mode
	sta	cvdc
	lda	#$FF
	sta	cMode			; notify geoWizard about Wheels 128
	ldy	graphMode		; get 40/80 column info
@1:	sty	cVideo
	rts

setScrRectangle:			; sets up a rectangle coordinates, no matter which 40/80 mode
	lda	#$00			; the coordinates suggest the entire screen
	sta	r2L
	lda	#$C7
	sta	r2H
	lda	#$00
	sta	r3H
	lda	#$00
	sta	r3L
	lda	cVideo
	bmi	@1
	lda	#$01
	sta	r4H
	lda	#$3F
	sta	r4L
	rts

@1:	lda	#$02
	sta	r4H
	lda	#$7F
	sta	r4L
	rts

L489F:
	lda	cMode
	bmi	@1
	jsr	setdbBuf		; jsrs directly into Wheels 64 Kernal in setting up
	clv				; the DlgBoxRamBuf
	bvc	@2
@1:	jsr	setdbBuf128		; jsrs directly into Wheels 128 Kernal for DlgBoxRamBuf
	jsr	svbackRAM		; go ahead and save it here, as we need to preserve the
					; 80 column software mouse and its mask. I really wanted
					; to put it in the runApp sequence, as backing up/restoring
					; the backRAM would take quite some time.
;	lda	#>brspace
;	sta	r0H
;	lda	#<brspace
;	sta	r0L			; source $1b55 - copies 80 column software mouse mask & image
;	lda	#>bufbackRAM
;	sta	r1H
;	lda	#<bufbackRAM
;	sta	r1L			; dest $5bbf
;	lda	#$01
;	sta	r2H
;	lda	#$98
;	sta	r2L			; xfer $0198 bytes
;	lda	#$01
;	sta	r3H			; $01 - frontRAM (dest)
;	lda	#$00
;	sta	r3L			; $00 - backRAM (src)
;	jsr	MoveBData		; copies backRAM to frontRAM

	lda	#$00			; This is to ensure that the application/DA's custom mouse
	sta	r0H			; pointer is wiped out. Otherwise, the mouse pointer will
;	lda	#$00			; remain active in a geoWizard session!
	sta	r0L
	jsr	SetMousePicture	; zeroes out the mouse

@2:	jsr	i_MoveData		; copies the dialog box buffer
.word dlgBoxRamBuf		; source
.word bufDBSpace			; dest
.word $01a1				; xfer length

	jsr	savClr		; saves Wheels OS color info
	jmp	savREUClr		; stash color info into the reu, at $c000 instead

L48E5:
	jsr	retREUClr		; fetches color info from the REU
	jsr	retClr		; restores Wheels OS color info
	jsr	i_MoveData
.word bufDBSpace			; source
.word dlgBoxRamBuf		; dest
.word $01a1				; xfer length - restore DB buffer space
	lda	cMode
	bmi	@1			; $04
	jmp	retdbBuf		; jmp's into Wheels 64 kernal
@1:	jsr	retdbBuf128		; jmp's into Wheels 128 kernal
	jmp	rtbackRAM		; restore the area in backRAM for Wheels 128.
;	lda	#>bufbackRAM
;	sta	r0H
;	lda	#<bufbackRAM
;	sta	r0L
;	lda	#>brspace
;	sta	r1H
;	lda	#<brspace
;	sta	r1L
;	lda	#$01
;	sta	r2H
;	lda	#$98			; xfer length
;	sta	r2L
;	lda	#$00			; backRAM (dest)
;	sta	r3H
;	lda	#$01			; frontRAM (src)
;	sta	r3L
;	jmp	MoveBData		; restores contents of backRAM - I assume is mouse data

enableIO:
	lda	cMode
	bne	@1
	lda	$01
	sta	cio
	lda	#$35			; enable i/o on GEOS 64
	sta	$01
@1:	rts

enableGEOS:
	lda	cMode
	bne	@1
	lda	cio
	sta	$01			; enable GEOS 64
@1:	rts

getDrvNames:			; gets up to 4 disk drive names
	lda	$BA			; saves CBM Kernal's device number
	pha
	lda	#$00
;	sta	aDiskName		; not really needed as i_FillRam zeroed them out earlier.
;	sta	bDiskName
;	sta	cDiskName
;	sta	dDiskName
	sta	a0L
	lda	#$08			; starting disk dev #
	sta	a0H
	lda	#>aDiskName
	sta	a1H
	lda	#<aDiskName
	sta	a1L

@1:	ldy	a0L
	lda	driveType,y		; checks for existence of a drive
	beq	@2
	lda	a0H			; gets disk device #
	jsr	SetDevice		; sets it up properly
	jsr	OpenDisk		; opens it up
	txa				; check error
	bne	@2
	ldx	#r8
	jsr	GetPtrCurDkNm	; feed disk name into r8
	ldx	#r8
	ldy	#a1
	lda	#r8
	jsr	CopyFString		; copies the disk name into respective buffers
@2:	clc
	lda	a1L
	adc	#$12
	sta	a1L
	lda	a1H
	adc	#$00
	sta	a1H			; cycles through the disk names
	inc	a0H
	inc	a0L
	lda	a0L			; cycles through all four drives
	cmp	#$04
	bcc	@1
	pla				; restores the original drive
	jsr	SetDevice		; and does the honors
	jmp	OpenDisk

chkDNames:
	lda	$BA			; save CBM kernal's drive #
	pha
	lda	#$00
	sta	a0L
	lda	#$08			; start w/ dev #8
	sta	a0H
	lda	#>aDiskName
	sta	a1H
	lda	#<aDiskName
	sta	a1L
@1:	ldy	#$00
	lda	(a1L),y
	beq	@2			; is it empty?
	lda	a0H
	jsr	SetDevice
	jsr	OpenDisk		; opens the disk and compares the disk name
	ldx	#r8
	jsr	GetPtrCurDkNm
	ldx	#r8
	ldy	#a1
	lda	#r8
	jsr	CmpFString
	beq	@2
	jsr	L49F6			; the disk name does not match the stored disk name
	lda	r0L
	cmp	#$01			; is it the OK icon?
	beq	@1
@2:	clc
	lda	a1L
	adc	#$12			; cycle through the disk names (all 4 of them)
	sta	a1L
	lda	a1H
	adc	#$00
	sta	a1H
	inc	a0H
	inc	a0L
	lda	a0L
	cmp	#$04
	bcc	@1
	pla
	jsr	SetDevice		; restore original drive before exiting the routine
	jmp	OpenDisk

L49F6:
	lda	a0L
	clc
	adc	#$41			; ascii the number
	sta	drvLtr
	lda	#>drvName
	sta	r0H
	lda	#<drvName
	sta	r0L
	ldx	#a1
	ldy	#r0
	lda	#r7
	jsr	CopyFString		; copies string pointed by a1 to r7
	lda	#$00
	sta	drvName+16		; null terminate it
	lda	#>dbInsDisk
	sta	r0H
	lda	#<dbInsDisk
	sta	r0L
	jmp	DoRcvrBox		; warns the user about wrong disk name

saveIO:				; preserves i/o registers
	jsr	enableIO		; for GEOS 64
;	lda	scroly		; disable this as it may interfere with badlines,
;	sta	cscroly		; needed for correct operation by Wheels OS disk drivers.
	lda	spena
	sta	cspena
	lda	vmcsb
	sta	cvmcsb
;	lda	ci2pra		; disable this to make sure Wheels OS disk drivers
;	and	#$03			; are not interfered with.
;	sta	cci2pra
	jmp	enableGEOS

restoreIO:
	jsr	enableIO		; for GEOS 64
;	lda	ci2pra
;	and	#$FC
;	ora	cci2pra
;	sta	ci2pra
	lda	cvmcsb
	sta	vmcsb
	lda	cspena
	sta	spena
;	lda	cscroly
;	sta	scroly
	jmp	enableGEOS

genericCDB:				; generic DB w/ CANCEL icon in addition
	lda	#$02			; CANCEL
.byte $2c				; BIT opcode
genericDB:				; issues a generic DB w/ variable text & OK icon
	lda	#$00			; NULL
	sta	pl1			; to eliminate the CANCEL option of the DB
	stx	r5H
	sty	r5L			; pass text pointer for the DBVARSTR function
	LoadW	r0, dbGenOK		; loads r0 w/ db table
	jmp	DoRcvrBox		; issues DB & exits

setMargin:				; allows text to be formatted in dialog boxes
	lda	cMode			; check computer
	bmi	@1
;	lda	#$00			; Wheels 64
.byte $2c				; BIT opcode
@1:	lda	#$80
	sta	leftMargin+1
	lda	#$50			; set margin
	sta	leftMargin
	rts

dbGenOK:				; generic DB w/ text & OK icon
.byte $81				; default DB params
.byte DB_USR_ROUT
.word setMargin			; needed to reformat text in dialog boxes
.byte DBVARSTR
.byte $10,$10			; x/y position
.byte r5				; for now
.byte OK
.byte $01,$48			; x/y position
pl1:					; to wedge in a CANCEL icon, if needed.
.byte NULL				; or CANCEL, if needed.
.byte $11,$48
.byte NULL

tCpyright:				; text pointer for geoWizard copyright notice
.byte $1A,$18

;.byte "GEOWIZARD!"
.byte "WheelWIZARD!"
.byte $1B
.byte $16,$91
bd1:
.byte $00,$09			; sounds like gotoxy
.byte $18

.byte "Copyright (C) 1990, Jim Collette"
.byte $16,$01
bd2:
.byte $00,$13

.byte "Click to exit"
.byte $14,$5f
bd3:
.byte $00,$80

.byte "L - Load a Program"
.byte $14,$E3
bd4:
.byte $00,$80

.byte "D - Load a DA"
.byte $16,$01
bd5:
.byte $00,$1C
.byte $80

.byte "P - Screen Dump"
.byte $14,$71
bd6:
.byte $00,$80

.byte "Q - Quit to DeskTop"
.byte $14,$F6
bd7:
.byte $00
; .byte $80 - C= logo (shortcut)
;.asciiz "R - Reboot"
.asciiz "(c) 2005 TSE"

itDummy:				; dummy icon table
.byte $01				; one icon
.byte $a0
bd8:
.byte $00				; mouse xpos
.byte $64				; mouse ypos
.word $0000				; pointer to icon data
.byte $00,$00			; x/y pos of icon
.byte $01,$01			; width/height of icon
.word exitgeoWiz			; service routine

;tDestroy:				; text
;.byte $18
;
;.byte "This will destroy the program", 13
;
;.byte "in RAM and data may be lost.", 13
;
;.byte "Any open files may be trashed.", 13
;
;.byte "Sure you want to do this?"
;.byte $1B,$00

tProg:				; text
.byte $18

.byte "This program cannot be", 13

.byte "run in this video mode.", 13

.byte "Switch video mode?"
.byte $1B,$00

tCannot:				; text
.byte $18

.byte "This program cannot be", 13

.byte "run under GEOS 128."
.byte $1B,$00

tNewDsk:				; text
.byte $18

.byte "Insert new disk into drive."
.byte $1B,$00

tNoDA:				; text
.byte $18

.byte "Can't load this DA."
.byte $1B,$00

tOnDisk:				; text
.byte $18

.byte "On disk:"
.byte $1B,$00

;dbNoPrint:				; dialog box table
;.byte $81				; default
;.byte DBTXTSTR
;.byte $10,$10
;.word tNoPrint
;.byte DBTXTSTR
;.byte $10,$20
;.word PrntFilename
;.byte OK
;.byte $01,$48
;.byte NULL
;
;tNoPrint:				; text
;.byte $18
;.asciiz "Couldn't find printer driver:"

runDA:				; runs a DA
	pla
	sta	retAddr
	pla
	sta	retAddr+1		; saves the return address
	tsx
	stx	retSPtr		; saves the stack pointer
;	jsr	L55A6			; saves a memory region (dropped.)
	jmp	L55F3			; executes the loading/running of the DA

L5187:
;	jsr	L55B0			; restores a memory region (dropped.)
	ldx	retSPtr
	txs				; restore stack pointer and return address
	lda	retAddr+1
	pha
	lda	retAddr
	pha
	rts

dbDskErr:				; error message db
.byte $81				; default
.byte OK
.byte $11,$48
.byte DBTXTSTR
.byte $10,$10
.word tErrMsg
.byte DBTXTSTR
.byte $10,$20
.word diskErrNum
.byte NULL

tErrMsg:				; text
.byte $18

.byte "Disk Error:"
.byte $1B,$00

dbInsDisk:				; db table urging user to insert disk
.byte $81				; default db
.byte DBTXTSTR
.byte $10,$10
.word tInsDisk
.byte DBTXTSTR
.byte $10,$20
.word drvName
.byte DBTXTSTR
.byte $10,$30
.word tDrve
.byte OK
.byte $01,$48
.byte CANCEL
.byte $11,$48
.byte NULL

tInsDisk:				; text
.byte $18
.asciiz "Please insert disk:"

tDrve:				; text

.byte "In Drive "

drvLtr:

.byte "A."
.byte $1B,$00

L53E5:
	stx	l587C
	lda	l587C
	sta	r15L
	lda	#$00
	sta	r15H
	lda	#$00
	sta	r2H
	lda	#$0A
	sta	r2L
	ldx	#r15
	ldy	#r2
	jsr	Ddiv
;	lda	#$18			; BOLD attribute?
;	sta	diskErrNum
;	lda	#$3A			; ':'
;	sta	diskErrNum+2
;	lda	#$49			; 'I'
;	sta	diskErrNum+1
	ldy	#$03			; place beyond the 'I:' char sequence
	lda	r15L
	beq	@1
	ora	#$30
	sta	diskErrNum,y	; inserts an ASCII number
	iny
@1:	lda	r8L
	ora	#$30
	sta	diskErrNum,y	; up to two digits accuracy
	iny
	lda	#$1B			; PLAINTEXT attribute?
	sta	diskErrNum,y
	iny
	lda	#$00			; NULL-terminate the string.
	sta	diskErrNum,y
	lda	#>dbDskErr
	sta	r0H
	lda	#<dbDskErr
	sta	r0L
	jmp	DoRcvrBox		; issues a disk error db

.include "4drives.asm"

fileReq:					; routine to OPEN an app/da/auto_exec
	jsr	setup4DB			; Init the drive table entries
	LoadW	r0, dbOpen
	jsr	Drv4DB			; issues the DB
	lda	r0L
	cmp	#$02				; did the user CANCEL?
	beq	@7
	cmp	#$06
	bne	@1				; did the user click on the DISK selection?
	jsr	changeDisk			; handle the disk change
	bra	fileReq
@1:	cmp	#$05				; did the user click on the OPEN icon?
	beq	@5				; otherwise, a drive icon was clicked on.
	jsr	changeDevice		; issues the device change
	bra	fileReq
@7:	clc
	rts
@5:	sec
	rts

dblAddr:					; bitmap doubles certain addresses
	lda	c128Flag
	beq	@2				; do nothing in GEOS 64
	lda	#$7F
	ora	graphMode
	sta	r15L
	ldy	#$00
@1:	lda	(r0L),y
	sta	r1L
	iny
	lda	(r0L),y
	beq	@2				; seems to 'bitmap double' the addresses
	sta	r1H
	iny
	ldx	#$00
	lda	($04,x)			; r1L
	ora	graphMode
	and	r15L
	sta	($04,x)			; r1L
	clv
	bvc	@1
@2:	rts

;L55A6:
;	jsr	i_MoveData
;.word l7f40				; src
;.word l588f				; dest
;.word $00C0				; xfer length
;	rts

;L55B0:
;	jsr	i_MoveData
;.word l588f				; src
;.word l7f40				; dest
;.word $00C0				; xfer length
;	rts

retMDRegs:				; set MoveData regs for EnterDT/RstrAppl upon return
	lda	RstrAppl+2		; Makes the RstrAppl as destination
	ldx	RstrAppl+1
	stx	r1L			; .A = high byte, .X = lo byte
	sta	r1H
	lda	#>bufDT
	sta	r0H
	lda	#<bufDT		; src
	sta	r0L
here:
	lda	#<(L43E0-DeskTopCode)
	sta	r2L
	lda	#>(L43E0-DeskTopCode)
	sta	r2H			; (Seems OK.)
	jmp	MoveData

setMDRegs:				; set MoveData regs for EnterDeskTop/RstrAppl
					; .A = hi byte, .X = lo byte
	pha				; save high byte of EnterDeskTop/RstrAppl addy
	stx	r0L
	sta	r0H			; EnterDeskTop/RstrAppl code is source
	lda	#>bufDT
	sta	r1H
	lda	#<bufDT		; dest
	sta	r1L
	jsr	here
	lda	#>DeskTopCode
	sta	r0H
	lda	#<DeskTopCode
	sta	r0L
	pla				; r1 points to EnterDeskTop/RstrAppl address
	sta	r1H
	stx	r1L
	jmp	MoveData		; r2 is already preserved in between MoveData calls

L55F3:				; loads/executes a DA
	jsr	fileReq		; prompts the user for the DA via a dialog box
	bcs	@6
	jmp	L5187			; otherwise, exit the runDA option

@6:	lda	#>l578d
	sta	appDA+2		; modify the appDA exit routine
	lda	#<l578d
	sta	appDA+1
	lda	RstrAppl+2		; preserve RstrAppl code
	ldx	RstrAppl+1		; RstrAppl code is source
	jsr	setMDRegs

	lda	#>appFName
	sta	r6H
	lda	#<appFName
	sta	r6L
	jsr	FindFile		; finds the DA
	lda	dirEntryBuf+1
	sta	a3L
	lda	dirEntryBuf+2
	sta	a3H			; save t/s
	lda	#>dirEntryBuf
	sta	r9H
	lda	#<dirEntryBuf
	sta	r9L
	jsr	GetFHdrInfo		; gets its file header

	lda	fileHeader+76	; initialization address of DA
	sta	exeDA+1
	lda	fileHeader+75
	sta	exeDA			; for the indirect JMP call to execute DA

	lda	curDrive
	sta	l7f55			; preserves current drive

	jsr	i_MoveData
.word l5722
.word l8b05				; stashes code within sprite #4
.word l578d-l5722

	jsr	savClr		; saves current color info
	jsr	savScreens		; saves the fg/bg screens under GEOS 128
	lda	cVideo
	bpl	@1			; take branch in 40 column mode
	jsr	setScrRectangle	; if it is 80 columns, need to save it.
	jsr	ImprintRectangle	; saves the visible rectangle area to the background screen.
	jsr	savGWScreen		; saves the geoWizard VDC screen
@1:	jmp	l8b05			; continues w/ code recently moved to $8b05 ($5722)

L5620:				; move this out of the way
	ldx	#>tNoDA		; warns user in error of loading DA
	ldy	#<tNoDA
	jsr	genericDB		; issue generic DB w/ OK icon
	jmp	L55F3			; go back to the file requestor again

l5722:
	MoveW	a3, r1		; copies the t/s info to r1
	lda	fileHeader+70
	cmp	#$01			; is the DA a VLIR file?
	bne	@1
	ldy	#$01
	lda	(r9L),y
	sta	r1L
	iny
	lda	(r9L),y
	sta	r1H			; get the VLIR index block
	jsr	L903C			; goes directly to disk driver code - NO NO!
	txa				; I assume this is the GetBlock call
	bne	@2			; branch on disk error
	ldx	#$08
	lda	diskBlkBuf+2
	sta	r1L
	beq	@2
	lda	diskBlkBuf+3
	sta	r1H			; r1 points to first t/s of vlir #$00 of the DA
@1:	lda	#$FF			; if not VLIR, r1 isn't preserved!
	sta	r2L
	sta	r2H			; up to $ffff bytes to load - r7 supplied by GetFHdrInfo
	lda	fileHeader+72
	sta	r7H
	lda	fileHeader+71
	sta	r7L			; load address of DA
	jsr	ReadFile		; reads in VLIR #$00 of the DA into address pointed by r7
	lda	c128Flag		; bring this code into main body of geoWizard?
	bmi	@3
	jsr	setdbBuf		; sets up the DB space, which is also used by DA's
	clv
	bvc	@4
@3:	jsr	setdbBuf128		; sets up the DB space, also used by DA's, for Wheels 128
@4:	jmp	(exeDA)		; executes the DA via the indirect JMP!

@2:	txa
	jsr	L53E5			; not sure
	jmp	L55F3			; repeats the DA loading/excuting loop

l578d:				; used by the exiting DA
	lda	l7f55
	jsr	SetDevice
	jsr	retMDRegs		; restore RstrAppl code
	lda	c128Flag
	bmi	@2
	jsr	retdbBuf		; restores the DB buffers under Wheels 64
	clv
	bvc	@5
@2:	jsr	retdbBuf128		; restores the DB buffers under Wheels 128
@5:	lda	cVideo
	bpl	@1			; take branch in 40 column mode
	jsr	retGWScreen		; fetches geoWizard's VDC screen from the REU
	jsr	setScrRectangle	; sets up a 80 column rectangle
	jsr	RecoverRectangle	; recovers the VDC screen

@1:	jsr	retScreens		; restores the screens & 1st 32Kb of the REU
	jsr	retClr		; restores the color info for geoWizard
	jmp	L5187			; restores the stack, etc. and exits back to geoWizard loop

retClr:				; restores color info
	clc
	bcc	savClr+1		; relative JMP
savClr:				; saves color info
	sec
	php				; save carry flag info
	jsr	setScrRectangle
	jsr	ConvToCards		; use Wheels OS routines
	LoadW	r0, clrCards	; set up a buffer for the color info
	plp
	bcc	@1
	jmp	SaveColor
@1:	jmp	RstrColor

savREUClr:				; saves the color info to the REU
	ldy	#$90
.byte $2c				; BIT opcode
retREUClr:				; fetches the color info from the REU
	ldy	#$91			; FetchRAM
	lda	#>clrCards
	sta	r0H
	lda	#<clrCards
	sta	r0L
	sta	r1L
	sta	r2L
	lda	#$d1			; $d100 on the REU side
	sta	r1H
	lda	#$08
	sta	r2H			; $0800 on xfer length
	lda	reuBank
	sta	r3L
	jmp	DoRAMOp		; stores/fetches color info from the reu, at $c000 instead

DoRcvrBox:
	jsr	ColorDB
	jmp	DoDlgBox

ColorDB:
	lda	#$ff
	sta	a2H			; set flag
	MoveW	RecoverVector,saveRecVec
	LoadW	RecoverVector, RstrDB
	lda	appDBColor
.byte $2c				; BIT opcode
RstrDB:
	lda	#$bf			; greyish color
	sta	a2L
	ldx	#31
@10:	lda	r0,x
	pha
	dex
	bpl	@10
	jsr	LdDBCoords
	jsr	ConvToCards
	MoveB	a2L, r4H
	jsr	ColorRectangle
	lda	cVideo
	bpl	@3
	dec	r1L			; for the 80 column screen
@3:	dec	r1L			; recolorize the DB by one card offset
	dec	r1H			; to accomplish the 'shadowing' effect of the DB
	jsr	ColorRectangle
	ldx	#0
@50:	pla
	sta	r0,x
	inx
	cpx	#32
	bcc	@50
	inc	a2H			; test the flag
	bne	@2			; if non-zero, go through the restoration process
	rts

@2:	MoveW	saveRecVec,RecoverVector
	jmp	(RecoverVector)	; and goes through the normal RecoverVector process

LdDBCoords:
	LoadB	r2L, DEF_DB_TOP+8		; add one here for the custom imprint/recover
	LoadB	r2H, DEF_DB_BOT+1		; routines.
	LoadW	r3,  $0048			; DEF_DB_LEFT(+8?)
	LoadW	r4,  $0100			; DEF_DB_RIGHT+1	; ditto here
	bit	cVideo			; check video mode
	bpl	@1
	asl	r3L				; the custom imprint/recover routines do not handle
	asl	r4H				; bitmap doubling yet.
	lda	#$08
	sta	r4L
@1:	rts

goMono:				; go monochrome mode
	jsr	ConvToCards
	lda	#$bf			; set the color to grey-ish
	sta	r4H
	jmp	ColorRectangle	; and colorizes the screen, 40/80 column modes

svbackRAM:				; saves $1300-$7fff in backRAM to the REU. (Wheels 128 only.)
	lda	#$00
	sta	r15L			; starting REU address @ $0000
	sta	r0L
	sta	r1L
	sta	r2L
	lda	#>brspace		; source $1300
	sta	r15H			; and save a copy
	lda	#$01
	sta	r2H			; xfer 256 bytes

@1:	lda	r15H			; get backRAM space address
	sta	r0H
	lda	#>xferarea		; destination $3f00
	sta	r1H
	ldy	#$01			; get destination bank
	sty	r3H			; $01 - frontRAM (dest)
	dey
	sty	r3L			; $00 - backRAM (src)
	jsr	MoveBData		; copies backRAM to frontRAM

	lda	#>xferarea		; loads r0 w/ $3f00
	sta	r0H
	lda	r15L			; get REU address
	sta	r1H
	ldx	reuBank		; get REU bank #
	inx
	inx				; use a *third* bank of the REU!
	stx	r3L
	jsr	StashRAM		; and saves the backRAM space
	inc	r15L			; increment REU address
	inc	r15H			; get next page in backRAM
	bpl	@1			; take branch until we're done with $1300-$7fff
	rts

rtbackRAM:				; restores backRAM contents @ $1300-$7fff from the REU
	lda	#>brspace		; $1300 destination in backRAM
	sta	r15H
	lda	#>xferarea		; loads r0 w/ $3f00
	sta	r0H
	lda	#$01			; length 256 bytes to transfer at a time.
	sta	r2H
	lda	#$00
	sta	r15L
	sta	r0L
	sta	r1L
	sta	r2L
@1:	lda	r15L			; get REU address
	sta	r1H
	ldx	reuBank		; get REU bank #
	inx
	inx				; use a *third* bank of the REU!
	stx	r3L
	jsr	FetchRAM		; and restores the backRAM space
	inc	r15L			; increment REU address

	lda	r15H			; get backRAM address
	sta	r1H
	ldy	#$00			; backRAM (dest)
	sty	r3H
	iny
	sty	r3L			; frontRAM (src)
	jsr	MoveBData		; restores contents of backRAM
	inc	r15H			; get next backRAM page
	bpl	@1			; are we done yet (finish at $7fff)
	rts

cMode:
.byte $00				; $00 = GEOS 64 - $ff = GEOS 128
cVideo:				; $00 = 40 col - $ff = 80 col
.byte $00
diskErrNum:				; contains the ASCII string representation for disk error number.
.byte $18,$49,$3a			; BOLD, 'I:' text.

.bss					; $57e7
.res 4				; part of diskErrNum
saveRecVec:				; contains original recoverVector address
.res 2
eDTop:
.res 2				; holds original EnterDeskTop address
cvdc:					; copy of vdcClrMode
.res 1
return:				; holds the return address for geoWizard
.res 2
stackPtr:
.res 1				; holds the previous stack pointer
retSPtr:				; holds the stack pointer
.res 1
retAddr:				; holds the return address
.res 2
copyVideo:				; holds the operating video mode
.res 1
ccurDrive:				; holds the current drive
.res 1
cscroly:				; holds the scroly register value
.res 1
cspena:				; holds the sprite enable register value
.res 1
cvmcsb:				; holds the vmcsb register value
.res 1
cci2pra:				; holds the ci2pra register value
.res 1
;cnumDrives:			; holds the # of drives available
;.res 1
cturboFlags:			; holds copy of turbo flags used by the GEOS kernal
.res 4
cio:					; copy of GEOS 64 i/o value
.res 1
appFName:				; application/autoexec filename
.res 17
diskName:				; name of disk/partition
.res 17
drvName:				; name of drive - same as diskName?
.res 18
aDiskName:				; name of drive X
.res 18
bDiskName:
.res 18
cDiskName:
.res 18
dDiskName:
.res 18
DAName:				; desk accessory filename
.res 17
l587C:				; unknown buffer
.res 5
pstkptr:				; contains previous stack pointer
.res 1
prevstk:				; contains previous stack value
.res 1
l7f55:				; contains disk device #
.res 1
;l588f:				; unknown buffer (not needed, I guess.)
;.res 384
bufDBSpace:				; buffer holding dialog box space
.res 432
;bufbackRAM:			; buffer holding backRAM contents
;.res 408				; can it be 256 bytes?
indCall:				; holds the indirect JMP call
.res 5				; only need 3 bytes to hold this value?
bufDT:				; buffer holding EnterDeskTop code
.res (L43E0-DeskTopCode)	; shouldn't it be 32?
bufZP:				; buffer holding zp region
.res 248
bufStack:				; buffer holding the stack ($5e59)
.res 256
clrCards:
.res 2000				; reserve 2000 bytes of color info.
					; only have room for 40 column screen.
