; geoWizard VLIR #$00 Source Code
; Modded for Wheels OS Usage
; Disassembly/Source Copyright (c) 2004 by Todd Elliott

.out "Source Code (c) 2004 by Todd S. Elliott"

.include "../include/geos/geossym.inc"
.include "../include/geos/geossym2.inc"
.include "../include/geos/diskdrv.inc"
.include "../include/geos/inputdrv.inc"
.include "../include/geos/jumptab.inc"
.include "../include/geos/const.inc"
.include "../include/geos/geosmac.ca65.inc"
.include "../include/geos/wheelsym.inc"
.include "../include/geos/cbmarch.inc"

gWizMod		= $4000	; load address of geowizard's VLIR #$01 module
PVec			= $84af	; Panic Vector
;L4003		= $4003
;M128Loop		= $9d83	; location of GEOS 128 Main Loop
;M64Loop		= $c0df	; location of GEOS 64 Main Loop
;gWiz128Code	= $bfb0	; wrong location - should be in the stack, at $0100
;gWiz64Code		= $f914	; ditto for 64 mode - should be in stack area at $0100
;gWizSMod		= $9f0d	; start address for the GW Switcher code
;gWizCode		= gWizSMod+7; execute address for geoWizard Switcher code

; start address $0400
;	ldy	#$00
;	sty	cMode			; default Wheels 64 mode
	lda	version		; check GEOS version
	cmp	#$41			; is it Wheels?
	bcc	@2			; above v2.0?
	lda	driverVersion	; check disk device drivers
	cmp	#$52			; is it Wheels?
	bcc	@2
	ldy	c128Flag
	bpl	@1
	lda	#$FF
	sta	cMode			; notify geoWizard about Wheels 128
	ldy	graphMode		; get 40/80 column info
@1:	sty	cVideo
	bra	@3

@2:	ldx	#>tReqWheels	; requires Wheels OS
	ldy	#<tReqWheels
	jmp	exitGWiz		; issues generic DB and exits to Dashboard
;	jsr	genericDB		; issues a generic DB w/ OK icon
;	jmp	EnterDeskTop	; and exits to Dashboard

@3:	bit	cVideo
	bpl	@4			; compensate for 40/80 column usage
	lda	#$7f
	sta	bd0
	lda	#$02			; $027F for Wheels 128
	sta	bd0+1
	lda	#$a0
	sta	bd1
	inc	bd2+1
	lda	#$89
	sta	bd3
	lda	#$96
	sta	bd4			; and we're done bitmap doubling
@4:	jsr	i_GraphicsString
.byte $05				; NEWPATTERN
.byte $02				; pattern
.byte $01				; MOVEPENTO
.word $0000				; xpos
.byte $00				; ypos
.byte $03				; RECTANGLETO
bd0:
.word $013F				; xpos
.byte $C7				; ypos
.byte $05				; NEWPATTERN
.byte $01				; pattern
.byte $01				; MOVEPENTO
bd1:
.word $0050				; xpos
.byte $96				; ypos
.byte $03				; RECTANGLETO
bd2:
.word $00FF				; xpos
.byte $C5				; ypos
.byte NULL

	jsr	i_BitmapUp
.word bmpGW
bd3:
.byte $09				; xpos
.byte $8E				; ypos
bd4:
.byte $16				; width
.byte $30				; height

;	jsr	L0AD3			; checks autoexec mode & saves $5000-$5fff if needed.
	jsr	checkRAM		; detects expansion RAM and ensures that geoWizard
	sty	reuPart		; save partition #
	bcc	@1			; is VLIR #$01 already in the REU?
;	jmp	splashDB		; if it is, skip loading in VLIR #$01 of geoWizard
	jmp	patchWKrnl		; patch Wheels kernal

@1:	lda	#>nBuffer
	sta	r6H
	lda	#<nBuffer
	sta	r6L
	lda	#$0E			; AUTO_EXEC
	sta	r7L
	lda	#$01			; 1 filename returned
	sta	r7H
	lda	#>permName
	sta	r10H
	lda	#<permName
	sta	r10L
	jsr	FindFTypes		; find geoWizard itself
	txa
	beq	@5
	jmp	EnterDeskTop	; disk error - abort to deskTop
@5:	lda	#>nBuffer
	sta	r0H
	lda	#<nBuffer
	sta	r0L
	jsr	OpenRecordFile
	lda	#$01			; open up VLIR #$01 of geoWizard
	jsr	PointRecord
	lda	#>gWizMod
	sta	r7H
	lda	#<gWizMod
	sta	r7L
	lda	#$10
	sta	r2H
	lda	#$00			; load in up to $1000 bytes worth
	sta	r2L
	jsr	ReadRecord		; and read in the VLIR #$01 module
	txa
	pha
	jsr	CloseRecordFile
	pla
	cmp	#$0B			; trap the Buffer Overflow error
	bne	patchWOS		; relative JMP

	ldx	#>tResMod
	ldy	#<tResMod		; warn user about VLIR #$01 module error
exitGWiz:
	jsr	genericDB
;	jsr	L0B08			; finds autoexec mode and restores $5000-$5fff if needed.
	jmp	EnterDeskTop

patchWOS:
;	lda	MainLoop+1
;	sta	gWizMod
;	lda	MainLoop+2		; get correct address of Wheels OS MainLoop
;	sta	gWizMod+1		; necessary?
	lda	#>gWizMod
	sta	r0H
	sta	r1H
	lda	#<gWizMod
	sta	r0L			; source/dest same address - $4000 for CPU/REU
	sta	r1L
	sta	r2L
	lda	#$20			; copy $2000 bytes to the REU
	sta	r2H
	lda	reuBank		; get REU bank byte
	sta	gWizMod+2		; copy the REU bank byte onto the geoWizard module as well
	sta	r3L
	jsr	StashRAM		; stash geoWizard module #$01 into the REU
;	jmp	patchG128		; patch Wheels OS Kernal

; hold the following wedge code as they may be needed later
;	lda	#>nBuffer
;	sta	r6H
;	lda	#<nBuffer
;	sta	r6L
;	jsr	FindFile		; find geoWizard all over again.
;	lda	#>dirEntryBuf
;	sta	r9H
;	lda	#<dirEntryBuf
;	sta	r9L
;	jsr	GetFHdrInfo		; and get its file header
;	lda	fileHeader+160
;	cmp	#$2A			; is it the asterisk?
;	bne	@2
;	lda	fileHeader+161	; check mouse/joystick mode
;	ora	#$20			; force uppercase
;	cmp	#$6A			; is it 'J'?
;	bne	@2
;	lda	#$00			; joystick mode
;	sta	clickMode
;@2:	lda	cMode
;	bmi	patchG128		; take branch in 128 mode
;	jmp	patchG64		; otherwise handle 64 mode

patchWKrnl:				; for Wheels OS
;	lda	clickMode
;	bne	@3
;	jmp	L05C3			; handle joystick mode
	clc
	lda	MainLoop+1
	sta	r15L
	adc	#$03
	sta	eM64Switcher-2	; patch geoWizard 64's switcher
	sta	eMSwitcher-2	; patch geoWizard 128's switcher
	lda	MainLoop+2		; get correct address of Wheels OS MainLoop
	sta	r15H
	adc	#$00			; add PC counter offset of 3 to the address
	sta	eM64Switcher-1	; so that geoWizard 64 can switch to MainLoop
	sta	eMSwitcher-1	; so that geoWizard 128 can switch to MainLoop
	ldy	#$00
	lda	(r15),y		; check for the bit opcode
	cmp	#$2c			; BIT opcode
	beq	@1			; take branch in order to wedge geoWizard
	jmp	splashDB		; need to warn user that it hasn't been wedged in

@1:	php
	sei
	clc
	lda	#$4c			; JMP opcode
	sta	(r15),y
	iny
	lda	Panic+1		; get the Panic JMP vector lobyte
	sta	eM64Switcher-23	; for geoWizard 64 to find its REU info
	sta	eMSwitcher-23	; for geoWizard 128 to find its REU info
	sta	r0L			; for the MoveData below (source)
	adc	#$07			; get an offset of $07 to skip the REU info
;	lda	#<gWizCode
	sta	(r15),y
	iny
	lda	Panic+2		; get the Panic JMP vector hibyte
	sta	eM64Switcher-22	; for geoWizard 64 to find its REU info
	sta	eMSwitcher-22	; for geoWizard 128 to find its REU info
	sta	r0H			; for the MoveData below (source)
	adc	#$00			; get an offset of $07 to skip the REU info
;	lda	#>gWizCode
	sta	(r15),y		; wedge in geoWizard into Wheels OS MainLoop	
;	plp

	LoadW	r1, panicbuf	; dest address
	bit	cMode			; test for Wheels 128
	bpl	@2			; take branch for Wheels 64
	lda	#(eMSwitcher-GWMSwitcher); length - Wheels 128
.byte $2c				; BIT opcode
@2:	lda	#(eM64Switcher-GW64MSwitcher); length - Wheels 64
	sta	r2L
	lda	#$00
	sta	r2H
	jsr	MoveData		; preserve the Panic routine should the user 'uninstall'

	lda	reuBank
	sta	GWMSwitcher+6	; add reu bank onto the switcher code, too (geoWizard 128)
	sta	GW64MSwitcher+6	; for geoWizard 64
	MoveW	r0, r1		; makes the Panic routine as the destination, not the source
	bit	cMode			; test for Wheels 128
	bpl	@3			; take branch for Wheels 64
	LoadW	r0, GWMSwitcher	; the geoWizard 128 switcher as source now
	bra	@4
@3:	LoadW	r0, GW64MSwitcher	; the geoWizard 64 switcher as source now.
@4:	jsr	MoveData		; and overwrite the appropriate Panic routine with the
					; geoWizard 64/128 switcher code
	LoadW	PVec, EnterDeskTop; load the Panic Vector with EnterDeskTop
	plp
;	jsr	i_MoveData		; moves the geoWizard activator code to a 'safe' location
;.word GWMSwitcher
;.word gWizSMod			; could be either $cef0/$c985 (64/128) - initially was $0100
;.word eMSwitcher-GWMSwitcher	; $0062 or $003b

;	lda	#>gWizSMod		; necessary? - will it be overwritten?!?
;	sta	r0H
;	sta	r1H
;	lda	#<gWizSMod
;	sta	r0L
;	sta	r1L
;	lda	#<(eMSwitcher-GWMSwitcher)
;	sta	r2L			; move only $0062 bytes
;	lda	#>(eMSwitcher-GWMSwitcher)
;	sta	r2H
;	lda	reuBank
;	sta	gWizCode-1		; add reu bank onto the switcher code, too
;	sta	r3L			; use correct REU bank byte
;	jsr	StashRAM		; and stash the geoWizard activation code into the REU
	jmp	splashDB

;patchG64:				; for GEOS 64 operation
;	lda	#$BF
;	sta	$F568
;	lda	#$58
;	sta	$F567			; no idea what this is.
;	cli
;	jmp	splashDB

GWMSwitcher:			; the actual switcher (mouse) code used by geoWizard
.incbin "gwswitcher.bin"
eMSwitcher:				; end address of switcher (mouse) code used by geoWizard

GW64MSwitcher:			; the actual switcher (mouse) code used by geoWizard
.incbin "gw64switcher.bin"	; for Wheels 64 usage
eM64Switcher:			; end address of switcher (mouse) code used by geoWizard

;gWizJSwitcher:			; geoWizard Switcher Activator (joystick) code
;	lda	mouseData
;	bmi	@1
;	lda	keyData
;	cmp	#$14
;	bne	@1
;	lda	#$00
;	sta	keyData
;	php
;	sei
;	ldy	#$06
;@2:	lda	$BFE2,y		; get preset REU information for swapping in VLIR #$01
;	sta	r0L,y
;	dey
;	bpl	@2
;	jsr	SwapRAM
;	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
;	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
;	plp
;	lda	r5L			; must have been passed on by VLIR #$01
;	beq	@1
;	jmp	(r4L)			; passed via VLIR #$01
;
;@1:	.byte	$4C			; JMP opcode
;MLJReEntry:
;.word $c0dd				; GEOS 128 MainLoop re-entry address
;
;.byte $00,$40,$00,$40,$00,$20	; actually $bfe2
;reuJBank:
;.byte $0F

;Wiz64JSwitcher:			; GEOS 64/geoWizard Switcher Activator code (joystick)
;	lda	mouseData
;	bmi	L08AA
;	lda	keyData
;	cmp	#$14
;	bne	L08AA
;	lda	#$00
;	sta	keyData
;	php
;	sei
;	ldy	#$06
;@1:	lda	$F949,y		; get preset REU information for swapping in VLIR #$01
;	sta	r0L,y
;	dey
;	bpl	@1
;	jsr	SwapRAM
;	jsr	L4003			; executes code in VLIR #$01 of geoWizard itself.
;	jsr	SwapRAM		; restores RAM underneath $4000-$5fff
;	plp
;	lda	r5L			; must have been passed on by VLIR #$01
;	beq	L08AA
;	jmp	(r4L)			; passed via VLIR #$01
;
;L08AA:
;.byte $20				; JSR opcode
;ML64JReEntry:			; for GEOS 64 MainLoop re-entry
;.word $fa56
;	jmp	$c0e2
;
;.byte $00,$40,$00,$40,$00,$20	; actually $f949
;reu64JBank:
;.byte $0F

splashDB:				; displays the successful splash DB
	lda	firstBoot		; are we into booting sequence?
	beq	@3			; was @1
;	jmp	enterDeskTop	; exit cleanly w/o db displayer

;@1:	lda	clickMode
;	bne	@2
;	lda	#>tLeftArrow
;	sta	L0CB6+1
;	lda	#<tLeftArrow	; self-modify the DB table to point to joystick mode
;	sta	L0CB6			; in the text prompt
@2:	lda	#>dbSplash
	sta	r0H
	lda	#<dbSplash
	sta	r0L
	jsr	DoDlgBox		; displays that geoWizard has been installed!
	lda	r0L
	cmp	#$75			; for the uninstallation
	bne	@3
	jsr	freeRAM		; frees up geoWizard from the REU device
@3:	jmp	EnterDeskTop	; finally exit geoWizard

checkRAM:				; rewrite this routine for Wheels OS usage!
	jsr	IsBankAssigned	; is geoWizard already in expansion RAM?
					; if it is already in expansion RAM
	beq	@1			; branch if it not in expansion RAM
	pha
	jsr	RstrKernal		; restores the GEOS Kernal @ $5000
	pla				; preserve the .A register
	sec
	bcs	@2			; relative JMP

;	lda	#(0 | 64)
;	jsr	GetNewKernal
@1:	jsr	GetRAMBam		; load in expansion RAM BAM
	lda	c128Flag		; checks to see if 192Kb of expansion RAM need to be allocated
	bpl	@3			; for Wheels 128.
	lda	#$03			; allocate 192Kb of expansion RAM (Wheels 128)
.byte $2c				; BIT opcode
@3:	lda	#$02			; allocate 128Kb of expansion RAM (Wheels 64)
	sta	r2L
	LoadB	r7L, $11		;ID number, can be anything less than 128.
					;(only ramdisks can have 128 and higher ID numbers)
	LoadW	r0, permName	;point to a partition name.
	ldy	#$00			;don't care which partition...
	sty	r3L			;or bank to use.
	jsr	SvRamDevice		;allocate a bank and partition.
	sty	r15L			; preserve partition #
	jsr	PutRAMBam		; write the expansion RAM BAM
	jsr	RstrKernal
	txa				;was a bank and partition available?
	bne	@9			;branch if not.
	ldy	r15L			; get partition #
	lda	r3L			; get available RAM bank
	clc				; It is now installed in expansion RAM

@2:	sta	reuBank
	rts

@9:	pla
	pla				; clean up the stack
	ldx	#>tReqRAM
	ldy	#<tReqRAM
	jmp	exitGWiz		; issues a message in a DB w/ an OK icon

IsBankAssigned:
	lda	#(0 | 64)
	jsr	GetNewKernal	; is this legal in autoexec mode?
	ldy	#1			; partition number
@1:	jsr	RamDevInfo
	lda	r3L			;is this partition in use?
	beq	@7			;branch if not.
	lda	r7L
	cmp	#$11			;does this partition have our ID number?
	bne	@7			;branch if not.
	sty	r15H			; save .Y
	LoadW	r0, permName	; use geoWizard's permanent name string
	ldx	#r0
	ldy	#r1
	jsr	CmpString		;check the partition name.
	bne	@7			;branch if not "geoWizard"
	ldy	r15H			; retrieve partition #
;	jsr	RstrKernal
	lda	r3L			;exit holding the bank number.
	rts
@7:	iny
	cpy	#9			;check all 8 partitions.
	bcc	@1
;	jsr	RstrKernal
	lda	#0
	rts

freeRAM:
	lda	MainLoop+1
	sta	r0L
	lda	MainLoop+2		; get correct address of Wheels OS MainLoop
	sta	r0H
	php
	sei
	ldy	#$00
	lda	#$2c			; BIT opcode
	sta	(r0),y
	iny
	lda	#$b4
	sta	(r0),y
	iny
	lda	#$88
	sta	(r0),y		; BIT $88B4 into Wheels OS MainLoop

	LoadW	r0, panicbuf	; source address
;	LoadW	r1, (Panic+1)	; dest address
	lda	Panic+1		; get Panic address
	sta	r1L			; dest address
	sta	PVec			; and refresh the Panic Vector
	lda	Panic+2
	sta	r1H
	sta	PVec+1
	bit	cMode			; test for Wheels 128
	bpl	@2			; take branch for Wheels 64
	lda	#(eMSwitcher-GWMSwitcher); length - Wheels 128
.byte $2c				; BIT opcode
@2:	lda	#(eM64Switcher-GW64MSwitcher); length - Wheels 64
	sta	r2L
	lda	#$00
	sta	r2H
	jsr	MoveData		; preserve the Panic routine should the user 'uninstall'
	plp

	jsr	IsBankAssigned	;do we have a bank assigned?
	beq	@1			;branch if not.
;	lda	#(0 | 64)
;	jsr	GetNewKernal
	jsr	GetRAMBam		; gets the expansion RAM's BAM
	ldy	reuPart		; get RAM partition number
	jsr	DelRamDevice	; .Y holds the partition number.
	jsr	PutRAMBam		; and writes back the modified expansion RAM's BAM
@1:	jmp	RstrKernal
;	jmp	EnterDeskTop	; and quit geoPublish
;	rts

srInstall:				; service routine for the geoWizard Install Splash DB
	lda	#>keypressRout
	sta	keyVector+1
	lda	#<keypressRout	; wedge in a keyboard handler routine
	sta	keyVector
	lda	#$60			; $54
	sta	r1H
	lda	#$00
	sta	r11H
	lda	#$50
	sta	r11L
	lda	r11H
	ora	cVideo		; check 40/80 column modes
	sta	r11H
	lda	#>tInstBank
	sta	r0H
	lda	#<tInstBank
	sta	r0L
	jsr	PutString		; prints out the text string
	lda	reuBank		; get bank # (not a9L)
	sta	r0L
	lda	#$00
	sta	r0H
	lda	#$C0
	jsr	PutDecimal		; and print out the bank #
	lda	#$29			; closing parenthesis
	jmp	PutChar

tInstBank:				; text pointer
.byte $18
.asciiz "(Installed in bank "

keypressRout:			; handle keypresses for the DB
	lda	keyData
	sta	a0L
	cmp	#$0D			; is it RETURN?
	beq	@1
	cmp	#$75			; is it 'u' for 'Uninstall' geoWizard?
	beq	@2
	rts
@1:	lda	#$01
.byte $2c
@2:	lda	#$75			; for uninstalling geoWizard
	sta	sysDBData		; indicate so and exit the DB
	jmp	RstrFrmDialog

;L0AD3:				; revise for Wheels OS usage
;	lda	firstBoot
;	bne	@1			; are we in autoexec mode?
;	lda	sysRAMFlg		; continue w/ code in autoexec mode.
;	sta	cRAMFlag
;	and	#$7F
;	sta	sysRAMFlg		; disable MoveData for some reason.
;	lda	ramExpSize
;	beq	@1
;	lda	#$50
;	sta	r0H
;	lda	#$00
;	sta	r0L			; move $5000-$5fff into RAM expansion starting at $0000
;	lda	#$00
;	sta	r1H
;	lda	#$00
;	sta	r1L
;	lda	#$10
;	sta	r2H
;	lda	#$00
;	sta	r2L
;	lda	#$00
;	sta	r3L			; into bank $00 of REU. Will this crash Wheels OS?
;	jsr	StashRAM
;@1:	rts
;
;L0B08:
;	lda	firstBoot
;	bne	@1
;	lda	ramExpSize
;	beq	@1
;	lda	#$50
;	sta	r0H
;	lda	#$00
;	sta	r0L			; get contents at $0000 in REU back to CPU $5000-$5fff
;	lda	#$00
;	sta	r1H
;	lda	#$00
;	sta	r1L
;	lda	#$10
;	sta	r2H
;	lda	#$00
;	sta	r2L
;	lda	#$00
;	sta	r3L			; use bank $00 of the REU - conflicts with Wheels OS?
;	jsr	FetchRAM
;	lda	cRAMFlag
;	sta	sysRAMFlg
;@1:	rts

genericDB:				; issues a generic DB w/ variable text & OK icon
	stx	r5H
	sty	r5L			; pass text pointer for the DBVARSTR function
	LoadW	r0, dbGenOK		; loads r0 w/ db table
	jmp	DoDlgBox		; issues DB & exits

setMargin:				; allows text to be formatted in dialog boxes
	lda	cMode			; check computer
	bmi	@1
;	lda	#$00			; Wheels 64
.byte $2c				; BIT opcode
@1:	lda	#$80
	sta	leftMargin+1
	lda	#$50			; set margin
	sta	leftMargin
	rts

dbGenOK:				; generic DB w/ text & OK icon
.byte $81				; default DB params
.byte DB_USR_ROUT
.word setMargin			; needed to reformat text in dialog boxes
.byte DBVARSTR
.byte $10,$10			; x/y position
.byte r5				; for now
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tReqWheels:				; text
.byte $18

.byte "Requires Wheels OS", 13
.asciiz "Aborting..."

tResMod:				; text showing resident module
.byte $18

.byte "geoWizard resident module", 13
.asciiz "overflow error! Aborting."

tReqRAM:
.byte $18

.byte "Requires at least 128Kb", 13
.byte "of expansion RAM to run.", 13
.byte "Aborting..."

dbSplash:				; the splash DB table
.byte $81				; default
.byte DBTXTSTR
.byte $10,$10			; x/y position
.word tGWInstall
.byte DBTXTSTR
.byte $10,$1C			; x/y position
L0CB6:
.word tClickMouse
.byte DBTXTSTR
.byte $10,$28			; x/y position
.word tActivate
.byte DBTXTSTR
.byte $10,$34			; x/y position
.word tUninstall
.byte DB_USR_ROUT
.word srInstall
.byte OK
.byte $01,$48			; x/y position
.byte NULL

tGWInstall:				; text
.byte $18
.asciiz "WheelWizard installed!"
tClickMouse:			; text
.asciiz "Click both mouse buttons"
tActivate:				; text
.asciiz "to activate. Hit 'u' to"
tUninstall:
.asciiz "Uninstall WheelWizard."

;tLeftArrow:				; text for left arrow
;.asciiz "Hit <- (left arrow) then fire"

bmpGW:			; bitmap used for the geoWizard splash screen
.byte $16,$FF,$81,$80,$14,$00,$82,$01
.byte $80,$14,$00,$82,$01,$80,$07,$00
.byte $83,$78,$00,$3C,$08,$00,$84,$78
.byte $00,$01,$80,$07,$00,$84,$78,$00
.byte $3C,$3C,$07,$00,$84,$78,$00,$01
.byte $80,$07,$00,$84,$78,$78,$7C,$3C
.byte $07,$00,$84,$F8,$00,$01,$80,$07
.byte $00,$84,$78,$78,$7C,$3C,$07,$00
.byte $DB,$F8,$00,$01,$80,$00,$00,$00
.byte $01,$FE,$00,$00,$78,$F8,$F8,$00
.byte $00,$00,$0F,$E0,$00,$00,$00,$F0
.byte $00,$01,$80,$00,$00,$1F,$83,$FF
.byte $00,$FC,$78,$F8,$F8,$78,$07,$F0
.byte $3F,$FC,$F0,$00,$1F,$F0,$00,$01
.byte $80,$00,$00,$7F,$C7,$FF,$83,$FE
.byte $79,$F9,$F0,$78,$3F,$F8,$7F,$FC
.byte $FF,$E0,$7F,$F0,$00,$01,$80,$00
.byte $00,$FF,$C7,$CF,$87,$FF,$79,$F9
.byte $F0,$78,$FF,$F8,$FE,$7C,$FF,$F0
.byte $FF,$F0,$00,$01,$DB,$80,$00,$01
.byte $FF,$CF,$8F,$8F,$FF,$79,$FB,$E0
.byte $78,$FF,$F9,$F8,$7C,$7F,$F1,$FF
.byte $E0,$00,$01,$80,$00,$03,$F3,$CF
.byte $BF,$9F,$8F,$7F,$FB,$E0,$F8,$F9
.byte $F9,$F0,$78,$7E,$F3,$F1,$E0,$00
.byte $01,$80,$00,$03,$E3,$CF,$FF,$1F
.byte $0F,$7F,$FB,$C0,$F8,$03,$F3,$E0
.byte $F8,$7C,$03,$E1,$E0,$00,$01,$80
.byte $00,$07,$C3,$DF,$FE,$3E,$0F,$3F
.byte $FF,$C0,$F0,$07,$E3,$E0,$F8,$F8
.byte $07,$C1,$E0,$00,$01,$80,$00,$07
.byte $DB,$C3,$DF,$F8,$3E,$0F,$3F,$FF
.byte $C0,$F0,$0F,$C3,$C1,$F0,$F8,$07
.byte $C1,$E0,$00,$01,$80,$00,$07,$87
.byte $DF,$C0,$3C,$0F,$3F,$FF,$80,$F0
.byte $1F,$83,$C1,$F0,$F0,$07,$83,$E0
.byte $00,$01,$80,$00,$07,$87,$CF,$00
.byte $3C,$1F,$3F,$FF,$81,$F0,$3F,$03
.byte $C3,$F0,$F0,$07,$83,$E0,$00,$01
.byte $80,$00,$07,$8F,$CF,$0F,$3C,$1F
.byte $3F,$BF,$01,$F0,$7E,$03,$E7,$F1
.byte $F0,$07,$CF,$C0,$00,$01,$80,$00
.byte $07,$DF,$CF,$BF,$DB,$3C,$3E,$1F
.byte $BF,$01,$E0,$FC,$7B,$FF,$F1,$F0
.byte $07,$DF,$C0,$00,$01,$80,$00,$07
.byte $FF,$CF,$FF,$3E,$FE,$1F,$BF,$01
.byte $E1,$FB,$F9,$FF,$F9,$E0,$03,$FF
.byte $C0,$00,$01,$80,$00,$03,$FF,$C7
.byte $FE,$3F,$FC,$0F,$1E,$01,$E1,$FF
.byte $F9,$FF,$F9,$E0,$03,$FF,$C0,$00
.byte $01,$80,$00,$01,$FF,$83,$F8,$1F
.byte $F8,$0F,$1E,$01,$E1,$FF,$F0,$FC
.byte $79,$E0,$01,$FF,$C0,$00,$01,$80
.byte $00,$00,$0F,$80,$00,$0F,$E0,$00
.byte $88,$00,$01,$E0,$FF,$80,$00,$01
.byte $E0,$04,$00,$86,$01,$80,$00,$00
.byte $0F,$80,$10,$00,$85,$01,$80,$00
.byte $03,$DF,$11,$00,$92,$01,$80,$00
.byte $03,$FF,$00,$17,$40,$00,$A4,$00
.byte $40,$0E,$E6,$30,$09,$54,$0A,$04
.byte $00,$92,$01,$80,$00,$03,$FE,$00
.byte $22,$62,$0A,$B1,$A3,$64,$10,$89
.byte $40,$AC,$46,$A9,$04,$00,$92,$01
.byte $80,$00,$01,$FC,$00,$22,$55,$0A
.byte $A5,$55,$4A,$10,$E9,$20,$A9,$54
.byte $A9,$04,$00,$82,$01,$80,$04,$00
.byte $8C,$22,$56,$0A,$A5,$55,$4C,$12
.byte $89,$10,$A9,$54,$A1,$04,$00,$82
.byte $01,$80,$04,$00,$8C,$12,$53,$06
.byte $95,$53,$26,$0E,$E6,$60,$65,$52
.byte $6A,$04,$00,$82,$01,$80,$0F,$00
.byte $81,$40,$04,$00,$82,$01,$80,$14
.byte $00,$DB,$01,$87,$40,$00,$00,$10
.byte $0C,$00,$04,$75,$00,$43,$8E,$38
.byte $01,$C8,$00,$03,$A0,$66,$00,$00
.byte $01,$8C,$C0,$00,$00,$00,$04,$00
.byte $08,$CC,$80,$C4,$D3,$6C,$00,$80
.byte $00,$06,$60,$22,$00,$00,$01,$88
.byte $40,$00,$00,$00,$04,$10,$08,$84
.byte $81,$44,$51,$44,$00,$80,$00,$04
.byte $20,$22,$00,$84,$01,$90,$0C,$F3
.byte $35,$B3,$C7,$3C,$11,$00,$40,$44
.byte $51,$44,$00,$9A,$D8,$08,$06,$22
.byte $31,$EF,$31,$90,$12,$DB,$49,$23
.byte $14,$84,$90,$11,$00,$40,$46,$59
.byte $44,$00,$89,$24,$08,$09,$22,$48
.byte $84,$49,$90,$12,$49,$62,$14,$84
.byte $90,$11,$00,$40,$43,$CF,$44,$00
.byte $89,$24,$08,$09,$22,$78,$84,$79
.byte $88,$52,$49,$42,$17,$04,$90,$10
.byte $84,$40,$40,$82,$44,$00,$89,$24
.byte $04,$29,$22,$40,$84,$41,$8C,$D2
.byte $48,$C2,$12,$04,$90,$10,$CC,$40
.byte $41,$86,$6C,$02,$89,$24,$06,$69
.byte $22,$64,$84,$65,$87,$8C,$70,$87
.byte $3B,$9F,$8E,$CC,$10,$78,$40,$E6
.byte $18,$38,$83,$1F,$B6,$03,$C6,$77
.byte $38,$63,$39,$80,$00,$40,$80,$04
.byte $40,$00,$08,$00,$80,$00,$00,$00
.byte $80,$07,$00,$8E,$01,$80,$00,$41
.byte $00,$04,$40,$00,$08,$00,$80,$00
.byte $00,$01,$08,$00,$8A,$01,$80,$00
.byte $E3,$00,$03,$80,$00,$04,$01,$0C
.byte $00,$82,$01,$80,$14,$00,$82,$01
.byte $80,$14,$00,$81,$01,$16,$FF

;clickMode:
;.byte $FF			; default mouse mode
cMode:
.byte $00			; Computer operating mode - 64=00 or 128=ff
permName:
.asciiz "geoWizard   V1.1"

.bss
nBuffer:				; name buffer for the disk routines
.res $11
reuBank:				; geoWizard's reu bank #
.res 1
reuPart:				; geoWizard's reu partition #
.res 1
cVideo:
.res 1				; Computer video mode - 40=00 or 80=80/ff?
;cRAMFlag:				; might not be needed
;.res 1				; copy of sysRAMFlag
panicbuf:				; temporary buffer for the PANIC routine
.res $ff
