; Wheels OS File requestor for use w/ geoWizard.
; Copyright (C) 2004 by Todd S. Elliott

; Main DB Table
dbOpen:					; DB for opening a geoPublish file
.byte $81					; default DB position and pattern
.byte $10					; DBGETFILES
.byte $04
.byte $04					; default x,y pos
.byte $05					; OPEN icon
.byte $11					; card xpos
.byte $19					; ypos
.byte $0b					; DBTXTSTR
.byte $82					; xpos
.byte $0a					; ypos
.word tOnDisk				; - pointer to text (on disk:)
.byte $0b					; DBTXTSTR
tXpos:					; modify the X position for naming DB purposes
.byte $82					; xpos
.byte $14					; ypos
.word diskName				; - pointer to diskname
.byte $02					; CANCEL icon
.byte $11					; card xpos
.byte $4c					; ypos
.byte $12					; DBUSRICON
.byte $11					; card xpos
.byte $3b					; ypos
.word aDriveTable
.byte $12					; DBUSRICON
.byte $14					; card xpos
.byte $3b					; ypos
.word bDriveTable
.byte $12					; DBUSRICON
.byte $11					; card xpos
.byte $44					; ypos
.word cDriveTable
.byte $12					; DBUSRICON
.byte $14					; card xpos
.byte $44					; ypos
.word dDriveTable
setDiskIcon:				; modified by open DB routines
.byte $06					; DISK icon
.byte $11					; card xpos
.byte $2a					; ypos
.byte $00					; delimiter

; these are icon table entries for the dialog box and are self-modified to
; reflect whether a drive is present and also whether it is on.
aDriveTable:
.word offAIcon
.byte $00,$00	; default pos
bd9:
.byte $03,$08	; height/width
.word iconADrive
bDriveTable:
.word offBIcon
.byte $00,$00	; default pos
bda:
.byte $03,$08	; height/width
.word iconBDrive
cDriveTable:
.word offCIcon
.byte $00,$00	; default pos
bdb:
.byte $03,$08	; height/width
.word iconCDrive
dDriveTable:
.word offDIcon
.byte $00,$00	; default pos
bdc:
.byte $03,$08	; height/width
.word iconDDrive

; icon bitmap data follows
; 25 bytes for each icon bitmap
offAIcon:
.byte $98					; 24 unique bytes follow
.byte %11111111,%01111110,%11111100
.byte %10000000,%10000001,%00000110
.byte %10000000,%10000001,%00000110
.byte %10000001,%11111111,%10000110
.byte %10000001,%00000000,%10000110
.byte %10000001,%00000000,%10000110
.byte %11111101,%01111110,%10111110
.byte %00111111,%11111111,%11111110

offBIcon:
.byte $98					; 24 unique bytes follow
.byte %11111101,%11111111,%01111110
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%11111111,%00000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %11111101,%11111111,%01111111
.byte %00111111,%11111111,%11111111

offCIcon:
.byte $98					; 24 unique bytes follow
.byte %11111110,%11111111,%01111100
.byte %10000001,%00000000,%10000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%00000110
.byte %10000001,%00000000,%10000110
.byte %11111110,%11111111,%01111110
.byte %00111111,%11111111,%11111110

offDIcon:
.byte $98					; 24 unique bytes follow
.byte %11111101,%11111111,%01111110
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %10000001,%00000000,%10000011
.byte %11111101,%11111111,%01111111
.byte %00111111,%11111111,%11111111

; table of pointers to relevant data
iconLTable:
.byte <aDriveTable,<bDriveTable,<cDriveTable,<dDriveTable
iconHTable:
.byte >aDriveTable,>bDriveTable,>cDriveTable,>dDriveTable
offLTable:
.byte <offAIcon,<offBIcon,<offCIcon,<offDIcon
offHTable:
.byte >offAIcon,>offBIcon,>offCIcon,>offDIcon

setup4DB:					; sets up the dialog box table for four drives.
	lda	a1L				; checks copy of keyData
	cmp	#$E4				; is it a DA?
	beq	@6
	cmp	#$CC				; is it AUTOEXEC?
	bne	@4
	lda	#$0E				; AUTOEXEC GEOS filetype
.byte $2c					; BIT opcode
@4:	lda	#$06				; APPLICATION GEOS filetype
.byte $2c
@6:	lda	#$05				; Desk Accessory GEOS filetype
	sta	r7L

	lda	#$00
	sta	appFName			; delimit the filename buffer immediately
	sta	r7H
	sta	setDiskIcon
	sta	r10H
	sta	r10L				; no permanent name
	jsr	checkDisk			; checks for a ramdisk, etc.
	bcc	@1
	lda	#$06
	sta	setDiskIcon			; restores the DISK icon entry
@1:	tya					; get dev #
	jsr	SetDevice
	jsr	readDiskName		; reads in the disk name and stores it
	ldx	#$08
@2:	lda	iconLTable-8,x
	sta	r0L
	lda	iconHTable-8,x
	sta	r0H
	lda	driveType-8,x		; check to see if a drive is present
	beq	@5
	cpx	curDrive			; is it the current disk device?
	bne	@3
	jsr	InvertIcon			; and make that icon turned ON
	beq	@3				; relative JMP
@5:	tay
	sta	(r0L),y
	iny
	sta	(r0L),y			; sets up the icontable
@3:	inx
	cpx	#$0c				; are we done with 8-11 yet?
	bne	@2
	LoadW	r5, appFName
	rts

Drv4DB:					; issues the DB w/ 4 drives & takes care of the icons.
	jsr	DoRcvrBox
	ldx	curDrive			; need to invert the drive icon to clear it
						; and fall through the following routine
InvertIcon:
	lda	offLTable-8,x		; select an OFF icon for that drive entry
	sta	r1L
	lda	offHTable-8,x
	sta	r1H
	ldy	#$18				; invert the drive icon
@1:	lda	(r1),y
	eor	#$ff
	sta	(r1),y
	dey
	bne	@1
	rts

checkDisk:					; checks for a ramdisk
	ldy	curDrive
	lda	driveType-8,y		; checks the dataDrive's disk device under driveType table
	bmi	@1				; checks for the presence of a ramdisk
@2:	sec					; It's not a ramdisk
	rts
@1:	cmp	#$83				; is it RL1581 driver?
	bcc	@3				; branch if it's a 1541/71 ramdisk
	bne	@2				; a native ramdisk is being used, so branch out
	lda	cableType			; check RAMLink status
	bmi	@2				; branch if it is a 1581 RL ramdisk
@3:	clc					; it's a ramdisk
	rts

readDiskName:				; reads in disk name and stores it
	ldx	#r0				; use r0
	jsr	GetPtrCurDkNm		; retrieve the disk name
	ldy	#$00
@5:	lda	(r0L),y
	cmp	#$a0				; check for padded spaces
	beq	@6
	sta	diskName,y			; store in disk name.
	iny
	cpy	#$10				; are we done anyway?
	bne	@5
@6:	lda	#$00
	sta	diskName,y			; and delimit it
	rts

changeDisk:					; handles the disk change
	lda	curType			; check out the disk device to determine if it's
	cmp	#$20				; removable media. only CMD HD and above are exempt.
	bcs	@4
	ldx	#>tNewDsk			; warns user about inserting new disk
	ldy	#<tNewDsk
	jsr	genericDB			; issue generic DB w/ OK icon

;	lda	#>dbNewDsk			; rework this to use a generic DB
;	sta	r0H
;	lda	#<dbNewDsk
;	sta	r0L
;	lda	#>tNewDsk
;	sta	r6H
;	lda	#<tNewDsk
;	sta	r6L
;	jsr	DoRcvrBox			; prompts the user to insert a new disk
@4:	jmp	OpenDisk			; OpenDisk the new disk

changeDevice:				; handles the disk device change
	jsr	SetDevice			; sets the new disk device
	jmp	OpenDisk

iconADrive:					; service handler routines for the drive icons
	lda	#$08
.byte $2c
iconBDrive:
	lda	#$09
.byte $2c
iconCDrive:
	lda	#$0a
.byte $2c
iconDDrive:
	lda	#$0b
	sta	sysDBData
	jmp	RstrFrmDialog
