(DE DO NIL
  (PROG(IN RULESUSED RULE) LOOP
    (MSG ":_ ")
    (SETQ IN
      (READL))
    (COND((MEMBER(CAR IN)
         '(OK ENDE FERTIG))
        (RETURN T))
      ((EQ(LAST IN)
         ':)
        (MSG ":+ ")
        (SETQ IN
          (APPEND IN
            (READL)))))
    (EVAL(TO-DO IN))
    (GO LOOP)))

(DE REMEMBER
  (NEW)
  (COND((MEMBER NEW FACTS)
       NIL)
    (T(SETQ FACTS
        (CONS NEW FACTS)) NEW)))

(DE RECALL
  (FACT)
  (COND((MEMBER FACT FACTS)
       FACT)))

(DE TESTIF
  (RULE)
  (PROG(IFS)
    (SETQ IFS
      (CAR RULE)) LOOP
    (COND((NULL IFS)
        (RETURN T))
      ((RECALL(CAR IFS)))
      (T(RETURN NIL)))
    (SETQ IFS
      (CDR IFS))
    (GO LOOP)))

(DE USETHEN
  (RULE)
  (PROG(THENS SUCCESS)
    (SETQ THENS
      (CADR RULE)) LOOP
    (COND((NULL THENS)
        (RETURN SUCCESS))
      ((REMEMBER(CAR THENS))
        (SETQ SUCCESS T)
        (PRINT-RULE RULE)
        (MSG T "DEDUZIERT " T "--> ")
        (PRINC(CAR THENS))
        (TERPRI)))
    (SETQ THENS
      (CDR THENS))
    (GO LOOP)))

(DE TRYRULE
  (RULE)
  (COND((TESTIF RULE)
      (REMEMBERRULE RULE)
      (USETHEN RULE))))

(DE STEPFORWARD NIL
  (PROG(RULELIST)
    (SETQ RULELIST RULES) LOOP
    (COND((NULL RULELIST)
        (RETURN NIL))
      ((TRYRULE(CAR RULELIST))
        (RETURN T)))
    (SETQ RULELIST
      (CDR RULELIST))
    (GO LOOP)))

(DE DEDUCE NIL
  (SETQ RULESUSED NIL)
  (PROG(PROGRESS) LOOP
    (COND((STEPFORWARD)
        (SETQ PROGRESS T))
      (T(RETURN PROGRESS)))
    (GO LOOP)))

(SETQ RULES
   'NIL)

(SETQ FACTS
   'NIL)

(SETQ HYPS
   'NIL)

(DE VERIFY
  (FACT)
  (PROG(RELEVANT1 RELEVANT2)
    (COND((RECALL FACT)
        (RETURN T)))
    (SETQ RELEVANT1
      (INTHEN FACT RULES))
    (SETQ RELEVANT2 RELEVANT1)
    (COND((NULL RELEVANT1)
        (COND((MEMBER FACT ASKED)
            (RETURN NIL))
          ((ASK FACT)
            (REMEMBER FACT)
            (RETURN T))
          (T(SETQ ASKED
              (CONS FACT ASKED))
            (RETURN NIL))))) LOOP1
    (COND((NULL RELEVANT1)
        (GO LOOP2))
      ((TRYRULE(CAR RELEVANT1))
        (RETURN T)))
    (SETQ RELEVANT1
      (CDR RELEVANT1))
    (GO LOOP1) LOOP2
    (COND((NULL RELEVANT2)
        (GO EXIT))
      ((TRYRULE+(CAR RELEVANT2))
        (RETURN T)))
    (SETQ RELEVANT2
      (CDR RELEVANT2))
    (GO LOOP2) EXIT
    (RETURN NIL)))

(DE TRYRULE+
  (RULE)
  (COND((TESTIF+ RULE)
      (REMEMBERRULE RULE)
      (USETHEN RULE))))

(DE TESTIF+
  (RULE)
  (PROG(IFS)
    (SETQ IFS
      (CAR RULE)) LOOP
    (COND((NULL IFS)
        (RETURN T))
      ((VERIFY(CAR IFS)))
      (T(RETURN NIL)))
    (SETQ IFS
      (CDR IFS))
    (GO LOOP)))

(DE INIF
  (FACT R)
  (MAPCAN '(LAMBDA(X)
      (COND((MEMBER FACT
          (CAR X))
          (LIST X)))) R))

(DE INTHEN
  (FACT R)
  (MAPCAN '(LAMBDA(X)
      (COND((MEMBER FACT
          (CADR X))
          (LIST X)))) R))

(DE DIAGNOSE NIL
  (SETQ RULESUSED NIL)
  (PROG(ASKED POS)
    (SETQ POS HYPS) LOOP
    (COND((NULL POS)
        (MSG T 
          "KEINE HYPOTHESE KANN BEWIESEN WERDEN" T)
        (RETURN NIL))
      ((VERIFY(CAR POS))
        (MSG T "DIE HYPOTHESE :" T 
          "--> ")
        (PRINC(CAR POS))
        (MSG T "IST WAHR" T)
        (RETURN(CAR POS))))
    (MSG T "DIE HYPOTHESE :" T "--> ")
    (PRINC(CAR POS))
    (MSG T 
      "KANN NICHT BEWIESEN WERDEN" T)
    (SETQ POS
      (CDR POS))
    (GO LOOP)))

(SETQ DATA
   '(RULES FACTS HYPS))

(DE ASK
  (S)
  (MSG T "IST DIES WAHR (J/N/W) :" T)
  (PRINC S)
  (SETQ CH
    (WAITCHAR))
  (MSG T CH T)
  (COND((EQ CH "J")
       T)
    ((EQ CH "N")
       F)
    (T(TELLWHY)
      (ASK S))))

(DE TELLWHY NIL
  (MSG T "ICH VERSUCHE ZU BEWEISEN :" 
    T)
  (PRINC(CAR POS))
  (MSG T T "ICH TESTE :" T)
  (PRINT-RULE RULE))

(DE PRINT-FACTS NIL
  (COND(FACTS(PRLIST FACTS))
    (T(MSG 
        "ES SIND KEINE FAKTEN VORHANDEN!" T))))

(DE PRINT-HYPS NIL
  (COND(HYPS(PRLIST HYPS))
    (T(MSG 
        "NOCH WURDE KEINE HYPOTHESE AUFGESTELLT!" T))))

(DE PRINT-RULES NIL
  (COND(RULES(MAPC 'PRINT-RULE RULES))
    (T(MSG "BITTE REGELN EINGEBEN!" T))))

(DE PRINT-RULE
  (R)
  (MSG T "+++ REGEL "
    (CAR(CDDR R)) " +++" T)
  (PRINT-IF(CAR R))
  (PRINT-THEN(CADR R)))

(DE PRLIST
  (L)
  (MAPC '(LAMBDA(X)
      (PRINC X)
      (TERPRI)) L))

(DE PRINT-RULE-N
  (N)
  (COND((SETQ X
      (GET-RULE-N N RULES))
      (PRINT-RULE X))
    (T(MSG 
        "ES GIBT NOCH KEINE REGEL " N 
        T))))

(DE GET-RULE-N
  (N R)
  (PROG NIL LOOP
    (COND((NULL R)
        (RETURN NIL))
      ((EQ N
        (CAR(CDDR(CAR R))))
        (RETURN(CAR R))))
    (SETQ R
      (CDR R))
    (GO LOOP)))

(DE PRINT-IF
  (IFS)
  (PRINC(CONS 'WENN
      (CONS ':
        (CAR IFS))))
  (TERPRI)
  (MAPC '(LAMBDA(X)
      (PRINC(APPEND '(UND WENN :) X))
      (TERPRI))
    (CDR IFS)))

(DE PRINT-THEN
  (THENS)
  (PRINC(CONS 'DANN
      (CONS ':
        (CAR THENS))))
  (TERPRI)
  (MAPC '(LAMBDA(X)
      (PRINC(APPEND '(UND DANN :) X))
      (TERPRI))
    (CDR THENS)))

(DF FORGET-FACT L
  (SETQ FACTS
    (REMOVE L FACTS)))

(DF FORGET-HYP L
  (SETQ HYPS
    (REMOVE L HYPS)))

(DE FORGET-FACTS NIL
  (SETQ FACTS NIL))

(DE FORGET-HYPS NIL
  (SETQ HYPS NIL))

(DE FORGET-RULES NIL
  (SETQ RULES NIL)
  (SETQ RULE NIL))

(DE FORGET-RULE
  (N)
  (SETQ RULES
    (REMOVE(GET-RULE-N N RULES) RULES)
))

(DE WHAT? NIL
  (MSG "WAS SOLL ICH TUN ?" T))

(DF HOW FACT
  (COND((SETQ X
      (INTHEN FACT RULESUSED))
      (MSG "MIT DEN FAKTEN :" T)
      (MAPC '(LAMBDA(Y)
          (PRLIST(CAR Y))) X))
    ((MEMBER FACT FACTS)
      (MSG "DAS FAKTUM WAR GEGEBEN" T))
    (T(MSG 
        "DAS HABE ICH NICHT DEDUZIERT" T))))

(DF WHY FACT
  (COND((MEMBER FACT HYPS)
      (MSG 
        "ES WAR EINE DER HYPOTHESEN" T))
    ((SETQ X
      (INIF FACT RULESUSED))
      (MSG "ES FOLGT DARAUS :" T)
      (MAPC '(LAMBDA(Y)
          (PRLIST(CADR Y))) X))
    (T(MSG 
        "DAS HABE ICH NICHT BENUTZT" T))))

(DF WHICH NIL
  (COND((NULL RULESUSED)
      (MSG "KEINE" T))
    (T(MSG "DIE REGELN ")
      (PRINC(MAPCAR 'LAST RULESUSED))
      (TERPRI))))

(DE DO NIL
  (PROG(IN RULESUSED RULE) LOOP
    (MSG ":_ ")
    (SETQ IN
      (READL))
    (COND((MEMBER(CAR IN)
         '(OK ENDE FERTIG))
        (RETURN T))
      ((EQ(LAST IN)
         ':)
        (MSG ":+ ")
        (SETQ IN
          (APPEND IN
            (READL)))))
    (EVAL(TO-DO IN))
    (GO LOOP)))

(DE REMEMBER
  (NEW)
  (COND((MEMBER NEW FACTS)
       NIL)
    (T(SETQ FACTS
        (CONS NEW FACTS)) NEW)))

(DE RECALL
  (FACT)
  (COND((MEMBER FACT FACTS)
       FACT)))

(DE TESTIF
  (RULE)
  (PROG(IFS)
    (SETQ IFS
      (CAR RULE)) LOOP
    (COND((NULL IFS)
        (RETURN T))
      ((RECALL(CAR IFS)))
      (T(RETURN NIL)))
    (SETQ IFS
      (CDR IFS))
    (GO LOOP)))

(DE USETHEN
  (RULE)
  (PROG(THENS SUCCESS)
    (SETQ THENS
      (CADR RULE)) LOOP
    (COND((NULL THENS)
        (RETURN SUCCESS))
      ((REMEMBER(CAR THENS))
        (SETQ SUCCESS T)
        (PRINT-RULE RULE)
        (MSG T "DEDUZIERT " T "--> ")
        (PRINC(CAR THENS))
        (TERPRI)))
    (SETQ THENS
      (CDR THENS))
    (GO LOOP)))

(DE TRYRULE
  (RULE)
  (COND((TESTIF RULE)
      (REMEMBERRULE RULE)
      (USETHEN RULE))))

(DE STEPFORWARD NIL
  (PROG(RULELIST)
    (SETQ RULELIST RULES) LOOP
    (COND((NULL RULELIST)
        (RETURN NIL))
      ((TRYRULE(CAR RULELIST))
        (RETURN T)))
    (SETQ RULELIST
      (CDR RULELIST))
    (GO LOOP)))

(DE DEDUCE NIL
  (SETQ RULESUSED NIL)
  (PROG(PROGRESS) LOOP
    (COND((STEPFORWARD)
        (SETQ PROGRESS T))
      (T(RETURN PROGRESS)))
    (GO LOOP)))

(SETQ RULES
   'NIL)

(SETQ FACTS
   'NIL)

(SETQ HYPS
   'NIL)

(DE VERIFY
  (FACT)
  (PROG(RELEVANT1 RELEVANT2)
    (COND((RECALL FACT)
        (RETURN T)))
    (SETQ RELEVANT1
      (INTHEN FACT RULES))
    (SETQ RELEVANT2 RELEVANT1)
    (COND((NULL RELEVANT1)
        (COND((MEMBER FACT ASKED)
            (RETURN NIL))
          ((ASK FACT)
            (REMEMBER FACT)
            (RETURN T))
          (T(SETQ ASKED
              (CONS FACT ASKED))
            (RETURN NIL))))) LOOP1
    (COND((NULL RELEVANT1)
        (GO LOOP2))
      ((TRYRULE(CAR RELEVANT1))
        (RETURN T)))
    (SETQ RELEVANT1
      (CDR RELEVANT1))
    (GO LOOP1) LOOP2
    (COND((NULL RELEVANT2)
        (GO EXIT))
      ((TRYRULE+(CAR RELEVANT2))
        (RETURN T)))
    (SETQ RELEVANT2
      (CDR RELEVANT2))
    (GO LOOP2) EXIT
    (RETURN NIL)))

(DE TRYRULE+
  (RULE)
  (COND((TESTIF+ RULE)
      (REMEMBERRULE RULE)
      (USETHEN RULE))))

(DE TESTIF+
  (RULE)
  (PROG(IFS)
    (SETQ IFS
      (CAR RULE)) LOOP
    (COND((NULL IFS)
        (RETURN T))
      ((VERIFY(CAR IFS)))
      (T(RETURN NIL)))
    (SETQ IFS
      (CDR IFS))
    (GO LOOP)))

(DE INIF
  (FACT R)
  (MAPCAN '(LAMBDA(X)
      (COND((MEMBER FACT
          (CAR X))
          (LIST X)))) R))

(DE INTHEN
  (FACT R)
  (MAPCAN '(LAMBDA(X)
      (COND((MEMBER FACT
          (CADR X))
          (LIST X)))) R))

(DE DIAGNOSE NIL
  (SETQ RULESUSED NIL)
  (PROG(ASKED POS)
    (SETQ POS HYPS) LOOP
    (COND((NULL POS)
        (MSG T 
          "KEINE HYPOTHESE KANN BEWIESEN WERDEN" T)
        (RETURN NIL))
      ((VERIFY(CAR POS))
        (MSG T "DIE HYPOTHESE :" T 
          "--> ")
        (PRINC(CAR POS))
        (MSG T "IST WAHR" T)
        (RETURN(CAR POS))))
    (MSG T "DIE HYPOTHESE :" T "--> ")
    (PRINC(CAR POS))
    (MSG T 
      "KANN NICHT BEWIESEN WERDEN" T)
    (SETQ POS
      (CDR POS))
    (GO LOOP)))

(SETQ DATA
   '(RULES FACTS HYPS))

(DE ASK
  (S)
  (MSG T "IST DIES WAHR (J/N/W) :" T)
  (PRINC S)
  (SETQ CH
    (WAITCHAR))
  (MSG T CH T)
  (COND((EQ CH "J")
       T)
    ((EQ CH "N")
       F)
    (T(TELLWHY)
      (ASK S))))

(DE TELLWHY NIL
  (MSG T "ICH VERSUCHE ZU BEWEISEN :" T)
  (PRINC(CAR POS))
  (MSG T T "ICH TESTE :" T)
  (PRINT-RULE RULE))

(DE PRINT-FACTS NIL
  (COND(FACTS(PRLIST FACTS))
    (T(MSG 
        "ES SIND KEINE FAKTEN VORHANDEN!" T))))

(DE PRINT-HYPS NIL
  (COND(HYPS(PRLIST HYPS))
    (T(MSG 
        "NOCH WURDE KEINE HYPOTHESE AUFGESTELLT!" T))))

(DE PRINT-RULES NIL
  (COND(RULES(MAPC 'PRINT-RULE RULES))
    (T(MSG "BITTE REGELN EINGEBEN!" T))))

(DE PRINT-RULE
  (R)
  (MSG T "+++ REGEL "
    (CAR(CDDR R)) " +++" T)
  (PRINT-IF(CAR R))
  (PRINT-THEN(CADR R)))

(DE PRLIST
  (L)
  (MAPC '(LAMBDA(X)
      (PRINC X)
      (TERPRI)) L))

(DE PRINT-RULE-N
  (N)
  (COND((SETQ X
      (GET-RULE-N N RULES))
      (PRINT-RULE X))
    (T(MSG 
        "ES GIBT NOCH KEINE REGEL " N T))))

(DE GET-RULE-N
  (N R)
  (PROG NIL LOOP
    (COND((NULL R)
        (RETURN NIL))
      ((EQ N
        (CAR(CDDR(CAR R))))
        (RETURN(CAR R))))
    (SETQ R
      (CDR R))
    (GO LOOP)))

(DE PRINT-IF
  (IFS)
  (PRINC(CONS 'WENN
      (CONS ':
        (CAR IFS))))
  (TERPRI)
  (MAPC '(LAMBDA(X)
      (PRINC(APPEND '(UND WENN :) X))
      (TERPRI))
    (CDR IFS)))

(DE PRINT-THEN
  (THENS)
  (PRINC(CONS 'DANN
      (CONS ':
        (CAR THENS))))
  (TERPRI)
  (MAPC '(LAMBDA(X)
      (PRINC(APPEND '(UND DANN :) X))
      (TERPRI))
    (CDR THENS)))

(DF FORGET-FACT L
  (SETQ FACTS
    (REMOVE L FACTS)))

(DF FORGET-HYP L
  (SETQ HYPS
    (REMOVE L HYPS)))

(DE FORGET-FACTS NIL
  (SETQ FACTS NIL))

(DE FORGET-HYPS NIL
  (SETQ HYPS NIL))

(DE FORGET-RULES NIL
  (SETQ RULES NIL)
  (SETQ RULE NIL))

(DE FORGET-RULE
  (N)
  (SETQ RULES
    (REMOVE(GET-RULE-N N RULES) RULES)
))

(DE WHAT? NIL
  (MSG "WAS SOLL ICH TUN ?" T))

(DF HOW FACT
  (COND((SETQ X
      (INTHEN FACT RULESUSED))
      (MSG "MIT DEN FAKTEN :" T)
      (MAPC '(LAMBDA(Y)
          (PRLIST(CAR Y))) X))
    ((MEMBER FACT FACTS)
      (MSG "DAS FAKTUM WAR GEGEBEN" T))
    (T(MSG 
        "DAS HABE ICH NICHT DEDUZIERT" T))))

(DF WHY FACT
  (COND((MEMBER FACT HYPS)
      (MSG 
        "ES WAR EINE DER HYPOTHESEN" T))
    ((SETQ X
      (INIF FACT RULESUSED))
      (MSG "ES FOLGT DARAUS :" T)
      (MAPC '(LAMBDA(Y)
          (PRLIST(CADR Y))) X))
    (T(MSG 
        "DAS HABE ICH NICHT BENUTZT" T))))

(DF WHICH NIL
  (COND((NULL RULESUSED)
      (MSG "KEINE" T))
    (T(MSG "DIE REGELN ")
      (PRINC(MAPCAR 'LAST RULESUSED))
      (TERPRI))))

(DE REMEMBERRULE
  (RULE)
  (COND((NOT(MEMBER RULE RULESUSED))
      (SETQ RULESUSED
        (CONS RULE RULESUSED)))))

(DF RULES-WITH-IF L
  (MAPC 'PRINT-RULE
    (INIF L RULES)))

(DF RULES-WITH-THEN L
  (MAPC 'PRINT-RULE
    (INTHEN L RULES)))

(DE USED-RULE
  (N)
  (COND((SETQ X
      (GET-RULE-N N RULESUSED))
      (MSG "JA:" T)
      (PRINT-RULE X))
    (T(MSG "NEIN" T))))

(DF ADD-FACT L
  (COND((NULL FACTS)
      (SETQ FACTS
        (LIST L)))
    ((MEMBER L FACTS))
    (T(NCONC1 FACTS L))))

(DF ADD-HYP L
  (COND((NULL HYPS)
      (SETQ HYPS
        (LIST L)))
    ((MEMBER L HYPS))
    (T(NCONC1 HYPS L))))

(DF IF L
  (MSG "REGEL "
    (ADD1(LENGTH RULES)) T)
  (SETQ RULE
    (LIST(LIST L) NIL
      (ADD1(LENGTH RULES))))
  (COND(RULES(NCONC1 RULES RULE))
    (T(SETQ RULES
        (LIST RULE)))))

(DF ANDIF L
  (NCONC1(CAR RULE) L))

(DF THEN L
  (SETQ THEN-FACT L)
  (RPLACA(CDR RULE)
    (LIST L)))

(DE IS-HYP NIL
  (COND(THEN-FACT(APPLY 'ADD-HYP 
        THEN-FACT))))

(DF ANDTHEN L
  (SETQ THEN-FACT L)
  (NCONC1(CADR RULE) L))

(DE TO-DO
  (S)
  (PROG(SENT)
    (SETQ SENT DIAREG) LOOP
    (COND((NULL SENT)
        (RETURN(LIST 'WHAT?)))
      ((MATCH(CAAR SENT) S)
        (RETURN(DO-FUNC(CDAR SENT) S))))
    (SETQ SENT
      (CDR SENT))
    (GO LOOP)))

(DE DO-FUNC
  (FUNC S)
  (CONS(CAR FUNC)
    (COND((CDR(MEMBER ': S)))
      ((IN-EXPR S)))))

(DF DO-LISP
  (L)
  (PRINT(EVAL L)))

(DE IN-EXPR
  (L)
  (COND((ATOM L)
       NIL)
    ((OR(NUMBERP(CAR L))
      (CONSP(CAR L)))
      (LIST(CAR L)))
    (T(IN-EXPR(CDR L)))))

(DE MATCH
  (P S)
  (COND((NULL P)
      (OR(NULL S)
        (EQ(CAR S)
           ':)))
    ((EQ(CAR P)
       '*)
      (COND((OR(NULL S)
          (EQ(CAR S)
             ':))
          (NULL(CDR P)))
        ((MATCH(CDR P) S))
        ((MATCH P
          (CDR S)))))
    ((NULL S)
       NIL)
    ((EQ(CAR P)
      (CAR S))
      (MATCH(CDR P)
        (CDR S)))
    ((AND(CONSP(CAR P))
      (MEMBER(CAR S)
        (CAR P)))
      (MATCH(CDR P)
        (CDR S)))))

(SETQ DIAREG
   '(((WENN).IF)
      ((UND DANN).ANDTHEN)
      ((DANN).THEN)
      ((UND *).ANDIF)
      ((ALS *).IS-HYP)
      (((DRUCKE ZEIGE D)
         *
        (REGELN R)).PRINT-RULES)
      (((DRUCKE ZEIGE D)
         *
        (FAKTEN F)).PRINT-FACTS)
      (((DRUCKE ZEIGE D)
         *
        (HYPOTHESEN H)).PRINT-HYPS)
      (((DRUCKE ZEIGE D)
         * REGEL *).PRINT-RULE-N)
      (((VERGISS LOESCHE V)
         *
        (FAKTEN F)).FORGET-FACTS)
      (((VERGISS LOESCHE V)
         *
        (HYPOTHESEN H)).FORGET-HYPS)
      (((VERGISS LOESCHE V)
         *
        (REGELN R)).FORGET-RULES)
      (((VERGISS LOESCHE V)
         * FAKTUM).FORGET-FACT)
      (((VERGISS LOESCHE V)
         *
        (HYPOTHESE HYP)).FORGET-HYP)
      (((VERGISS LOESCHE V)
         * REGEL *).FORGET-RULE)
      ((WIE *).HOW)
      ((WELCHE *).WHICH)
      ((WARUM *).WHY)
      ((*(FAKTUM LERNE MERKE L M) *).
        ADD-FACT)
      ((*(HYPOTHESE HYP) *).ADD-HYP)
      ((* DIAGNOSE *).DIAGNOSE)
      ((*(DEDUZIERE DEDUZIEREN 
          DEDUKTION) *).DEDUCE)
      ((*(KONKLUSION K) *).
        RULES-WITH-THEN)
      ((*(PRAEMISSE P) *).
        RULES-WITH-IF)
      ((*(ANGEWENDET BENUTZT A) *).
        USED-RULE)
      ((* LISP *).DO-LISP)))

(SETQ EXPFNS
   '(DO REMEMBER RECALL TESTIF 
    USETHEN TRYRULE STEPFORWARD 
    DEDUCE RULES FACTS HYPS VERIFY 
    TRYRULE+ TESTIF+ INIF INTHEN 
    DIAGNOSE DATA ASK TELLWHY 
    PRINT-FACTS PRINT-HYPS 
    PRINT-RULES PRINT-RULE PRLIST 
    PRINT-RULE-N GET-RULE-N PRINT-IF 
    PRINT-THEN FORGET-FACT FORGET-HYP 
    FORGET-FACTS FORGET-HYPS 
    FORGET-RULES FORGET-RULE 
    CHANGE-RULE WHAT? HOW WHY WHICH 
    REMEMBERRULE RULES-WITH-IF 
    RULES-WITH-THEN USED-RULE 
    ADD-FACT ADD-HYP IF ANDIF THEN 
    IS-HYP ANDTHEN TO-DO DO-FUNC 
    DO-LISP IN-EXPR MATCH DIAREG 
    EXPFNS))

