/************************************************

  smemtest.c - unit tests for smem.a

  ShadowM 08/12/2007

 ************************************************/

#define NULL     0
#define FALSE    0
#define TRUE     1
#define NUMTESTS 7

extern int smalloc(), sfree();
extern int blklist, memtop, firstfit;
static int *lomem;
static int tests[NUMTESTS][2];
static int printing;

/***********************************************
  Blocking character read from keyboard.
 ***********************************************/
int getchar() {
  char a, x, y;

  a = 0; x = y; y = 0;
  while (a == 0) {
    sys(0xffe4, &a, &x, &y);
  }

  return a;
}

/***********************************************
  Show available memory.
 ***********************************************/
int showMem() {
  int *hiptr;
  int hiaddr;

  printf("lomem:   $%04x\n", *lomem);
  printf("blklist: $%04x\n", blklist);
  printf("memtop:  $%04x\n", memtop);
  printf("freemem: $%04x\n", freemem());

  if (blklist == memtop) {
    printf("No memory allocated.\n");
    return;
  }

  hiptr = blklist;
  hiaddr = blklist;
  while (hiptr != memtop) {
    printf("$%04x size: $%04x, flags: $%04x\n",
           hiptr, *hiptr, *(hiptr+1));
    hiaddr += *hiptr;
    hiptr = hiaddr;
  }

  if (printing) {
    printf("\n");
  } else {
    printf("hit a key...\n\n");
    getchar();
  }
}

/***********************************************
  Allocate memory verbosely.
 ***********************************************/
int tstAlloc(index)
int index; {
  tests[index][1] = smalloc(tests[index][0]);
  if (tests[index][1] == NULL) {
    printf("*** smalloc failed! ***\n");
    exit(1);
  } else {
    printf("smalloc'd %d bytes: $%04x\n",
           tests[index][0], tests[index][1]);
  }
  showMem();
  return tests[index][1];
}

/***********************************************
  Free memory verbosely.
 ***********************************************/
int tstFree(index)
int index; {

  sfree(tests[index][1]);
  printf("sfreed pointer %d ($%04x):\n", 
         index, tests[index][1]);
  showMem();
}

/***********************************************
  Program entry point.
 ***********************************************/
int main(argc, argv)
int argc;
char **argv; {
  int i;

  printing = FALSE;
  if (argc > 1) {
    if (!strcmp(argv[1], "print")) {
      printing = TRUE;
    }
  }

  lomem = 0x0014;
  printf("\nsmalloc: $%04x, sfree: $%04x\n\n",
          &smalloc, &sfree);

  /* set up array of test allocations: */
  for (i = 0; i < NUMTESTS; i++) {
    tests[i][1] = 0;
  }

  tests[0][0] = 22; /* sizeof struct menu     */
  tests[1][0] = 10; /* sizeof struct menuitem */
  tests[2][0] = 10;
  tests[3][0] = 10;
  tests[4][0] = 25; /* sizeof struct dirent   */
  tests[5][0] = 25;
  tests[6][0] = 25;

  /* Torture test! *****************
     Using these test values instead of
     those above will force a failure:
  printf("setting top of memory to 0x3800\n");
  settop(0x3800);
  showMem();

  tests[0][0] = 768;
  tests[1][0] = 128;
  tests[2][0] = 128;
  tests[3][0] = 128;
  tests[4][0] = 512;
  tests[5][0] = 512;
  tests[6][0] = 512;
  **********************************/

  printf("Test allocations:\n");
  for (i = 0; i < NUMTESTS; i++) {
    printf("%d: %d\n", i, tests[i][0]);
  }

  /* Uncomment these lines to test 
     first-fit allocation:
  printf("\nSetting firstfit flag...\n");
  firstfit = TRUE;
  */

  for (i = 0; i < 3; i++) {
    printf("\nTest run #%d\n", i);
    printf("-----------\n");
    tstAlloc(0);
    tstAlloc(1);
    tstAlloc(2);
    tstAlloc(3);
    tstFree(1);
    tstFree(2);
    tstFree(3);
    tstAlloc(4);
    tstAlloc(5);
    tstAlloc(6);
    tstFree(5);
  }

  exit(0);
}

/************************************************/
