;======================================
; hexdump (memory hex dump routine)
;
; revision history:
; -----------------
; 2016-07-23 First version.
;======================================

;caller must include library

;--------------------------------------
; hexdump fromaddr,toaddr
; Prints hex dump in given range.
; If range is invalid, prints error
; message.
;--------------------------------------
proc hexdump
arg word fromaddr
arg word toaddr
word i
word isave
word j
byte print
byte b

begin

if toaddr < fromaddr
  output "#chexdump: invalid addresses $#04h-$#04h",fromaddr,toaddr
  return

output "#c from: $#04h, to: $#04h",fromaddr,toaddr
i=0
while i < toaddr-fromaddr
  output"#c$#04h ",fromaddr+i
  isave=i
  for j=0 to 7
    if i > toaddr-fromaddr
      put "   " ;out of data
    else
      output "#02h ",m[fromaddr+i]
    i=i+1
  put " "

  i=isave
  for j=0 to 7
    if i > toaddr-fromaddr
      put " " ;out of data
    else
      b=m[fromaddr+i]
      print=false
      if b >= 'a' and b <= 'z'
        print=true
      if b >= ' ' and b <= 'Z'
        print=true
      if print
        put b
      else
        put "."
    i=i+1

end
