;=======================================
; getcmddate (set date from CMD drive)
;=======================================

program getcmddate

include library
include prosys
include c64

data word trd="T-RD\0d"

word w
byte dev
byte cmddate[4]
byte datestr[9]
byte baddate ;boolean

;--------------------------------------
; Display usage message.
;--------------------------------------
proc usage

begin

output"#cUsage: #s <device>",carg[0]
output"#cdevice is 0:, 1:, or a device number"
output"#c(number must be from 8 to 30)#c"

end

;--------------------------------------
; Parse command-line arguments.
; return: true if arguments are valid,
;         false otherwise
;--------------------------------------
func byte parse
word i
word j
byte b

begin

if ncarg<>1
  return false

;carg[0] is program name
if cmpstr(carg[1],"=","0:")
  dev=c64ddv0
else if cmpstr(carg[1],"=","1:")
  dev=c64ddv1
else
  b=strval(carg[1],#j) ;j must be word
  if (carg[1]+b)@< ;not null-terminator?
    return false
  if j<8 or j>30
    return false
  dev=j

return true ;fall-through

end

;--------------------------------------
; Convert byte to 0-padded string.
; (assumes byte not greater than 99)
; pass: byte to convert
; pass: pointer to converted string
;--------------------------------------
proc bytestr
arg byte b
arg word str ;pointer to byte[]

begin

if b < 10
  m[str]='0'
  m[str+1]=b+$30
else
  m[str]=(b/10)+$30
  m[str+1]=(b%10)+$30
m[str+2]=0

end

;======================================
; program mainline
;======================================

begin

if not parse
  usage
  exit

m[cstatus]=0
jsr clisten,dev
jsr csecond,$6f
if m[cstatus] and $80
  output"#cDevice #w not present!#c",dev
  exit
for w=0 to 4
  jsr cciout,m[trd+w]
jsr cunlsn

jsr ctalk,dev
jsr ctksa,$6f
for w=0 to 3
  jsr cacptr
  cmddate[w]=rega
m[cstatus]=0
while m[cstatus]=0 ;clear error status
  jsr cacptr
jsr cuntlk

;31, SYNTAX ERROR?
if cmpstr(cmddate,"=","31,",false,3)
  output"#cNo clock on device #w!#c",dev
  exit

;clock not set correctly?
baddate=false
if cmddate[0]>7 ;day of week
  baddate=true
;uIEC adds 100 after 2000, CMD doesn't
if cmddate[1]>100
  cmddate[1]=cmddate[1]-100
if cmddate[2]>12 ;month
  baddate=true
if cmddate[3]>31 ;day
  baddate=true
if baddate
  output"#cBad date returned from device #w!#c",dev
  exit

m[$c14]=cmddate[1] ;year
m[$c13]=cmddate[2] ;month
m[$c12]=cmddate[3] ;day
bytestr cmddate[2],datestr   ;month
datestr[2]='/'
bytestr cmddate[3],datestr+3 ;day
datestr[5]='/'
bytestr cmddate[1],datestr+6 ;year
datestr[8]=0
output"#cDate set to #s.#c",datestr

end
