;SDA.ASM                                       ()1987 - MPERE ETAL
;====================================================================
;
CBM    = 4032         ;64,128 OR 4032
;
; KERNEL EQUATES
;
  .IFN CBM-4032 <     ;IF NOT 
;
;         =64         =128    (BASIC 4.0)
;        -----         -----  -----
FNLEN  = $00B7        ;        00D1
LA     = $00B8        ;        00D2
SA     = $00B9        ;        00D3
DV     = $00BA        ;        00D4
FNADR  = $00BB        ;        00DA
STATUS = $0090        ;        0096
OPEN   = $FFC0        ;        563
CLOSE  = $FFC3        ;        22
L0     = $FA00        ;HUFFMAN CODE LENGTHS   ($7B00 FOR )
C0     = $FB00        ;HUFFMAN CODES
C1     = $FC00        ;HUFFMAN CODES
C2     = $FD00        ;HUFFMAN CODES
G0     = $FE00        ;ASCII FOR HUFFMAN CODE
>
CHKIN  = $FFC6
CHKOUT = $FFC9
CLRCHN = $FFCC
CHRIN  = $FFCF
CHROUT = $FFD2
IBUF   = $00FD        ;INDIRECT POINTER INTO 
FN     = $0100        ;WHERE TO PUT FILENAME
;
  .IFE CBM-128 <
;
NDX    = $00D0
KEYD   = $034A
BASIC  = $4003
STAR   = $1C01
>
  .IFE CBM-64 <
;
NDX    = $00C6
KEYD   = $0277
BASIC  = $E37B
STAR   = $0801
>
  .IFE CBM-4032 <
;
STATUS = $0096
FNLEN  = $00D1
FNADR  = $00DA
LA     = $00D2
SA     = $00D3
DV     = $00D4
OPEN   = $F563
CLOSE  = $F2E2
NDX    = $009E
KEYD   = $026F
BASIC  = $B3FF
L0     = $7B00        ;HUFFMAN CODE LENGTHS   ($7B00 FOR )
C0     = $7C00        ;HUFFMAN CODES
C1     = $7D00        ;HUFFMAN CODES
C2     = $7E00        ;HUFFMAN CODES
G0     = $7F00        ;ASCII FOR HUFFMAN CODE
STAR   = $0401
>
;
  * = $0200
;
SQTYP    *=*+1        ;0=STORE 1=PACK 2=SQUEEZE 3,5=CRUNCH 4=SQUASH
CHKCRC   *=*+2        ;CHECKSUM READ FROM ARCHIVE
LEN      *=*+3        ;UNSQUEEZED LENGTH IN BYTES (LO-HIGH)
SQB      *=*+2        ;SQUEEZED LENGTH IN 254 BYTE BLOCKS
FILTYP   *=*+1        ;FILE TYPE (P,S,U OR R)
CRC      *=*+2        ;NEW CALCULATED CHECKSUM
HCODE    *=*+3        ;HUFFMAN CODE
NCODSQ   *=*+1        ;NUMBER OF HUFFMAN CODES
TMP1     *=*+3        ;TEMP FOR HUFIN
TMP      *=*+3        ;TEMP
IBIT     *=*+1        ;INPUT BIT
IBYT     *=*+1        ;INPUT BYTE
ARCST    *=*+1        ;EOF FLAG
COUNT    *=*+1        ;RUNLENGTH CODING COUNT
CRC2     *=*+1        ;TEMP
COFF     *=*+1        ;BIT OFFSET
PREV     *=*+1        ;RL CHAR FOR OUTPUT
CLEN     *=*+1        ;HUFMAN CODE LENGTH
PRTFLG   *=*+1        ;FLAG OUTPUT TO SCREEN OR DISK
BITE     *=*+1        ;BITIN BUFFER
LTMP     *=*+1
CMSK     *=*+1
;
  .WOR STAR
   * = STAR
;
 .WOR THERE, 10
 .BYT $9E
;
 .IFE CBM-64 <
 .ASC "(2063)", 0
>
 .IFE CBM-4032 <
 .ASC "(1039)", 0
>
 .IFE CBM-128 <
 .ASC "(7183)", 0
>
THERE .WOR 0
;
MAIN LDA #<EOF        ;INITIALIZE BUFFER POINTER
 STA IBUF
 LDA #>EOF
 STA IBUF+1
 LDA #0               ;FLAG. 0=TYPE THIS FILE, $FF=EXTRACT TO DISK
 STA PRTFLG
;
MAIN0 JSR GET1ST      ;GET ARCHIVE ENTRY HEADER
 BCS ABOR             ;ERROR READING HEADER
 BIT PRTFLG           ;FIRST FILE?
 BPL MAIN1            ;YES..TYPE IT
 JSR OPEN             ;OTHERWISE OPEN THE DISK FILE
 BIT STATUS           ;ABORT IF DEVICE NOT PRESENT OR DISK ERROR
 BMI ABOR
 LDX #8               ;AND SETUP 
 JSR CHKOUT
MAIN1 JSR GETNXT      ;UNSQUEEZE A BYTE
 BCS ABOR             ;ERROR WITH HUFFMAN CODE...ABORT
 BIT ARCST            ;INPUT PAST END?
 BMI MAIN2            ;YES..NEXT FILE
 JSR CHROUT           ;OTHERWISE SEND TO OUTPUT
 BIT STATUS
 BMI ABOR
 JMP MAIN1            ;NEXT BYTE
;
MAIN2 JSR CLRCHN      ;DONE WITH THIS FILE...CLOSE IT
 LDA #8
 JSR CLOSE
 BIT PRTFLG           ;FIRST FILE?
 BMI MAIN3            ;NO
 LDA #0               ;YES...WAIT FOR KEY
 STA NDX
WAIT LDA NDX
 BEQ WAIT
 LDA KEYD
 CMP #3               ;ABORT IF /
 BEQ ABOR
MAIN3 LDA #254
 STA IBYT             ;FORCE BYTIN TO GET NEW BLOCK
 STA PRTFLG           ;AND START SENDING TO DISK INSTEAD OF SCREEN
 JSR BYTIN            ;ADJUSTS BUFFER POINTER
 LDA CHKCRC           ;CHECK IF CHECKSUM IS OK
 CMP CRC
 BNE CRCERR
 LDA CHKCRC+1
 CMP CRC+1
 BNE CRCERR
 LDA #"O"
 JSR CHROUT
 LDA #"K"
 .BYT $2C
CRCERR LDA #"?"
 JSR CHROUT
 JMP MAIN0            ;NEXT FILE
;
ABOR JSR CLRCHN       ;EXIT...RETURN TO  . PROMPT
 LDA #8
 JSR CLOSE
 JMP BASIC
;
;==============================================
; EAD IN ARCHIVE HEADER & INITIALIZE USQ ETC.
;==============================================
;
GET1ST LDX #16        ;ZERO A BUNCH OF THINGS
 LDA #0
G1ST STA CRC,X
 DEX
 BPL G1ST
 LDA #"0"             ; 0: FOR FILENAME
 STA FN
 LDA #":"
 STA FN+1
 JSR BYTIN            ;GET VERSION
 CMP #2               ;MUST BE 2
 BNE ABOR             ;ABORT IF VERSION ISN'T 2
 INX                  ;.X=0
NEWB1 JSR BYTIN       ;GET 1ST PART OF HEADER
 STA SQTYP,X
 INX
 CPX #9
 BNE NEWB1
 JSR BYTIN            ;GET FNLEN
 CMP #17              ;CHECK FOR BAD FILENAME LENGTH
 BCS ABOR             ;ITS BAD ... EOF
 TAX                  ;SAVE LENGTH
 CLC
 ADC #4
 STA FNLEN            ;SAVE LENGTH (+4 FOR 0: AND ,TYPE)
 LDA #13
 JSR CHROUT
 LDY #0
 LDA #<FN             ;SETUP FILENAME POINTER FOR 
 STA FNADR
 LDA #>FN
 STA FNADR+1
GTH2 JSR BYTIN        ;CONTINUE GETTING FILENAME
 STA FN+2,Y
 JSR CHROUT
 INY
 DEX
 BNE GTH2
 LDA #","             ;TAG ON ,TYPE
 STA FN+2,Y
 JSR CHROUT
 INY
 LDA FILTYP
 STA FN+2,Y
 JSR CHROUT
 LDA #" "
 JSR CHROUT
 LDA #8               ;OPEN 8,8,1
 TAX
 LDY #1               ;SA=1 FOR WRITE
 STA LA
 STX DV
 STY SA
 JSR BYTIN            ;IGNORE RECORD LENGTH
 JSR BYTIN            ;AND DATE
 JSR BYTIN
NOU JSR CHKHDR        ;ABORT TO  IF ERROR IN HEADER
 LDY SQTYP            ;SQUEEZED FILE?
 CPY #2
 BEQ DOUSQ            ;YES-GET ENCODING TABLE
 CPY #4               ;SQUEEZED+PACKED?
 BEQ DOUSQ            ;YES-GET ENCODING TABLE
 CPY #1               ;PACKED?
 BNE GTH8             ;NO STORED OR CRUNCHED
 JSR BYTIN            ;PACKED...IGNORE CONTROL CHARACTER (ALWAYS $FE)
GTH8 CLC              ;GOT HEADER...RETURN
 RTS                  ;GOT HEADER...RETURN
;
DOUSQ LDY #0          ;GET HUFFMAN ENCODING TABLE
 TYA
GTH3 STA C0,Y         ;ZERO HUFFMAN CODES AND LENGTHS
 STA C1,Y
 STA C2,Y
 STA L0,Y
 INY
 BNE GTH3
 TAX
GTH6 LDA #0
 STA TMP1
 STA TMP1+1
 STA TMP1+2
 LDY #5
GTH4 JSR BITIN        ;GET 5 BITS (CODE LENGTH)
 ROR A
 DEY
 BNE GTH4
 ROR A                ;RIGHT JUSTIFY
 ROR A
 ROR A
 STA LTMP             ;SAVE CODE LENGTH
 CMP #25              ;CODE LENGTH > 24?
 BCS BADCD            ;YES...BAD ENCODING TABLE
 CMP #0               ;LENGTH=0?
 BEQ GTH7             ;YES THEN NO CODE TO GET
 TAY
GTH5 JSR BITIN        ;ELSE GET UFFMAN CODE
 ROL TMP
 ROL TMP+1
 ROL TMP+2
 DEY
 BNE GTH5
 TAY
GTH9 ROR TMP+2        ;JUSTIFY IT
 ROR TMP+1
 ROR TMP
 ROL TMP1
 ROL TMP1+1
 ROL TMP1+2
 DEY
 BNE GTH9
 JSR SERT             ;INSERT IN TABLE (SORTED ON CODE LENGTH)
GTH7 INX
 BNE GTH6             ;AND REPEAT 256 TIMES
 DEC NCODSQ
 CLC
BADCD RTS             ;GOT HEADER
;
;---------------------
; VERIFY HEADER IS OK
;---------------------
;
ABORT PLA
 PLA
 JMP ABOR             ;BAD HEADER
;
CHKHDR LDA SQTYP      ;MUST BE 0,1,2 OR 4
 CMP #3               ;CRUNCHED?
 BEQ ABORT            ;YES-ERROR
 CMP #5               ;1 PASS OR BAD HEADER
 BCS ABORT
 LDA FILTYP           ;MUST BE P,S, OR U
 CMP #"P"
 BEQ CHOK
 CMP #"S"
 BEQ CHOK
 CMP #"U"
 BNE ABORT
CHOK RTS
;
;----------------------------------------------------------------
; SUBROUTINE. ADD HUFFMAN CODE TO TABLE SORTED BY LENGTH OF CODE
;----------------------------------------------------------------
;
SERT STX SRTX+1       ;SAVE .X=ASCII FOR THIS CODE
 JSR RAM              ;ALL 
 LDY #0
 LDA LTMP             ;CODE LENGTH READ FROM HEADER
SRT0 CPY NCODSQ       ;Y=# OF CODES?
 BNE SRT1             ;NO-MAYBE INSERT IT
SRT00 STA L0,Y        ;ELSE STORE IT AT END OF TABLE
 LDA TMP1             ;CODE
 STA C0,Y
 LDA TMP1+1
 STA C1,Y
 LDA TMP1+2
 STA C2,Y
 INC NCODSQ
SRTX LDX #1
 TXA
 STA G0,Y             ;SAVE ASCII
 JMP ROM              ;RE-ENABLE S
;
SRT1 CMP L0,Y
 BCC SRT2             ;NEW CODE IS SMALLER. INSERT IT
 INY
 BNE SRT0             ;ALWAYS
;
SRT2 STY SRT3+1
 LDY #$FE
SRT4 JSR SRT8
 DEY
SRT3 CPY #0
 BNE SRT4
 JSR SRT8
 LDA LTMP
 JMP SRT00
;
SRT8 LDA L0,Y
 STA L0+1,Y
 LDA G0,Y
 STA G0+1,Y
 LDA C0,Y
 STA C0+1,Y
 LDA C1,Y
 STA C1+1,Y
 LDA C2,Y
 STA C2+1,Y
 RTS
;
;
 .IFE CBM-64 <
;
ROM PHA
ROM0 LDA #0           ;SAVED 
 STA $01
 AND #7               ;IS / ENABLED?
 BEQ NICL             ;NO...DON'T ENABLE INTERRUPTS
 PLA
 CLI
 RTS
;
RAM PHA
 LDA $01              ;SAVE 
 STA ROM0+1
 AND #$F8             ;ALL 
 SEI                  ;KILL INTERRUPTS
 STA $01
NICL PLA
 RTS
>
  .IFN CBM-64 <       ;IF -128 OR 
;
RAM STA $FF01         ;BANK 0 IF 128, NOTHING IF 
 RTS
ROM PHA               ;BANK 15 IF 128, NOTHING IF 
 LDA #$00
 STA $FF00
 PLA
 RTS
>
;-----------------------------
; NSQUEEZE A BYTE SUBROUTINE
;-----------------------------
;
; SE THIS ROUTINE TO GET ONE BYTE AT A TIME FROM THE ARCHIVED FILE.
; HE OVERFLOW FLAG, IF SET, INDICATES THAT THERE ARE NO MORE BYTES
;     TO GET FROM THIS ARCHIVE ENTRY. HE PREVIOUS ONE WAS THE LAST
;     CHARACTER OF THE SQUEEZED FILE.
; HE X AND Y REGISTERS ARE NOT AFFECTED BY THIS ROUTINE
;
GETNXT STX BAST+1
 STY BASTY+1
 JSR DCLN             ;CHECK FOR END OF FILE
 BIT ARCST
 BMI BAST0            ;EOF...DON'T INPUT PAST END
;
GXT LDX COUNT         ;ON A RUN?
 BEQ GNXT             ;NO
 JSR RL33             ;YES - GET REPEATED CHARACTER
 JMP USQ89
;
GNXT LDX SQTYP        ;WHAT TYPE OF FILE?
 BEQ USQ88            ;STORED..GET BYTE
 CPX #1
 BEQ USQ88            ;SAME IF PACKED
 JSR RAM              ;NEED TO ACCESS TABLES AT $FA00
 JSR HUFIN            ;ELSE GET HUFFMAN CODE
;
 .IFE CBM-64 <
;
 PHA                  ;RE-ENABLE 
 LDA $01
 ORA #$07
 STA $01
 CLI
 PLA
>
 BCS BAST             ;ERROR READING HUFFMAN CODE
 BCC USQ80
USQ88 JSR BYTIN
USQ80 CPX #0          ;WAS IT STORED?
 BEQ USQ89            ;YES THEN WE'VE GOT A BYTE
 CPX #2               ;WAS IT SQUEEZED?
 BEQ USQ89            ;YES THEN WE'VE GOT A BYTE
 JSR RLOUT            ;OTHERWISE IT MIGHT NEED TO BE UN-PACKED
USQ89 JSR DCBO        ;UPDATE CHECKSUM
BAST0 CLC
BAST LDX #0
BASTY LDY #0
 BIT ARCST
 RTS
;
;
DCLN LDX LEN          ;CHECK FOR END OF FILE
 BNE DL0
 LDX LEN+1
 BNE DL1
 LDX LEN+2
 BNE DL2
 LDA #$FF             ;LEN IS ZERO. FLAG EOF
 STA ARCST
 RTS
;
DL2 DEC LEN+2
DL1 DEC LEN+1
DL0 DEC LEN
 RTS
;
DCBO PHA              ;UPDATE CHECKSUM
 INC CRC2
 EOR CRC2
 CLC
 ADC CRC
 STA CRC
 BCC DCBO1
 INC CRC+1
DCBO1 PLA
 RTS
;
;----------------------------------
; RUN-LENGTH BYTE OUTPUT FOR ARC/X
;----------------------------------
;
RLOUT JMP RL1         ;CHANGES
;
RL1 CMP #254          ;IS IT A CONTROL CHARACTER?
 BEQ CONTRL           ;YES-GET COUNT,CHAR
 RTS                  ;ELSE SEND TO OUTPUT
;
CONTRL LDA #<RL2      ;SETUP FOR COUNT
 STA RLOUT+1
 LDA #>RL2
 STA RLOUT+2
GNX PLA
 PLA
 JMP GNXT
;
RL2 STA PREV          ;SAVE COUNT
 LDA #<RL3            ;AND SETUP FOR CHAR
 STA RLOUT+1
 LDA #>RL3
 STA RLOUT+2
 JMP GNX
;
RL3 STY RL3Y+1        ;SAVE .Y
 LDY #<RL33
 STY RLOUT+1
 LDY #>RL33
 STY RLOUT+2
 LDY PREV             ;RECALL COUNT
 STY COUNT
 STA PREV             ;SAVE CHAR
RL33 DEC COUNT        ;SEND CHAR COUNT TIMES
 BEQ RL3Y             ;LAST ONE. RESET RLOUT
 BNE RL44
;
RL3Y LDY #0
RL0 LDA #<RL1         ;RESET RLOUT
 STA RLOUT+1
 LDA #>RL1
 STA RLOUT+2
RL44 LDA PREV
 RTS
;
;----------------------------------------------
;READ SINGLE BYTE FROM A FILE AS A HUFFMAN CODE
;----------------------------------------------
;
HUFIN  LDA #0         ;RESET LENGTH OF CODE
 STA CLEN
 STA HFI1+1
 STA COFF
 STA CMSK
 INC CMSK
 STA HCODE
 STA HCODE+1
 STA HCODE+2
 STY HFIY+1
 STX HFIX+1
HFILP JSR BITIN       ;GET A BIT
 .IFE CBM-128 <
 STA $FF01
>
 BCC ZBIT             ;ZERO BIT-JUST BUMP LENGTH
 LDY COFF             ;ELSE ADJUST CODE AS WELL
 LDA CMSK
 ORA HCODE,Y
 STA HCODE,Y
ZBIT ASL CMSK         ;ADJUST MASK FOR NEXT TIME
 BCC ZB2
 ROL CMSK
 INC COFF
ZB2 INC CLEN          ;CHECK IF CODE LENGTH >23
 LDA CLEN
 CMP #24
 BCC HFI1
NTS SEC               ;CODE TOO LONG...BAD FILE
 JMP HFIX
;
HFI1 LDY #0
HFI3 CMP L0,Y         ;CHECK CODE LENGTH OK
 BEQ HFI9             ;LENGTH THE SAME CHECK IT
 BCC HFILP            ;LESS-GET ANOTHER BIT
 BCS NTS              ;LENGTH > ... MUST BE AN ERROR
HFI9 LDX C0,Y         ;LENGTH OK. CHECK IF CODE IS
 CPX HCODE
 BNE HFI2             ;NO
 LDX C1,Y
 CPX HCODE+1
 BNE HFI2
 LDX C2,Y
 CPX HCODE+2
 BNE HFI2
 LDA G0,Y             ;GOT IT
 CLC
HFIX LDX #0
HFIY LDY #0
 .IFE CBM-128 <
 JMP ROM
>
 RTS
;
HFI2 INY              ;TRY AGAIN FOR THIS LENGTH
 BEQ NTS              ;ERROR.. NO CODE
 STY HFI1+1
 CPY NCODSQ
 BCC HFI3
 BEQ HFI3
 JMP NTS              ;NONE-ERROR
;
;-------
; BITIN
;-------
;
BITS .BYT 1, 2, 4, 8, 16, 32, 64, 128
;
BITIN STY BTIY+1
 STA BTIA+1
 LDY IBIT             ;OFFSET INTO BIT BUFFER
 BNE BTI1             ;NEED A NEW BYTE IF ZERO
 JSR BYTIN
 STA BITE
BTI1 LDA BITE         ;PUT BIT IN CARRY
 AND BITS,Y
 BNE BTI2
 CLC
 .BYT $24
BTI2 SEC
 PHP
 INY                  ;AND ADJUST BIT POINTER FOR NEXT TIME
 CPY #8
 BCC BTI3
 LDY #0
BTI3 STY IBIT
 PLP
BTIY LDY #0
BTIA LDA #0
 RTS
;
;-------
; BYTIN
;-------
;
BYTIN STY BIY+1
 JSR RAM              ;ALL 
 LDY IBYT             ;OFFSET INTO FILE
 CPY #254             ;END OF BUFFER?
 BCC BI1              ;NO...JUST GET BYTE
 CLC                  ;ELSE BUMP BUFFER POINTER
 TYA
 ADC IBUF
 STA IBUF
 BCC BI2
 INC IBUF+1
BI2 LDY #0
BI1 LDA (IBUF),Y
 INY
 STY IBYT
BIY LDY #0
 JMP ROM              ;RE-ENABLE S
;
 .IFE CBM-64 <        ;PAD FILE LENGTH TO EXACTLY 4 BLOCKS
 .ASC "1234567890"
>
 .IFE CBM-128 <
 .ASC " () 1987 - MPERE ETAL  "
>
 .IFE CBM-4032 <
 .ASC " () 1987 - MPERE ETAL        "
>
EOF      = *
;
 .END
